/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import rnadesign.designapp.rnagui.GraphControlPanel;
import rnadesign.designapp.rnagui.Object3DPainter;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.designapp.rnagui.SimplePainter;
import rnadesign.rnacontrol.CameraController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.SimpleCameraController;
import tools3d.Matrix3D;
import tools3d.SimpleCamera;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;

class GraphPanel
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
ModelChangeListener {
    Object3DGraphController graphController;
    GraphControlPanel controlPanel;
    private static final long serialVersionUID = -1285814574859329687L;
    public static final int ZOOM_BUTTON_MASK = 3072;
    public static final int MOVE_BUTTON_MASK = 2048;
    public static final int ROTATE_BUTTON_MASK = 1024;
    public static final int ROTATE_SELECTED_KEY = 89;
    public static final int TRANSLATE_SELECTED_KEY = 84;
    public static final int CANCEL_SELECTED_KEY = 67;
    public static final int X_AXIS_BUTTON_MASK = 1024;
    public static final int Y_AXIS_BUTTON_MASK = 2048;
    public static final int Z_AXIS_BUTTON_MASK = 3072;
    public static final int RESET_CAMERA = 82;
    public static final int DESELECT_OBJECT = 68;
    private SelectionMode selectionMode = SelectionMode.None;
    private static final double ZOOM_FACTOR = 0.01;
    private static final double MOVE_FACTOR = 1.0;
    private static final double ROTATE_FACTOR = 1.0;
    private double zoom = 1.0;
    private Point p;
    private static final double DISTANCE_THRESHOLD = 5.0;
    private Object3D selected;
    private Map<Point2D, Object3D> projectionMap = new HashMap<Point2D, Object3D>();
    Object3DPainter painter;
    Object3DPainter painterSave;

    GraphPanel(GraphControlPanel p, RnaGuiParameters params, Object3DGraphController graphController) {
        this.controlPanel = p;
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension((int)params.xScreenMax, (int)params.yScreenMax));
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.painter = new SimplePainter(params);
        this.painter.setCameraController(new SimpleCameraController(new SimpleCamera()));
        this.painterSave = new SimplePainter(params);
        SimpleCamera camera = new SimpleCamera();
        camera.setOrigin2D((int)(params.xScreenMax / 2.0), (int)(params.yScreenMax / 2.0));
        this.painterSave.setCameraController(new SimpleCameraController(camera));
        graphController.addModelChangeListener(this);
        this.graphController = graphController;
        this.getInputMap().put(KeyStroke.getKeyStroke(82, 2), "reset");
        this.getActionMap().put("reset", new ResetAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(68, 2), "deselect");
        this.getActionMap().put("deselect", new DeselectAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(89, 2), "rotate");
        this.getActionMap().put("rotate", new RotateAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(84, 2), "translate");
        this.getActionMap().put("translate", new TranslateAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "cancel");
        this.getActionMap().put("cancel", new CancelAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancel");
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        Object3D root = this.graphController.getGraph().getGraph();
        this.projectionMap.clear();
        this.buildProjectionMap(root, this.projectionMap);
    }

    private void updateCamera(MouseEvent e) {
        double x = (double)e.getX() - this.p.getX();
        double y = (double)e.getY() - this.p.getY();
        y *= -1.0;
        this.p = e.getPoint();
        CameraController projector = this.painter.getCameraController();
        int masks = 3072;
        if ((e.getModifiersEx() & masks) == 2048) {
            projector.moveCamera(x * 1.0, y * 1.0);
        } else if ((e.getModifiersEx() & masks) == 1024) {
            double phiChangeDeg = -y * 1.0;
            double thetaChangeDeg = -x * 1.0;
            projector.rotateCameraNorth(phiChangeDeg * (Math.PI / 180));
            projector.rotateCameraWest(thetaChangeDeg * (Math.PI / 180));
            this.controlPanel.movePhiSlider(-thetaChangeDeg);
            this.controlPanel.moveThetaSlider(-phiChangeDeg);
        } else if ((e.getModifiersEx() & masks) == 3072) {
            this.zoom += y * 0.01;
            projector.setZoom(this.zoom);
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.p == null) {
            this.p = e.getPoint();
            return;
        }
        if (this.selectionMode == SelectionMode.None) {
            this.updateCamera(e);
            return;
        }
        if (this.selectionMode == SelectionMode.Translate || this.selectionMode == SelectionMode.Rotate) {
            this.updateObject(e);
        }
    }

    public void updateObject(MouseEvent e) {
        double xAxis = 0.0;
        double yAxis = 0.0;
        double zAxis = 0.0;
        double amount = 0.0;
        int masks = 3072;
        if ((e.getModifiersEx() & masks) == 1024) {
            xAxis = 1.0;
        } else if ((e.getModifiersEx() & masks) == 2048) {
            yAxis = 1.0;
        } else if ((e.getModifiersEx() & masks) == 3072) {
            zAxis = 1.0;
        }
        amount = (double)e.getX() - this.p.getX();
        this.p = e.getPoint();
        if (this.graphController.getGraph().getSelectionRoot() != null) {
            if (this.selectionMode == SelectionMode.Translate) {
                if (xAxis == 1.0) {
                    xAxis = amount;
                } else if (yAxis == 1.0) {
                    yAxis = amount;
                } else if (zAxis == 1.0) {
                    zAxis = amount;
                }
                this.graphController.getGraph().translateSelected(new Vector3D(xAxis, yAxis, zAxis));
            } else if (this.selectionMode == SelectionMode.Rotate) {
                this.graphController.getGraph().rotateSelected(xAxis, yAxis, zAxis, amount * Math.PI / 180.0);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.selectionMode != SelectionMode.None) {
            return;
        }
        Set<Point2D> points = this.projectionMap.keySet();
        Point point = e.getPoint();
        Point2D closest = null;
        double distance = Double.MAX_VALUE;
        for (Point2D p : points) {
            double newDistance = p.distance(point.x, point.y);
            if (!(newDistance < distance) || !(newDistance < 5.0)) continue;
            closest = p;
            distance = newDistance;
        }
        if (closest == null) {
            this.graphController.getGraph().deselectCurrent();
            this.selected = null;
            return;
        }
        this.selected = this.projectionMap.get(closest);
        try {
            String name = Object3DTools.getFullName(this.selected);
            this.graphController.getGraph().selectByFullName(name);
        }
        catch (Object3DGraphControllerException ex) {
            this.selected = null;
            this.graphController.getGraph().deselectCurrent();
        }
    }

    private void buildProjectionMap(Object3D root, Map<Point2D, Object3D> map) {
        Point2D p = this.painter.getCameraController().project(root.getPosition());
        Object3D objectToAdd = root;
        if (map.get(p) != null) {
            double distanceNew;
            Object3D object = map.get(p);
            Vector3D cameraPosition = this.painter.getCameraController().getCamera().getPosition();
            double distanceOld = Math.abs(cameraPosition.getZ() - object.getPosition().getZ());
            if (distanceOld < (distanceNew = Math.abs(cameraPosition.getZ() - root.getPosition().getZ()))) {
                objectToAdd = object;
            }
        }
        map.put(p, objectToAdd);
        if (root.size() == 0) {
            return;
        }
        for (int i = 0; i < root.size(); ++i) {
            this.buildProjectionMap(root.getChild(i), map);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.p = null;
        Object3D root = this.graphController.getGraph().getGraph();
        this.projectionMap.clear();
        this.buildProjectionMap(root, this.projectionMap);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    public CameraController getCameraController() {
        return this.painter.getCameraController();
    }

    public Object3DGraphController getGraphController() {
        return this.graphController;
    }

    public Object3DPainter getPainter() {
        return this.painter;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.painter.paint(g, this.graphController);
    }

    public void resetPainter() {
        this.zoom = 1.0;
        this.painter.copy(this.painterSave);
    }

    public void setPainter(Object3DPainter p) {
        this.painter = p;
    }

    public void setCameraController(CameraController p) {
        this.painter.setCameraController(p);
    }

    private class DeselectAction
    extends AbstractAction {
        private DeselectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphPanel.this.graphController.getGraph().deselectCurrent();
            GraphPanel.this.selected = null;
        }
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphPanel.this.getCameraController().getCamera().setPosition(new Vector3D(0.0, -10.0, 0.0));
            GraphPanel.this.getCameraController().getCamera().setOrientation(new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, -0.0, 0.0, 0.0, 1.0));
            GraphPanel.this.getCameraController().getCamera().setZoom(1.0);
            Object3D root = GraphPanel.this.graphController.getGraph().getGraph();
            GraphPanel.this.projectionMap.clear();
            GraphPanel.this.buildProjectionMap(root, GraphPanel.this.projectionMap);
            GraphPanel.this.repaint();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphPanel.this.selectionMode = SelectionMode.None;
            Object3D root = GraphPanel.this.graphController.getGraph().getGraph();
            GraphPanel.this.projectionMap.clear();
            GraphPanel.this.buildProjectionMap(root, GraphPanel.this.projectionMap);
            GraphPanel.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class TranslateAction
    extends AbstractAction {
        private TranslateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GraphPanel.this.selectionMode == SelectionMode.Translate) {
                GraphPanel.this.selectionMode = SelectionMode.None;
            } else {
                GraphPanel.this.selectionMode = SelectionMode.Translate;
            }
            Object3D root = GraphPanel.this.graphController.getGraph().getGraph();
            GraphPanel.this.projectionMap.clear();
            GraphPanel.this.buildProjectionMap(root, GraphPanel.this.projectionMap);
            GraphPanel.this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    private class RotateAction
    extends AbstractAction {
        private RotateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GraphPanel.this.selectionMode == SelectionMode.Rotate) {
                GraphPanel.this.selectionMode = SelectionMode.None;
            } else {
                GraphPanel.this.selectionMode = SelectionMode.Rotate;
            }
            Object3D root = GraphPanel.this.graphController.getGraph().getGraph();
            GraphPanel.this.projectionMap.clear();
            GraphPanel.this.buildProjectionMap(root, GraphPanel.this.projectionMap);
            GraphPanel.this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public static enum SelectionMode {
        Translate,
        Rotate,
        None;

    }
}

