/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import java.awt.Container;
import javax.swing.JFrame;
import rnadesign.designapp.PackageConstants;
import rnadesign.designapp.rnagui.GeneralGeometryPainter;
import rnadesign.designapp.rnagui.GeometryPainter;
import rnadesign.designapp.rnagui.GraphControlPanel;
import rnadesign.designapp.rnagui.NanoTilerGeometryPainterFactory;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.SimpleCameraController;
import tools3d.SimpleCamera;

public class GraphicsCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "graphics";
    private Object3DGraphController controller;

    public GraphicsCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GraphicsCommand command = new GraphicsCommand(this.controller);
        command.controller = this.controller;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Launches graphics window. Correct usage: graphics";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"graphics\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Launches graphics in new window." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("NanoTiler");
        frame.setDefaultCloseOperation(3);
        Container pane = frame.getContentPane();
        RnaGuiParameters params = new RnaGuiParameters();
        GraphControlPanel graphPanel = new GraphControlPanel(params, this.controller);
        SimpleCameraController xyProjector = new SimpleCameraController(new SimpleCamera());
        xyProjector.setOrigin2D((int)(params.xScreenMax / 2.0), (int)(params.yScreenMax / 2.0));
        graphPanel.setCameraController(xyProjector);
        NanoTilerGeometryPainterFactory geometryPainterFactory = new NanoTilerGeometryPainterFactory();
        GeometryPainter geometryPainter = geometryPainterFactory.createPainter(2);
        GeneralGeometryPainter newPainter = new GeneralGeometryPainter(params, geometryPainter, this.controller);
        newPainter.setCameraController(xyProjector);
        graphPanel.setPainter(newPainter);
        this.controller.addModelChangeListener(graphPanel.graphPanel);
        pane.add(graphPanel);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
    }
}

