/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DAction;
import tools3d.objects3d.Object3DActionVisitor;
import tools3d.objects3d.Object3DTools;

public class HelixConstraintWizard
implements GeneralWizard {
    public static final String FRAME_TITLE = "Add Helix Constraint";
    private static final Dimension TABLE_DIM = new Dimension(200, 200);
    private CommandApplication application;
    private ArrayList<StrandJunction3D> junctions;
    private BranchSelector branchSelector1;
    private BranchSelector branchSelector2;
    private JDialog frame;
    private boolean finished;
    private JButton add;
    private Object3DGraphController graphController;
    private int selectedIndex1 = -1;
    private int selectedIndex2 = -1;
    private JTextField bpmin;
    private ArrayList<ActionListener> actionListeners = new ArrayList();

    public HelixConstraintWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.frame = new JDialog(parentFrame instanceof Frame ? (Frame)parentFrame : null, FRAME_TITLE, true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                HelixConstraintWizard.this.finished = true;
            }
        });
        this.junctions = new ArrayList();
        Object3DActionVisitor visitor = new Object3DActionVisitor(graphController.getGraph().getGraph(), new Object3DAction(){

            @Override
            public void act(Object3D obj) {
                if (obj instanceof StrandJunction3D) {
                    HelixConstraintWizard.this.junctions.add((StrandJunction3D)obj);
                }
            }
        });
        visitor.nextToEnd();
        if (this.junctions.size() <= 1) {
            JOptionPane.showMessageDialog(null, "No junctions available to apply helix constraints to.\nPlease add junctions using the place junction wizard.");
            return;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel label = new JLabel("<html><h2>Select first branch");
        label.setAlignmentX(0.0f);
        panel.add(label);
        this.branchSelector1 = new BranchSelector(new AddListener());
        panel.add(this.branchSelector1);
        label = new JLabel("<html><h2>Select second branch");
        label.setAlignmentX(0.0f);
        panel.add(label);
        this.branchSelector2 = new BranchSelector(new AddListener());
        panel.add(this.branchSelector2);
        panel.add(Box.createVerticalStrut(15));
        JPanel temp = new JPanel();
        temp.add(new JLabel("Base Pairs:"));
        this.bpmin = new JTextField(10);
        this.bpmin.setText("0");
        temp.add(this.bpmin);
        panel.add(temp);
        panel.add(Box.createVerticalStrut(15));
        panel.add(Box.createVerticalStrut(15));
        JPanel bottomPanel = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(new CloseWindowListener());
        bottomPanel.add(close);
        this.add = new JButton("Add");
        this.add.addActionListener(new AddListener());
        this.add.setEnabled(false);
        bottomPanel.add(this.add);
        panel.add(bottomPanel);
        this.frame.add(panel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private class BranchSelector
    extends JPanel {
        JList junctionList;
        JList branchList;
        ListSelectionListener listener;

        BranchSelector(ListSelectionListener l) {
            this.listener = l;
            this.setLayout(new BoxLayout(this, 0));
            this.junctionList = new JList(new JunctionListModel());
            this.junctionList.setSelectionMode(0);
            this.junctionList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    HelixConstraintWizard.this.add.setEnabled(false);
                    if (BranchSelector.this.junctionList.getSelectedIndex() != -1) {
                        BranchSelector.this.branchList.clearSelection();
                        BranchSelector.this.branchList.setEnabled(true);
                        int branches = ((StrandJunction3D)HelixConstraintWizard.this.junctions.get(BranchSelector.this.junctionList.getSelectedIndex())).getBranchCount();
                        Integer[] b = new Integer[branches];
                        for (int i = 0; i < branches; ++i) {
                            b[i] = new Integer(i + 1);
                        }
                        BranchSelector.this.branchList.setModel(new DefaultComboBoxModel<Integer>(b));
                        BranchSelector.this.branchList.revalidate();
                    } else {
                        BranchSelector.this.branchList.setEnabled(false);
                    }
                }
            });
            JScrollPane pane = new JScrollPane(this.junctionList);
            pane.setPreferredSize(TABLE_DIM);
            this.add(pane);
            this.add(new JSeparator(1));
            this.branchList = new JList();
            this.branchList.setSelectionMode(0);
            this.branchList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    BranchSelector.this.listener.valueChanged(e);
                }
            });
            this.branchList.setEnabled(false);
            pane = new JScrollPane(this.branchList);
            pane.setPreferredSize(TABLE_DIM);
            this.add(pane);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (!b) {
                this.junctionList.clearSelection();
            }
            this.branchList.setEnabled(b);
        }

        public int getJunction() {
            if (this.junctionList.getSelectedIndex() == -1) {
                return -1;
            }
            return this.junctionList.getSelectedIndex();
        }

        public int getBranch() {
            if (this.branchList.getSelectedIndex() == -1) {
                return -1;
            }
            return this.branchList.getSelectedIndex() + 1;
        }
    }

    private class JunctionListModel
    extends AbstractListModel {
        private JunctionListModel() {
        }

        @Override
        public int getSize() {
            return HelixConstraintWizard.this.junctions.size();
        }

        @Override
        public Object getElementAt(int index) {
            return Object3DTools.getFullName((Object3D)HelixConstraintWizard.this.junctions.get(index));
        }
    }

    private class AddListener
    implements ActionListener,
    ListSelectionListener {
        private AddListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (HelixConstraintWizard.this.branchSelector1.getBranch() != -1 && HelixConstraintWizard.this.branchSelector2.getBranch() != -1) {
                HelixConstraintWizard.this.add.setEnabled(true);
            } else {
                HelixConstraintWizard.this.add.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HelixConstraintWizard.this.branchSelector1.getJunction() == HelixConstraintWizard.this.branchSelector2.getJunction()) {
                JOptionPane.showMessageDialog(HelixConstraintWizard.this.frame, "Pleas select two different junctions");
                return;
            }
            BranchDescriptor3D branch1 = ((StrandJunction3D)HelixConstraintWizard.this.junctions.get(HelixConstraintWizard.this.branchSelector1.getJunction())).getBranch(HelixConstraintWizard.this.branchSelector1.getBranch() - 1);
            BranchDescriptor3D branch2 = ((StrandJunction3D)HelixConstraintWizard.this.junctions.get(HelixConstraintWizard.this.branchSelector2.getJunction())).getBranch(HelixConstraintWizard.this.branchSelector2.getBranch() - 1);
            String branch1Name = Object3DTools.getFullName(branch1);
            String branch2Name = Object3DTools.getFullName(branch2);
            Integer bpmi = null;
            try {
                bpmi = Integer.parseInt(HelixConstraintWizard.this.bpmin.getText());
                if (bpmi < 0) {
                    JOptionPane.showMessageDialog(HelixConstraintWizard.this.frame, "Enter values above zero in the base pair fields");
                    return;
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(HelixConstraintWizard.this.frame, "Must enter numbers in fields");
                HelixConstraintWizard.this.bpmin.setText("0");
                return;
            }
            try {
                HelixConstraintWizard.this.application.runScriptLine("genhelixconstraint " + branch1Name + " " + branch2Name + " bp=" + bpmi);
            }
            catch (CommandException ex) {
                JOptionPane.showMessageDialog(HelixConstraintWizard.this.frame, ex.getMessage());
                return;
            }
            HelixConstraintWizard.this.frame.setVisible(false);
            HelixConstraintWizard.this.frame.dispose();
        }
    }

    private class CloseWindowListener
    implements ActionListener {
        private CloseWindowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelixConstraintWizard.this.frame.setVisible(false);
            HelixConstraintWizard.this.frame.dispose();
        }
    }
}

