/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.Wizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class ManualRotateWizard
implements Wizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private static final int COL_SIZE_SELECTION = 20;
    private static final int COL_SIZE_DOUBLE = 8;
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    public static final String FRAME_TITLE = "Rotate Wizard";
    private JTextField selectionField;
    private JTextField angleField;
    private JTextField xField;
    private JTextField yField;
    private JTextField zField;
    private CommandApplication application;
    private List<String> rotateHistory;
    private List<String> selectHistory;

    public ManualRotateWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.rotateHistory = new ArrayList<String>();
        this.selectHistory = new ArrayList<String>();
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout());
        this.selectionField = new JTextField(this.getSelectionString(), 20);
        top.add(new JLabel("Rotate:"));
        top.add(this.selectionField);
        JPanel rotatePanel = new JPanel();
        rotatePanel.setLayout(new FlowLayout());
        this.angleField = new JTextField("0.0", 8);
        this.xField = new JTextField("0.0", 8);
        this.yField = new JTextField("0.0", 8);
        this.zField = new JTextField("0.0", 8);
        rotatePanel.add(new JLabel("Rotate:  angle:"));
        rotatePanel.add(this.angleField);
        rotatePanel.add(new JLabel(" x:"));
        rotatePanel.add(this.xField);
        rotatePanel.add(new JLabel(" y:"));
        rotatePanel.add(this.yField);
        rotatePanel.add(new JLabel(" z:"));
        rotatePanel.add(this.zField);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Rotate");
        button.addActionListener(new RotateButtonListener());
        bottomPanel.add(button);
        button = new JButton("Close");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)top, "North");
        f.add((Component)rotatePanel, "Center");
        f.add((Component)bottomPanel, "South");
    }

    private String getSelectionString() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "all";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManualRotateWizard.this.frame.setVisible(false);
            ManualRotateWizard.this.frame = null;
            ManualRotateWizard.this.finished = true;
        }
    }

    private class RotateButtonListener
    implements ActionListener {
        private RotateButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectCommand = "select " + ManualRotateWizard.this.selectionField.getText().trim();
            String command = "rotate " + ManualRotateWizard.this.angleField.getText().trim() + " " + ManualRotateWizard.this.xField.getText().trim() + " " + ManualRotateWizard.this.yField.getText().trim() + " " + ManualRotateWizard.this.zField.getText().trim();
            try {
                ManualRotateWizard.this.application.runScriptLine(selectCommand);
                ManualRotateWizard.this.selectHistory.add(selectCommand);
                ManualRotateWizard.this.application.runScriptLine(command);
                ManualRotateWizard.this.rotateHistory.add(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(ManualRotateWizard.this.frame, "Error executing command: " + selectCommand + " or " + command + " : " + ce.getMessage());
            }
        }
    }
}

