/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.Wizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaTools;
import tools3d.objects3d.Object3D;

public class MoveWizard
implements Wizard {
    private static final int COL_SIZE_NAME = 20;
    private static final String FRAME_TITLE = "Move Wizard";
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Vector<String> tree;
    private String[] allowedNames;
    private String[] forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;
    private JTextField selectionField1;
    private JTextField selectionField2;
    private JLabel label;

    public MoveWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.allowedNames = RnaTools.getRnaClassNames();
        this.forbiddenNames = null;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        JPanel westCenterPanel = new JPanel();
        westCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Current Object Name: ");
        westCenterPanel.add((Component)this.label, "North");
        this.selectionField1 = new JTextField(this.getSelectionText(), 20);
        westCenterPanel.add((Component)this.selectionField1, "Center");
        westCenterPanel.add((Component)new TreePanel(this.selectionField1), "South");
        centerPanel.add((Component)westCenterPanel, "West");
        JPanel centerCenterPanel = new JPanel();
        centerCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("New Parent Name: ");
        centerCenterPanel.add((Component)this.label, "North");
        this.selectionField2 = new JTextField(this.getSelectionText(), 20);
        centerCenterPanel.add((Component)this.selectionField2, "Center");
        centerCenterPanel.add((Component)new TreePanel(this.selectionField2), "South");
        centerPanel.add((Component)centerCenterPanel, "East");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Move");
        button.addActionListener(new MoveListener());
        buttonPanel.add(button);
        f.add((Component)centerPanel, "Center");
        f.add((Component)buttonPanel, "South");
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextField field) {
            Object3DGraphController controller = ((AbstractDesigner)MoveWizard.this.application).getGraphController();
            MoveWizard.this.tree = controller.getGraph().getTree(MoveWizard.this.allowedNames, MoveWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            MoveWizard.this.treePanel = new JPanel();
            MoveWizard.this.treeList = new JList(MoveWizard.this.tree);
            MoveWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            MoveWizard.this.treeScroll = new JScrollPane(MoveWizard.this.treeList);
            MoveWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            MoveWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            MoveWizard.this.treeScroll.setPreferredSize(new Dimension(300, 200));
            MoveWizard.this.treePanel.add(MoveWizard.this.treeScroll);
            this.add((Component)MoveWizard.this.treePanel, "South");
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextField field;

        public SelectionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)MoveWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)MoveWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.setText(text);
            }
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoveWizard.this.frame.setVisible(false);
            MoveWizard.this.frame = null;
            MoveWizard.this.finished = true;
        }
    }

    private class MoveListener
    implements ActionListener {
        private MoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "move " + MoveWizard.this.selectionField1.getText().trim() + " " + MoveWizard.this.selectionField2.getText().trim();
            try {
                MoveWizard.this.application.runScriptLine(command);
                MoveWizard.this.frame.setVisible(false);
                MoveWizard.this.frame = null;
                MoveWizard.this.finished = true;
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(MoveWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoveWizard.this.frame.setVisible(false);
            MoveWizard.this.frame = null;
            MoveWizard.this.finished = true;
        }
    }
}

