/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;

public class PlatonicSolidWizard
implements GeneralWizard {
    private static final int COL_SIZE_DOUBLE = 8;
    private static final int COL_SIZE_INT = 5;
    private static final int COL_SIZE_NAME = 15;
    private boolean finished = false;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame = null;
    private JTextField seqCharField;
    private JTextField lengthField;
    private JTextField nameField;
    private JTextField sxField;
    private JTextField syField;
    private JTextField szField;
    private JCheckBox addStemsBox;
    private JCheckBox onlyFirstPathBox;
    private JComboBox geometryChoice;
    private JComboBox tilerChoice;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    private boolean addStemsFlag = false;
    private boolean onlyFirstPathMode = false;
    private double length = 100.0;
    private double sx = 0.0;
    private double sy = 0.0;
    private double sz = 0.0;
    private int geometryId = 0;
    private int tilerAlgorithm = 3;
    private int nx = 3;
    private int ny = 3;
    private int nz = 3;
    private String name = "polyhedron";
    private String charString = "N";
    private static String[] geometryNames = new String[]{"Tetrahedron", "Cube", "Octahedron", "Dodecahedron", "Icosahedron"};
    private static String[] tilerNames = new String[]{"random", "complete", "simple", "fragment"};
    public static final String FRAME_TITLE = "Insert Platonic shape Wizard";

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        JPanel topPanel = new JPanel();
        JPanel xPanel = new JPanel();
        JPanel sPanel = new JPanel();
        JPanel checkPanel = new JPanel();
        this.addStemsBox = new JCheckBox("Add stems:", this.addStemsFlag);
        this.onlyFirstPathBox = new JCheckBox("Use first path:", this.onlyFirstPathMode);
        this.seqCharField = new JTextField(this.charString, 1);
        this.lengthField = new JTextField("" + this.length, 8);
        this.sxField = new JTextField("" + this.sx, 8);
        this.syField = new JTextField("" + this.sy, 8);
        this.szField = new JTextField("" + this.sz, 8);
        this.nameField = new JTextField(this.name, 15);
        topPanel.add(new JLabel("Name:"));
        topPanel.add(this.nameField);
        this.geometryChoice = new JComboBox<String>(geometryNames);
        xPanel.add(this.geometryChoice);
        this.tilerChoice = new JComboBox<String>(tilerNames);
        xPanel.add(new JLabel("Length:"));
        xPanel.add(this.lengthField);
        sPanel.add(new JLabel("Position: x:"));
        sPanel.add(this.sxField);
        sPanel.add(new JLabel("y:"));
        sPanel.add(this.syField);
        sPanel.add(new JLabel("z:"));
        sPanel.add(this.szField);
        center.add(xPanel);
        center.add(sPanel);
        center.add(checkPanel);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)topPanel, "North");
        f.add((Component)bottomPanel, "South");
        f.add((Component)center, "Center");
    }

    Vector3D generatePosition() {
        log.info("Line 174: PlatonicSolidWizard!");
        Vector3D result = null;
        double sx = Double.parseDouble(this.sxField.getText().trim());
        double sy = Double.parseDouble(this.syField.getText().trim());
        double sz = Double.parseDouble(this.szField.getText().trim());
        result = new Vector3D(sx, sy, sz);
        return result;
    }

    private void readOutValues() {
        this.addStemsFlag = this.addStemsBox.isSelected();
        this.onlyFirstPathMode = this.onlyFirstPathBox.isSelected();
        this.charString = this.seqCharField.getText().trim();
        this.length = Double.parseDouble(this.lengthField.getText().trim());
        this.name = this.nameField.getText().trim();
        this.geometryId = this.geometryChoice.getSelectedIndex();
        this.tilerAlgorithm = this.translateTilerId(this.tilerChoice.getSelectedIndex());
    }

    private int translateGeometryId(int id) {
        switch (id) {
            case 0: {
                return 10;
            }
            case 1: {
                return 11;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 13;
            }
            case 4: {
                return 14;
            }
        }
        log.severe("internal error in PlatonicSolidWizard!");
        return 11;
    }

    private int translateTilerId(int id) {
        switch (id) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        log.severe("Internal error in PlatonicSolidWizard!");
        return 3;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlatonicSolidWizard.this.frame.setVisible(false);
            PlatonicSolidWizard.this.frame = null;
            PlatonicSolidWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlatonicSolidWizard.this.readOutValues();
            char sequenceChar = 'N';
            if (PlatonicSolidWizard.this.charString.length() > 0) {
                sequenceChar = PlatonicSolidWizard.this.charString.charAt(0);
            }
            String childNameBase = "p";
            int geometryCode = PlatonicSolidWizard.this.translateGeometryId(PlatonicSolidWizard.this.geometryId);
            try {
                PlatonicSolidWizard.this.graphController.addGeometry(new Vector3D(PlatonicSolidWizard.this.sx, PlatonicSolidWizard.this.sy, PlatonicSolidWizard.this.sz), PlatonicSolidWizard.this.length, PlatonicSolidWizard.this.name, childNameBase, PlatonicSolidWizard.this.addStemsFlag, sequenceChar, PlatonicSolidWizard.this.onlyFirstPathMode, geometryCode, PlatonicSolidWizard.this.tilerAlgorithm);
            }
            catch (Object3DGraphControllerException exc) {
                JOptionPane.showMessageDialog(PlatonicSolidWizard.this.frame, "An error occured during the tiling algorithm: " + exc.getMessage());
            }
            PlatonicSolidWizard.this.frame.setVisible(false);
            PlatonicSolidWizard.this.frame = null;
            PlatonicSolidWizard.this.finished = true;
        }
    }
}

