/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import guitools.BeanEditor;
import guitools.XMLBeanEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DHandle;
import rnadesign.rnacontrol.SequenceController;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleRnaStrand;
import sequence.DnaTools;
import sequence.Sequence;
import sequence.SimpleSequence;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;

public class RnaStrandWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    Object3DController controller;
    SequenceController sequences;
    BeanEditor beanEditor = new XMLBeanEditor();
    Component frame;

    @Override
    public void addActionListener(ActionListener listener) {
        this.beanEditor.addActionListener(listener);
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component frame) {
        this.controller = controller.getGraph();
        this.frame = frame;
        SimpleRnaStrand strand = new SimpleRnaStrand();
        this.initStrand(strand);
        this.beanEditor.addActionListener(new DoneActionListener());
        this.beanEditor.launchEdit(strand, frame);
    }

    public Object3DHandle getObject3DHandle() {
        return new Object3DHandle((Object3D)this.beanEditor.getObject());
    }

    private Sequence generateInitSequence() {
        String s = "NNNNNNNNNNNNNNNNNNNN";
        char c = (char)(65 + this.sequences.getSequenceCount());
        char[] chars = new char[]{c};
        String name = new String(chars);
        SimpleSequence result = null;
        try {
            result = new SimpleSequence(s, name, DnaTools.AMBIGUOUS_RNA_ALPHABET);
        }
        catch (UnknownSymbolException e) {
            // empty catch block
        }
        return result;
    }

    private void initStrand(RnaStrand strand) {
        SimpleRnaStrand helpStrand = new SimpleRnaStrand();
        Vector3D pos = new Vector3D(10.0, 20.0, 10.0);
        helpStrand.setRelativePosition(pos);
        strand.setRelativePosition(pos);
        Sequence sequence = this.generateInitSequence();
        log.warning("Sorry, RNA Strand wizard is currently not functional");
        assert (false);
        strand.setRelativePosition(pos);
        for (int i = 0; i < sequence.size(); ++i) {
        }
    }

    @Override
    public boolean isFinished() {
        return this.beanEditor.isFinished();
    }

    private class DoneActionListener
    implements ActionListener {
        private DoneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Calling DoneActionListener in RnaStrandWizard!");
            if (RnaStrandWizard.this.isFinished()) {
                log.fine("Calling DoneActionListener in RnaStrandWizard: text editor was finished!");
                Object3DHandle object3DHandle = RnaStrandWizard.this.getObject3DHandle();
                if (object3DHandle != null && object3DHandle.isValid()) {
                    RnaStrandWizard.this.controller.addGraph(object3DHandle);
                    log.fine("Here was adding of graph!");
                } else {
                    log.fine("Object3DDebugHandle was null!");
                }
                log.fine("Inserting new object into main object tree!");
            } else {
                log.fine("Calling DoneActionListener in RnaStrandWizard: text editor was NOT finished!");
            }
            if (RnaStrandWizard.this.frame != null) {
                RnaStrandWizard.this.frame.repaint();
            }
            log.fine("RnaStrandWizard finished!");
        }
    }
}

