/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.objects3d.Object3D;

public class SignatureWizard
implements GeneralWizard {
    private static final int COL_SIZE_NAME = 30;
    private static final String FRAME_TITLE = "Signature Wizard";
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Object3DGraphController graphController;
    private JTextField objectField;
    private JTextArea resultsField;
    private Vector<String> tree;
    private String[] allowedNames = new String[]{"Object3D", "RnaStrand", "Atom3D", "Nucleotide3D"};
    private String[] forbiddenNames = null;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JLabel label;
    private JScrollPane treeScroll;

    public SignatureWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel instructionsPanel = new JPanel();
        instructionsPanel.setLayout(new BoxLayout(instructionsPanel, 1));
        this.label = new JLabel("             Specify the parent object in the field below.");
        instructionsPanel.add(this.label);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        this.label = new JLabel("Object: ");
        labelPanel.add(this.label);
        this.label = new JLabel("Results: ");
        labelPanel.add(this.label);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        this.objectField = new JTextField(this.getSelectionText(), 30);
        fieldPanel.add(this.objectField);
        this.resultsField = new JTextArea(20, 20);
        this.resultsField.setLineWrap(true);
        JScrollPane resultsScroller = new JScrollPane(this.resultsField);
        resultsScroller.setVerticalScrollBarPolicy(20);
        fieldPanel.add(resultsScroller);
        TreePanel treePanel = new TreePanel(this.objectField);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Generate Signature");
        button.addActionListener(new SignatureListener());
        buttonPanel.add(button);
        f.add((Component)instructionsPanel, "North");
        f.add((Component)labelPanel, "West");
        f.add((Component)fieldPanel, "Center");
        f.add((Component)treePanel, "East");
        f.add((Component)buttonPanel, "South");
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        if (controller == null) {
            log.info("GraphController received by lauchWizard is null!");
        }
        this.graphController = controller;
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextField field) {
            Object3DGraphController controller = ((AbstractDesigner)SignatureWizard.this.application).getGraphController();
            SignatureWizard.this.tree = controller.getGraph().getTree(SignatureWizard.this.allowedNames, SignatureWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            SignatureWizard.this.treePanel = new JPanel();
            SignatureWizard.this.treeList = new JList(SignatureWizard.this.tree);
            SignatureWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            SignatureWizard.this.treeScroll = new JScrollPane(SignatureWizard.this.treeList);
            SignatureWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            SignatureWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            SignatureWizard.this.treeScroll.setPreferredSize(new Dimension(300, 300));
            SignatureWizard.this.treePanel.add(SignatureWizard.this.treeScroll);
            this.add((Component)SignatureWizard.this.treePanel, "South");
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextField field;

        public SelectionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)SignatureWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)SignatureWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.setText(text);
            }
        }
    }

    private class SignatureListener
    implements ActionListener {
        private SignatureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String signatureResult = SignatureWizard.this.graphController.generateSignature(SignatureWizard.this.objectField.getText());
                SignatureWizard.this.resultsField.setText(signatureResult);
            }
            catch (Object3DGraphControllerException ce) {
                JOptionPane.showMessageDialog(SignatureWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SignatureWizard.this.frame.setVisible(false);
            SignatureWizard.this.frame = null;
            SignatureWizard.this.finished = true;
        }
    }
}

