/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import controltools.ModelChanger;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerEventConstants;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.Object3DHandle;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.Molecule3D;
import rnadesign.rnamodel.MoleculeTools;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.RnaUnfolder;
import rnadesign.rnamodel.SequenceCollector;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandSimilarity;
import sequence.Sequence;
import tools3d.Appearance;
import tools3d.RotationDescriptor;
import tools3d.SimpleRotationDescriptor;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.CoordinateSystemObject3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DActionVisitor;
import tools3d.objects3d.Object3DDepthIterator;
import tools3d.objects3d.Object3DFirstSelectedWrapperAction;
import tools3d.objects3d.Object3DIterator;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetSelected;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.Object3DTranslator;
import tools3d.objects3d.Object3DWriter;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DSet;

public class Object3DController
implements ModelChanger {
    public static final int NO_SEQUENCE_RENAMING = 0;
    public static final int SEQUENCE_RENAMING_ABC = 1;
    public static final int SEQUENCE_RENAMING_COUNTER = 2;
    private static final Object3DGraphControllerEventConstants eventConst = new Object3DGraphControllerEventConstants();
    private int depthMax = 10;
    private List<ModelChangeListener> modelChangeListeners = new ArrayList<ModelChangeListener>();
    private Object3D graph;
    private Object3D selectionCursor;
    private Object3D selectionRoot;
    private Object3DIterator iterator;
    private Vector3D[] points;
    private String rootName = "root";
    private Appearance selectionRootPoint = new Appearance();
    private int renameSequenceMode = 2;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public Object3DController() {
        if (this.graph == null) {
            this.setGraph(this.createRootNode());
        }
    }

    public CoordinateSystem3D applyNormalizedOrientation(String rootName, String className) {
        Object3D tree = this.getGraph();
        if (rootName != null) {
            tree = this.findByFullName(rootName);
        }
        if (tree == null) {
            return null;
        }
        return Object3DTools.applyNormalizedOrientation(tree, className);
    }

    String generateNewSequenceName(String origName, Set<String> sofarNames) {
        assert (origName != null);
        assert (sofarNames != null);
        String result = origName;
        if (!sofarNames.contains(origName)) {
            return origName;
        }
        int counter = 1;
        switch (this.renameSequenceMode) {
            case 0: {
                return origName;
            }
            case 1: {
                assert (false);
                break;
            }
            case 2: {
                while (sofarNames.contains(result)) {
                    result = origName + "_" + counter;
                    ++counter;
                }
                break;
            }
        }
        return result;
    }

    void addAtom(Nucleotide3D obj, String atomName) throws Object3DGraphControllerException {
        assert (obj != null);
        assert (atomName != null);
        try {
            if ("P".equals(atomName)) {
                NucleotideDBTools.addMissingPhosphor(obj);
            } else if ("OP".equals(atomName) || "O1P".equals(atomName) || "O2P".equals(atomName)) {
                NucleotideTools.addMissingOP(obj);
            } else if ("O3*".equals(atomName)) {
                NucleotideTools.addMissingO3Prime(obj);
            }
        }
        catch (RnaModelException rme) {
            throw new Object3DGraphControllerException(rme.getMessage());
        }
    }

    void addAtom(String nucleotideName, String atomName) throws Object3DGraphControllerException {
        assert (nucleotideName != null);
        assert (atomName != null);
        Object3D obj = Object3DTools.findByFullName(this.graph, nucleotideName);
        boolean result = false;
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object: " + nucleotideName);
        }
        if (obj instanceof Nucleotide3D) {
            this.addAtom((Nucleotide3D)obj, atomName);
        } else if (obj instanceof RnaStrand) {
            RnaStrand strand = (RnaStrand)obj;
            for (int i = 0; i < strand.getResidueCount(); ++i) {
                this.addAtom((Nucleotide3D)strand.getResidue3D(i), atomName);
            }
        } else {
            throw new Object3DGraphControllerException("Object has to be nucleotide or strand");
        }
    }

    public void addEnding(String objectFullName, String ending, Set<String> allowedNames, Set<String> forbiddenNames) throws Object3DGraphControllerException {
        assert (this.graph != null);
        Object3D obj = Object3DTools.findByFullName(this.graph, objectFullName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object: " + objectFullName);
        }
        Object3DTools.addEnding(obj, ending, allowedNames, forbiddenNames);
    }

    public int getChildrenCount(String fullName) throws Object3DGraphControllerException {
        log.finest("Starting Object3DController.getChildrenCount!");
        if (this.graph == null) {
            throw new Object3DGraphControllerException("No object graph defined!");
        }
        Object3D obj = null;
        obj = fullName != null && fullName.length() > 0 ? Object3DTools.findByFullName(this.graph, fullName) : this.graph;
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + fullName);
        }
        return obj.size();
    }

    public boolean addGraph(Object3D g) {
        if (g == null) {
            return false;
        }
        if (this.graph == null) {
            this.setGraph(this.createRootNode());
        }
        if (this.renameSequenceMode != 0) {
            SequenceCollector currentSeqCollector = Object3DGraphController.generateCollectedSequences(this.graph);
            HashSet<String> currentSequenceNames = new HashSet<String>();
            for (int i = 0; i < currentSeqCollector.getSequenceCount(); ++i) {
                currentSequenceNames.add(currentSeqCollector.getSequence(i).getName());
            }
            SequenceCollector newSeqCollector = Object3DGraphController.generateCollectedSequences(g);
            for (int i = 0; i < newSeqCollector.size(); ++i) {
                Sequence seq = newSeqCollector.getSequence(i);
                seq.setName(this.generateNewSequenceName(seq.getName(), currentSequenceNames));
                currentSequenceNames.add(seq.getName());
            }
        }
        String origName = g.getName();
        String newName = this.graph.insertChildSafe(g);
        if (!newName.equals(origName)) {
            log.warning("Renaming object " + origName + " to " + newName + " upon insertion into " + this.rootName);
        }
        this.refresh(new ModelChangeEvent((Object)this, 4));
        return true;
    }

    public void addGraph(Object3D g, String rootName) throws Object3DGraphControllerException {
        assert (g != null);
        assert (rootName != null);
        Object3D rootObj = Object3DTools.findByFullName(this.getGraph(), rootName);
        if (rootObj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + rootName);
        }
        if (this.renameSequenceMode != 0) {
            SequenceCollector currentSeqCollector = Object3DGraphController.generateCollectedSequences(this.graph);
            HashSet<String> currentSequenceNames = new HashSet<String>();
            for (int i = 0; i < currentSeqCollector.getSequenceCount(); ++i) {
                currentSequenceNames.add(currentSeqCollector.getSequence(i).getName());
            }
            SequenceCollector newSeqCollector = Object3DGraphController.generateCollectedSequences(g);
            for (int i = 0; i < newSeqCollector.size(); ++i) {
                Sequence seq = newSeqCollector.getSequence(i);
                seq.setName(this.generateNewSequenceName(seq.getName(), currentSequenceNames));
                currentSequenceNames.add(seq.getName());
            }
        }
        String origName = g.getName();
        String newName = rootObj.insertChildSafe(g);
        if (!newName.equals(origName)) {
            log.warning("Renaming object " + origName + " to " + newName + " upon insertion into " + rootName);
        }
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void addGraph(Object3DHandle g) {
        this.addGraph(g.getObject3D());
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    @Override
    public void addModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void clear() {
        this.graph = null;
        this.iterator = null;
        this.setGraph(this.createRootNode());
    }

    private Object3D createRootNode() {
        SimpleObject3D root = new SimpleObject3D();
        root.setName(this.rootName);
        return root;
    }

    void cloneObject(String origFullName, String newParentFullName, String newIndividualName, int symId) throws Object3DGraphControllerException {
        log.fine("Starting Object3DController.cloneObject!");
        if (this.graph == null) {
            throw new Object3DGraphControllerException("No object graph defined!");
        }
        Object3D obj = Object3DTools.findByFullName(this.graph, origFullName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Object3DController: Could not find original object with name: " + origFullName);
        }
        Object3D parent = Object3DTools.findByFullName(this.graph, newParentFullName);
        if (parent == null) {
            throw new Object3DGraphControllerException("Object3DController: Could not find new parent object with name: " + newParentFullName);
        }
        Object3D newObj = (Object3D)obj.cloneDeep();
        newObj.setName(newIndividualName);
        int origSize = parent.size();
        parent.insertChild(newObj);
        assert (parent.size() == origSize + 1);
        log.fine("Finished Object3DController.cloneObject!");
    }

    public double computeDistance(String origFullName, String newParentFullName) throws Object3DGraphControllerException {
        if (this.graph == null) {
            throw new Object3DGraphControllerException("No object graph defined!");
        }
        Object3D obj = Object3DTools.findByFullName(this.graph, origFullName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + origFullName);
        }
        Object3D parent = Object3DTools.findByFullName(this.graph, newParentFullName);
        if (parent == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + newParentFullName);
        }
        return obj.distance(parent);
    }

    String fuseStrands(String strandFullName1, String strandFullName2) throws Object3DGraphControllerException {
        String appendedStrandName = strandFullName1;
        Object3D obj1 = this.findByFullName(strandFullName1);
        if (obj1 == null || !(obj1 instanceof RnaStrand)) {
            throw new Object3DGraphControllerException("Could not find strand with name " + strandFullName1);
        }
        Object3D obj2 = this.findByFullName(strandFullName2);
        if (obj2 == null || !(obj2 instanceof RnaStrand)) {
            throw new Object3DGraphControllerException("Could not find strand with name " + strandFullName2);
        }
        NucleotideStrand strand1 = (NucleotideStrand)obj1;
        NucleotideStrand strand2 = (NucleotideStrand)obj2;
        if (strand1.getResidueCount() == 0) {
            throw new Object3DGraphControllerException("Strand must have at leat one residue: " + strandFullName1);
        }
        if (strand2.getResidueCount() == 0) {
            throw new Object3DGraphControllerException("Strand must have at leat one residue: " + strandFullName2);
        }
        double d1 = strand1.getResidue3D(strand1.getResidueCount() - 1).distance(strand2.getResidue3D(0));
        double d2 = strand2.getResidue3D(strand2.getResidueCount() - 1).distance(strand1.getResidue3D(0));
        boolean atomMode = false;
        if (strand1.getResidue3D(strand1.getResidueCount() - 1).getIndexOfChild("O3*") >= 0 && strand2.getResidue3D(strand2.getResidueCount() - 1).getIndexOfChild("O3*") >= 0 && strand2.getResidue3D(0).getIndexOfChild("P") >= 0 && strand1.getResidue3D(0).getIndexOfChild("P") >= 0) {
            atomMode = true;
            d1 = strand1.getResidue3D(strand1.getResidueCount() - 1).getChild("O3*").distance(strand2.getResidue3D(0).getChild("P"));
            d2 = strand2.getResidue3D(strand2.getResidueCount() - 1).getChild("O3*").distance(strand1.getResidue3D(0).getChild("P"));
        }
        if (d1 < 12.0) {
            strand1.append(strand2);
            this.remove(strand2);
            log.info("Appending " + strandFullName2 + " to " + strandFullName1);
        } else if (d2 < 12.0) {
            strand2.append(strand1);
            this.remove(strand1);
            log.info("Appending " + strandFullName1 + " to " + strandFullName2);
            appendedStrandName = strandFullName2;
        } else {
            throw new Object3DGraphControllerException("Strands are too far to be fused: " + d2);
        }
        return appendedStrandName;
    }

    private boolean hasClosebyAtom(Atom3D atom, RnaStrand strandOrig, Object3DSet strands, double distance) {
        double resCutoff = 20.0;
        for (int i = 0; i < strands.size(); ++i) {
            RnaStrand strand = (RnaStrand)strands.get(i);
            if (strand == strandOrig) continue;
            for (int j = 0; j < strand.getResidueCount(); ++j) {
                double d;
                Residue3D residue = strand.getResidue3D(j);
                for (int k = 0; k < residue.getAtomCount() && !((d = atom.distance(residue.getAtom(k))) > resCutoff); ++k) {
                    if (!(d < distance)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDuplicateStrand(RnaStrand strand, Object3DSet strands, double distance) {
        block0: for (int i = 0; i < strand.getResidueCount(); ++i) {
            Residue3D residue = strand.getResidue3D(i);
            for (int j = 0; j < residue.getAtomCount(); ++j) {
                if (!this.hasClosebyAtom(residue.getAtom(j), strand, strands, distance)) {
                    return false;
                }
                if (j > 0) continue block0;
            }
        }
        return true;
    }

    public void reportMissingAtoms(Nucleotide3D nuc, PrintStream ps) {
        List<String> result = NucleotideTools.findMissingAtoms(nuc);
        if (result != null && result.size() > 0) {
            ps.print("Nucleotide " + nuc.getFullName() + " has missing atoms:");
            for (String name : result) {
                ps.print(" " + name);
            }
            ps.println();
        }
    }

    public void checkStructure(RnaStrand strand, PrintStream ps) {
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            this.reportMissingAtoms((Nucleotide3D)strand.getResidue3D(i), ps);
        }
    }

    public void checkStructure(PrintStream ps) {
        Object3DSet strands = Object3DTools.collectByClassName(this.getGraph(), "RnaStrand");
        for (int i = 0; i < strands.size(); ++i) {
            this.checkStructure((RnaStrand)strands.get(i), ps);
        }
    }

    public void removeDuplicateSequences() {
        Object3DSet strands = Object3DTools.collectByClassName(this.getGraph(), "RnaStrand");
        boolean isOk = true;
        double distanceCutoff = 1.5;
        do {
            for (int i = strands.size() - 1; i >= 0; --i) {
                assert (strands.get(i) instanceof RnaStrand);
                RnaStrand strand = (RnaStrand)strands.get(i);
                if (strand.getParent() instanceof StrandJunction3D) continue;
                if (this.isDuplicateStrand(strand, strands, distanceCutoff)) {
                    log.info("Removing strand: " + strand.getFullName());
                    this.remove(strand);
                    strands.remove(strand);
                    isOk = false;
                    continue;
                }
                log.info("Keeping strand " + strand.getFullName());
            }
        } while (!isOk);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public String splitStrand(String strandFullName, int position) throws Object3DGraphControllerException {
        String appendedStrandName = strandFullName;
        Object3D obj1 = this.findByFullName(strandFullName);
        if (obj1 == null || !(obj1 instanceof NucleotideStrand) || obj1.getParent() == null) {
            throw new Object3DGraphControllerException("Could not find strand or parent object of object with name " + strandFullName);
        }
        NucleotideStrand strand1 = (NucleotideStrand)obj1;
        if (strand1.getResidueCount() < position) {
            throw new Object3DGraphControllerException("Strand must have at leat one residue: " + strandFullName);
        }
        String newName = strand1.getName() + "_split";
        NucleotideStrand newStrand = (NucleotideStrand)strand1.split(position, newName);
        if (strand1.getParent().getChild(newName) != null) {
            throw new Object3DGraphControllerException("Object with name already exists: " + newStrand.getName());
        }
        strand1.getParent().insertChild(newStrand);
        this.refresh(new ModelChangeEvent((Object)this, 3));
        return strand1.getFullName();
    }

    private Object3D synthesizeObject(String className, Vector3D position, String name) throws Object3DGraphControllerException {
        assert (className != null);
        assert (name != null);
        assert (position != null);
        SimpleObject3D obj = null;
        if (className.equals("Object3D") || className.equals("simple")) {
            obj = new SimpleObject3D(position);
        } else if (className.equals("CoordinateSystem3D") || className.equals("cs")) {
            obj = new CoordinateSystem3D(position);
        } else {
            throw new Object3DGraphControllerException("Generating object " + className + " is not available.");
        }
        obj.setName(name);
        return obj;
    }

    public Object3D findByFullName(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        Object3D result = Object3DTools.findByFullName(this.graph, name);
        return result;
    }

    public Object3DSet findAllByFullName(String name) throws Object3DGraphControllerException {
        SimpleObject3DSet result = new SimpleObject3DSet();
        if (name == null || name.length() == 0) {
            throw new Object3DGraphControllerException("No viable name defined for findAllByFullName.");
        }
        if (name.charAt(name.length() - 1) != '*') {
            Object3D obj = Object3DTools.findByFullName(this.graph, name);
            if (obj != null) {
                result.add(obj);
            }
        } else {
            if (name.length() < 3 || name.charAt(name.length() - 2) != '.') {
                throw new Object3DGraphControllerException("Bad placeholder syntax in findAllByFullName: " + name);
            }
            String pName = name.substring(0, name.length() - 2);
            Object3D pObj = this.findByFullName(pName);
            if (pObj == null) {
                throw new Object3DGraphControllerException("Could not find parent object in findAllByFullName: " + pName);
            }
            for (int i = 0; i < pObj.size(); ++i) {
                result.add(pObj.getChild(i));
            }
        }
        return result;
    }

    public void generateSignature(String signature) {
        System.out.println("Not yet implemented");
    }

    public Properties superposeStrands(String fullName1, String fullName2) throws Object3DGraphControllerException {
        Object3D obj1 = this.findByFullName(fullName1);
        Object3D obj2 = this.findByFullName(fullName2);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + fullName1);
        }
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + fullName2);
        }
        StrandSimilarity similarityGenerator = new StrandSimilarity();
        Properties properties = similarityGenerator.similarity(obj1, obj2);
        properties.setProperty("name1", fullName1);
        properties.setProperty("name2", fullName2);
        return properties;
    }

    public void synthesizeObject(String className, Vector3D position, String name, String newParentFullName) throws Object3DGraphControllerException {
        assert (className != null);
        assert (name != null);
        assert (position != null);
        Object3D obj = this.synthesizeObject(className, position, name);
        assert (obj.getName().equals(name));
        Object3D newParent = Object3DTools.findByFullName(this.graph, newParentFullName);
        if (newParent == null) {
            throw new Object3DGraphControllerException("Could not find parent object with name: " + newParentFullName);
        }
        if (newParent.getChild(obj.getName()) != null) {
            throw new Object3DGraphControllerException("Object " + newParentFullName + " already has child node with name " + name);
        }
        newParent.insertChild(obj);
    }

    public void moveObject(Object3D obj, Object3D newParent) throws Object3DGraphControllerException {
        log.fine("Starting Object3DController.moveObject!");
        Object3D oldParent = obj.getParent();
        if (oldParent == null) {
            throw new Object3DGraphControllerException("Cannot move root object: " + obj.getFullName());
        }
        oldParent.removeChild(obj);
        newParent.insertChild(obj);
        log.fine("Finished Object3DController.moveObject!");
    }

    public void moveObject(String origFullName, String newParentFullName) throws Object3DGraphControllerException {
        log.fine("Starting Object3DController.moveObject!");
        if (this.graph == null) {
            throw new Object3DGraphControllerException("No object graph defined!");
        }
        Object3D obj = Object3DTools.findByFullName(this.graph, origFullName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + origFullName);
        }
        Object3D newParent = Object3DTools.findByFullName(this.graph, newParentFullName);
        if (newParent == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + newParentFullName);
        }
        Object3D oldParent = obj.getParent();
        if (oldParent == null) {
            throw new Object3DGraphControllerException("Cannot move root object: " + origFullName);
        }
        oldParent.removeChild(obj);
        newParent.insertChild(obj);
        log.fine("Finished Object3DController.moveObject!");
    }

    public void moveToClosestObject(String origFullName, String parentFullName, String distClassName, String assignClassName, double distCutoff) throws Object3DGraphControllerException {
        log.fine("Starting Object3DController.moveObject!");
        if (this.graph == null) {
            throw new Object3DGraphControllerException("No object graph defined!");
        }
        Object3D obj = Object3DTools.findByFullName(this.graph, origFullName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + origFullName);
        }
        String name = obj.getName();
        Object3D newParent = Object3DTools.findByFullName(this.graph, parentFullName);
        if (newParent == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + parentFullName);
        }
        Vector3D pos = obj.getPosition();
        Object3DSet assignObjectSet = Object3DTools.collectByClassName(newParent, assignClassName);
        double dMax = 1.0E30;
        Object3D bestParent = null;
        Object3D bestPartner = null;
        for (int i = 0; i < assignObjectSet.size(); ++i) {
            double d;
            Object3D other = Object3DTools.findClosestByClassName(assignObjectSet.get(i), pos, distClassName);
            if (other == null || !((d = other.getPosition().distance(pos)) < dMax)) continue;
            dMax = d;
            bestParent = assignObjectSet.get(i);
            bestPartner = other;
        }
        if (bestParent != null && dMax <= distCutoff) {
            log.info("Inserting object " + obj.getFullName() + " as child node of " + bestParent.getFullName() + " because of close distance to " + bestPartner.getFullName() + " : " + dMax);
            this.moveObject(obj, bestParent);
        }
        log.fine("Finished Object3DController.moveObject!");
    }

    @Override
    public void fireModelChanged(ModelChangeEvent changeEvent) {
        log.fine("calling Object3DController.fireModelChanged!");
        for (int i = 0; i < this.modelChangeListeners.size(); ++i) {
            ModelChangeListener listener = this.modelChangeListeners.get(i);
            listener.modelChanged(changeEvent);
        }
    }

    public int getDepthMax() {
        return this.depthMax;
    }

    public Object3D getGraph() {
        return this.graph;
    }

    public Object3D getGraph(String fullName) {
        return Object3DTools.findByFullName(this.graph, fullName);
    }

    public Object3D getSelectionCursor() {
        return this.selectionCursor;
    }

    public Object3D getSelectionRoot() {
        return this.selectionRoot;
    }

    public Vector<String> getTree(Set<String> allowedNames, Set<String> forbiddenNames) {
        if (this.graph != null) {
            return Object3DTools.getFullNameTree(this.graph, allowedNames, forbiddenNames);
        }
        Vector<String> result = new Vector<String>();
        result.add("No object tree defined!");
        return result;
    }

    public Vector<String> getTree(String[] allowedNamesRaw, String[] forbiddenNamesRaw) {
        HashSet<String> allowedNames = new HashSet<String>();
        HashSet<String> forbiddenNames = new HashSet<String>();
        if (allowedNamesRaw != null) {
            for (String s : allowedNamesRaw) {
                allowedNames.add(s);
            }
        }
        if (forbiddenNamesRaw != null) {
            for (String s : forbiddenNamesRaw) {
                forbiddenNames.add(s);
            }
        }
        return this.getTree(allowedNames, forbiddenNames);
    }

    public void printTree(PrintStream ps, Set<String> allowedNames, Set<String> forbiddenNames) {
        log.fine("Starting printTree[1]");
        if (this.graph != null) {
            Object3DTools.printFullNameTree(ps, this.graph, allowedNames, forbiddenNames);
        } else {
            ps.println("No object tree defined!");
        }
    }

    public void printTree(PrintStream ps, String name, Set<String> allowedNames, Set<String> forbiddenNames) {
        log.fine("Starting printTree[2] for name: " + name);
        if (this.graph != null) {
            Object3D obj = this.findByFullName(name);
            if (obj == null) {
                ps.println("Could not find object with name: " + name);
            } else {
                log.fine("Calling printFullNameTree(ps, obj) for object " + obj.getFullName());
                Object3DTools.printFullNameTree(ps, obj, allowedNames, forbiddenNames);
            }
        } else {
            ps.println("No object tree defined!");
        }
    }

    public void removeByClassName(String className) {
        Object3D root = this.getSelectionCursor();
        if (root != null) {
            Object3DSet set = Object3DTools.collectByClassName(root, className);
            for (int i = 0; i < set.size(); ++i) {
                this.remove(set.get(i));
            }
        }
    }

    public Vector3D computeCenterOfMass(Object3D treeRoot, String className) {
        if (treeRoot == null) {
            treeRoot = this.getGraph();
        }
        return Object3DSetTools.centerOfMass(Object3DTools.collectByClassName(treeRoot, className));
    }

    public Object3DSet collectAtoms() {
        return Object3DTools.collectByClassName(this.getGraph(), "Atom3D");
    }

    public Object3DSet collectResidues() {
        return Object3DTools.collectByClassName(this.getGraph(), "Nucleotide3D");
    }

    public Object3DSet collectJunctions() {
        return Object3DTools.collectByClassName(this.getGraph(), "StrandJunction3D");
    }

    public Object3DSet collectKissingLoops() {
        return Object3DTools.collectByClassName(this.getGraph(), "KissingLoop3D");
    }

    public int countAtomCollisions(double distance, Level verboseLevel) {
        return AtomTools.countAtomCollisions(this.collectAtoms(), distance, verboseLevel);
    }

    public void rename(String newName) throws Object3DGraphControllerException {
        Object3D root = this.getSelectionRoot();
        if (root != null) {
            if (root.getParent() == null) {
                throw new Object3DGraphControllerException("Cannot rename root object!");
            }
        } else {
            throw new Object3DGraphControllerException("No object selected!");
        }
        root.setName(newName);
    }

    public void selectAll() {
        log.fine("calling Object3DController.selectAll()");
        this.selectionCursor = this.graph;
        this.selectionRoot = this.graph;
        Object3DSetSelected selectSetter = new Object3DSetSelected(true);
        Object3DActionVisitor selectVisitor = new Object3DActionVisitor(this.selectionRoot, selectSetter);
        selectVisitor.nextToEnd();
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void select(Object3D obj) {
        log.fine("calling Object3DController.select()");
        assert (Object3DTools.isAncestor(this.graph, obj) || obj == this.graph);
        this.selectionCursor = obj;
        this.selectionRoot = obj;
        Object3DSetSelected selectSetter = new Object3DSetSelected(true);
        Object3DActionVisitor selectVisitor = new Object3DActionVisitor(this.selectionRoot, selectSetter);
        selectVisitor.nextToEnd();
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void selectByFullName(String name) throws Object3DGraphControllerException {
        if (this.graph == null) {
            throw new Object3DGraphControllerException("No object graph defined!");
        }
        Object3D obj = Object3DTools.findByFullName(this.graph, name);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name);
        }
        assert (Object3DTools.isAncestor(this.graph, obj) || this.graph == obj);
        this.select(obj);
    }

    public void selectCurrent() {
        Object3DSetSelected selectSetter = new Object3DSetSelected(true);
        Object3DActionVisitor selectVisitor = new Object3DActionVisitor(this.selectionCursor, selectSetter);
        this.selectionRoot = this.selectionCursor;
        selectVisitor.nextToEnd();
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void deselectAll() {
        this.selectionCursor = this.graph;
        this.selectionRoot = null;
        Object3DSetSelected selectSetter = new Object3DSetSelected(true);
        Object3DActionVisitor selectVisitor = new Object3DActionVisitor(this.selectionCursor, selectSetter);
        selectVisitor.nextToEnd();
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void deselectCurrent() {
        Object3DSetSelected deselectSetter = new Object3DSetSelected(false);
        Object3DActionVisitor deselectVisitor = new Object3DActionVisitor(this.selectionCursor, deselectSetter);
        deselectVisitor.nextToEnd();
        if (this.selectionCursor.equals(this.selectionRoot)) {
            this.selectionRoot = null;
        }
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public boolean isEmpty() {
        return this.graph == null || this.graph.size() == 0;
    }

    public void remove(Object3D subTree) {
        log.fine("Started method remove on Object3DController!");
        Object3DTools.remove(subTree);
        if (this.selectionRoot == null) {
            this.selectionCursor = this.graph;
        }
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void randomize(Object3D subTree) {
        log.fine("Started method randomize on Object3DController!");
        Object3DTools.randomizeOrientation(subTree);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void randomizeTranslation(Object3D subTree, double scale) {
        log.fine("Started method randomize on Object3DController!");
        Object3DTools.randomizeTranslation(subTree, scale);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void randomize(String subTreeName) throws Object3DGraphControllerException {
        Object3D obj = Object3DTools.findByFullName(this.graph, subTreeName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object:" + subTreeName);
        }
        this.randomize(obj);
    }

    public void randomize(String subTreeName, String mode, double scale) throws Object3DGraphControllerException {
        Object3D obj = Object3DTools.findByFullName(this.graph, subTreeName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object:" + subTreeName);
        }
        if (mode == null || mode.equals("rotate")) {
            this.randomize(obj);
        } else if (mode.equals("translate")) {
            this.randomizeTranslation(obj, scale);
        } else {
            throw new Object3DGraphControllerException("Unknown randomization mode: " + mode);
        }
    }

    public void remove() {
        log.fine("Started method remove on Object3DController!");
        Object3D selRoot = this.getSelectionCursor();
        if (selRoot != null) {
            Object3DTools.remove(selRoot);
            this.refresh(new ModelChangeEvent((Object)this, 4));
        }
    }

    public void remove(String fullName) throws Object3DGraphControllerException {
        Object3D obj = Object3DTools.findByFullName(this.graph, fullName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + fullName);
        }
        this.remove(obj);
    }

    public void resetSelectionCursor() {
        this.selectionCursor = this.graph;
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void moveUpSelectionCursor() {
        if (this.selectionCursor != null && this.selectionCursor.getParent() != null) {
            this.selectionCursor = this.selectionCursor.getParent();
        }
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void moveDownSelectionCursor() {
        if (this.selectionCursor != null && this.selectionCursor.size() > 0) {
            this.selectionCursor = this.selectionCursor.getChild(0);
        }
        this.refresh(new ModelChangeEvent((Object)this, 1));
    }

    public void incSelectionCursor() {
        if (this.selectionCursor != null && this.selectionCursor.getSiblingCount() > 0 && this.selectionCursor.getSiblingId() + 1 < this.selectionCursor.getSiblingCount()) {
            this.selectionCursor = this.selectionCursor.getSibling(this.selectionCursor.getSiblingId() + 1);
        }
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void decSelectionCursor() {
        if (this.selectionCursor != null && this.selectionCursor.getSiblingCount() > 0 && this.selectionCursor.getSiblingId() > 0) {
            this.selectionCursor = this.selectionCursor.getSibling(this.selectionCursor.getSiblingId() - 1);
        }
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public Object3D getNextObject() {
        if (this.iterator == null) {
            return null;
        }
        return this.iterator.getNextObject();
    }

    public int getObjectCount() {
        if (this.graph == null) {
            return 0;
        }
        return this.graph.getTotalNumberOfObjects();
    }

    public String getGraphText() {
        if (this.graph != null) {
            return ((Object)this.graph).toString();
        }
        return "";
    }

    public String getSelectedGraphText() {
        Object3D cursor = this.getSelectionCursor();
        if (cursor != null) {
            String cursorText = cursor.infoString();
        } else {
            String cursorText = "undefined";
        }
        Object3D selectionRoot = this.getSelectionRoot();
        String selectionRootText = selectionRoot != null ? Object3DTools.generateFullTreeLine(selectionRoot) : "undefined";
        String result = "Selection-root: " + selectionRootText;
        return result;
    }

    public String getSelectedGraphInfoText() {
        Object3D selectionRoot = this.getSelectionRoot();
        String selectionRootText = selectionRoot != null ? Object3DTools.getFullName(selectionRoot) : "undefined";
        return selectionRootText;
    }

    public boolean hasMoreObjects() {
        if (this.iterator != null) {
            return this.iterator.hasMoreObjects();
        }
        return false;
    }

    private void refresh(ModelChangeEvent event) {
        this.iterator = new Object3DDepthIterator(this.graph);
        this.iterator.setDepthMax(this.depthMax);
        this.refreshSelection();
        this.fireModelChanged(event);
    }

    private void refreshSelection() {
        if (this.graph == null) {
            return;
        }
        Object3DTools.setSelectAll(this.graph, false);
        if (this.selectionRoot != null) {
            Object3DTools.setSelectAll(this.selectionRoot, true);
        }
    }

    public void resetIterator() {
        if (this.iterator != null) {
            this.iterator.reset();
        }
    }

    public void rotate(Object3D obj, double ax, double ay, double az, double angle) {
        log.fine("Rotating object: " + ax + " " + ay + " " + az + " " + angle);
        Vector3D axis = new Vector3D(ax, ay, az);
        obj.rotate(axis, angle);
        this.refresh(new ModelChangeEvent((Object)this, 2));
    }

    public void rotateAroudBond(String name1, String name2, double angle) throws Object3DGraphControllerException {
        Object3D parent2;
        Object3D obj1 = Object3DTools.findByFullName(this.graph, name1);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name1);
        }
        Object3D obj2 = Object3DTools.findByFullName(this.graph, name2);
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name2);
        }
        if (obj1 instanceof Atom3D) {
            throw new Object3DGraphControllerException("Object 1 has to be of type atom: " + name1);
        }
        if (obj2 instanceof Atom3D) {
            throw new Object3DGraphControllerException("Object 2 has to be of type atom: " + name2);
        }
        Object3D parent1 = Object3DTools.findAncestorByClassName(obj1, "RnaStrand");
        if (parent1 == (parent2 = Object3DTools.findAncestorByClassName(obj2, "RnaStrand")) && parent1 instanceof RnaStrand) {
            try {
                MoleculeTools.rotateAroundBond((Molecule3D)parent1, (Atom3D)obj1, (Atom3D)obj2, angle);
            }
            catch (RnaModelException rne) {
                throw new Object3DGraphControllerException(rne.getMessage());
            }
            finally {
                this.refresh(new ModelChangeEvent((Object)this, 2));
            }
        } else {
            throw new Object3DGraphControllerException("Atoms definining rotation must currently be of same RNA strand: " + name1 + " " + name2);
        }
    }

    public void alignObject(String name1, String name2, Vector3D direction) throws Object3DGraphControllerException {
        if (direction.length() == 0.0) {
            throw new Object3DGraphControllerException("Direction vector must be non-zero!");
        }
        Object3D obj1 = Object3DTools.findByFullName(this.graph, name1);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name1);
        }
        Object3D obj2 = Object3DTools.findByFullName(this.graph, name2);
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name2);
        }
        Vector3D center = obj1.getPosition();
        Vector3D diff = obj2.getPosition().minus(obj1.getPosition());
        double angle = direction.angle(diff);
        Vector3D axis = diff.cross(direction);
        SimpleRotationDescriptor rotation = new SimpleRotationDescriptor(axis, center, angle);
        this.rotateSelected(rotation);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void alignOrientation(String name) throws Object3DGraphControllerException {
        Object3D obj1 = Object3DTools.findByFullName(this.graph, name);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name);
        }
        if (!(obj1 instanceof CoordinateSystemObject3D)) {
            throw new Object3DGraphControllerException("Object carries no direction information: " + name);
        }
        Object3D obj = this.getSelectionRoot();
        if (obj == null) {
            obj = this.getGraph();
        }
        obj.passiveTransform3(((CoordinateSystemObject3D)obj1).getCoordinateSystem());
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void rotateSelected(RotationDescriptor rotator) {
        Object3D obj = this.getSelectionRoot();
        if (obj != null && obj.isSelected()) {
            obj.rotate(rotator.getCenter(), rotator.getAxis(), rotator.getAngle());
        }
        this.refresh(new ModelChangeEvent((Object)this, 2));
    }

    public void rotateSelected(double ax, double ay, double az, double angle) {
        Object3D obj = this.getSelectionRoot();
        SimpleRotationDescriptor rotator = new SimpleRotationDescriptor(new Vector3D(ax, ay, az), obj.getPosition(), angle);
        this.rotateSelected(rotator);
    }

    public void rotateSelected(Vector3D axis, Vector3D center, double angle) {
        SimpleRotationDescriptor rotator = new SimpleRotationDescriptor(axis, center, angle);
        this.rotateSelected(rotator);
    }

    public void rotateSelected(Vector3D axis, String centerObjectName, double angle) throws Object3DGraphControllerException {
        Object3D obj = Object3DTools.findByFullName(this.graph, centerObjectName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object: " + centerObjectName);
        }
        this.rotateSelected(axis, obj.getPosition(), angle);
    }

    public void twistSelected(RotationDescriptor rotator) {
        Object3D obj = this.getSelectionRoot();
        if (obj != null && obj.isSelected()) {
            obj.twist(rotator.getCenter(), rotator.getAxis(), rotator.getAngle());
        }
        this.refresh(new ModelChangeEvent((Object)this, 2));
    }

    public void twistSelected(Vector3D axis, Vector3D center, double angle) {
        SimpleRotationDescriptor rotator = new SimpleRotationDescriptor(axis, center, angle);
        this.twistSelected(rotator);
    }

    public void twistSelected(double ax, double ay, double az, double angle) {
        Object3D obj = this.getSelectionRoot();
        SimpleRotationDescriptor rotator = new SimpleRotationDescriptor(new Vector3D(ax, ay, az), obj.getPosition(), angle);
        this.twistSelected(rotator);
    }

    public void twistSelected(Vector3D axis, String centerObjectName, double angle) throws Object3DGraphControllerException {
        Object3D obj = Object3DTools.findByFullName(this.graph, centerObjectName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object: " + centerObjectName);
        }
        this.twistSelected(axis, obj.getPosition(), angle);
    }

    public void setDepthMax(int n) {
        this.depthMax = n;
        if (this.iterator != null) {
            this.iterator.setDepthMax(n);
        }
        this.refresh(new ModelChangeEvent((Object)this, 3));
    }

    public void setGraph(Object3D g) {
        this.selectionCursor = this.graph = g;
        this.selectionRoot = null;
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void setSelectionCursor(Object3D cursor) {
        this.selectionCursor = cursor;
    }

    public void translate(Vector3D v) {
        if (this.graph != null) {
            this.graph.translate(v);
        }
        this.refresh(new ModelChangeEvent((Object)this, 1));
    }

    public void applySymmetry(String rootName, int symId) throws Object3DGraphControllerException {
        Object3D tree = this.findByFullName(rootName);
        if (tree == null) {
            throw new Object3DGraphControllerException("Could not find object: " + rootName);
        }
        Object3DTools.applySymmetry(tree, symId);
        this.refresh(new ModelChangeEvent((Object)this, 1));
    }

    public int getRenameSequenceMode() {
        return this.renameSequenceMode;
    }

    public void setRenameSequenceMode(int mode) {
        this.renameSequenceMode = mode;
    }

    public void translateSelected(Vector3D v) {
        if (this.graph != null) {
            Object3DTranslator translatorAction = new Object3DTranslator(v);
            Object3DFirstSelectedWrapperAction selectedAction = new Object3DFirstSelectedWrapperAction(translatorAction);
            Object3DActionVisitor actionVisitor = new Object3DActionVisitor(this.graph, selectedAction);
            actionVisitor.nextToEnd();
        }
        this.refresh(new ModelChangeEvent((Object)this, 1));
    }

    public Properties unfoldStrands() {
        RnaUnfolder unfolder = new RnaUnfolder();
        Properties result = unfolder.fold(this.getGraph());
        this.refresh(new ModelChangeEvent((Object)this, 4));
        return result;
    }

    public void write(OutputStream os, Object3DWriter writer) {
        writer.write(os, this.graph);
    }

    public void writeSelected(OutputStream os, Object3DWriter writer) {
        if (this.selectionRoot != null) {
            writer.write(os, this.selectionRoot);
        }
    }
}

