/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import chemistrytools.ChemicalElement;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.AminoAcid3D;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.Protein3DTools;
import rnadesign.rnamodel.ProteinStrand;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaPhysicalProperties;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import rnasecondary.Interaction;
import rnasecondary.InteractionType;
import tools3d.CharacterShape;
import tools3d.Cube;
import tools3d.Cylinder;
import tools3d.LineShape;
import tools3d.PointShape;
import tools3d.Shape3D;
import tools3d.Shape3DSet;
import tools3d.SimpleShape3D;
import tools3d.SimpleShape3DSet;
import tools3d.Vector3D;
import tools3d.objects3d.FurthestFinder;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Shape3DSetFactory;
import tools3d.objects3d.SimpleObject3D;

public class SimpleShapeSetFactory
implements Shape3DSetFactory {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean addDebugInfoMode = false;
    private int depthMax = -1;
    public static final double SPHERE_RADIUS_MIN = 1.0;

    private void adjustShapeProperties(Shape3D shape, Object3D object, Properties properties) {
        shape.setSelected(object.isSelected());
        shape.setProperties(properties);
    }

    private int getStrandId(RnaStrand strand) {
        Object3D root = strand.getParent();
        if (root == null) {
            return 0;
        }
        String name = strand.getName();
        Object3DSet strands = Rna3DTools.collectRnaStrand(root);
        for (int i = 0; i < strands.size(); ++i) {
            RnaStrand otherStrand = (RnaStrand)strands.get(i);
            String otherName = otherStrand.getName();
            if (!otherName.equals(name)) continue;
            return i;
        }
        return strands.size();
    }

    private int getStrandId(ProteinStrand strand) {
        Object3D root = strand.getParent();
        if (root == null) {
            return 0;
        }
        String name = strand.getName();
        Object3DSet strands = Protein3DTools.collectProteinStrands(root);
        for (int i = 0; i < strands.size(); ++i) {
            ProteinStrand otherStrand = (ProteinStrand)strands.get(i);
            String otherName = otherStrand.getName();
            if (!otherName.equals(name)) continue;
            return i;
        }
        return strands.size();
    }

    public Shape3DSet createSingleObjectShapeSet(Object3D obj) {
        Object3D parent;
        SimpleObject3D residue;
        BioPolymer strand;
        SimpleShape3DSet shapeSet = new SimpleShape3DSet();
        if (obj == null) {
            log.warning("called with null object!");
            return shapeSet;
        }
        Object3D furthestObject = FurthestFinder.find(obj);
        if (furthestObject == null) {
            log.warning("no furthest object found!");
            return shapeSet;
        }
        double radius = obj.distance(furthestObject);
        if (radius < 1.0) {
            radius = 1.0;
        }
        SimpleShape3D shape = null;
        Properties objectProperties = new Properties();
        objectProperties.setProperty("depth", "" + obj.getDepth());
        objectProperties.setProperty("class_name", "" + obj.getClassName());
        boolean siblingId = true;
        if (obj.getParent() != null) {
            objectProperties.setProperty("sibling_id", "" + obj.getSiblingId());
            objectProperties.setProperty("sibling_max", "" + obj.getParent().size());
            objectProperties.setProperty("parent_id", "" + obj.getParent().getSiblingId());
            objectProperties.setProperty("parent_class_name", "" + obj.getParent().getClassName());
        }
        if (obj instanceof Atom3D) {
            Atom3D atom = (Atom3D)obj;
            ChemicalElement chemicalElement = atom.getElement();
            if (chemicalElement != null) {
                String name = chemicalElement.getShortName();
                objectProperties.setProperty("element", name);
            }
            if (atom.getParent().getClassName().equals("Nucleotide3D")) {
                String base = "" + ((Nucleotide3D)atom.getParent()).getSymbol().getCharacter();
                objectProperties.setProperty("base", base);
            }
        }
        RnaPhysicalProperties rna = new RnaPhysicalProperties();
        if (obj instanceof RnaStrand) {
            strand = (RnaStrand)obj;
            radius = rna.getSingleStrandWidth();
            double height = RnaPhysicalProperties.computeSingleStrandLength(strand.getResidueCount());
            int strandId = this.getStrandId((RnaStrand)strand);
            objectProperties.setProperty("strand_id", "" + strandId);
            if (strand.size() == 0) {
                shape = new Cylinder(obj.getPosition(), height, radius);
                this.adjustShapeProperties(shape, obj, objectProperties);
                shapeSet.add(shape);
                int nRes = strand.getResidueCount();
                for (int i = 0; i < nRes; ++i) {
                    Vector3D pos = strand.getResiduePosition(i);
                    char c = strand.getResidue(i).getSymbol().getCharacter();
                    shape = new CharacterShape(c);
                    shape.setPosition(pos);
                    this.adjustShapeProperties(shape, obj, objectProperties);
                    shapeSet.add(shape);
                }
            } else {
                double lRadius = 1.0;
                shape = new PointShape(obj.getPosition(), lRadius);
                this.adjustShapeProperties(shape, obj, objectProperties);
                shapeSet.add(shape);
            }
        } else if (obj instanceof ProteinStrand) {
            strand = (ProteinStrand)obj;
            radius = rna.getSingleStrandWidth();
            double height = RnaPhysicalProperties.computeSingleStrandLength(strand.getResidueCount());
            int strandId = this.getStrandId((ProteinStrand)strand);
            objectProperties.setProperty("strand_id", "" + strandId);
            if (strand.size() == 0) {
                shape = new Cylinder(obj.getPosition(), height, radius);
                this.adjustShapeProperties(shape, obj, objectProperties);
                shapeSet.add(shape);
                int nRes = strand.getResidueCount();
                for (int i = 0; i < nRes; ++i) {
                    Vector3D pos = strand.getResiduePosition(i);
                    char c = strand.getResidue(i).getSymbol().getCharacter();
                    shape = new CharacterShape(c);
                    shape.setPosition(pos);
                    this.adjustShapeProperties(shape, obj, objectProperties);
                    shapeSet.add(shape);
                }
            } else if (this.addDebugInfoMode) {
                shape = new Cube(obj.getPosition(), new Vector3D(radius, radius, radius));
                this.adjustShapeProperties(shape, obj, objectProperties);
                shapeSet.add(shape);
            }
        } else if (obj instanceof Nucleotide3D) {
            residue = (Nucleotide3D)obj;
            parent = residue.getParent();
            int strandId = 1;
            if (parent != null && parent instanceof RnaStrand) {
                RnaStrand parentStrand = (RnaStrand)parent;
                strandId = this.getStrandId(parentStrand);
            }
            objectProperties.setProperty("strand_id", "" + strandId);
            radius = rna.getAverageBaseRadius();
            shape = new PointShape(obj.getPosition(), radius);
            this.adjustShapeProperties(shape, obj, objectProperties);
            shapeSet.add(shape);
            if (((Nucleotide3D)residue).getSymbol() == null) {
                log.severe("Nucleotide3D without symbol!");
                System.exit(1);
            }
            char c = ((Nucleotide3D)residue).getSymbol().getCharacter();
            objectProperties.setProperty("base", "" + c);
            shape = new CharacterShape(c);
            shape.setPosition(obj.getPosition());
            this.adjustShapeProperties(shape, obj, objectProperties);
            shapeSet.add(shape);
        } else if (obj instanceof AminoAcid3D) {
            residue = (AminoAcid3D)obj;
            parent = residue.getParent();
            int strandId = 1;
            if (parent != null && parent instanceof ProteinStrand) {
                ProteinStrand parentStrand = (ProteinStrand)parent;
                strandId = this.getStrandId(parentStrand);
            }
            objectProperties.setProperty("strand_id", "" + strandId);
            radius = rna.getAverageBaseRadius();
            shape = new PointShape(obj.getPosition(), radius);
            this.adjustShapeProperties(shape, obj, objectProperties);
            shapeSet.add(shape);
            if (((AminoAcid3D)residue).getSymbol() == null) {
                log.severe("Amino acid without symbol!");
                System.exit(1);
            }
            char c = ((AminoAcid3D)residue).getSymbol().getCharacter();
            shape = new CharacterShape(c);
            shape.setPosition(obj.getPosition());
            this.adjustShapeProperties(shape, obj, objectProperties);
            shapeSet.add(shape);
        } else if (obj instanceof StrandJunction3D) {
            radius = 3.0;
            shape = new PointShape(obj.getPosition(), radius);
            this.adjustShapeProperties(shape, obj, objectProperties);
            shapeSet.add(shape);
        } else if (obj instanceof BranchDescriptor3D) {
            radius = 2.0;
            Vector3D pos = obj.getPosition();
            Vector3D pos2 = pos.plus(((BranchDescriptor3D)obj).getDirection());
            shape = new PointShape(pos, radius);
            this.adjustShapeProperties(shape, obj, objectProperties);
            shapeSet.add(shape);
            LineShape shape2 = new LineShape(pos, pos2);
            this.adjustShapeProperties(shape2, obj, objectProperties);
            shapeSet.add(shape2);
        } else {
            double lRadius = 1.0;
            shape = new PointShape(obj.getPosition(), lRadius);
            this.adjustShapeProperties(shape, obj, objectProperties);
            shapeSet.add(shape);
        }
        return shapeSet;
    }

    @Override
    public Shape3DSet createShapeSet(Object3D obj) {
        if (obj == null || this.depthMax >= 0 && obj.getDepth() > this.depthMax) {
            return new SimpleShape3DSet();
        }
        Shape3DSet result = this.createSingleObjectShapeSet(obj);
        for (int i = 0; i < obj.size(); ++i) {
            result.merge(this.createShapeSet(obj.getChild(i)));
        }
        return result;
    }

    @Override
    public Shape3DSet createShapeSet(Link link) {
        SimpleShape3DSet result = new SimpleShape3DSet();
        LineShape newShape = new LineShape(link.getObj1().getPosition(), link.getObj2().getPosition());
        Properties linkProperties = new Properties();
        if (link instanceof InteractionLink) {
            InteractionLink intLink = (InteractionLink)link;
            Interaction interaction = intLink.getInteraction();
            InteractionType intType = interaction.getInteractionType();
            if (intType.getSubTypeId() == 1) {
                linkProperties.setProperty("interaction_type", "watson_crick");
            }
            if (intType.getSubTypeId() == 6) {
                linkProperties.setProperty("interaction_type", "backbone");
            }
        }
        newShape.setProperties(linkProperties);
        result.add(newShape);
        if (link.getTypeName().equals("Link") || link.getTypeName().equals("Vector")) {
            // empty if block
        }
        return result;
    }

    @Override
    public int getDepthMax() {
        return this.depthMax;
    }

    @Override
    public void setDepthMax(int n) {
        this.depthMax = n;
    }
}

