/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import generaltools.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.PackageConstants;
import rnadesign.rnamodel.AbstractPdbReader;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.GeneralPdbWriter;
import symmetry.Cell;
import symmetry.DefaultCell;
import symmetry.SpaceGroup;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleObject3D;

public class SymmetryTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("Controller");
    public static final String ccp4PdbsetBinary = rb.getString("ccp4PdbsetBinary");

    public static int computeSpaceGroupSymmetryCount(SpaceGroup spaceGroup) throws Object3DGraphControllerException {
        log.info("Starting computerNumberSpaceGroupSymmetries!");
        Atom3D dummyAtom = new Atom3D();
        int result = -1;
        DefaultCell defaultCell = new DefaultCell();
        try {
            File tmpFile = File.createTempFile("pdbset_count", ".pdb");
            String tmpFileName = tmpFile.getAbsolutePath();
            SymmetryTools.writePdbSymmetric(tmpFileName, dummyAtom, SymmetryTools.generateSymgenCommandsSimple(spaceGroup, defaultCell));
            result = AbstractPdbReader.countPdbAtoms(tmpFileName);
        }
        catch (IOException ioe) {
            throw new Object3DGraphControllerException("Internal error in computeSpaceGroupSymmetryCount : " + ioe.getMessage());
        }
        assert (result > 0);
        log.info("Finished computerNumberSpaceGroupSymmetries!");
        return result;
    }

    public static CoordinateSystem[] generateCoordinateSystems(SpaceGroup spaceGroup, Cell cell) throws Object3DGraphControllerException {
        Vector3D[] initialVectors = new Vector3D[]{new Vector3D(0.0, 0.0, 0.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, 0.0, 1.0)};
        Vector3D[] newVectors = SymmetryTools.generateSymmetricVectors(initialVectors, spaceGroup, cell);
        assert (newVectors.length % initialVectors.length == 0);
        assert (newVectors.length > 0);
        int numSym = newVectors.length / initialVectors.length;
        CoordinateSystem[] result = new CoordinateSystem[numSym];
        for (int i = 0; i < numSym; ++i) {
            int pc = 4 * i;
            Vector3D basePos = newVectors[pc];
            Vector3D x = newVectors[pc + 1].minus(basePos);
            Vector3D y = newVectors[pc + 2].minus(basePos);
            Vector3D z = newVectors[pc + 3].minus(basePos);
            result[i] = new CoordinateSystem3D(basePos, x, y);
            if (result[i].isCartesian()) continue;
            throw new Object3DGraphControllerException("Non-cartesian coordinate system detected!");
        }
        log.info("Generated " + result.length + " coordinate systems from space group " + spaceGroup);
        return result;
    }

    static String generateSymgenCommandsSimple(SpaceGroup spaceGroup, Cell cell) {
        StringBuffer buf = new StringBuffer();
        buf.append(((Object)cell).toString() + PackageConstants.NEWLINE);
        buf.append("SPACEGROUP " + spaceGroup.getNumber() + PackageConstants.NEWLINE);
        buf.append("SYMGEN " + spaceGroup.getNumber() + PackageConstants.NEWLINE);
        return buf.toString();
    }

    public static Vector3D[] generateSymmetricVectors(Vector3D[] coords, SpaceGroup spaceGroup, Cell cell) throws Object3DGraphControllerException {
        assert (coords != null);
        if (coords.length == 0) {
            return new Vector3D[0];
        }
        log.info("Starting computerNumberSpaceGroupSymmetries!");
        SimpleObject3D tree = new SimpleObject3D();
        for (int i = 0; i < coords.length; ++i) {
            Atom3D atom = new Atom3D(coords[i]);
            atom.setName("C");
            tree.insertChild(new Atom3D(coords[i]));
        }
        Vector3D[] result = null;
        DefaultCell defaultCell = new DefaultCell();
        try {
            File tmpFile = File.createTempFile("pdbset_all", ".pdb");
            String tmpFileName = tmpFile.getAbsolutePath();
            SymmetryTools.writePdbSymmetric(tmpFileName, tree, SymmetryTools.generateSymgenCommandsSimple(spaceGroup, defaultCell));
            FileInputStream fis = new FileInputStream(tmpFileName);
            String[] pdbLines = StringTools.readAllLines(fis);
            result = AbstractPdbReader.readPdbVectors(pdbLines);
        }
        catch (IOException ioe) {
            throw new Object3DGraphControllerException("Internal error in computeSpaceGroupSymmetryCount : " + ioe.getMessage());
        }
        assert (result != null);
        log.info("Finished generateSymmetricVectors!");
        assert (result.length >= coords.length);
        assert (result.length % coords.length == 0);
        return result;
    }

    public static void launchSymgen(String inFileName, String outFileName, String symmetryCommands) throws Object3DGraphControllerException {
        log.info("Starting launchGensym!");
        String commandFileName = "";
        try {
            File commandFile = File.createTempFile("pdbset", ".prm");
            commandFileName = commandFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(commandFile);
            PrintStream ps = new PrintStream(fos);
            ps.println(symmetryCommands);
            ps.close();
        }
        catch (IOException ioe) {
            throw new Object3DGraphControllerException("IO Error while creating temp file for pdbset/symgen: " + ioe.getMessage());
        }
        if (commandFileName.length() == 0) {
            throw new Object3DGraphControllerException("IO Error while creating temp file for pdbset/symgen!");
        }
        String[] commandWords = new String[]{ccp4PdbsetBinary, inFileName, outFileName, commandFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        log.info("Created command for launching: " + ((Object)command).toString());
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        log.info("queue manager finished job!");
        log.info("Finished launchGensym!");
    }

    static void writePdbSymmetric(String fileName, Object3D tree, String symmetryCommands) throws Object3DGraphControllerException {
        log.info("Starting writePdbSymmetric!");
        try {
            String tmpName = fileName + "_asym.pdb";
            FileOutputStream fos = new FileOutputStream(tmpName);
            GeneralPdbWriter writer = new GeneralPdbWriter();
            writer.write((OutputStream)fos, tree);
            fos.close();
            SymmetryTools.launchSymgen(tmpName, fileName, symmetryCommands);
        }
        catch (IOException exc) {
            throw new Object3DGraphControllerException("Error opening/writing to file " + fileName);
        }
        log.info("Finished writePdbSymmetric!");
    }
}

