/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.logging.Logger;
import numerictools.DoubleArrayTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorOptimizer;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;

public abstract class AbstractBranchDescriptorOptimizer
implements BranchDescriptorOptimizer {
    protected static Logger log = Logger.getLogger("NanoTiler_debug");

    protected static BranchDescriptor3D interpolateBranchDescriptor(RnaStem3D stem, BranchDescriptor3D branch1, BranchDescriptor3D branch2, double phase) throws FittingException {
        Vector3D branch1NewBase = branch1.getBasePosition().plus(branch1.getDirection().mul(RnaConstants.HELIX_RISE));
        Vector3D branch2NewBase = branch2.getBasePosition().plus(branch2.getDirection().mul(RnaConstants.HELIX_RISE));
        Vector3D newZ = branch2NewBase.minus(branch1NewBase);
        assert (newZ.lengthSquare() > 0.0);
        newZ.normalize();
        Vector3D newPos = branch1NewBase;
        CoordinateSystem cs = BranchDescriptorTools.generatePropagatedBranchDescriptorCoordinateSystem(branch1, 1);
        double ang = newZ.angle(branch1.getDirection());
        if (ang > 0.0 && stem.getLength() >= 3) {
            if (ang == Math.PI) {
                throw new FittingException("Could not generate interpolated branch descriptor");
            }
            Vector3D rotVec = cs.getZ().cross(newZ);
            assert (rotVec.length() > 0.0);
            rotVec.normalize();
            cs.rotate(rotVec, ang);
        }
        if (phase != 0.0) {
            cs.rotate(cs.getZ(), phase);
        }
        NucleotideStrand outgoingStrand = stem.getStrand1();
        NucleotideStrand incomingStrand = stem.getStrand2();
        assert (outgoingStrand.getResidueCount() == stem.getLength());
        assert (incomingStrand.getResidueCount() == stem.getLength());
        int incomingIndex = stem.getLength() - 1;
        int outgoingIndex = 0;
        return new SimpleBranchDescriptor3D(incomingStrand, outgoingStrand, incomingIndex, outgoingIndex, cs);
    }

    protected static BranchDescriptor3D propagateBranchDescriptor(RnaStem3D stem, BranchDescriptor3D branch1) {
        Vector3D branch1NewBase = branch1.getBasePosition().plus(branch1.getDirection().mul(RnaConstants.HELIX_RISE));
        Vector3D newZ = branch1.getDirection();
        assert (newZ.lengthSquare() > 0.0);
        newZ.normalize();
        Vector3D newPos = branch1NewBase;
        CoordinateSystem cs = BranchDescriptorTools.generatePropagatedBranchDescriptorCoordinateSystem(branch1, 1);
        NucleotideStrand outgoingStrand = stem.getStrand1();
        NucleotideStrand incomingStrand = stem.getStrand2();
        assert (outgoingStrand.getResidueCount() == stem.getLength());
        assert (incomingStrand.getResidueCount() == stem.getLength());
        int incomingIndex = stem.getLength() - 1;
        int outgoingIndex = 0;
        return new SimpleBranchDescriptor3D(incomingStrand, outgoingStrand, incomingIndex, outgoingIndex, cs);
    }

    protected static double computeBranchDescriptorError(int stemLength, BranchDescriptor3D branch1, BranchDescriptor3D branch2, BranchDescriptor3D b) {
        int lastBp = stemLength - 1;
        double[] t = new double[]{branch1.computeHelixPosition(1, 1).distanceSquare(b.computeHelixPosition(0, 1)), branch1.computeHelixPosition(1, 2).distanceSquare(b.computeHelixPosition(0, 2)), branch2.computeHelixPosition(1, 2).distanceSquare(b.computeHelixPosition(lastBp, 1)), branch2.computeHelixPosition(1, 1).distanceSquare(b.computeHelixPosition(lastBp, 2))};
        return Math.sqrt(t[DoubleArrayTools.findHighestElement(t)]);
    }

    protected static double computeBranchDescriptorErrorDebug(int stemLength, BranchDescriptor3D branch1, BranchDescriptor3D branch2, BranchDescriptor3D b) {
        int lastBp = stemLength - 1;
        double t1 = branch1.computeHelixPosition(1, 1).distanceSquare(b.computeHelixPosition(0, 1));
        double t2 = branch1.computeHelixPosition(1, 2).distanceSquare(b.computeHelixPosition(0, 2));
        return Math.sqrt(0.5 * (t1 + t2));
    }
}

