/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.FragmentGridTiler;
import rnadesign.rnamodel.InteractionLinkImp;
import rnadesign.rnamodel.KissingLoopTools;
import rnadesign.rnamodel.MoleculeTools;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnadesign.rnamodel.SimpleRnaStem3D;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.TilingStatistics;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteraction;
import sequence.Residue;
import sequence.UnknownSymbolException;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.LinkTools;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class ConnectingStemGenerator {
    public static final int APPEND_NONE = 0;
    public static final int APPEND_ALL = 1;
    public static final int APPEND_STICKY_ENDS = 2;
    public static final double STRAND_SYMMETRY_COLLISION_CUTOFF = 10.0;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private final FragmentGridTiler tiler;
    private final Object3DSet junctionsOrig;
    private final String baseName;
    private final Object3DSet vertexSet;
    private final LinkSet links;
    private final int requiredJunctionIndex;
    private final int appendStrandsMode;
    private char c1 = (char)71;
    private char c2 = (char)67;
    public static int stickyTailLength = 9;

    public ConnectingStemGenerator(FragmentGridTiler tiler, Object3DSet junctionsOrig, String baseName, Object3DSet vertexSet, LinkSet links, int requiredJunctionIndex, int appendStrandsMode) {
        this.log.fine("Constructing ConnectingStemGenerator!");
        this.tiler = tiler;
        this.junctionsOrig = junctionsOrig;
        this.baseName = baseName;
        this.vertexSet = vertexSet;
        this.links = links;
        this.requiredJunctionIndex = requiredJunctionIndex;
        this.appendStrandsMode = appendStrandsMode;
        this.log.fine("Finished constructing ConnectingStemGenerator!");
    }

    public void setBasepairCharacters(char c1, char c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    public Object3DLinkSetBundle generate() {
        Object3D vertex1;
        int i;
        this.log.info("Starting ConnectingStemGenerator.generate!");
        boolean debugFoundConnection = false;
        this.tiler.setStemStatistics(new TilingStatistics());
        SimpleObject3DSet junctions = new SimpleObject3DSet();
        for (int i2 = 0; i2 < this.junctionsOrig.size(); ++i2) {
            if (this.junctionsOrig.get(i2) != null && !(this.junctionsOrig.get(i2) instanceof StrandJunction3D)) continue;
            junctions.add(this.junctionsOrig.get(i2));
        }
        int[][] branchFlags = new int[junctions.size()][100];
        assert (junctions.size() == this.vertexSet.size());
        this.log.info("Starting ConnectingStemGenerator.generate() " + this.junctionsOrig.size() + " " + junctions.size() + " " + this.links.size() + " " + this.baseName + " " + this.vertexSet.size());
        SimpleObject3D resultTree = new SimpleObject3D();
        resultTree.setName("stems");
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        int numFound = 0;
        int numTest = 0;
        for (i = 0; i < this.vertexSet.size(); ++i) {
            for (int j = i + 1; j < this.vertexSet.size(); ++j) {
                if (this.links.getLinkNumber(this.vertexSet.get(i), this.vertexSet.get(j)) <= 0) continue;
                ++numTest;
            }
        }
        this.log.info("Pairs of connected vertices: " + numTest);
        if (numTest == 0) {
            this.log.warning("No vertex links found!");
        }
        if (junctions.size() == 0) {
            this.log.warning("No junctions defined!");
        }
        for (i = 0; i < junctions.size(); ++i) {
            if (junctions.get(i) == null || !(junctions.get(i) instanceof StrandJunction3D)) continue;
            StrandJunction3D junction1 = (StrandJunction3D)junctions.get(i);
            vertex1 = this.vertexSet.get(i);
            Object3DSet neighbors1 = LinkTools.findNeighbors(vertex1, this.links);
            int junction1BranchCount = junction1.getBranchCount();
            for (int j = i + 1; j < junctions.size(); ++j) {
                Object3DLinkSetBundle stemBundle;
                if (junctions.get(j) == null || !(junctions.get(j) instanceof StrandJunction3D) || this.requiredJunctionIndex >= 0 && this.requiredJunctionIndex != i && this.requiredJunctionIndex != j || this.links.getLinkNumber(this.vertexSet.get(i), this.vertexSet.get(j)) == 0) continue;
                this.log.info("Found connected junctions: " + (i + 1) + " " + (j + 2));
                ++numFound;
                debugFoundConnection = true;
                StrandJunction3D junction2 = (StrandJunction3D)junctions.get(j);
                assert (junction1 != junction2);
                if (junction1.distance(junction2) == 0.0) {
                    this.log.warning("Strange, two junctions have distance zero: " + (i + 1) + " " + (j + 1));
                }
                Object3D vertex2 = this.vertexSet.get(j);
                Object3DSet neighbors2 = LinkTools.findNeighbors(vertex2, this.links);
                int junction2BranchCount = junction2.getBranchCount();
                this.log.info("Before for statement. junction1BranchCount=" + junction1BranchCount);
                int[] branchIndices = null;
                try {
                    branchIndices = this.findBestBranchDescriptorPair(junction1, junction2, i, j, branchFlags, this.tiler.getStemFitParameters());
                }
                catch (FittingException fe) {
                    this.log.info("Skipping junction pair because no suitable branch descriptor pair could be found!");
                    continue;
                }
                assert (branchIndices != null && branchIndices.length == 2 && branchIndices[0] >= 0 && branchIndices[1] >= 0);
                int branch1Idx = branchIndices[0];
                int branch2Idx = branchIndices[1];
                branchFlags[i][branch1Idx] = 1;
                branchFlags[j][branch2Idx] = 1;
                BranchDescriptor3D branch1 = junction1.getBranch(branch1Idx);
                BranchDescriptor3D branch2 = junction2.getBranch(branch2Idx);
                assert (branch1 != branch2);
                if (branch1.distance(branch2) <= 0.0) {
                    this.log.info("Error detected: same branches " + branch1Idx + " " + branch2Idx + " int junctions: " + junction1 + " and " + junction2);
                    this.log.finest("" + branch1);
                    this.log.finest("" + branch2);
                    continue;
                }
                assert (branch1.distance(branch2) > 0.0);
                assert (branch1.isValid());
                assert (branch2.isValid());
                if (!this.tiler.getKissingLoopMode()) {
                    this.log.info("Kissing loop mode is off!");
                    stemBundle = ConnectJunctionTools.generateConnectingStem(branch1, branch2, this.c1, this.c2, this.baseName, this.tiler.getStemFitParameters(), this.tiler.getNucleotideDB(), this.tiler.getConnectionAlgorithm(), -1);
                    if (stemBundle != null) {
                        this.tiler.getStemStatistics().updateCoverage(true);
                        Object3D stemBundleObject = stemBundle.getObject3D();
                        Object3DSet stemSet = Object3DTools.collectByClassName(stemBundleObject, SimpleRnaStem3D.CLASS_NAME);
                        Object3DSet atomSet = Object3DTools.collectByClassName(stemBundleObject, "Atom3D");
                        assert (atomSet != null && atomSet.size() > 0);
                        assert (stemSet.size() == 1);
                        RnaStem3D stem = (RnaStem3D)stemSet.get(0);
                        Object3DTools.setRecursiveProperty(stem.getStrand1(), "sequence_status", "adhoc", "Nucleotide3D");
                        Object3DTools.setRecursiveProperty(stem.getStrand2(), "sequence_status", "adhoc", "Nucleotide3D");
                        String fitScoreString = stem.getProperties().getProperty("fit_score");
                        assert (fitScoreString != null);
                        double fitScore = Double.parseDouble(fitScoreString);
                        this.tiler.getStemStatistics().updateAverageAngle(fitScore);
                        this.tiler.getStemStatistics().updateAverageDistance(fitScore);
                        switch (this.appendStrandsMode) {
                            case 0: {
                                this.log.info("Using ConnectingStemGenerator.generate.APPEND_NONE:");
                                resultTree.insertChild(stemBundle.getObject3D());
                                break;
                            }
                            case 1: {
                                this.log.info("Using ConnectingStemGenerator.generate.APPEND_ALL:");
                                NucleotideStrand strand1 = branch1.getOutgoingStrand();
                                NucleotideStrand strand2 = branch2.getOutgoingStrand();
                                strand1.append(stem.getStrand1());
                                strand2.append(stem.getStrand2());
                                break;
                            }
                            case 2: {
                                NucleotideStrand strand2;
                                NucleotideStrand strand1;
                                this.log.info("Using ConnectingStemGenerator.generate.APPEND_STICKY_ENDS:");
                                if (stem.getLength() < 2 * stickyTailLength) {
                                    this.log.fine("Stem too short for sticky end generation: " + stem.getLength() + " " + stickyTailLength);
                                    strand1 = branch1.getOutgoingStrand();
                                    strand2 = branch2.getOutgoingStrand();
                                    strand1.append(stem.getStrand1());
                                    strand2.append(stem.getStrand2());
                                    break;
                                }
                                strand1 = branch1.getOutgoingStrand();
                                NucleotideStrand strand1b = branch2.getIncomingStrand();
                                NucleotideStrand strand22 = branch2.getOutgoingStrand();
                                NucleotideStrand strand2b = branch1.getIncomingStrand();
                                int cutPos = this.computeStickyEndCut(stem.getLength());
                                strand1.append((NucleotideStrand)stem.getStrand1().cloneDeep(0, cutPos - 1));
                                strand1b.prepend((NucleotideStrand)stem.getStrand1().cloneDeep(cutPos, stem.getStrand1().size()));
                                strand22.append((NucleotideStrand)stem.getStrand2().cloneDeep(0, cutPos - 1));
                                strand2b.prepend((NucleotideStrand)stem.getStrand2().cloneDeep(cutPos, stem.getStrand2().size()));
                                break;
                            }
                            default: {
                                assert (false);
                                break;
                            }
                        }
                        resultLinks.merge(stemBundle.getLinks());
                        continue;
                    }
                    this.log.info("Stem bundle received from ConnectJunctionTools was null!");
                    this.tiler.getStemStatistics().updateCoverage(false);
                    continue;
                }
                this.log.info("Generating interpolating stems in kissing loop mode started!");
                stemBundle = KissingLoopTools.generateConnectingStem(branch1, branch2, this.c1, this.c2, this.baseName, this.tiler.getStemFitParameters(), this.tiler.getNucleotideDB(), this.tiler.getKissingLoopDB(), this.tiler.getConnectionAlgorithm(), this.tiler.getAxialSteps());
            }
        }
        for (i = 0; i < this.links.size(); ++i) {
            Link link = this.links.get(i);
            if (link.getProperty("silent") != null) {
                this.log.info("Silent link found, ignoring for placement!");
                continue;
            }
            vertex1 = link.getObj1();
            Object3D vertex2 = link.getObj2();
            int index1 = this.vertexSet.indexOf(vertex1);
            int index2 = this.vertexSet.indexOf(vertex2);
            assert (index1 >= 0);
            assert (index2 >= 0);
            Object3DSet neighbors1 = LinkTools.findNeighbors(vertex1, this.links);
            Object3DSet neighbors2 = LinkTools.findNeighbors(vertex2, this.links);
            assert (neighbors1.size() > 0);
            assert (neighbors2.size() > 0);
            if (neighbors1.size() == 1 && neighbors2.size() == 0) {
                this.log.severe("Sorry, helix placement of isolated line not yet implemented!");
            }
            StrandJunction3D junction = null;
            Object3D vertex = null;
            Object3D junctionVertex = null;
            int junctionIndex = -1;
            int otherIndex = -1;
            if (neighbors2.size() == 1) {
                junctionIndex = index1;
                otherIndex = index2;
                vertex = vertex2;
            } else {
                if (neighbors1.size() != 1) continue;
                junctionIndex = index2;
                otherIndex = index1;
                vertex = vertex1;
            }
            junction = (StrandJunction3D)junctions.get(junctionIndex);
            junctionVertex = this.vertexSet.get(junctionIndex);
            Object3DLinkSetBundle culDeSacStems = new SimpleObject3DLinkSetBundle();
            if (junction == null || vertex == null || junctionVertex == null) continue;
            int symIndex = this.findMatchingSymmetry(link, junctionVertex);
            try {
                if (symIndex < 0) {
                    this.log.info("Trying to generate free stem for junction " + junction.getName());
                    culDeSacStems = this.generateFreeStem(junctions, junctionIndex, vertex, junctionVertex, this.baseName, this.tiler.getStemFitParameters(), this.tiler.getNucleotideDB(), this.tiler.getConnectionAlgorithm(), branchFlags);
                    assert (culDeSacStems != null);
                } else {
                    this.log.info("Trying to generate symmetric stem for junction " + junction.getName());
                    CoordinateSystem3D cs = (CoordinateSystem3D)junctionVertex.getChild(symIndex);
                    culDeSacStems = this.generateSymmetryStem(junctions, junctionIndex, cs, this.baseName, this.tiler.getStemFitParameters(), this.tiler.getNucleotideDB(), this.tiler.getConnectionAlgorithm(), branchFlags);
                }
                assert (culDeSacStems != null);
                if (this.appendStrandsMode == 0) {
                    if (culDeSacStems.getObject3D() != null) {
                        this.log.info("Generated free stem for junction " + junction.getName());
                        resultTree.insertChild(culDeSacStems.getObject3D());
                    } else {
                        this.log.info("Could not generate cul de sac stem for junction " + junction.getName());
                    }
                }
                resultLinks.merge(culDeSacStems.getLinks());
                continue;
            }
            catch (FittingException fe) {
                this.log.info("Could not place cul de sac helix for junction " + junction.getName());
                this.tiler.getStemStatistics().updateCoverage(false);
            }
        }
        this.log.info("Finished ConnectingStemGenerator.generate: " + resultTree.size() + " " + resultLinks.size() + " " + numFound);
        if (!debugFoundConnection) {
            this.log.warning("No stems found for junction index: " + this.requiredJunctionIndex);
        }
        return new SimpleObject3DLinkSetBundle(resultTree, resultLinks);
    }

    private int findMatchingSymmetry(Link link, Object3D obj) {
        int result = -1;
        Properties properties = link.getProperties();
        if (properties != null) {
            int symIndex;
            Set<Object> keys = properties.keySet();
            Iterator<Object> keyIterator = keys.iterator();
            String symmetryName = "";
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                if (key.indexOf("symmetry:") != 0) continue;
                this.log.finest("Parsing key: " + key);
                String[] words = key.split(":");
                this.log.finest("Parsed words: " + words.length + " " + words[0]);
                assert (words.length == 2);
                this.log.finest("Found symmetry in link: " + words[1]);
                symmetryName = words[1];
                break;
            }
            if ((symIndex = obj.getIndexOfChild(symmetryName)) >= 0 && symIndex < obj.size()) {
                this.log.finest("Symmetry also found in object: " + obj.getName() + " " + obj.getChild(symIndex).getName());
                result = symIndex;
            } else {
                this.log.finest("Symmetry could not be found in junction vertex!");
            }
        }
        return result;
    }

    BranchDescriptor3D generateDummyBranchDescriptor(Object3D vertex, Object3D junctionVertex) throws FittingException {
        NucleotideStrand outStrand;
        NucleotideStrand inStrand;
        CoordinateSystem3D cs;
        block3: {
            Vector3D pos = vertex.getPosition();
            Vector3D direction = junctionVertex.getPosition().minus(vertex.getPosition());
            if (direction.length() == 0.0) {
                throw new FittingException("Both fitting points are identical!");
            }
            direction.normalize();
            Vector3D x = Vector3DTools.generateRandomOrthogonalDirection(direction);
            x.normalize();
            Vector3D y = direction.cross(x);
            cs = new CoordinateSystem3D(vertex.getPosition(), x, y);
            String sequence = "A";
            String name = "culdesac";
            inStrand = null;
            outStrand = null;
            try {
                inStrand = (NucleotideStrand)Rna3DTools.generateSimpleRnaStrand(name, sequence, pos, direction).getObject3D();
                outStrand = (NucleotideStrand)Rna3DTools.generateSimpleRnaStrand(name, sequence, pos, direction.mul(-1.0)).getObject3D();
            }
            catch (UnknownSymbolException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        int incomingIndex = 0;
        int outgoingIndex = 0;
        return new SimpleBranchDescriptor3D(inStrand, outStrand, incomingIndex, outgoingIndex, cs);
    }

    Object3DLinkSetBundle generateFreeStem(Object3DSet junctions, int junctionId, Object3D vertex, Object3D junctionVertex, String baseName, FitParameters stemFitParameters, Object3D nucleotideDB, int connectionAlgorithm, int[][] branchFlags) throws FittingException {
        StrandJunction3D junction = (StrandJunction3D)junctions.get(junctionId);
        BranchDescriptor3D bd = this.generateDummyBranchDescriptor(vertex, junctionVertex);
        int bestIndex = 0;
        double bestAngle = 0.0;
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            double angle = bd.getDirection().angle(junction.getBranch(i).getDirection());
            if (!(angle > bestAngle)) continue;
            bestAngle = angle;
            bestIndex = i;
        }
        if (this.isBranchDescriptorUsed(junctionId, bestIndex, branchFlags)) {
            throw new FittingException("Branch descriptor already used!");
        }
        BranchDescriptor3D junctionBranch = junction.getBranch(bestIndex);
        Object3DLinkSetBundle stemBundle = ConnectJunctionTools.generateConnectingStem(junction.getBranch(bestIndex), bd, this.c1, this.c2, baseName, stemFitParameters, nucleotideDB, connectionAlgorithm, -1);
        if (stemBundle == null) {
            this.tiler.getStemStatistics().updateCoverage(false);
            throw new FittingException("Could not generate free stem for junction " + junction.getName());
        }
        assert (stemBundle != null);
        this.setBranchDescriptorUsed(junctionId, bestIndex, branchFlags);
        Object3DSet stems = Object3DTools.collectByClassName(stemBundle.getObject3D(), SimpleRnaStem3D.CLASS_NAME);
        assert (stems.size() > 0);
        RnaStem3D stem = (RnaStem3D)stems.get(0);
        Object3DTools.setRecursiveProperty(stem.getStrand1(), "sequence_status", "adhoc", "Nucleotide3D");
        Object3DTools.setRecursiveProperty(stem.getStrand2(), "sequence_status", "adhoc", "Nucleotide3D");
        String fitScoreString = stem.getProperties().getProperty("fit_score");
        assert (fitScoreString != null);
        double fitScore = Double.parseDouble(fitScoreString);
        this.tiler.getStemStatistics().updateCoverage(true);
        this.tiler.getStemStatistics().updateAverageAngle(fitScore);
        this.tiler.getStemStatistics().updateAverageDistance(fitScore);
        switch (this.appendStrandsMode) {
            case 0: {
                this.log.fine("Using ConnectingStemGenerator.generate.APPEND_NONE:");
                break;
            }
            case 1: {
                this.log.fine("Using ConnectingStemGenerator.generate.APPEND_ALL:");
                NucleotideStrand inStrand = junctionBranch.getIncomingStrand();
                NucleotideStrand outStrand = junctionBranch.getOutgoingStrand();
                outStrand.append(stem.getStrand1());
                inStrand.prepend(stem.getStrand2());
                stemBundle.setObject3D(null);
                break;
            }
            case 2: {
                this.log.fine("Using ConnectingStemGenerator.generateFreeStem.APPEND_STICKY_ENDS:");
                this.log.fine("Cannot handle sticky tails for free helices yet: " + stem.getLength() + " " + stickyTailLength);
                NucleotideStrand inStrand = junctionBranch.getIncomingStrand();
                NucleotideStrand outStrand = junctionBranch.getOutgoingStrand();
                outStrand.append(stem.getStrand1());
                inStrand.prepend(stem.getStrand2());
                stemBundle.setObject3D(null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (stemBundle != null);
        return stemBundle;
    }

    Object3DLinkSetBundle generateSymmetryStem(Object3DSet junctions, int junctionId, CoordinateSystem transformation, String baseName, FitParameters stemFitParameters, Object3D nucleotideDB, int connectionAlgorithm, int[][] branchFlags) throws FittingException {
        StrandJunction3D junction = (StrandJunction3D)junctions.get(junctionId);
        StrandJunction3D symJunction = (StrandJunction3D)junction.cloneDeep();
        symJunction.activeTransform2(transformation);
        CoordinateSystem cs = transformation;
        this.log.fine("Trying to connect symmetric junctions: positions are: " + junction.getPosition() + " " + symJunction.getPosition() + " with cs " + transformation + " distances: " + cs.distance(junction) + " " + cs.distance(symJunction) + " angle: " + 57.29577951308232 * junction.getPosition().minus(cs.getPosition()).angle(symJunction.getPosition().minus(cs.getPosition())));
        Object3DLinkSetBundle stemBundle = this.generateConnectingStem(junction, symJunction, junctionId, -1, branchFlags, baseName, stemFitParameters, nucleotideDB, connectionAlgorithm, transformation);
        assert (stemBundle != null);
        return stemBundle;
    }

    int[] findBestBranchDescriptorPair(StrandJunction3D junction1, StrandJunction3D junction2, int i, int j, int[][] branchFlags, FitParameters fitParameters) throws FittingException {
        assert (junction1 != null && junction2 != null);
        assert (branchFlags != null);
        int junction1BranchCount = junction1.getBranchCount();
        int junction2BranchCount = junction2.getBranchCount();
        int branch1Idx = -1;
        int branch2Idx = -1;
        double bestAngle = 0.0;
        double bestDist = 0.0;
        for (int ii = 0; ii < junction1BranchCount; ++ii) {
            if (this.isBranchDescriptorUsed(i, ii, branchFlags)) continue;
            BranchDescriptor3D branch1 = junction1.getBranch(ii);
            for (int jj = 0; jj < junction2BranchCount; ++jj) {
                if (this.isBranchDescriptorUsed(j, jj, branchFlags)) continue;
                BranchDescriptor3D branch2 = junction2.getBranch(jj);
                double angle = branch1.getDirection().angle(branch2.getDirection());
                double dist = branch1.distance(branch2);
                this.log.fine("Chosen junction branches angle, dist: " + 57.29577951308232 * angle + ", " + dist);
                if (!(angle > bestAngle) || !(Math.abs(angle - Math.PI) <= fitParameters.getAngleLimit())) continue;
                bestAngle = angle;
                bestDist = dist;
                branch1Idx = ii;
                branch2Idx = jj;
            }
        }
        if (branch1Idx < 0) {
            throw new FittingException("No good branch descriptor pair could be found for junctions!");
        }
        int[] result = new int[]{branch1Idx, branch2Idx};
        assert (result != null && result.length == 2 && result[0] >= 0 && result[1] >= 0);
        return result;
    }

    boolean isBranchDescriptorUsed(int junctionId, int branchId, int[][] branchFlags) {
        return junctionId >= 0 && junctionId < branchFlags.length && branchFlags[junctionId][branchId] == 1;
    }

    void setBranchDescriptorUsed(int junctionId, int branchId, int[][] branchFlags) {
        if (junctionId >= 0 && junctionId < branchFlags.length) {
            branchFlags[junctionId][branchId] = 1;
        }
    }

    Object3DLinkSetBundle generateConnectingStem(StrandJunction3D junction1, StrandJunction3D junction2, int junction1Id, int junction2Id, int[][] connectionFlags, String baseName, FitParameters stemFitParameters, Object3D nucleotideDB, int connectionAlgorithm, CoordinateSystem transformation) throws FittingException {
        Object3DLinkSetBundle stemBundle;
        int[] bdIds = this.findBestBranchDescriptorPair(junction1, junction2, junction1Id, junction2Id, connectionFlags, stemFitParameters);
        int branch1Idx = bdIds[0];
        int branch2Idx = bdIds[1];
        RnaInteractionType watsonCrickType = new RnaInteractionType(1);
        if (this.isBranchDescriptorUsed(junction1Id, branch1Idx, connectionFlags) || this.isBranchDescriptorUsed(junction2Id, branch2Idx, connectionFlags)) {
            throw new FittingException("Stem cannot be placed because Branch descriptors are already in use!");
        }
        if (junction2Id < 0) {
            BranchDescriptor3D b1 = junction1.getBranch(branch1Idx);
            BranchDescriptor3D b2 = junction2.getBranch(branch2Idx);
            this.log.fine("Trying to connect symmetric junction branch descriptors: " + b1.getPosition() + " " + b2.getPosition() + " with distance " + b1.distance(b2) + " and angle " + 57.29577951308232 * b1.getDirection().angle(b2.getDirection()));
        }
        if ((stemBundle = ConnectJunctionTools.generateConnectingStem(junction1.getBranch(branch1Idx), junction2.getBranch(branch2Idx), this.c1, this.c2, baseName, stemFitParameters, nucleotideDB, connectionAlgorithm, -1)) == null) {
            throw new FittingException("Could not find suitable stem fit for symmetric branch descriptor pair!");
        }
        LinkSet stemBundleLinks = stemBundle.getLinks();
        this.setBranchDescriptorUsed(junction1Id, branch1Idx, connectionFlags);
        this.setBranchDescriptorUsed(junction2Id, branch2Idx, connectionFlags);
        Object3DSet stems = Object3DTools.collectByClassName(stemBundle.getObject3D(), SimpleRnaStem3D.CLASS_NAME);
        assert (stems.size() > 0);
        RnaStem3D stem = (RnaStem3D)stems.get(0);
        Object3DTools.setRecursiveProperty(stem.getStrand1(), "sequence_status", "adhoc", "Nucleotide3D");
        Object3DTools.setRecursiveProperty(stem.getStrand2(), "sequence_status", "adhoc", "Nucleotide3D");
        String fitScoreString = stem.getProperties().getProperty("fit_score");
        assert (fitScoreString != null);
        double fitScore = Double.parseDouble(fitScoreString);
        this.tiler.getStemStatistics().updateCoverage(true);
        this.tiler.getStemStatistics().updateAverageAngle(fitScore);
        this.tiler.getStemStatistics().updateAverageDistance(fitScore);
        BranchDescriptor3D branch1 = null;
        if (branch1Idx >= 0) {
            branch1 = junction1.getBranch(branch1Idx);
        }
        BranchDescriptor3D branch2 = null;
        if (branch2Idx >= 0) {
            branch2 = junction2.getBranch(branch2Idx);
        }
        block0 : switch (this.appendStrandsMode) {
            case 0: {
                this.log.fine("Using ConnectingStemGenerator.generate.APPEND_NONE:");
                break;
            }
            case 1: {
                this.log.fine("Using ConnectingStemGenerator.generate.APPEND_ALL:");
                NucleotideStrand strand1 = branch1.getOutgoingStrand();
                NucleotideStrand strand2 = branch2.getOutgoingStrand();
                if (junction1Id >= 0) {
                    strand1.append(stem.getStrand1());
                } else {
                    assert (junction2Id >= 0);
                    branch2.getIncomingStrand().prepend(stem.getStrand1());
                }
                if (junction2Id >= 0) {
                    strand2.append(stem.getStrand2());
                } else {
                    assert (junction1Id >= 0);
                    branch1.getIncomingStrand().prepend(stem.getStrand2());
                }
                stemBundle.setObject3D(null);
                break;
            }
            case 2: {
                Vector3D v22;
                Vector3D v21;
                Vector3D v2;
                Vector3D v12;
                Vector3D v11;
                Vector3D v1;
                double dist;
                this.log.fine("Using ConnectingStemGenerator.generate.APPEND_STICKY_ENDS:");
                if (stem.getLength() < 2 * stickyTailLength) {
                    this.log.fine("Stem too short for sticky end generation: " + stem.getLength() + " " + stickyTailLength);
                    NucleotideStrand strand1 = branch1.getOutgoingStrand();
                    NucleotideStrand strand2 = branch2.getOutgoingStrand();
                    if (junction1Id >= 0) {
                        strand1.append(stem.getStrand1());
                    } else {
                        assert (junction2Id >= 0);
                        branch2.getIncomingStrand().prepend(stem.getStrand1());
                    }
                    if (junction2Id >= 0) {
                        strand2.append(stem.getStrand2());
                        break;
                    }
                    assert (junction1Id >= 0);
                    branch1.getIncomingStrand().prepend(stem.getStrand2());
                    break;
                }
                NucleotideStrand strand1 = branch1.getOutgoingStrand();
                NucleotideStrand strand1b = branch2.getIncomingStrand();
                NucleotideStrand strand2 = branch2.getOutgoingStrand();
                NucleotideStrand strand2b = branch1.getIncomingStrand();
                int cutPos = this.computeStickyEndCut(stem.getLength());
                NucleotideStrand appendedHalf1 = (NucleotideStrand)stem.getStrand1().cloneDeep(0, cutPos);
                strand1.append(appendedHalf1);
                NucleotideStrand prependedHalf1 = (NucleotideStrand)stem.getStrand2().cloneDeep(cutPos, stem.getStrand2().size());
                strand2b.prepend(prependedHalf1);
                for (int i = 0; i < appendedHalf1.getResidueCount(); ++i) {
                    Residue r1 = appendedHalf1.getResidue(i);
                    int i2 = prependedHalf1.getResidueCount() - 1 - i;
                    if (i2 < 0) break;
                    Residue r2 = prependedHalf1.getResidue(i2);
                    stemBundleLinks.add(new InteractionLinkImp((Object3D)((Object)r1), (Object3D)((Object)r2), new SimpleInteraction(r1, r2, watsonCrickType)));
                    this.log.fine("added watson crick link(1)!");
                }
                if (junction2Id >= 0) {
                    NucleotideStrand prependedHalf2 = (NucleotideStrand)stem.getStrand1().cloneDeep(cutPos, stem.getStrand1().size());
                    NucleotideStrand appendedHalf2 = (NucleotideStrand)stem.getStrand2().cloneDeep(0, cutPos);
                    strand1b.prepend(prependedHalf2);
                    strand2.append(appendedHalf2);
                    for (int i = 0; i < appendedHalf2.getResidueCount(); ++i) {
                        Residue r1 = appendedHalf2.getResidue(i);
                        int i2 = prependedHalf2.getResidueCount() - 1 - i;
                        if (i2 < 0) break block0;
                        Residue r2 = prependedHalf2.getResidue(i2);
                        stemBundleLinks.add(new InteractionLinkImp((Object3D)((Object)r1), (Object3D)((Object)r2), new SimpleInteraction(r1, r2, watsonCrickType)));
                        this.log.fine("added watson crick link(2)!");
                    }
                    break;
                }
                this.log.fine("Computing new symmetry sticky tail helices!");
                BranchDescriptor3D branch3 = junction1.getBranch(branch2Idx);
                strand1b = branch3.getIncomingStrand();
                strand2 = branch3.getOutgoingStrand();
                NucleotideStrand newStrand1 = (NucleotideStrand)stem.getStrand1().cloneDeep(cutPos, stem.getStrand1().size());
                NucleotideStrand newStrand2 = (NucleotideStrand)stem.getStrand2().cloneDeep(0, cutPos);
                if (transformation != null) {
                    newStrand1.passiveTransform2(transformation);
                    newStrand2.passiveTransform2(transformation);
                }
                if ((dist = (v1 = Vector3D.average(v11 = MoleculeTools.averageAtomPosition(appendedHalf1), v12 = MoleculeTools.averageAtomPosition(prependedHalf1))).distance(v2 = Vector3D.average(v21 = MoleculeTools.averageAtomPosition(newStrand1), v22 = MoleculeTools.averageAtomPosition(newStrand2)))) >= 10.0) {
                    strand1b.prepend(newStrand1);
                    strand2.append(newStrand2);
                    for (int i = 0; i < newStrand2.getResidueCount(); ++i) {
                        Residue r1 = newStrand2.getResidue(i);
                        int i2 = newStrand1.getResidueCount() - 1 - i;
                        if (i2 < 0) break block0;
                        Residue r2 = newStrand1.getResidue(i2);
                        stemBundleLinks.add(new InteractionLinkImp((Object3D)((Object)r1), (Object3D)((Object)r2), new SimpleInteraction(r1, r2, watsonCrickType)));
                        this.log.fine("added watson crick link(3)!");
                    }
                    break;
                }
                this.log.info("Not adding strand halfs because symmetry images would lead to collisions!");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.log.fine("finished generateConnectingStem with " + stemBundle.getObject3D() + " objects and " + stemBundle.getLinks().size() + " links.");
        return stemBundle;
    }

    private int computeStickyEndCut(int stemLength) {
        int middle = stemLength / 2;
        int d = stickyTailLength / 2;
        int result = middle - d;
        return result;
    }
}

