/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SequenceBindingSite;
import rnadesign.rnamodel.SimpleRnaStrand;
import rnadesign.rnamodel.SimpleSequenceBindingSite;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Sequence;
import sequence.SequenceIOException;
import sequence.SequenceReader;
import sequence.SimpleLetterSymbol;
import sequence.SimpleSequence;
import sequence.SimpleSequenceSubset;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DFormats;
import tools3d.objects3d.Object3DFormatter;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Polygon3D;
import tools3d.objects3d.Primitive3D;
import tools3d.objects3d.SimpleObject3D;

public class GeneralRnaReader
implements Object3DFactory,
Object3DFormatter {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private int formatId = 1;

    @Override
    public Object3DLinkSetBundle readBundle(InputStream is) throws Object3DIOException {
        return null;
    }

    @Override
    public Object3D readAnyObject3D(InputStream is) throws Object3DIOException {
        log.fine("Starting readAnyObject3D!");
        DataInputStream dis = new DataInputStream(is);
        String objectName = GeneralRnaReader.readWord(dis);
        Object3D object3d = null;
        if (objectName.equals("(Object3D")) {
            object3d = new SimpleObject3D();
            this.readObject3DBody(dis, object3d);
        } else if (objectName.equals("(RnaStrand")) {
            object3d = new SimpleRnaStrand();
            this.readRnaStrandBody(dis, (RnaStrand)object3d);
        } else if (objectName.equals("(Nucleotide3D")) {
            object3d = new Nucleotide3D();
            this.readObject3DBody(dis, object3d);
            char c = object3d.getName().charAt(0);
            Nucleotide3D nuc = (Nucleotide3D)object3d;
            try {
                nuc.setSymbol(new SimpleLetterSymbol(c, DnaTools.AMBIGUOUS_RNA_ALPHABET));
            }
            catch (UnknownSymbolException exc) {
                throw new Object3DIOException("Unknown RNA nucleotide symbol: " + object3d.getName());
            }
        } else if (objectName.equals("(Binding")) {
            object3d = this.readBindingSiteBody(dis);
        } else {
            throw new Object3DIOException("readAnyObject3D: " + objectName + " : unknown type name");
        }
        String expected = ")";
        String word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("readAnyObject3D: " + objectName + " : " + expected + " excepted instead of " + word);
        }
        return object3d;
    }

    private void readObject3DBody(DataInputStream dis, Object3D object3d) throws Object3DIOException {
        log.fine("Starting readObject3D!");
        String word = null;
        object3d.clear();
        word = GeneralRnaReader.readWord(dis);
        object3d.setName(word);
        Vector3D v = GeneralRnaReader.readVector3D(dis);
        object3d.setRelativePosition(v);
        String expected = "(children";
        word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("createObject3D: " + expected + " excepted instead of " + word);
        }
        word = GeneralRnaReader.readWord(dis);
        int numChildren = 0;
        try {
            numChildren = Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("createObject3D: Could not parse number of children: " + word);
        }
        for (int i = 0; i < numChildren; ++i) {
            Object3D child = this.readAnyObject3D(dis);
            object3d.insertChild(child);
        }
        expected = ")";
        word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("createObject3D: " + expected + " excepted instead of " + word);
        }
        log.fine("Ending readObject3DBody!");
    }

    private SequenceBindingSite readBindingSiteBody(DataInputStream dis) throws Object3DIOException {
        SimpleSequenceBindingSite object3D = new SimpleSequenceBindingSite();
        this.readObject3DBody(dis, object3D);
        String expected = "(subset";
        String word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("readBindingSiteBody: " + expected + " excepted instead of " + word);
        }
        SimpleSequenceSubset subset = new SimpleSequenceSubset();
        SequenceReader sequenceReader = new SequenceReader();
        try {
            sequenceReader.readSequenceSubsetBody(dis, subset);
        }
        catch (SequenceIOException e) {
            throw new Object3DIOException(e);
        }
        expected = ")";
        word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("readBindingSiteBody: " + expected + " excepted instead of " + word);
        }
        object3D.setBindingSequence(subset);
        return object3D;
    }

    private void readLinkBody(DataInputStream dis, Link link) throws Object3DIOException {
        link.clear();
        String word = GeneralRnaReader.readWord(dis);
        link.setName(word);
    }

    private void readRnaStrandBody(DataInputStream dis, RnaStrand object3d) throws Object3DIOException {
        log.fine("Starting readRnaStrand!");
        assert (false);
        String word = null;
        object3d.clear();
        word = GeneralRnaReader.readWord(dis);
        object3d.setName(word);
        Vector3D v = GeneralRnaReader.readVector3D(dis);
        object3d.setRelativePosition(v);
        this.readChildren(dis, object3d);
        this.readSequence(dis);
        log.fine("Ending readRnaStrandBody!");
    }

    private void readChildren(DataInputStream dis, Object3D object3d) throws Object3DIOException {
        String expected = "(children";
        String word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("createObject3D: " + expected + " excepted instead of " + word);
        }
        word = GeneralRnaReader.readWord(dis);
        int numChildren = 0;
        try {
            numChildren = Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("createObject3D: Could not parse number of children: " + word);
        }
        for (int i = 0; i < numChildren; ++i) {
            Object3D child = this.readAnyObject3D(dis);
            object3d.insertChild(child);
        }
        expected = ")";
        word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("createObject3D: " + expected + " excepted instead of " + word);
        }
    }

    public String getHeader(String className) {
        return Object3DFormats.getHeader(className, this.formatId);
    }

    public String getFooter(String className) {
        return Object3DFormats.getFooter(className, this.formatId);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public void setFormatId(int n) {
        this.formatId = n;
    }

    public void readHeader(DataInputStream dis, String className) throws Object3DIOException {
        String expected = this.getHeader(className);
        String word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("Header " + expected + " excepted instead of " + word);
        }
    }

    public void readFooter(DataInputStream dis, String className) throws Object3DIOException {
        String expected = this.getFooter(className);
        String word = GeneralRnaReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("Header " + expected + " excepted instead of " + word);
        }
    }

    public Sequence readSequence(DataInputStream dis) throws Object3DIOException {
        Alphabet alphabet;
        log.fine("starting readSequence!");
        this.readHeader(dis, "Sequence");
        String name = GeneralRnaReader.readWord(dis);
        String alphabetName = GeneralRnaReader.readWord(dis);
        if (alphabetName.equals("RNA")) {
            alphabet = DnaTools.RNA_ALPHABET;
        } else if (alphabetName.equals("RNA_A")) {
            alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;
        } else if (alphabetName.equals("DNA")) {
            alphabet = DnaTools.DNA_ALPHABET;
        } else if (alphabetName.equals("DNA_A")) {
            alphabet = DnaTools.AMBIGUOUS_DNA_ALPHABET;
        } else {
            throw new Object3DIOException("Unknown sequence type" + alphabetName);
        }
        String seq = GeneralRnaReader.readWord(dis);
        SimpleSequence sequence = null;
        try {
            sequence = new SimpleSequence(seq, name, alphabet);
        }
        catch (UnknownSymbolException e) {
            throw new Object3DIOException("Unknown sequence character encountered.");
        }
        this.readFooter(dis, "Sequence");
        return sequence;
    }

    public static Vector3D readVector3D(DataInputStream dis) throws Object3DIOException {
        log.fine("starting readVector!");
        String word = GeneralRnaReader.readWord(dis);
        String expected = "(v3";
        if (!word.equals(expected)) {
            throw new Object3DIOException(expected + " excepted instead of " + word);
        }
        word = GeneralRnaReader.readWord(dis);
        if (word.length() == 0) {
            throw new Object3DIOException("Not x coordinate provided to Vector3D " + word);
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Vector3D " + word);
        }
        word = GeneralRnaReader.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Vector3D " + word);
        }
        word = GeneralRnaReader.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Vector3D " + word);
        }
        word = GeneralRnaReader.readWord(dis);
        expected = ")";
        if (!word.equals(expected)) {
            throw new Object3DIOException("readVector3D: " + expected + " excepted instead of " + word);
        }
        log.fine("ending readVector!");
        return new Vector3D(x, y, z);
    }

    public static Primitive3D readPrimitive3D(DataInputStream dis) throws Object3DIOException {
        log.fine("starting readPrimitive3D!");
        String word = GeneralRnaReader.readWord(dis);
        String expected = "(pg3";
        if (!word.equals(expected)) {
            throw new Object3DIOException(expected + " excepted instead of " + word);
        }
        Vector3D cv = GeneralRnaReader.readVector3D(dis);
        Color color = new Color((float)cv.getX(), (float)cv.getY(), (float)cv.getZ());
        word = GeneralRnaReader.readWord(dis);
        int numPoints = 0;
        try {
            numPoints = Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("readPrimitive3D: Could not parse number of points: " + word);
        }
        Vector3D[] points = new Vector3D[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            points[i] = GeneralRnaReader.readVector3D(dis);
        }
        log.fine("ending readVector!");
        return new Polygon3D(points, color);
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            log.fine("found word: " + s);
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        log.fine("found word: " + s);
        return s;
    }
}

