/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.PropertyTools;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.HelixConstraintLink;
import rnadesign.rnamodel.HelixOptimizer;
import rnadesign.rnamodel.RnaStrand;
import tools3d.CoordinateSystem;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.symmetry2.SymCopies;
import tools3d.symmetry2.SymCopySingleton;

public class HelixOptimizerTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final int NO_FUSE = 0;
    public static final int FUSE_APPEND = 1;
    public static final int FUSE_PREPEND = 2;
    public static final String GENERATED_HELICES = "generated_helices";

    public static String generateHelixName(BranchDescriptor3D bd1, BranchDescriptor3D bd2) {
        return "h_" + Object3DTools.getFullName(bd1).replace('.', '_') + "_" + Object3DTools.getFullName(bd2).replace('.', '_');
    }

    public static Object3DLinkSetBundle generateHelix(HelixConstraintLink hcl, int connectionAlgorithm, FitParameters stemFitParameters, Object3D nucleotideDB) throws FittingException {
        CoordinateSystem cs;
        SymCopies symCopies;
        char c1 = 'G';
        char c2 = 'C';
        BranchDescriptor3D bd1 = (BranchDescriptor3D)hcl.getObj1();
        BranchDescriptor3D bd2 = (BranchDescriptor3D)hcl.getObj2();
        String helixName = HelixOptimizerTools.generateHelixName(bd1, bd2);
        if (hcl.getSymId1() > 0) {
            bd1 = (BranchDescriptor3D)bd1.cloneDeep();
            symCopies = SymCopySingleton.getInstance();
            cs = (CoordinateSystem)symCopies.get(hcl.getSymId1());
            bd1.activeTransform(cs);
        }
        if (hcl.getSymId2() > 0) {
            bd2 = (BranchDescriptor3D)bd2.cloneDeep();
            symCopies = SymCopySingleton.getInstance();
            cs = (CoordinateSystem)symCopies.get(hcl.getSymId2());
            bd2.activeTransform(cs);
        }
        Properties properties = new Properties();
        log.fine("Starting to generate interpolating helix with length " + hcl.getBasePairMin());
        Object3DLinkSetBundle stemBundle = ConnectJunctionTools.generateConnectingStem(bd1, bd2, c1, c2, helixName, stemFitParameters, nucleotideDB, connectionAlgorithm, hcl.getBasePairMin());
        if (stemBundle == null || stemBundle.getObject3D() == null || stemBundle.getObject3D().size() < 1) {
            throw new FittingException("Could not generate helix for branch descriptors " + bd1.getFullName() + " " + bd2.getFullName());
        }
        return stemBundle;
    }

    public static Properties generateHelix(HelixConstraintLink hcl, int connectionAlgorithm, FitParameters stemFitParameters, Object3D nucleotideDB, Object3D root, LinkSet links, int fuseStrandsMode) throws FittingException {
        Properties properties = new Properties();
        log.fine("Starting to generate interpolating helix with length " + hcl.getBasePairMin());
        Object3DLinkSetBundle stemBundle = HelixOptimizerTools.generateHelix(hcl, connectionAlgorithm, stemFitParameters, nucleotideDB);
        if (stemBundle != null) {
            log.fine("Stem bundle generated with ConnectJunctionTools!");
            if (stemBundle.getObject3D() != null) {
                log.fine("Adding helix object " + stemBundle.getObject3D().getName() + " to tree node: " + root.getFullName());
                switch (fuseStrandsMode) {
                    case 0: {
                        root.insertChild(stemBundle.getObject3D());
                        PropertyTools.addProperty(properties, GENERATED_HELICES, stemBundle.getObject3D().getName());
                        break;
                    }
                    case 1: {
                        Object3DSet strands = Object3DTools.collectByClassName(stemBundle.getObject3D(), "RnaStrand");
                        assert (strands.size() == 2);
                        RnaStrand strand1 = (RnaStrand)((BranchDescriptor3D)hcl.getObj1()).getOutgoingStrand();
                        RnaStrand strand2 = (RnaStrand)((BranchDescriptor3D)hcl.getObj2()).getOutgoingStrand();
                        strand1.append((RnaStrand)strands.get(0));
                        strand2.append((RnaStrand)strands.get(1));
                        break;
                    }
                    case 2: {
                        Object3DSet strands = Object3DTools.collectByClassName(stemBundle.getObject3D(), "RnaStrand");
                        assert (strands.size() == 2);
                        RnaStrand strand1 = (RnaStrand)((BranchDescriptor3D)hcl.getObj2()).getIncomingStrand();
                        RnaStrand strand2 = (RnaStrand)((BranchDescriptor3D)hcl.getObj1()).getIncomingStrand();
                        strand1.prepend((RnaStrand)strands.get(0));
                        strand2.prepend((RnaStrand)strands.get(1));
                    }
                }
                links.merge(stemBundle.getLinks());
            } else {
                log.fine("No stems were generated!");
            }
        } else {
            log.fine("No stems and links were generated!");
        }
        return properties;
    }

    public static Properties optimizeHelices(int numSteps, double errorScoreLimit, double errorScoreInitialLimit, double kt, FitParameters stemFitParameters, Object3DSet movableObjects, Object3DSet parentObjects, Object3D root, LinkSet links, Object3D nucleotideDB, int connectionAlgorithm, int fuseStrands, boolean firstFixedMode, int helixMutInterval) throws FittingException {
        HelixOptimizer optimizer = new HelixOptimizer(root, links, numSteps, errorScoreLimit, parentObjects);
        if (!optimizer.validate()) {
            throw new FittingException("Could not generate valid optimizer. Maybe no helix constraints are specified?");
        }
        optimizer.setKtOrig(kt);
        optimizer.setHelixMutInterval(helixMutInterval);
        optimizer.setKeepFirstFixedMode(firstFixedMode);
        if (movableObjects != null && movableObjects.size() > 0) {
            log.fine("Setting movable objects: " + movableObjects.size());
            optimizer.setMovableObjects(movableObjects);
        } else {
            log.fine("All objects are considered movable in optimization!");
        }
        int helixCount = 0;
        optimizer.setErrorScoreInitialLimit(errorScoreInitialLimit);
        Properties properties = optimizer.optimize();
        log.fine("Optimization of helices finished: " + properties);
        if (stemFitParameters != null && properties != null && (properties.getProperty("error") == null || properties.getProperty("error").length() > 0)) {
            for (int i = 0; i < links.size(); ++i) {
                if (!(links.get(i) instanceof HelixConstraintLink)) continue;
                ++helixCount;
                HelixConstraintLink hcl = (HelixConstraintLink)links.get(i);
                BranchDescriptor3D bd1 = (BranchDescriptor3D)hcl.getObj1();
                BranchDescriptor3D bd2 = (BranchDescriptor3D)hcl.getObj2();
                try {
                    Properties newProperties = HelixOptimizerTools.generateHelix(hcl, connectionAlgorithm, stemFitParameters, nucleotideDB, root, links, fuseStrands);
                    PropertyTools.merge(properties, newProperties);
                    continue;
                }
                catch (FittingException fe) {
                    log.warning("Could not place helix between branch descriptors " + bd1.getFullName() + " " + bd2.getFullName());
                }
            }
        }
        return properties;
    }
}

