/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.InteractionLink;
import rnasecondary.Interaction;
import sequence.Residue;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleLink;

public class InteractionLinkImp
extends SimpleLink
implements InteractionLink {
    private Interaction interaction;

    public InteractionLinkImp(Object3D o1, Object3D o2, Interaction interaction) {
        super(o1, o2);
        this.interaction = interaction;
        assert (o1 == interaction.getResidue1());
        assert (o2 == interaction.getResidue2());
    }

    public InteractionLinkImp(Interaction interaction) {
        super((Object3D)((Object)interaction.getResidue1()), (Object3D)((Object)interaction.getResidue2()));
        this.interaction = interaction;
    }

    @Override
    public Object clone() {
        InteractionLinkImp l = new InteractionLinkImp(this.getObj1(), this.getObj2(), (Interaction)this.interaction.clone());
        l.setName(this.getName());
        l.setName(new String(this.getName()));
        l.setTypeName(new String(this.getTypeName()));
        return l;
    }

    @Override
    public Object clone(Object3D newObj1, Object3D newObj2) {
        InteractionLinkImp l = (InteractionLinkImp)this.clone();
        l.setObj1(newObj1);
        l.setObj2(newObj2);
        return l;
    }

    @Override
    public Interaction getInteraction() {
        return this.interaction;
    }

    @Override
    public boolean isValid() {
        return this.interaction.getResidue1() == this.getObj1() && this.interaction.getResidue2() == this.getObj2();
    }

    @Override
    public void replaceObjectInLink(Object3D oldObject, Object3D newObject) {
        assert (newObject instanceof Residue);
        if (this.interaction.getResidue1() == oldObject) {
            this.interaction.setResidue1((Residue)((Object)newObject));
            assert (this.getObj1() == oldObject);
        }
        if (this.interaction.getResidue2() == oldObject) {
            this.interaction.setResidue2((Residue)((Object)newObject));
            assert (this.getObj2() == oldObject);
        }
        super.replaceObjectInLink(oldObject, newObject);
    }

    @Override
    public void setInteraction(Interaction interaction) {
        this.interaction = interaction;
    }

    @Override
    public void setObj1(Object3D o) {
        assert (o instanceof Residue);
        super.setObj1(o);
        this.interaction.setResidue1((Residue)((Object)o));
    }

    @Override
    public void setObj2(Object3D o) {
        assert (o instanceof Residue);
        super.setObj2(o);
        this.interaction.setResidue2((Residue)((Object)o));
    }
}

