/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.IncomingNomenclature;
import rnadesign.rnamodel.JunctionQualityChecker;
import rnadesign.rnamodel.LilleyNomenclature;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.RnaPdbRnaviewReader;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.StemTools;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunction3DLispWriter;
import rnadesign.rnamodel.StrandJunctionDBExportTools;
import rnadesign.rnamodel.StrandJunctionTools;
import rnasecondary.Stem;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3DSet;
import tools3d.objects3d.modeling.CollisionForceField;

public class JunctionScanner {
    private static final String DEFAULT_LOG_NAME = "junctionscan";
    private String SLASH = PackageConstants.SLASH;
    public static final char JUNCTION_MODE_CHAR = 'j';
    public static final char KISSINGLOOP_MODE_CHAR = 'k';
    public static final int LOOP_LENGTH_SUM_MAX = 50;
    public static final int SEVERE_ERROR = 1;
    private static ResourceBundle rb = ResourceBundle.getBundle("JunctionScanner");
    private int branchDescriptorOffset = Integer.parseInt(rb.getString("branchDescriptorOffset"));
    private boolean collisionCheckMode = false;
    private double corridorRadius = Double.parseDouble(rb.getString("corridorRadius"));
    private double corridorStart = Double.parseDouble(rb.getString("corridorStart"));
    private int minStemLength = Integer.parseInt(rb.getString("minStemLength"));
    private boolean debugMode = false;
    private String pdbEnding = ".pdb";
    private String dbEnding = ".db.txt";
    private double stemFitRmsTolerance = Double.parseDouble(rb.getString("stemFitRmsTolerance"));
    private Logger log;

    public JunctionScanner(Logger log) {
        this.log = log;
    }

    public JunctionScanner() {
        this(Logger.getLogger(DEFAULT_LOG_NAME));
    }

    void writePdb(PrintStream ps, Object3D obj) {
        GeneralPdbWriter writer = new GeneralPdbWriter();
        writer.setOriginalMode(1);
        String pdbOutput = writer.writeString(obj);
        ps.println(pdbOutput);
    }

    void writeJunctionPdb(PrintStream ps, StrandJunction3D junction, boolean originalMode) {
        String pdbOutput = StrandJunctionTools.toPdb(junction, originalMode);
        ps.println(pdbOutput);
    }

    void writeJunctionLisp(PrintStream ps, StrandJunction3D junction) {
        StrandJunction3DLispWriter writer = new StrandJunction3DLispWriter();
        String s = writer.writeString(junction);
        ps.println(s);
    }

    void writeJunction(PrintStream ps, StrandJunction3D junction, int format, boolean originalMode) {
        switch (format) {
            case 1: {
                this.log.info("Writing junctions in Lisp format!");
                this.writeJunctionLisp(ps, junction);
                break;
            }
            case 3: {
                this.log.info("Writing junctions in PDB format!");
                this.writeJunctionPdb(ps, junction, originalMode);
                break;
            }
            case 2: {
                assert (false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void writeStem(PrintStream ps, RnaStem3D stem) {
        Stem stemInfo = stem.getStemInfo();
        ps.println("" + stemInfo);
    }

    void writeStems(PrintStream ps, Object3D root) {
        if (root instanceof RnaStem3D) {
            this.writeStem(ps, (RnaStem3D)root);
            ps.println();
        } else {
            for (int i = 0; i < root.size(); ++i) {
                this.writeStems(ps, root.getChild(i));
            }
        }
    }

    void writeJunctions(String outFileBase, Object3D junctions, int format, String ending, boolean originalMode) {
        int[] orderCounters = new int[10];
        JunctionQualityChecker qualityChecker = new JunctionQualityChecker();
        LilleyNomenclature lilleyNomenClature = new LilleyNomenclature();
        IncomingNomenclature incomingNomenclature = new IncomingNomenclature();
        for (int i = 0; i < junctions.size(); ++i) {
            if (junctions.getChild(i) == null) continue;
            StrandJunction3D junction = (StrandJunction3D)junctions.getChild(i);
            int order = junction.getBranchCount();
            if (order < 1 || order >= orderCounters.length) {
                this.log.warning("Ignoring junction of order " + order);
                continue;
            }
            if (!qualityChecker.isContinuous(junction)) {
                this.log.warning("Junction is not everywhere continuous. Ignoring junction.");
                continue;
            }
            int n = order;
            orderCounters[n] = orderCounters[n] + 1;
            String incomingName = incomingNomenclature.generateNomenclature(junction);
            String incomingFileName = outFileBase + "_" + incomingName + this.pdbEnding;
            String dbFileName = outFileBase + "_" + incomingName + this.dbEnding;
            this.log.info("##################### Info about junction: " + incomingFileName + " : " + StrandJunctionTools.generateJunctionAngleInfo(junction) + " Nomenclature: " + incomingNomenclature.generateNomenclature(junction));
            this.log.info("# Writing junction: " + incomingFileName);
            try {
                FileOutputStream fos = new FileOutputStream(incomingFileName);
                PrintStream ps = new PrintStream(fos);
                this.writeJunction(ps, junction, format, originalMode);
                fos.close();
            }
            catch (IOException e) {
                this.log.severe("Error writing output file: " + incomingFileName);
            }
            try {
                FileOutputStream fos2 = new FileOutputStream(dbFileName);
                PrintStream ps2 = new PrintStream(fos2);
                ps2.println(StrandJunctionDBExportTools.generateJunctionDBInfo(junction));
                fos2.close();
            }
            catch (IOException e) {
                this.log.severe("Error writing output file: " + dbFileName + " : " + e.getMessage());
            }
            this.log.info("##################### End of Info about junction: " + dbFileName);
        }
    }

    private void exit(int errorCode) {
        System.exit(errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(String[] args) {
        String fileName;
        boolean deleteAtomsMode = false;
        boolean originalMode = true;
        CorridorDescriptor corridorDescriptor = new CorridorDescriptor(this.corridorRadius, this.corridorStart);
        System.out.print("JunctionScan called with: ");
        for (int i = 0; i < args.length; ++i) {
            System.out.print(args[i] + " ");
        }
        if (args.length < 3) {
            this.log.severe("JunctionScan usage: JunctionScan readdir writedir pdbfilename [mode]");
            System.exit(0);
        }
        System.out.println("");
        String readDir = args[0];
        String writeDir = args[1];
        int format = 3;
        int loopLengthSumMax = 50;
        CollisionForceField collisionDetector = new CollisionForceField();
        String fileNameOrig = fileName = args[2];
        String[] words = fileNameOrig.split(this.SLASH);
        String fileNameOrigBase = words[words.length - 1];
        String mode = "jk";
        if (args.length > 3) {
            mode = args[3];
        }
        this.log.info("Using junction scanner mode: " + mode);
        String frontChar = fileName.substring(0, 1);
        if (!frontChar.equals(this.SLASH) && !frontChar.equals(".")) {
            fileName = readDir + this.SLASH + fileNameOrigBase;
        }
        boolean renumberMode = false;
        String renumberString = rb.getString("renumber");
        if (renumberString != null && renumberString.equals("true")) {
            renumberMode = true;
            System.out.println("Setting renumber mode to true!");
        } else {
            System.out.println("Setting renumber mode to false (default)!");
        }
        try {
            System.out.print("Processing file " + fileName);
            FileInputStream is = new FileInputStream(fileName);
            RnaPdbRnaviewReader reader = new RnaPdbRnaviewReader();
            reader.setResidueRenumberMode(renumberMode);
            Object3DLinkSetBundle bundle = reader.readBundle(is);
            this.log.info("Finished reading coordinate file");
            Object3D root = bundle.getObject3D();
            LinkSet links = bundle.getLinks();
            Object3DSet atomSet = Object3DTools.collectByClassName(root, "Atom3D");
            if (atomSet.size() == 0) {
                this.log.severe("No atoms read for file: " + fileName);
                this.exit(1);
            }
            this.log.info("Number of read atoms: " + atomSet.size());
            if (this.collisionCheckMode) {
                double collisionEnergy = collisionDetector.energy(atomSet, links);
                if (collisionEnergy > 0.0) {
                    this.log.warning("Sorry, collisions detected in structure: " + fileName);
                    this.exit(1);
                } else {
                    this.log.info("No collisions detected!");
                }
            }
            if (deleteAtomsMode) {
                this.log.info("Removing all atoms!");
                Object3DTools.removeByClassName(root, "Atom3D");
            }
            ((InputStream)is).close();
            if (this.debugMode) {
                String debugFileName = "debug.pdb";
                try {
                    this.log.info("Writing debug pdb file: " + debugFileName);
                    FileOutputStream fos = new FileOutputStream(debugFileName);
                    PrintStream ps = new PrintStream(fos);
                    this.writePdb(ps, root);
                }
                catch (IOException e) {
                    this.log.severe("Could not open debug file: " + debugFileName);
                }
            }
            this.log.info("Generating stems from " + links.size() + " links...");
            Object3DLinkSetBundle stemBundle = StemTools.generateStemsFromLinks(root, links, this.minStemLength);
            Object3D stemRoot = stemBundle.getObject3D();
            System.out.println("Found stems: ");
            this.writeStems(System.out, stemRoot);
            String stemFileName = writeDir + this.SLASH + fileNameOrigBase + "_stems.out";
            if (stemFileName.length() > 0) {
                Object3DSet branchDescriptors = BranchDescriptorTools.generateBranchDescriptors(new SimpleObject3DSet(stemBundle.getObject3D()), this.branchDescriptorOffset, this.stemFitRmsTolerance);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(stemFileName);
                    PrintStream ps = new PrintStream(fos);
                    for (int i = 0; i < branchDescriptors.size(); ++i) {
                        String branchText = StrandJunctionDBExportTools.generateBranchDBInfo((BranchDescriptor3D)branchDescriptors.get(i), i);
                        ps.println(branchText);
                    }
                }
                catch (IOException ioe) {
                    System.out.println("Error writing stems to file: " + stemFileName + " : " + ioe.getMessage());
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            if (stemRoot.size() > 0) {
                String outFileBase = writeDir + this.SLASH + fileNameOrigBase;
                if (mode.indexOf(106) >= 0) {
                    this.log.info("JunctionScan: Generating junctions!");
                    String junctionName = "junctions";
                    Object3D junctions = BranchDescriptorTools.generateJunctions(stemRoot, junctionName, this.branchDescriptorOffset, corridorDescriptor, this.stemFitRmsTolerance, loopLengthSumMax);
                    this.log.info("Number of initial junctions: " + junctions.size());
                    this.writeJunctions(outFileBase, junctions, format, this.pdbEnding, originalMode);
                }
                if (mode.indexOf(107) >= 0) {
                    String kissingLoopName = "kissingloops";
                    Object3D kissingLoops = BranchDescriptorTools.generateKissingLoops(stemRoot, kissingLoopName, this.branchDescriptorOffset, this.stemFitRmsTolerance);
                    this.log.info("Number of initial kissing loops: " + kissingLoops.size());
                    this.writeJunctions(outFileBase, kissingLoops, format, this.pdbEnding, originalMode);
                }
            } else {
                this.log.warning("Could not find any stems!");
            }
        }
        catch (IOException exp) {
            this.log.severe("Error opening input file: " + fileName);
        }
        System.out.println("Good bye!");
    }

    @Test(groups={"slow", "new"})
    public void testJunctionScannerMain() {
        System.out.println("Starting JunctionScanner.testMain");
        ResourceBundle rb = ResourceBundle.getBundle("JunctionScanner");
        CorridorDescriptor corridorDescriptor = new CorridorDescriptor(this.corridorRadius, this.corridorStart);
        assert (rb != null);
        String fileNames = rb.getString("testFileNames");
        assert (fileNames != null);
        String[] tokens = fileNames.split(",");
        String[] numberJunctions = rb.getString("testJunctions").split(",");
        String[] lilleyNames = rb.getString("testJunctionsLilley").split(",");
        String[] incomingNames = rb.getString("testJunctionsIncoming").split(",");
        assert (numberJunctions != null);
        assert (numberJunctions.length == tokens.length);
        assert (lilleyNames != null);
        String junctionName = "testJunc";
        int loopLengthSumMax = 50;
        RnaPdbRnaviewReader reader = new RnaPdbRnaviewReader();
        for (int i = 0; i < tokens.length; ++i) {
            String fileName = tokens[i];
            if (fileName.length() < 2) continue;
            System.out.println("Reading file: " + fileName);
            try {
                FileInputStream is = new FileInputStream(fileName);
                assert (is != null);
                Object3DLinkSetBundle bundle = reader.readBundle(is);
                ((InputStream)is).close();
                Object3D root = bundle.getObject3D();
                assert (root.size() > 0);
                LinkSet links = bundle.getLinks();
                assert (links.size() > 0);
                Object3DLinkSetBundle stemBundle = StemTools.generateStemsFromLinks(root, links, this.minStemLength);
                Object3D stemRoot = stemBundle.getObject3D();
                assert (stemRoot.size() > 0);
                Object3D junctions = BranchDescriptorTools.generateJunctions(stemRoot, junctionName, this.branchDescriptorOffset, corridorDescriptor, this.stemFitRmsTolerance, loopLengthSumMax);
                Object3DSet junctionSet = Object3DTools.collectByClassName(junctions, "StrandJunction3D");
                System.out.println("Number of found junctions: " + junctionSet.size());
                IncomingNomenclature incomingNomenclature = new IncomingNomenclature();
                LilleyNomenclature lilleyNomenclature = new LilleyNomenclature();
                for (int j = 0; j < junctionSet.size(); ++j) {
                    int k;
                    boolean found;
                    StrandJunction3D junction = (StrandJunction3D)junctionSet.get(j);
                    String incomingName = incomingNomenclature.generateNomenclature(junction);
                    String lilleyName = lilleyNomenclature.generateNomenclature(junction);
                    System.out.println("Junction " + (j + 1) + " : " + incomingName + " " + lilleyName);
                    if (lilleyNames.length > 0) {
                        found = false;
                        for (k = 0; k < lilleyNames.length; ++k) {
                            System.out.println("Comparing to Lilley name: " + lilleyNames[k]);
                            if (!lilleyNames[k].equals(lilleyName)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            System.out.println("Junction Lilley nomenclature not found in filename: " + fileName + " : " + lilleyName);
                        }
                    } else {
                        System.out.println("No junctions defined in test property file!");
                    }
                    if (incomingNames.length <= 0) continue;
                    found = false;
                    for (k = 0; k < incomingNames.length; ++k) {
                        System.out.println("Comparing to Incoming name: " + incomingNames[k]);
                        if (!incomingNames[k].equals(incomingName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    System.out.println("Junction Incoming nomenclature not found: " + fileName + " : " + incomingName);
                }
                if (junctionSet.size() == Integer.parseInt(numberJunctions[i])) continue;
                this.log.warning("Number of found junctions is not equal to the ones defined in JunctionScanner property file: " + junctionSet.size() + " " + numberJunctions[i]);
                continue;
            }
            catch (Object3DIOException e1) {
                System.out.println("Object3DIOException: " + e1.getMessage());
                assert (false);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IO Error: " + ioe.getMessage());
                assert (false);
                continue;
            }
        }
    }

    @Test(groups={"slow", "new"})
    public void testJunctionScannerKissingLoops() {
        ResourceBundle rb = ResourceBundle.getBundle("JunctionScanner");
        CorridorDescriptor corridorDescriptor = new CorridorDescriptor(this.corridorRadius, this.corridorStart);
        assert (rb != null);
        String fileNames = rb.getString("testKissingLoopNames");
        assert (fileNames != null);
        String[] tokens = fileNames.split(",");
        String[] numberJunctions = rb.getString("testKissingLoops").split(",");
        assert (numberJunctions != null);
        Object incomingNames = null;
        String junctionName = "testKissingLoop";
        RnaPdbRnaviewReader reader = new RnaPdbRnaviewReader();
        for (int i = 0; i < tokens.length; ++i) {
            String fileName = tokens[i];
            if (fileName.length() < 2) continue;
            System.out.println("Reading file: " + fileName);
            try {
                FileInputStream is = new FileInputStream(fileName);
                assert (is != null);
                Object3DLinkSetBundle bundle = reader.readBundle(is);
                ((InputStream)is).close();
                Object3D root = bundle.getObject3D();
                LinkSet links = bundle.getLinks();
                Object3DLinkSetBundle stemBundle = StemTools.generateStemsFromLinks(root, links, this.minStemLength);
                Object3D stemRoot = stemBundle.getObject3D();
                assert (stemRoot.size() > 0);
                Object3D junctions = BranchDescriptorTools.generateKissingLoops(stemRoot, junctionName, this.branchDescriptorOffset, this.stemFitRmsTolerance);
                Object3DSet junctionSet = Object3DTools.collectByClassName(junctions, "KissingLoop3D");
                System.out.println("Number of found kissing loops: " + junctionSet.size());
                IncomingNomenclature incomingNomenclature = new IncomingNomenclature();
                LilleyNomenclature lilleyNomenclature = new LilleyNomenclature();
                for (int j = 0; j < junctionSet.size(); ++j) {
                    boolean found;
                    StrandJunction3D junction = (StrandJunction3D)junctionSet.get(j);
                    String incomingName = incomingNomenclature.generateNomenclature(junction);
                    System.out.println("Kissing loop " + (j + 1) + " : " + incomingName);
                    if (incomingNames == null || (incomingNames).length <= 0 || (found = true)) continue;
                    System.out.println("Kissing loop Incoming nomenclature not found!");
                    assert (false);
                }
                System.out.println("Number of recognized kissing loops: " + junctionSet.size());
                if ($assertionsDisabled || junctionSet.size() == Integer.parseInt(numberJunctions[i])) continue;
                throw new AssertionError();
            }
            catch (Object3DIOException e1) {
                System.out.println("Object3DIOException: " + e1.getMessage());
                assert (false);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IO Error: " + ioe.getMessage());
                assert (false);
                continue;
            }
        }
    }
}

