/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.RnaPdbRnaviewReader;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.StemTools;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunction3DLispWriter;
import rnadesign.rnamodel.StrandJunctionTools;
import rnasecondary.Stem;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.modeling.CollisionForceField;

public class JunctionTester {
    private String SLASH = File.separator;
    private int branchDescriptorOffset = 2;
    private double corridorRadius = -1.0;
    private double corridorStart = 10.0;
    private double stemFitRmsTolerance = 2.0;
    private boolean originalMode = true;
    private int gap = 4;
    private double slack = 15.0;
    private boolean debugMode = false;
    private Logger log = Logger.getLogger("NanoTiler_debug");

    void writePdb(PrintStream ps, Object3D obj) {
        GeneralPdbWriter writer = new GeneralPdbWriter();
        String pdbOutput = writer.writeString(obj);
        ps.println(pdbOutput);
    }

    void writeJunctionPdb(PrintStream ps, StrandJunction3D junction) {
        String pdbOutput = StrandJunctionTools.toPdb(junction, this.originalMode);
        ps.println(pdbOutput);
    }

    void writeJunctionLisp(PrintStream ps, StrandJunction3D junction) {
        StrandJunction3DLispWriter writer = new StrandJunction3DLispWriter();
        String s = writer.writeString(junction);
        ps.println(s);
    }

    void writeJunction(PrintStream ps, StrandJunction3D junction, int format) {
        switch (format) {
            case 1: {
                this.log.info("Writing junctions in Lisp format!");
                this.writeJunctionLisp(ps, junction);
                break;
            }
            case 3: {
                this.log.info("Writing junctions in PDB format!");
                this.writeJunctionPdb(ps, junction);
                break;
            }
            case 2: {
                assert (false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void writeStem(PrintStream ps, RnaStem3D stem) {
        Stem stemInfo = stem.getStemInfo();
        ps.println("" + stemInfo);
    }

    void writeStems(PrintStream ps, Object3D root) {
        if (root instanceof RnaStem3D) {
            this.writeStem(ps, (RnaStem3D)root);
            ps.println();
        } else {
            for (int i = 0; i < root.size(); ++i) {
                this.writeStems(ps, root.getChild(i));
            }
        }
    }

    void writeJunctions(String outFileBase, Object3D junctions, int format, String ending) {
        int[] orderCounters = new int[10];
        for (int i = 0; i < junctions.size(); ++i) {
            if (junctions.getChild(i) == null) continue;
            StrandJunction3D junction = (StrandJunction3D)junctions.getChild(i);
            int order = junction.getBranchCount();
            if (order < 1 || order >= orderCounters.length) {
                this.log.warning("weird junction encountered.");
                continue;
            }
            if (order == 1) {
                this.log.warning("sorry, stem-loops not implemented.");
                continue;
            }
            int n = order;
            orderCounters[n] = orderCounters[n] + 1;
            String fileName = outFileBase + "." + order + "." + orderCounters[order] + ending;
            this.log.info("##################### Info about junction: " + fileName + " : " + StrandJunctionTools.generateJunctionAngleInfo(junction));
            this.log.info("Writing junction: " + fileName);
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                PrintStream ps = new PrintStream(fos);
                this.writeJunction(ps, junction, format);
                fos.close();
                continue;
            }
            catch (IOException e) {
                this.log.severe("Error writing output file: " + fileName);
            }
        }
    }

    public void main(String[] args) {
        boolean deleteAtomsMode = false;
        System.out.print("ElasticNetTest version 1.3 call with: ");
        for (int i = 0; i < args.length; ++i) {
            System.out.print(args[i] + " ");
        }
        if (args.length < 3) {
            this.log.severe("JunctionTest usage: JunctionTest readdir writedir pdbfilename");
            System.exit(0);
        }
        System.out.println("");
        CorridorDescriptor corridorDescriptor = new CorridorDescriptor(this.corridorRadius, this.corridorStart);
        GeneralPdbWriter writer = new GeneralPdbWriter();
        String readDir = args[0];
        String writeDir = args[1];
        String ending = ".pdb";
        int format = 3;
        CollisionForceField collisionDetector = new CollisionForceField();
        for (int i = 2; i < args.length; ++i) {
            String fileName = args[i];
            String frontChar = fileName.substring(0, 1);
            if (!frontChar.equals(this.SLASH) && !frontChar.equals(".")) {
                fileName = readDir + this.SLASH + args[i];
            }
            try {
                System.out.print("Processing file " + (i + 1) + " : " + fileName);
                FileInputStream is = new FileInputStream(fileName);
                RnaPdbRnaviewReader reader = new RnaPdbRnaviewReader();
                Object3DLinkSetBundle bundle = reader.readBundle(is);
                Object3D root = bundle.getObject3D();
                LinkSet links = bundle.getLinks();
                Object3DSet atomSet = Object3DTools.collectByClassName(root, "Atom3D");
                double collisionEnergy = collisionDetector.energy(atomSet, links);
                if (collisionEnergy > 0.0) {
                    this.log.warning("Sorry, collisions detected in structure: " + fileName);
                    continue;
                }
                this.log.fine("No collisions detected!");
                if (deleteAtomsMode) {
                    this.log.info("Removing all atoms!");
                    Object3DTools.removeByClassName(root, "Atom3D");
                }
                ((InputStream)is).close();
                if (this.debugMode) {
                    String debugFileName = "debug.pdb";
                    try {
                        FileOutputStream fos = new FileOutputStream(debugFileName);
                        PrintStream ps = new PrintStream(fos);
                        this.writePdb(ps, root);
                    }
                    catch (IOException e) {
                        this.log.severe("Could not open debug file: " + debugFileName);
                    }
                }
                Object3DLinkSetBundle stemBundle = StemTools.generateStems(root);
                Object3D stemRoot = stemBundle.getObject3D();
                this.writeStems(System.out, stemRoot);
                if (stemRoot.size() > 0) {
                    this.log.fine("JunctionTest: Generating junctions with corridor descriptor " + corridorDescriptor);
                    String junctionName = "junctions";
                    Object3D junctions = BranchDescriptorTools.generateJunctions(stemRoot, junctionName, this.branchDescriptorOffset, corridorDescriptor, this.stemFitRmsTolerance, 50);
                    String outFileBase = writeDir + this.SLASH + args[i] + "_junc";
                    this.writeJunctions(outFileBase, junctions, format, ending);
                    continue;
                }
                this.log.warning("Could not find any stems!");
                continue;
            }
            catch (IOException exp) {
                this.log.severe("Error opening input file: " + fileName);
            }
        }
    }
}

