/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.IntegerList;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionNomenclature;

public class LilleyNomenclature
implements StrandJunctionNomenclature {
    private boolean loopMode = true;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public boolean isLoopMode() {
        return this.loopMode;
    }

    public static int computeLoopLengthSum(StrandJunction3D junction) {
        int sum = 0;
        for (int i = 0; i < junction.getStrandCount(); ++i) {
            sum += junction.getLoopLength(i);
        }
        return sum;
    }

    private int compareTo(int[] ary1, int[] ary2) {
        assert (ary1.length == ary2.length);
        for (int i = 0; i < ary1.length; ++i) {
            if (ary1[i] < ary2[i]) {
                return -1;
            }
            if (ary2[i] >= ary1[i]) continue;
            return 1;
        }
        return 0;
    }

    private int[] rotateToSmallest(int[] loopLengths) {
        IntegerList list = new IntegerList(loopLengths);
        IntegerList bestList = new IntegerList(loopLengths);
        for (int i = 1; i < list.size(); ++i) {
            IntegerList newList = list.rotate(i);
            if (newList.compareTo(bestList) >= 0) continue;
            bestList = newList;
        }
        return bestList.toArray();
    }

    private int getConsecutiveStrand(StrandJunction3D junction, int strandId) {
        log.warning("Untrustworthy method used: LilleyNomenClature.getConsecutiveStrand");
        if (junction.isKissingLoop()) {
            if (++strandId >= junction.getStrandCount()) {
                strandId = 0;
            }
            return strandId;
        }
        int outBranchId = junction.getOutgoingBranchId(strandId);
        assert (outBranchId < junction.getBranchCount());
        int[] incomingSeqIds = junction.getIncomingSeqIds();
        int result = incomingSeqIds[outBranchId];
        assert (result < junction.getStrandCount());
        return result;
    }

    private int getConsecutiveBranchDescriptor(StrandJunction3D junction, int branchId) {
        if (junction.isKissingLoop()) {
            if (++branchId >= junction.getBranchCount()) {
                branchId = 0;
            }
            return branchId;
        }
        BranchDescriptor3D bd = junction.getBranch(branchId);
        NucleotideStrand inStrand = bd.getIncomingStrand();
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            if (!junction.getBranch(i).getOutgoingStrand().isProbablyEqual(inStrand)) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    @Override
    public String generateNomenclature(StrandJunction3D junction) {
        assert (junction.getBranchCount() == junction.getStrandCount());
        int branchCount = junction.getBranchCount();
        if (!this.loopMode) {
            return "" + branchCount + "H";
        }
        int[] loopLengths = new int[junction.getStrandCount()];
        int currentBranchDescriptor = 0;
        int pc = 0;
        do {
            BranchDescriptor3D branch = junction.getBranch(currentBranchDescriptor);
            NucleotideStrand strand = branch.getIncomingStrand();
            int strandIndex = junction.findStrandIndex(strand);
            assert (strandIndex >= 0);
            assert (strandIndex < junction.getStrandCount());
            loopLengths[strandIndex] = junction.getLoopLength(strandIndex);
            currentBranchDescriptor = this.getConsecutiveBranchDescriptor(junction, currentBranchDescriptor);
            assert (++pc < 1000);
        } while (currentBranchDescriptor != 0);
        loopLengths = this.rotateToSmallest(loopLengths);
        boolean zeroCount = false;
        StringBuffer buf = new StringBuffer();
        int helixCount = 1;
        for (int i = 0; i < loopLengths.length; ++i) {
            if (loopLengths[i] > 0) {
                if (helixCount > 1) {
                    buf.append(helixCount + "H" + "S" + loopLengths[i]);
                } else {
                    buf.append("HS" + loopLengths[i]);
                }
                helixCount = 1;
                continue;
            }
            ++helixCount;
        }
        return buf.toString();
    }

    public void setLoopMode(boolean b) {
        this.loopMode = b;
    }
}

