/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.DnaJunctionSet;
import graphtools.DnaJunctionSetTools;
import graphtools.GraphBase;
import graphtools.IntegerList;
import graphtools.IntegerListList;
import graphtools.IntegerListListList;
import java.util.logging.Logger;
import rnadesign.rnamodel.AbstractGridTiler;
import rnadesign.rnamodel.GridPathTools;
import rnadesign.rnamodel.GridTiler;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaPhysicalProperties;
import rnadesign.rnamodel.RnaStrand;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class RandomGridTiler
extends AbstractGridTiler
implements GridTiler {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static RnaPhysicalProperties rpp = new RnaPhysicalProperties();
    private static int offset = 2;
    private Object3D nucleotideDB;

    public RandomGridTiler(Object3D nucleotideDB) {
        this.nucleotideDB = nucleotideDB;
    }

    public IntegerListList generateRandomPathSet(GraphBase graph, boolean onlyFirstPathModea) {
        DnaJunctionSet junctionSet = DnaJunctionSetTools.generateRandomJunctionSet(graph);
        IntegerListList newPaths = DnaJunctionSetTools.generatePaths(graph, junctionSet);
        return newPaths;
    }

    public double computePathScore(IntegerList path) {
        return path.size();
    }

    public double computePathSetScore(IntegerListList pathSet) {
        if (pathSet == null || pathSet.size() == 0) {
            return 1000.0;
        }
        double worstPathScore = this.computePathScore(pathSet.get(0));
        for (int i = 1; i < pathSet.size(); ++i) {
            double score = this.computePathScore(pathSet.get(i));
            if (!(score > worstPathScore)) continue;
            worstPathScore = score;
        }
        return worstPathScore;
    }

    public int findBestPathSet(IntegerListListList pathSetSet) {
        int bestPathSetId = 0;
        double bestPathSetScore = this.computePathSetScore(pathSetSet.get(0));
        for (int i = 1; i < pathSetSet.size(); ++i) {
            double score = this.computePathSetScore(pathSetSet.get(i));
            if (!(score < bestPathSetScore)) continue;
            bestPathSetScore = score;
            bestPathSetId = i;
        }
        return bestPathSetId;
    }

    public Object3DLinkSetBundle generateTiling(Object3DSet objectSet, LinkSet links, IntegerListList circularPaths, String baseName, char sequenceChar) {
        int i;
        log.fine("Starting generateTiling(objectSet...)");
        log.fine("Using path set: " + circularPaths);
        GraphBase graph = GridPathTools.generateGraph(objectSet, links);
        SimpleObject3D resultObjects = new SimpleObject3D();
        SimpleObject3DSet strandSet = new SimpleObject3DSet();
        SimpleLinkSet newLinkSet = new SimpleLinkSet();
        resultObjects.setName("tilingroot");
        log.fine("generating strand for each path out of " + circularPaths.size());
        for (i = 0; i < circularPaths.size(); ++i) {
            String strandName = baseName + "_s" + (i + 1);
            Object3DLinkSetBundle bundle = this.generateStrand(circularPaths.get(i), objectSet, strandName, sequenceChar, 2 * offset);
            RnaStrand strand = (RnaStrand)bundle.getObject3D();
            LinkSet tmpLinks = bundle.getLinks();
            log.fine("Strand " + strand.getName() + " with size " + strand.getResidueCount() + " " + strand.size() + " generated. Number of new links: " + tmpLinks.size());
            resultObjects.insertChild(strand);
            strandSet.add(strand);
            newLinkSet.merge(tmpLinks);
            log.fine("New link set size after merging: " + newLinkSet.size());
        }
        log.fine("generating Stem3D for each link");
        for (i = 0; i < links.size(); ++i) {
            String stemName = baseName + "_h" + (i + 1);
            Object3DLinkSetBundle stemBundle = this.generateStem3D(circularPaths, objectSet, strandSet, links.get(i), stemName, this.nucleotideDB, offset);
            if (stemBundle != null) {
                resultObjects.insertChild(stemBundle.getObject3D());
                newLinkSet.merge(stemBundle.getLinks());
                continue;
            }
            log.fine("Warning: generated stem was null, not adding! Link index: " + i);
        }
        for (i = 0; i < strandSet.size(); ++i) {
            Rna3DTools.interpolateNonStems((RnaStrand)strandSet.get(i), resultObjects);
        }
        SimpleObject3DLinkSetBundle resultBundle = new SimpleObject3DLinkSetBundle(resultObjects, newLinkSet);
        log.fine("Finished generateTiling(1)! " + resultBundle.getObject3D().size() + " " + resultBundle.getLinks().size());
        return resultBundle;
    }

    public static Object3DSet generateObjectSet(Object3D objects, LinkSet links) {
        SimpleObject3DSet objectSet = new SimpleObject3DSet(objects);
        GraphBase graph = GridPathTools.generateGraph(objectSet, links);
        for (int i = objectSet.size() - 1; i >= 0; --i) {
            Object3D obj = objectSet.get(i);
            if (graph.getConnections(i).size() >= 2) continue;
            log.fine("Removing object " + i + " from set!");
            objectSet.remove(obj);
        }
        return objectSet;
    }

    @Override
    public Object3DLinkSetBundle generateTiling(Object3D objects, LinkSet links, String baseName, char sequenceChar, boolean onlyFirstPathMode) {
        log.fine("Starting generateTiling!");
        Object3DSet objectSet = RandomGridTiler.generateObjectSet(objects, links);
        log.fine("Using object3dset with " + objectSet.size() + " objects!");
        GraphBase graph = GridPathTools.generateGraph(objectSet, links);
        log.fine("Starting generatePathSets!");
        IntegerListList randomPathSet = this.generateRandomPathSet(graph, onlyFirstPathMode);
        log.fine("Finished generateRandomPathSet: " + randomPathSet.size() + " " + randomPathSet);
        Object3DLinkSetBundle bundle = this.generateTiling(objectSet, links, randomPathSet, baseName, sequenceChar);
        log.fine("Finished generateTiling with " + bundle.getObject3D().size() + " objects and " + bundle.getLinks().size() + " links.");
        return bundle;
    }
}

