/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ApplicationBugException;
import java.util.logging.Logger;
import numerictools.PolarTools;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.InteractionLinkImp;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleRnaStem3D;
import rnadesign.rnamodel.SimpleRnaStrand;
import rnadesign.rnamodel.StemTools;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleStem;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.LetterSymbol;
import sequence.SimpleSequence;
import sequence.UnknownSymbolException;
import tools3d.CoordinateSystem;
import tools3d.LineShape;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class Rna3DTools {
    public static double RMS_LARGE_LIMIT = 10.0;
    public static final Vector3D X_VEC = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D Z_VEC = new Vector3D(0.0, 0.0, 1.0);
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public static LineShape computeHelix(int s, Vector3D refPos, HelixParameters prm) {
        double z = prm.rise * (double)s;
        double zDelta = refPos.getZ() - 0.0;
        double phiDelta = PolarTools.phiFromXY(refPos.getX(), refPos.getY());
        double r = Math.sqrt(refPos.getX() * refPos.getX() + refPos.getY() * refPos.getY());
        double nt = prm.basePairsPerTurn;
        double h = prm.rise;
        double hoff = prm.offset;
        double phiOff = prm.phaseOffset;
        double a1 = Math.PI * 2 * (double)s / nt + phiDelta;
        double a2 = a1 + phiOff - 2.0 * phiDelta;
        double b1x = r * Math.cos(a1);
        double b1y = r * Math.sin(a1);
        double b2x = r * Math.cos(a2);
        double b2y = r * Math.sin(a2);
        Vector3D pos1 = new Vector3D(b1x, b1y, z + zDelta);
        Vector3D pos2 = new Vector3D(b2x, b2y, z + hoff - zDelta);
        if (s > 0 && prm.getDeformation() != null) {
            Matrix4D m = prm.getDeformation().generateMatrix4D();
            pos1 = m.multiply(pos1, s);
            pos2 = m.multiply(pos2, s);
        }
        return new LineShape(pos1, pos2);
    }

    public static LineShape computeHelix(int n, Vector3D refPos, HelixParameters prm, CoordinateSystem cs) {
        LineShape line = Rna3DTools.computeHelix(n, refPos, prm);
        Vector3D p1 = line.getPosition1();
        Vector3D p2 = line.getPosition2();
        p1 = cs.activeTransform(p1);
        p2 = cs.activeTransform(p2);
        return new LineShape(p1, p2);
    }

    public static LineShape computeHelix(int n, CoordinateSystem cs, HelixParameters prm) {
        return Rna3DTools.computeHelix(n, RnaConstants.C4_NORM_POS, prm, cs);
    }

    public static Object3DLinkSetBundle generateRnaStem3D(RnaStrand strand1, RnaStrand strand2, int startPos, int stopPos, int length, boolean setEqualMode, String stemName, Vector3D strand1BasePos, Vector3D directionOrig) {
        log.severe("Outdated method called: generateRnaStem3D(RnaStrand, RnaStrand, int, int, boolean, String, Vector3D, Vector3D)");
        SimpleStem stem = new SimpleStem(startPos, stopPos, length, strand1, strand2);
        if (!stem.isValid()) {
            throw new ApplicationBugException("Invalid stem parameters in RNA3DTools.generateRnaStem3D!");
        }
        Vector3D base = strand1BasePos;
        Vector3D endPos = strand1.getResidue3D(startPos + length - 1).getPosition();
        Vector3D direction = new Vector3D(directionOrig);
        direction.normalize();
        Vector3D base2 = strand2.getResidue3D(stopPos).getPosition();
        Vector3D rpTmp = base2.minus(base);
        Vector3D rp = direction.cross(rpTmp);
        rp.normalize();
        SimpleRnaStem3D stem3D = new SimpleRnaStem3D(stem);
        SimpleLinkSet newLinks = new SimpleLinkSet();
        stem3D.setName(stemName);
        RnaInteractionType watsonCrickInteraction = new RnaInteractionType(1);
        RnaInteractionType backboneInteraction = new RnaInteractionType(6);
        for (int i = 0; i < length; ++i) {
            assert (false);
            LineShape line = null;
            SimpleObject3D objectStrand1 = new SimpleObject3D(line.getPosition1());
            String name = "S1N" + (i + 1);
            objectStrand1.setName(name);
            stem3D.insertChild(objectStrand1);
            Residue3D res1 = strand1.getResidue3D(startPos + i);
            if (setEqualMode) {
                res1.setPosition(objectStrand1.getPosition());
            }
            SimpleObject3D objectStrand2 = new SimpleObject3D(line.getPosition2());
            String name2 = "S2N" + (i + 1);
            objectStrand2.setName(name2);
            stem3D.insertChild(objectStrand2);
            Residue3D res2 = strand2.getResidue3D(stopPos - i);
            if (setEqualMode) {
                res2.setPosition(objectStrand2.getPosition());
            }
            SimpleInteraction interaction = new SimpleInteraction(res1, res2, watsonCrickInteraction);
            InteractionLinkImp link = new InteractionLinkImp(res1, res2, interaction);
            newLinks.add(link);
        }
        stem3D.setStrand1End5Index(0);
        stem3D.setStrand1End3Index(length - 1);
        stem3D.setStrand2End5Index(length);
        stem3D.setStrand2End3Index(2 * length - 1);
        return new SimpleObject3DLinkSetBundle(stem3D, newLinks);
    }

    private static void addAtomInStem(Residue3D res, int pos, boolean watsonStrand, BranchDescriptor3D branch, Atom3D atomOrig) {
        Atom3D atom = (Atom3D)atomOrig.cloneDeep();
        LineShape line = Rna3DTools.computeHelix(pos, atom.getPosition(), branch.getHelixParameters(), branch.getCoordinateSystem());
        if (watsonStrand) {
            atom.setPosition(line.getPosition1());
        } else {
            atom.setPosition(line.getPosition2());
        }
        res.insertChild(atom);
    }

    private static void addAtomsInStem(Residue3D res, int pos, boolean watsonStrand, BranchDescriptor3D branch, Object3D nucleotideDB) {
        assert (nucleotideDB != null);
        String molTypeName = "" + res.getSymbol().getCharacter();
        int molIdx = nucleotideDB.getIndexOfChild(molTypeName);
        if (molIdx < 0) {
            log.severe("Warning: nucleotide type " + molTypeName + " was not defined in database: ");
            for (int i = 0; i < nucleotideDB.size(); ++i) {
                log.severe(nucleotideDB.getChild(i).getName());
            }
            return;
        }
        Nucleotide3D mol = (Nucleotide3D)nucleotideDB.getChild(molIdx);
        int atomCount = mol.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            Rna3DTools.addAtomInStem(res, pos, watsonStrand, branch, mol.getAtom(i));
        }
        assert (Object3DTools.collectByClassName(res, "Atom3D").size() > 0);
    }

    public static Object3DLinkSetBundle generateRnaStem3D(RnaStrand strand1, RnaStrand strand2, int startPos, int stopPos, int length, int helixOffset, boolean setEqualMode, String stemName, BranchDescriptor3D branch, Object3D nucleotideDB) {
        assert (nucleotideDB != null);
        SimpleStem stem = new SimpleStem(startPos, stopPos, length, strand1, strand2);
        if (!stem.isValid()) {
            throw new ApplicationBugException("Invalid stem parameters in RNA3DTools.generateRnaStem3D!");
        }
        SimpleRnaStem3D stem3D = new SimpleRnaStem3D(stem);
        SimpleLinkSet newLinks = new SimpleLinkSet();
        stem3D.setName(stemName);
        RnaInteractionType watsonCrickInteraction = new RnaInteractionType(1);
        RnaInteractionType backboneInteraction = new RnaInteractionType(6);
        for (int i = 0; i < length; ++i) {
            LineShape line = Rna3DTools.computeHelix(i + helixOffset, branch.getCoordinateSystem(), branch.getHelixParameters());
            SimpleObject3D objectStrand1 = new SimpleObject3D(line.getPosition1());
            String name = "S1N" + (i + 1);
            objectStrand1.setName(name);
            stem3D.insertChild(objectStrand1);
            Residue3D res1 = strand1.getResidue3D(startPos + i);
            if (setEqualMode) {
                res1.setPosition(objectStrand1.getPosition());
            }
            if (nucleotideDB != null && res1.getAtomCount() == 0) {
                Rna3DTools.addAtomsInStem(res1, i + helixOffset, true, branch, nucleotideDB);
            } else assert (false);
            SimpleObject3D objectStrand2 = new SimpleObject3D(line.getPosition2());
            String name2 = "S2N" + (i + 1);
            objectStrand2.setName(name2);
            stem3D.insertChild(objectStrand2);
            Residue3D res2 = strand2.getResidue3D(stopPos - i);
            if (setEqualMode) {
                res2.setPosition(objectStrand2.getPosition());
            }
            if (nucleotideDB != null && res2.getAtomCount() == 0) {
                Rna3DTools.addAtomsInStem(res2, i + helixOffset, false, branch, nucleotideDB);
            } else assert (false);
            SimpleInteraction interaction = new SimpleInteraction(res1, res2, watsonCrickInteraction);
            InteractionLinkImp link = new InteractionLinkImp(res1, res2, interaction);
            newLinks.add(link);
        }
        stem3D.setStrand1End5Index(0);
        stem3D.setStrand1End3Index(length - 1);
        stem3D.setStrand2End5Index(length);
        stem3D.setStrand2End3Index(2 * length - 1);
        assert (newLinks.size() == stem3D.getLength());
        assert (newLinks.get(0) instanceof InteractionLink);
        return new SimpleObject3DLinkSetBundle(stem3D, newLinks);
    }

    public static Object3DLinkSetBundle generateRnaStem3D(RnaStrand strand1, RnaStrand strand2, int startPos, int stopPos, int length, boolean setEqualMode, String stemName) {
        assert (false);
        SimpleStem stem = new SimpleStem(startPos, stopPos, length, strand1, strand2);
        if (!stem.isValid()) {
            throw new ApplicationBugException("Invalid stem parameters in RNA3DTools.generateRnaStem3D!");
        }
        Vector3D base = strand1.getResidue3D(startPos).getPosition();
        Vector3D endPos = strand1.getResidue3D(startPos + length - 1).getPosition();
        Vector3D direction = endPos.minus(base);
        direction.normalize();
        return Rna3DTools.generateRnaStem3D(strand1, strand2, startPos, stopPos, length, setEqualMode, stemName, base, direction);
    }

    static int find5PrimeStem(RnaStrand strand, int pos, Object3DSet stemSet) {
        for (int i = pos - 1; i >= 0; --i) {
            Nucleotide3D residue = (Nucleotide3D)strand.getResidue3D(i);
            boolean result = StemTools.isPartOfStem(residue, stemSet);
            if (!result) continue;
            return i;
        }
        return -1;
    }

    static int find3PrimeStem(RnaStrand strand, int pos, Object3DSet stemSet) {
        for (int i = pos + 1; i < strand.getResidueCount(); ++i) {
            Nucleotide3D residue = (Nucleotide3D)strand.getResidue3D(i);
            boolean result = StemTools.isPartOfStem(residue, stemSet);
            if (!result) continue;
            return i;
        }
        return -1;
    }

    public static Object3DSet collectRnaStrand(Object3D root) {
        SimpleObject3DSet stemSet = new SimpleObject3DSet();
        for (int i = 0; i < root.size(); ++i) {
            Object3D child = root.getChild(i);
            if (!(child instanceof RnaStrand)) continue;
            stemSet.add(child);
        }
        return stemSet;
    }

    public static void interpolateNonStems(RnaStrand strand, Object3D root) {
        Object3DSet stemSet = StemTools.collectStems3D(root);
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            Vector3D newPos;
            Vector3D direction;
            Nucleotide3D residue = (Nucleotide3D)strand.getResidue3D(i);
            if (StemTools.isPartOfStem(residue, stemSet)) continue;
            int pos5 = Rna3DTools.find5PrimeStem(strand, i, stemSet);
            int pos3 = Rna3DTools.find3PrimeStem(strand, i, stemSet);
            if (pos5 >= 0) {
                if (pos3 >= 0) {
                    Vector3D meanPos = Vector3D.mean(strand.getResidue3D(pos5).getPosition(), strand.getResidue3D(pos3).getPosition());
                    residue.setPosition(meanPos);
                    continue;
                }
                direction = new Vector3D(0.0, 0.0, 0.0);
                int pos5Count = pos5;
                while (--pos5Count >= 0) {
                    direction = strand.getResidue3D(pos5).getPosition();
                    direction.sub(strand.getResidue3D(pos5Count).getPosition());
                    if (direction.lengthSquare() == 0.0) continue;
                }
                if (direction.lengthSquare() == 0.0) {
                    log.severe("Warning: Could not find 5' stem direction!");
                    continue;
                }
                direction.normalize();
                newPos = strand.getResidue3D(pos5).getPosition().plus(direction.mul(RnaConstants.RESIDUE_DIST * (double)(i - pos5)));
                residue.setPosition(newPos);
                continue;
            }
            if (pos3 < 0) continue;
            direction = new Vector3D(0.0, 0.0, 0.0);
            int pos3Count = pos3;
            while (++pos3Count < strand.getResidueCount()) {
                direction = strand.getResidue3D(pos3).getPosition();
                direction.sub(strand.getResidue3D(pos3Count).getPosition());
                if (direction.lengthSquare() == 0.0) continue;
            }
            if (direction.lengthSquare() == 0.0) {
                log.severe("Warning: Could not find 3' stem direction!");
                continue;
            }
            direction.normalize();
            newPos = strand.getResidue3D(pos3).getPosition().plus(direction.mul(RnaConstants.RESIDUE_DIST * (double)(pos3 - i)));
            residue.setPosition(newPos);
        }
    }

    public static Object3DLinkSetBundle generateSimpleRnaStrand(String name, String seqString, Vector3D pos, Vector3D dir) throws UnknownSymbolException {
        Alphabet alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;
        SimpleRnaStrand strand = new SimpleRnaStrand(alphabet);
        strand.setName(name);
        strand.setPosition(pos);
        String seqName = name + ".seq";
        SimpleSequence seq = new SimpleSequence(seqString, seqName, alphabet);
        int residueCount = seqString.length();
        for (int i = 0; i < residueCount; ++i) {
            LetterSymbol symbol = seq.getResidue(i).getSymbol();
            Nucleotide3D residue = new Nucleotide3D(symbol, pos.plus(dir.mul(RnaConstants.RESIDUE_DIST * (double)i)));
            double r = 3.0;
            residue.setDimensions(new Vector3D(r, r, r));
            Character character = new Character(symbol.getCharacter());
            String resName = "" + character.toString() + (i + 1);
            residue.setName(resName);
            residue.setBoundingRadius(r);
            strand.insertChild(residue);
        }
        SimpleLinkSet links = new SimpleLinkSet();
        RnaInteractionType backboneType = new RnaInteractionType(6);
        for (int i = 1; i < strand.size(); ++i) {
            SimpleInteraction backboneInteraction = new SimpleInteraction((Residue3D)strand.getChild(i - 1), (Residue3D)strand.getChild(i), backboneType);
            links.add(new InteractionLinkImp(strand.getChild(i - 1), strand.getChild(i), backboneInteraction));
        }
        return new SimpleObject3DLinkSetBundle(strand, links);
    }

    RnaStrand cutStrand(RnaStrand strand, int n) {
        int i;
        int origLen = strand.getResidueCount();
        SimpleRnaStrand newStrand = new SimpleRnaStrand();
        String name = strand.getName() + "_cut" + n;
        newStrand.setName(name);
        Vector3D newPos = new Vector3D(0.0, 0.0, 0.0);
        Vector3D oldPos = new Vector3D(0.0, 0.0, 0.0);
        for (i = n; i < strand.getResidueCount(); ++i) {
            newStrand.insertChild(strand.getResidue3D(i));
            newPos.add(strand.getResidue3D(i).getPosition());
        }
        newPos.scale(1.0 / (double)newStrand.getResidueCount());
        for (i = strand.getResidueCount() - 1; i >= 0; --i) {
            strand.removeChild(i);
        }
        for (i = 0; i < strand.getResidueCount(); ++i) {
            oldPos.add(strand.getResidue3D(i).getPosition());
        }
        oldPos.scale(1.0 / (double)strand.getResidueCount());
        assert (origLen == newStrand.getResidueCount() + strand.getResidueCount());
        return newStrand;
    }
}

