/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.List;
import numerictools.PotentialND;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;

public class RnaIntegerPotential
implements PotentialND {
    private LinkSet links;
    private Object3DSet objSet;
    private List<Integer> linkIds1;
    private List<Integer> linkIds2;
    private double turnHeight;
    private double offset;

    public RnaIntegerPotential(Object3DSet objSet, LinkSet links, double turnHeight, double offset) {
        this.links = links;
        this.objSet = objSet;
        this.turnHeight = turnHeight;
        this.offset = offset;
        this.initIds();
        assert (Math.abs(this.getDistanceScore(3.0 * turnHeight + 2.0 * offset)) < 0.001);
        assert (Math.abs(this.getDistanceScore(3.0 * turnHeight + 2.0 * offset + 5.7) - 5.7) < 0.001);
        assert (Math.abs(this.getDistanceScore(3.0 * turnHeight + 2.0 * offset - 5.7) - 5.7) < 0.001);
    }

    private void initIds() {
        assert (this.links != null);
        this.linkIds1 = new ArrayList<Integer>();
        this.linkIds2 = new ArrayList<Integer>();
        for (int i = 0; i < this.links.size(); ++i) {
            Object3D obj1 = this.links.get(i).getObj1();
            Object3D obj2 = this.links.get(i).getObj2();
            int id1 = this.objSet.indexOf(obj1);
            int id2 = this.objSet.indexOf(obj2);
            if (id1 < 0 || id1 >= this.objSet.size() || id2 < 0 || id2 >= this.objSet.size()) continue;
            this.linkIds1.add(id1);
            this.linkIds2.add(id2);
        }
    }

    @Override
    public double[] generateLowPosition() {
        double[] result = new double[this.getDimension()];
        for (int i = 0; i < this.objSet.size(); ++i) {
            Vector3D pos = this.objSet.get(i).getPosition();
            result[3 * i] = pos.getX();
            result[3 * i + 1] = pos.getY();
            result[3 * i + 2] = pos.getZ();
        }
        return result;
    }

    @Override
    public double[] generateHighPosition() {
        return this.generateLowPosition();
    }

    @Override
    public int getDimension() {
        return this.objSet.size() * 3;
    }

    @Override
    public double getValue(double[] position) {
        double sum = 0.0;
        for (int i = 0; i < this.linkIds1.size(); ++i) {
            sum += this.getValue(position, i);
        }
        return sum;
    }

    private double getValue(double[] position, int linkId) {
        int objId1 = this.linkIds1.get(linkId);
        int objId2 = this.linkIds2.get(linkId);
        int off1 = objId1 * 3;
        int off2 = objId2 * 3;
        assert (off1 != off2);
        Vector3D pos1 = new Vector3D(position[off1], position[off1 + 1], position[off1 + 2]);
        Vector3D pos2 = new Vector3D(position[off2], position[off2 + 1], position[off2 + 2]);
        double distance = pos1.distance(pos2);
        return this.getDistanceScore(distance);
    }

    public double getDistanceScore(double distance) {
        int nTurns2;
        double result2;
        if ((distance -= 2.0 * this.offset) <= this.turnHeight) {
            return this.turnHeight - distance;
        }
        int nTurns = (int)(distance / this.turnHeight);
        double result1 = Math.abs(distance - (double)nTurns * this.turnHeight);
        if (result1 < (result2 = Math.abs(distance - (double)(nTurns2 = nTurns + 1) * this.turnHeight))) {
            return result1;
        }
        return result2;
    }
}

