/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.CollectionTools;
import graphtools.IntegerArrayGenerator;
import graphtools.IntegerArrayMaxDifferentConstraint;
import graphtools.IntegerPermutatorList;
import graphtools.MappedMaxDiffIntegerPermutator;
import graphtools.PermutationGenerator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.ConnectivityGenerator;
import rnadesign.rnamodel.DBElementConnectionDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.GrowConnectivity;
import rnadesign.rnamodel.RnaConstants;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;

public class SimpleConnectivityIterator
implements Iterator<GrowConnectivity> {
    boolean initial = true;
    public static int DEBUG_OUTPUT_INTERVALL = 0;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double angleTolerance = -1.0;
    private ConnectivityGenerator connGenerator;
    private MappedMaxDiffIntegerPermutator helixLengths;
    private IntegerArrayGenerator vertexIds;
    private PermutationGenerator[] helixPermutations;
    private IntegerPermutatorList permutatorList;
    private boolean debugMode = true;
    private boolean smartConnectionCheckMode = true;
    private boolean noSkipMode = false;

    SimpleConnectivityIterator(ConnectivityGenerator connGenerator) {
        this.connGenerator = connGenerator;
        this.init();
        assert (this.validate());
    }

    private void init() {
        int i;
        log.info("Starting SimpleConnectivityIterator.init()...");
        this.helixLengths = new MappedMaxDiffIntegerPermutator(this.connGenerator.getLinks().size(), 0, 2 * this.connGenerator.getHelixLengthVariation() + 1, this.connGenerator.getConnectionCountMax());
        assert (this.helixLengths.validate());
        int[] bbIdSizes = new int[this.connGenerator.getVertices().size()];
        for (i = 0; i < this.connGenerator.getBuildingBlockIndices().size(); ++i) {
            bbIdSizes[i] = this.connGenerator.getBuildingBlockIndices().get(i).size();
        }
        this.vertexIds = new IntegerArrayGenerator(bbIdSizes);
        this.vertexIds.addConstraint(new IntegerArrayMaxDifferentConstraint(this.connGenerator.getBuildingBlockCountMax()));
        assert (this.vertexIds.validate());
        this.helixPermutations = new PermutationGenerator[this.vertexIds.size()];
        for (i = 0; i < this.helixPermutations.length; ++i) {
            int numVertexHelices = this.connGenerator.getLinks().getLinkOrder(this.connGenerator.getVertices().get(i));
            assert (numVertexHelices > 0);
            this.helixPermutations[i] = new PermutationGenerator(numVertexHelices);
            assert (this.helixPermutations[i].validate());
        }
        this.permutatorList = new IntegerPermutatorList();
        this.permutatorList.add(this.helixLengths);
        for (PermutationGenerator p : this.helixPermutations) {
            this.permutatorList.add(p);
        }
        this.permutatorList.add(this.vertexIds);
        assert (this.permutatorList.validate());
        if (this.debugMode) {
            log.info("SimpleConnectivityIterator:Test-iterating through permutations: " + this.permutatorList);
            long count = 1L;
            do {
                log.info("Iterator: " + ++count + " : " + this.permutatorList.toString());
                assert (this.permutatorList.validate());
            } while (this.permutatorList.hasNext() && this.permutatorList.inc());
            log.info("Counted helix length combinations: " + count);
            this.permutatorList.reset();
            log.info("Status after reset: " + this.permutatorList);
            assert (this.permutatorList.hasNext());
            log.info("Now starting self-test of iterator: ");
            this.permutatorList.testCurrentTotal();
            assert (!this.permutatorList.hasNext());
            log.info("Successful self-testing of iterator!");
            this.permutatorList.reset();
        }
        assert (this.validate());
        log.info("Finished SimpleConnectivityIterator.init()");
    }

    public static int estimateNumberBasePairs(double distance) {
        return (int)(distance / RnaConstants.HELIX_RISE + 0.5);
    }

    int countIdenticalDuplicates(List list) {
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (list.get(i) != list.get(j)) continue;
                ++count;
            }
        }
        return count;
    }

    private DBElementConnectionDescriptor generateConnection(int n, List<DBElementDescriptor> buildingBlocks) {
        int bpOffset;
        assert (n < this.connGenerator.getLinks().size());
        Link link = this.connGenerator.getLinks().get(n);
        Object3D obj1 = link.getObj1();
        Object3D obj2 = link.getObj2();
        List<Object3D> vertices = this.connGenerator.getVertices();
        assert (this.countIdenticalDuplicates(vertices) == 0);
        int id1 = CollectionTools.indexOfIdentical(vertices, obj1);
        int id2 = CollectionTools.indexOfIdentical(vertices, obj2);
        log.fine("Attempting to generating connection between " + obj1.getFullName() + " " + obj2.getFullName() + " " + n + " number of building blocks: " + buildingBlocks.size() + " bb ids: " + id1 + " " + id2);
        assert (id1 >= 0);
        assert (id2 >= 0);
        assert (id1 != id2);
        assert (id1 < this.vertexIds.size());
        assert (id2 < this.vertexIds.size());
        assert (vertices.size() == this.vertexIds.size());
        assert (vertices.size() == buildingBlocks.size());
        int bbid1 = id1;
        int bbid2 = id2;
        DBElementDescriptor dbe1 = buildingBlocks.get(bbid1);
        DBElementDescriptor dbe2 = buildingBlocks.get(bbid2);
        int bpIdeal = SimpleConnectivityIterator.estimateNumberBasePairs(obj1.distance(obj2));
        int bp = bpIdeal + (bpOffset = this.helixLengths.get()[n] - this.connGenerator.getHelixLengthVariation());
        if (bp < 0) {
            return null;
        }
        int linkRank1 = this.connGenerator.getLinks().getLinkRank(obj1, link);
        int linkRank2 = this.connGenerator.getLinks().getLinkRank(obj2, link);
        assert (linkRank1 >= 0);
        assert (linkRank2 >= 0);
        assert (linkRank1 < this.helixPermutations[id1].size());
        assert (linkRank2 < this.helixPermutations[id2].size());
        int helixId1 = this.helixPermutations[id1].get()[linkRank1];
        int helixId2 = this.helixPermutations[id2].get()[linkRank2];
        return new DBElementConnectionDescriptor(dbe1, dbe2, helixId1, helixId2, bp);
    }

    public BigInteger getTotal() {
        return this.permutatorList.getTotal();
    }

    private Vector3D getHelixDirection(int dbElementId, int helixId) {
        return this.connGenerator.getBuildingBlocksHelixDirections().get(dbElementId).get(helixId);
    }

    private double computeAngle(int dbElementId, int helixId1, int helixId2) {
        double angle = this.getHelixDirection(dbElementId, helixId1).angle(this.getHelixDirection(dbElementId, helixId2));
        return angle;
    }

    private double computeAngle(DBElementConnectionDescriptor conn1, DBElementConnectionDescriptor conn2) {
        if (conn1.getDescriptor1() == conn2.getDescriptor1()) {
            int dbId = CollectionTools.indexOf(this.connGenerator.getBuildingBlocks(), conn1.getDescriptor1());
            assert (false);
            return this.computeAngle(dbId, conn1.getHelixendId1(), conn2.getHelixendId1());
        }
        if (conn1.getDescriptor1() == conn2.getDescriptor2()) {
            int dbId = CollectionTools.indexOf(this.connGenerator.getBuildingBlocks(), conn1.getDescriptor1());
            assert (false);
            return this.computeAngle(dbId, conn1.getHelixendId1(), conn2.getHelixendId1());
        }
        assert (false);
        return -1.0;
    }

    public boolean validateAngle(DBElementConnectionDescriptor newConn, DBElementConnectionDescriptor sofarConn, double linkAngle, double angleTolerance) {
        assert (newConn != null && sofarConn != null);
        double angle = this.computeAngle(newConn, sofarConn);
        return angleTolerance <= 0.0 || Math.abs(angle - linkAngle) <= angleTolerance;
    }

    public void testValidateAngle1() {
        DBElementConnectionDescriptor newConn = null;
        DBElementConnectionDescriptor sofarConn = null;
        double linkAngle = 0.1;
        double angleTolerance = Math.toRadians(20.0);
        assert (!this.validateAngle(newConn, sofarConn, linkAngle, angleTolerance));
    }

    private List<DBElementConnectionDescriptor> generateConnections(List<DBElementDescriptor> buildingBlocks) {
        ArrayList<DBElementConnectionDescriptor> result = new ArrayList<DBElementConnectionDescriptor>();
        int[] linkIds = new int[this.connGenerator.getLinks().size()];
        for (int i = 0; i < this.connGenerator.getLinks().size(); ++i) {
            Link link1 = this.connGenerator.getLinks().get(i);
            DBElementConnectionDescriptor newConn = this.generateConnection(i, buildingBlocks);
            if (newConn == null) {
                return null;
            }
            linkIds[i] = i;
            if (this.smartConnectionCheckMode) {
                for (DBElementConnectionDescriptor sofarConn : result) {
                    assert (sofarConn != null);
                    if (!newConn.isSimilar(sofarConn) || newConn.getBasePairCount() == sofarConn.getBasePairCount()) continue;
                    return null;
                }
            }
            if (this.angleTolerance > 0.0) {
                for (int j = i + 1; j < result.size(); ++j) {
                    double linkAngle;
                    Link link2 = this.connGenerator.getLinks().get(j);
                    DBElementConnectionDescriptor sofarConn = (DBElementConnectionDescriptor)result.get(j);
                    if (link1.findCommon(link2).size() != 1 || this.validateAngle(newConn, sofarConn, linkAngle = link1.angle(link2), this.angleTolerance)) continue;
                    return null;
                }
            }
            DBElementConnectionDescriptor conn = this.generateConnection(i, buildingBlocks);
            assert (conn != null);
            result.add(conn);
        }
        return result;
    }

    private List<DBElementDescriptor> generateBuildingBlocks() {
        List<DBElementDescriptor> bb = this.connGenerator.getBuildingBlocks();
        ArrayList<DBElementDescriptor> result = new ArrayList<DBElementDescriptor>();
        for (int i = 0; i < this.vertexIds.size(); ++i) {
            DBElementDescriptor dbe = (DBElementDescriptor)bb.get(this.vertexIds.get()[i]).clone();
            if (dbe.getOrder() != this.connGenerator.getVertexOrder(i)) {
                log.info("Skipping building block generation because building block order does not match vertex order.");
                assert (false);
                return null;
            }
            dbe.setDescriptorId(i);
            result.add(dbe);
        }
        assert (result.size() == this.vertexIds.size());
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.permutatorList.hasNext();
    }

    public GrowConnectivity getGrowConnectivity() {
        log.info("Starting getGrowConnectivity");
        List<DBElementDescriptor> buildingBlocks = this.generateBuildingBlocks();
        if (buildingBlocks == null) {
            return null;
        }
        List<DBElementConnectionDescriptor> connections = this.generateConnections(buildingBlocks);
        if (connections == null || buildingBlocks.contains(null) || connections.contains(null)) {
            return null;
        }
        GrowConnectivity growConn = new GrowConnectivity(buildingBlocks, connections, null, this.connGenerator.getNumGenerations());
        growConn.setGraphFlag(true);
        assert (growConn.isGraphFlag());
        if (!this.validateConnectivity(growConn)) {
            if (this.initial) {
                this.initial = false;
                try {
                    this.inc();
                }
                catch (IllegalAccessException e) {
                    return null;
                }
                return this.getGrowConnectivity();
            }
            return null;
        }
        assert (this.validateConnectivity(growConn));
        log.info("Generated grow connectivity corresponding to permutator status: " + this.permutatorList.toString());
        return growConn;
    }

    @Override
    public GrowConnectivity next() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            this.inc();
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return this.getGrowConnectivity();
    }

    private void inc() throws IllegalAccessException {
        assert (this.hasNext());
        GrowConnectivity connectivity = null;
        int incCounter = 1;
        int connectionCountMax = this.connGenerator.getConnectionCountMax();
        int buildingBlockCountMax = this.connGenerator.getBuildingBlockCountMax();
        do {
            log.info("another do iteration in SimpleConnectivityIterator.inc()...");
            if (!this.permutatorList.hasNext()) {
                throw new IllegalAccessException("No increasing possible!");
            }
            if (DEBUG_OUTPUT_INTERVALL > 0 && incCounter++ % DEBUG_OUTPUT_INTERVALL == 0) {
                log.info("Increasing building block connectivity from (" + incCounter++ + "): " + this.getGrowConnectivity());
            }
            this.permutatorList.inc();
            if (!this.permutatorList.validate()) continue;
            log.info("Trying grow connectivity corresponding to permutator status: " + this.permutatorList.toString());
            connectivity = this.getGrowConnectivity();
            if (connectivity == null) continue;
            if (connectivity.getNonEquivalentBuildingBlockCount() > buildingBlockCountMax) {
                log.info("Skipping to next building block during increment");
                this.skipToNextBuildingBlock();
            }
            if (connectivity.getNonEquivalentConnectionCount() <= connectionCountMax) continue;
            log.info("Skipping to next connection during increment");
            this.skipToNextConnection();
        } while (this.permutatorList.hasNext() && connectivity == null || !this.validateConnectivity(connectivity));
        if (connectivity == null || !this.validateConnectivity(connectivity)) {
            throw new IllegalAccessException("SimpleConnectivityIterator.inc: Could not find solution!");
        }
    }

    public boolean validateConnectivity(GrowConnectivity connectivity) {
        boolean result;
        if (connectivity == null || connectivity.getConnections() == null || connectivity.getBuildingBlocks() == null) {
            return false;
        }
        boolean check1 = !connectivity.getConnections().contains(null);
        boolean check2 = !connectivity.getBuildingBlocks().contains(null);
        int connectionCountMax = this.connGenerator.getConnectionCountMax();
        int buildingBlockCountMax = this.connGenerator.getBuildingBlockCountMax();
        if (!check1) {
            return false;
        }
        if (!check2) {
            return false;
        }
        log.info("Validating connectivity: " + connectivity.getNonEquivalentBuildingBlockCount() + " " + buildingBlockCountMax + " " + connectivity.getNonEquivalentConnectionCount() + " " + connectionCountMax);
        boolean bl = result = connectivity.getNonEquivalentBuildingBlockCount() <= buildingBlockCountMax && connectivity.getNonEquivalentConnectionCount() <= connectionCountMax;
        if (!result) {
            log.info("Invalid connectivity encountered: " + connectivity + " non-equiv blocks: " + connectivity.getNonEquivalentBuildingBlockCount() + " non-equiv conn: " + connectivity.getNonEquivalentConnectionCount());
        } else {
            log.info("Valid connectivity encountered: " + connectivity + " non-equiv blocks: " + connectivity.getNonEquivalentBuildingBlockCount() + " non-equiv conn: " + connectivity.getNonEquivalentConnectionCount());
        }
        return result;
    }

    public boolean validate() {
        if (this.helixPermutations == null || this.helixPermutations.length != this.connGenerator.getVertices().size() || this.vertexIds.size() != this.connGenerator.getVertices().size()) {
            return false;
        }
        return this.permutatorList != null;
    }

    @Override
    public void remove() {
        assert (false);
    }

    public void reset() {
        this.permutatorList.reset();
        assert (this.validate());
    }

    public boolean skipToNextBuildingBlock() throws IllegalAccessException {
        log.info("Starting skipToNextBuildingBlock");
        if (this.noSkipMode) {
            log.info("Deactivated skipToNextBuildingBlock!");
            return false;
        }
        GrowConnectivity connectivity = null;
        int skipN = 1 + this.helixPermutations.length;
        int incCounter = 1;
        do {
            log.info("another do iteration in SimpleConnectivityIterator.inc()...");
            if (!this.permutatorList.hasNext()) {
                throw new IllegalAccessException("No increasing possible!");
            }
            if (DEBUG_OUTPUT_INTERVALL > 0 && incCounter++ % DEBUG_OUTPUT_INTERVALL == 0) {
                log.info("Increasing building block connectivity from (" + incCounter++ + "): " + this.getGrowConnectivity());
            }
            this.permutatorList.skip(skipN);
            log.info("Skip: Trying grow connectivity corresponding to permutator status: " + this.permutatorList.toString());
        } while ((connectivity = this.getGrowConnectivity()) == null || !this.validateConnectivity(connectivity));
        assert (connectivity != null && this.validateConnectivity(connectivity));
        log.info("Finished skipToNextBuildingBlock");
        return true;
    }

    public boolean skipToNextConnection() throws IllegalAccessException {
        log.info("Starting skipToNextConnection");
        if (this.noSkipMode) {
            log.info("Deactivated skipToNextConnection!");
            return false;
        }
        GrowConnectivity connectivity = null;
        int skipN = 1;
        int incCounter = 1;
        do {
            log.info("another do iteration in SimpleConnectivityIterator.inc()...");
            if (!this.permutatorList.hasNext()) {
                throw new IllegalAccessException("No increasing possible!");
            }
            if (DEBUG_OUTPUT_INTERVALL > 0 && incCounter++ % DEBUG_OUTPUT_INTERVALL == 0) {
                log.info("Increasing building block connectivity from (" + incCounter++ + "): " + this.getGrowConnectivity());
            }
            this.permutatorList.skip(skipN);
            log.info("Skip: Trying grow connectivity corresponding to permutator status: " + this.permutatorList.toString());
        } while ((connectivity = this.getGrowConnectivity()) == null || !this.validateConnectivity(connectivity));
        assert (connectivity != null && this.validateConnectivity(connectivity));
        log.info("Finished skipToNextConnection");
        return true;
    }
}

