/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.CollectionTools;
import graphtools.BipartiteGraphPermutator;
import graphtools.IntegerArrayGenerator;
import graphtools.IntegerPermutator;
import graphtools.IntegerPermutatorList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.ConnectivityGenerator;
import rnadesign.rnamodel.DBElementConnectionDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.GrowConnectivity;
import rnadesign.rnamodel.RnaConstants;
import tools3d.Vector3D;

public class SmallConnectivityIterator
implements Iterator<GrowConnectivity> {
    boolean initial = true;
    public static int DEBUG_OUTPUT_INTERVALL = 0;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double angleTolerance = -1.0;
    private ConnectivityGenerator connGenerator;
    private IntegerPermutator helixLengths;
    private BipartiteGraphPermutator bipartite;
    private IntegerPermutatorList permutatorList;
    private boolean debugMode = false;
    private boolean smartConnectionCheckMode = true;
    private boolean noSkipMode = false;
    private int connAvail = 0;
    private int connMax = 0;
    private int[] connectionBBIds;
    private int[] connectionHelixIds;

    SmallConnectivityIterator(ConnectivityGenerator connGenerator) {
        this.connGenerator = connGenerator;
        this.connMax = connGenerator.getConnectionCountMax();
        this.init();
        assert (this.validate());
    }

    private void initConnections() {
        List<DBElementDescriptor> bbDescs = this.generateBuildingBlocks();
        int orderSum = 0;
        for (DBElementDescriptor d : bbDescs) {
            orderSum += d.getOrder();
        }
        this.connAvail = orderSum;
        if (2 * this.connMax > this.connAvail) {
            this.connMax = this.connAvail / 2;
        }
        this.connectionBBIds = new int[orderSum];
        this.connectionHelixIds = new int[orderSum];
        int pc = 0;
        for (int i = 0; i < bbDescs.size(); ++i) {
            DBElementDescriptor dbe = bbDescs.get(i);
            int order = dbe.getOrder();
            int j = 0;
            while (j < order) {
                this.connectionBBIds[pc] = i;
                this.connectionHelixIds[pc] = j++;
                ++pc;
            }
        }
    }

    private void init() {
        log.info("Starting SmallConnectivityIterator.init()...");
        this.initConnections();
        this.helixLengths = new IntegerArrayGenerator(this.connMax, 2 * this.connGenerator.getHelixLengthVariation() + 1);
        assert (this.helixLengths.validate());
        this.permutatorList = new IntegerPermutatorList();
        this.permutatorList.add(this.helixLengths);
        assert (this.connAvail >= 2 * this.connMax);
        this.bipartite = new BipartiteGraphPermutator(this.connAvail, this.connMax);
        this.permutatorList.add(this.bipartite);
        assert (this.permutatorList.validate());
        if (this.debugMode) {
            log.info("SmallConnectivityIterator:Test-iterating through permutations: " + this.permutatorList);
            long count = 1L;
            do {
                log.info("Iterator: " + ++count + " : " + this.permutatorList.toString());
                assert (this.permutatorList.validate());
            } while (this.permutatorList.hasNext() && this.permutatorList.inc());
            log.info("Counted helix length combinations: " + count);
            this.permutatorList.reset();
            log.info("Status after reset: " + this.permutatorList);
            assert (this.permutatorList.hasNext());
            log.info("Now starting self-test of iterator: ");
            this.permutatorList.testCurrentTotal();
            assert (!this.permutatorList.hasNext());
            log.info("Successful self-testing of iterator!");
            this.permutatorList.reset();
        }
        assert (this.validate());
        log.info("Finished SmallConnectivityIterator.init()");
    }

    private int estimateNumberBasePairs(double distance) {
        return (int)(distance / RnaConstants.HELIX_RISE + 0.5);
    }

    int countIdenticalDuplicates(List list) {
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (list.get(i) != list.get(j)) continue;
                ++count;
            }
        }
        return count;
    }

    private DBElementConnectionDescriptor generateConnection(int bbid1, int bbid2, int helixId1, int helixId2, int bp, List<DBElementDescriptor> buildingBlocks) {
        DBElementDescriptor dbe1 = buildingBlocks.get(bbid1);
        DBElementDescriptor dbe2 = buildingBlocks.get(bbid2);
        return new DBElementConnectionDescriptor(dbe1, dbe2, helixId1, helixId2, bp);
    }

    public BigInteger getTotal() {
        return this.permutatorList.getTotal();
    }

    private Vector3D getHelixDirection(int dbElementId, int helixId) {
        return this.connGenerator.getBuildingBlocksHelixDirections().get(dbElementId).get(helixId);
    }

    private double computeAngle(int dbElementId, int helixId1, int helixId2) {
        double angle = this.getHelixDirection(dbElementId, helixId1).angle(this.getHelixDirection(dbElementId, helixId2));
        return angle;
    }

    private double computeAngle(DBElementConnectionDescriptor conn1, DBElementConnectionDescriptor conn2) {
        if (conn1.getDescriptor1() == conn2.getDescriptor1()) {
            int dbId = CollectionTools.indexOf(this.connGenerator.getBuildingBlocks(), conn1.getDescriptor1());
            assert (false);
            return this.computeAngle(dbId, conn1.getHelixendId1(), conn2.getHelixendId1());
        }
        if (conn1.getDescriptor1() == conn2.getDescriptor2()) {
            int dbId = CollectionTools.indexOf(this.connGenerator.getBuildingBlocks(), conn1.getDescriptor1());
            assert (false);
            return this.computeAngle(dbId, conn1.getHelixendId1(), conn2.getHelixendId1());
        }
        assert (false);
        return -1.0;
    }

    public boolean validateAngle(DBElementConnectionDescriptor newConn, DBElementConnectionDescriptor sofarConn, double linkAngle, double angleTolerance) {
        assert (newConn != null && sofarConn != null);
        double angle = this.computeAngle(newConn, sofarConn);
        return angleTolerance <= 0.0 || Math.abs(angle - linkAngle) <= angleTolerance;
    }

    public void testValidateAngle1() {
        DBElementConnectionDescriptor newConn = null;
        DBElementConnectionDescriptor sofarConn = null;
        double linkAngle = 0.1;
        double angleTolerance = Math.toRadians(20.0);
        assert (!this.validateAngle(newConn, sofarConn, linkAngle, angleTolerance));
    }

    private List<DBElementConnectionDescriptor> generateConnections(List<DBElementDescriptor> buildingBlocks) {
        ArrayList<DBElementConnectionDescriptor> result = new ArrayList<DBElementConnectionDescriptor>();
        int[] bipartiteConn = this.bipartite.get();
        int[] helLen = this.helixLengths.get();
        for (int i = 0; i < this.connMax; ++i) {
            int c1 = bipartiteConn[2 * i];
            int bb1 = this.connectionBBIds[c1];
            int c2 = bipartiteConn[2 * i + 1];
            int bb2 = this.connectionBBIds[c2];
            int h1 = this.connectionHelixIds[c1];
            int h2 = this.connectionHelixIds[c2];
            int bp = helLen[i];
            DBElementConnectionDescriptor newConn = this.generateConnection(bb1, bb2, h1, h2, bp, buildingBlocks);
            if (newConn == null) {
                return null;
            }
            assert (newConn != null);
            result.add(newConn);
        }
        return result;
    }

    private List<DBElementDescriptor> generateBuildingBlocks() {
        List<DBElementDescriptor> bb = this.connGenerator.getBuildingBlocks();
        return bb;
    }

    @Override
    public boolean hasNext() {
        return this.permutatorList.hasNext();
    }

    public GrowConnectivity getGrowConnectivity() {
        log.info("Starting getGrowConnectivity");
        List<DBElementDescriptor> buildingBlocks = this.generateBuildingBlocks();
        if (buildingBlocks == null) {
            return null;
        }
        List<DBElementConnectionDescriptor> connections = this.generateConnections(buildingBlocks);
        if (connections == null || buildingBlocks.contains(null) || connections.contains(null)) {
            return null;
        }
        GrowConnectivity growConn = new GrowConnectivity(buildingBlocks, connections, null, this.connGenerator.getNumGenerations());
        String topol = this.connGenerator.getTopology();
        if (topol != null && topol.length() > 0) {
            growConn.addTopology(topol);
        }
        if (!this.validateConnectivity(growConn)) {
            if (this.initial) {
                this.initial = false;
                try {
                    this.inc();
                }
                catch (IllegalAccessException e) {
                    return null;
                }
                return this.getGrowConnectivity();
            }
            return null;
        }
        assert (this.validateConnectivity(growConn));
        log.info("Generated grow connectivity corresponding to permutator status: " + this.permutatorList.toString());
        return growConn;
    }

    @Override
    public GrowConnectivity next() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            this.inc();
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return this.getGrowConnectivity();
    }

    private void inc() throws IllegalAccessException {
        assert (this.hasNext());
        GrowConnectivity connectivity = null;
        int incCounter = 1;
        int connectionCountMax = this.connMax;
        int buildingBlockCountMax = this.connGenerator.getBuildingBlockCountMax();
        do {
            log.info("another do iteration in SmallConnectivityIterator.inc()...");
            if (!this.permutatorList.hasNext()) {
                throw new IllegalAccessException("No increasing possible!");
            }
            if (DEBUG_OUTPUT_INTERVALL > 0 && incCounter++ % DEBUG_OUTPUT_INTERVALL == 0) {
                log.info("Increasing building block connectivity from (" + incCounter++ + "): " + this.getGrowConnectivity());
            }
            this.permutatorList.inc();
            if (!this.permutatorList.validate()) continue;
            log.info("Trying grow connectivity corresponding to permutator status: " + this.permutatorList.toString());
            connectivity = this.getGrowConnectivity();
            if (connectivity == null) continue;
            if (connectivity.getNonEquivalentBuildingBlockCount() > buildingBlockCountMax) {
                log.info("Skipping to next building block during increment");
                assert (false);
            }
            if (connectivity.getNonEquivalentConnectionCount() <= connectionCountMax) continue;
            log.info("Skipping to next connection during increment");
            assert (false);
        } while (this.permutatorList.hasNext() && connectivity == null || !this.validateConnectivity(connectivity));
        if (connectivity == null || !this.validateConnectivity(connectivity)) {
            throw new IllegalAccessException("SmallConnectivityIterator.inc: Could not find solution!");
        }
    }

    public boolean validateConnectivity(GrowConnectivity connectivity) {
        boolean result;
        if (connectivity == null || connectivity.getConnections() == null || connectivity.getBuildingBlocks() == null) {
            return false;
        }
        boolean check1 = !connectivity.getConnections().contains(null);
        boolean check2 = !connectivity.getBuildingBlocks().contains(null);
        int connectionCountMax = this.connMax;
        int buildingBlockCountMax = this.connGenerator.getBuildingBlockCountMax();
        if (!check1) {
            return false;
        }
        if (!check2) {
            return false;
        }
        log.fine("Validating connectivity: " + connectivity.getNonEquivalentBuildingBlockCount() + " " + buildingBlockCountMax + " " + connectivity.getNonEquivalentConnectionCount() + " " + connectionCountMax);
        boolean bl = result = connectivity.getNonEquivalentBuildingBlockCount() <= buildingBlockCountMax && connectivity.getNonEquivalentConnectionCount() <= connectionCountMax;
        if (!result) {
            log.fine("Invalid connectivity encountered: " + connectivity + " non-equiv blocks: " + connectivity.getNonEquivalentBuildingBlockCount() + " non-equiv conn: " + connectivity.getNonEquivalentConnectionCount());
        } else {
            log.fine("Valid connectivity encountered: " + connectivity + " non-equiv blocks: " + connectivity.getNonEquivalentBuildingBlockCount() + " non-equiv conn: " + connectivity.getNonEquivalentConnectionCount());
        }
        return result;
    }

    public boolean validate() {
        if (this.permutatorList == null) {
            return false;
        }
        return this.permutatorList.validate();
    }

    @Override
    public void remove() {
        assert (false);
    }

    public void reset() {
        this.permutatorList.reset();
        assert (this.validate());
    }
}

