/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ApplicationBugException;
import java.util.logging.Logger;
import numerictools.DoubleArrayTools;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.SimpleRnaStem3D;
import rnasecondary.Interaction;
import rnasecondary.InteractionType;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleStem;
import rnasecondary.Stem;
import sequence.DnaTools;
import sequence.Residue;
import sequence.Sequence;
import tools3d.LineShape;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class StemTools {
    public static double WATSON_CRICK_RESIDUE_CUTOFF = 18.0;
    public static double WATSON_CRICK_ATOM_CUTOFF = 5.0;
    private static final double threshold = 0.5;
    public static int STEM_LENGTH_MINIMUM = 3;
    public static boolean atomMode = true;
    public static double backboneAngleMin = 1.0471975511965976;
    public static double backboneAngleMax = Math.PI;
    public static double baseAngleMin = 1.0471975511965976;
    public static double baseAngleMax = Math.PI;
    public static double drmsCutoff = 1.5;
    public static final int helixLength = 3;
    public static final int range = 1;
    public static final HelixParameters idealHelixParameters = new HelixParameters();
    private static final Vector3D[] idealHelix = StemTools.generateIdealHelixPatch(3, idealHelixParameters);
    private static Vector3D[] scratchHelix = new Vector3D[6];
    private static String helixRootAtomName = "C4*";
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static boolean debugMode = false;

    private static Vector3D[] generateIdealHelixPatch(int length, HelixParameters helixParameters) {
        Vector3D[] result = new Vector3D[2 * length];
        int pc = 0;
        for (int i = 0; i < length; ++i) {
            LineShape line = Rna3DTools.computeHelix(i, RnaConstants.C4_NORM_POS, helixParameters);
            Vector3D pos1 = line.getPosition1();
            Vector3D pos2 = line.getPosition2();
            result[pc++] = pos1;
            result[pc++] = pos2;
        }
        return result;
    }

    private static Vector3D obtainHelixBasePos(Residue3D residue, boolean atomMode) {
        int idx;
        if (atomMode && (idx = residue.getIndexOfChild(helixRootAtomName)) >= 0) {
            return residue.getChild(idx).getPosition();
        }
        return residue.getPosition();
    }

    private static Vector3D[] generateHelixPatch(NucleotideStrand strand1, int pos1, NucleotideStrand strand2, int pos2, int offset, boolean atomMode) {
        int pc = 0;
        int startPos = pos1 + offset;
        int endPos = pos2 - offset;
        Vector3D[] result = scratchHelix;
        for (int i = 0; i < 3; ++i) {
            Vector3D p1 = StemTools.obtainHelixBasePos(strand1.getResidue3D(startPos + i), atomMode);
            Vector3D p2 = StemTools.obtainHelixBasePos(strand2.getResidue3D(endPos - i), atomMode);
            result[pc++] = p1;
            result[pc++] = p2;
        }
        return result;
    }

    public static String stemResidueInfo(RnaStem3D stem) {
        StringBuffer buf = new StringBuffer();
        int len = stem.getLength();
        buf.append("5' start(stem pos 1, seq 1): " + stem.getStartResidue(0));
        buf.append("5' stop(stem pos 1, seq 2): " + stem.getStopResidue(0));
        buf.append("3' start(stem pos n, seq 1): " + stem.getStartResidue(len - 1));
        buf.append("3' stop(stem pos 2, seq 2): " + stem.getStopResidue(len - 1));
        return buf.toString();
    }

    public static String stemResidueLongInfo(RnaStem3D stem) {
        StringBuffer buf = new StringBuffer();
        int len = stem.getLength();
        buf.append("Stem info: " + stem.getStemInfo() + PackageConstants.NEWLINE);
        for (int i = 0; i < len; ++i) {
            buf.append("base pair: " + (i + 1));
            buf.append("start: " + stem.getStartResidue(i).getName() + " " + stem.getStartResidue(i).getChild("C4*"));
            buf.append(" stop: " + stem.getStopResidue(i).getName() + " " + stem.getStopResidue(i).getChild("C4*") + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    public static RnaStem3D generateNaturalStem(NucleotideStrand strand1, NucleotideStrand strand2, Stem stem, String stemName) {
        String name;
        int i;
        if (!stem.isValid()) {
            throw new ApplicationBugException("Invalid stem parameters in RNA3DTools.generateRnaStem3D!");
        }
        SimpleRnaStem3D stem3D = new SimpleRnaStem3D(stem);
        stem3D.setName(stemName);
        for (i = 0; i < stem.size(); ++i) {
            Vector3D pos1 = strand1.getResidue3D(stem.getResidue1(i).getPos()).getPosition();
            SimpleObject3D objectStrand1 = new SimpleObject3D(pos1);
            name = "S1N" + (i + 1);
            objectStrand1.setName(name);
            stem3D.insertChild(objectStrand1);
        }
        for (i = 0; i < stem.size(); ++i) {
            Vector3D pos2 = strand2.getResidue3D(stem.getResidue2(i).getPos()).getPosition();
            SimpleObject3D objectStrand2 = new SimpleObject3D(pos2);
            name = "S2N" + (i + 1);
            objectStrand2.setName(name);
            stem3D.insertChild(objectStrand2);
        }
        int length = stem.size();
        stem3D.setStrand1End5Index(0);
        stem3D.setStrand1End3Index(length - 1);
        stem3D.setStrand2End5Index(length);
        stem3D.setStrand2End3Index(2 * length - 1);
        Object3DTools.balanceTree(stem3D);
        assert (stem3D != null);
        return stem3D;
    }

    public static Object3DSet generateStemsFromSymmetricMatrix(double[][] mtx, int minStemLength, double thresh, NucleotideStrand strand1, String stemBaseName) {
        SimpleInteraction interaction;
        Residue residue2;
        Residue residue1;
        assert (mtx != null);
        assert (minStemLength > 0);
        assert (thresh > 0.0);
        log.fine("Starting generateStemsFromSymmetricMatrix... " + mtx.length);
        if (debugMode) {
            DoubleArrayTools.writeMatrix(System.out, mtx);
        }
        SimpleObject3DSet result = new SimpleObject3DSet();
        NucleotideStrand strand2 = strand1;
        RnaInteractionType watsonCrick = new RnaInteractionType(1);
        boolean openFlag = false;
        int stemCounter = 1;
        NucleotideStrand sequence = strand1;
        SimpleStem newStem = new SimpleStem(sequence, sequence);
        block0: for (int nys = 0; nys < mtx.length; ++nys) {
            for (int nx = 0; nx < nys; ++nx) {
                int ny = nys - nx;
                if (nx >= ny) {
                    if (!openFlag) continue block0;
                    if (newStem.size() >= minStemLength) {
                        result.add(StemTools.generateNaturalStem(strand1, strand2, newStem, stemBaseName + stemCounter++));
                    }
                    openFlag = false;
                    continue block0;
                }
                if (mtx[nx][ny] >= thresh) {
                    if (!openFlag) {
                        newStem = new SimpleStem(sequence, sequence);
                        openFlag = true;
                    }
                    residue1 = strand1.getResidue(nx);
                    residue2 = strand2.getResidue(ny);
                    interaction = new SimpleInteraction(residue1, residue2, watsonCrick);
                    newStem.add(interaction);
                    continue;
                }
                if (!openFlag) continue;
                if (newStem.size() >= minStemLength) {
                    result.add(StemTools.generateNaturalStem(strand1, strand2, newStem, stemBaseName + stemCounter++));
                }
                openFlag = false;
            }
        }
        if (openFlag) {
            if (newStem.size() >= minStemLength) {
                result.add(StemTools.generateNaturalStem(strand1, strand2, newStem, stemBaseName + stemCounter++));
            }
            openFlag = false;
        }
        block2: for (int nxs = 1; nxs < mtx.length; ++nxs) {
            for (int ny = mtx.length - 1; ny >= 0; --ny) {
                int nx = nxs + (mtx.length - ny - 1);
                if (nx >= ny) {
                    if (!openFlag) continue block2;
                    if (newStem.size() >= minStemLength) {
                        result.add(StemTools.generateNaturalStem(strand1, strand2, newStem, stemBaseName + stemCounter++));
                    }
                    openFlag = false;
                    continue block2;
                }
                if (mtx[nx][ny] >= thresh) {
                    if (!openFlag) {
                        newStem = new SimpleStem(strand1, strand2);
                        openFlag = true;
                    }
                    residue1 = strand1.getResidue(nx);
                    residue2 = strand2.getResidue(ny);
                    interaction = new SimpleInteraction(residue1, residue2, watsonCrick);
                    newStem.add(interaction);
                    continue;
                }
                if (!openFlag) continue;
                if (newStem.size() >= minStemLength) {
                    result.add(StemTools.generateNaturalStem(strand1, strand2, newStem, stemBaseName + stemCounter++));
                }
                openFlag = false;
            }
        }
        StemTools.removeConflictingStems(result);
        log.fine("Ending generateStemsFromSymmetricMatrix: " + result.size());
        return result;
    }

    public static Object3DSet generateStemsFromUnsymmetricMatrix(double[][] mtx, int minStemLength, double thresh, NucleotideStrand strand1, NucleotideStrand strand2, String stemBaseName) {
        int j;
        int i;
        log.fine("Starting generateStemsFromUnsymmetricMatrix");
        if (debugMode) {
            DoubleArrayTools.writeMatrix(System.out, mtx);
        }
        SimpleObject3DSet result = new SimpleObject3DSet();
        RnaInteractionType watsonCrick = new RnaInteractionType(1);
        boolean openFlag = false;
        int stemCounter = 1;
        int numRows = mtx.length;
        int numCols = mtx[0].length;
        NucleotideStrand sequence1 = strand1;
        NucleotideStrand sequence2 = strand2;
        SimpleStem newStem = new SimpleStem(sequence1, sequence2);
        int[][] visitedMtx = new int[mtx.length][mtx[0].length];
        int bondCount = 0;
        for (i = 0; i < numRows; ++i) {
            for (j = 0; j < numCols; ++j) {
                if (!(mtx[i][j] >= thresh)) continue;
                ++bondCount;
            }
        }
        log.fine("Number of interactions between strands: " + bondCount + " " + strand1.getName() + " " + strand2.getName());
        for (i = 0; i < numRows; ++i) {
            for (j = 0; j < numCols; ++j) {
                if (visitedMtx[i][j] == 1) continue;
                if (mtx[i][j] >= thresh) {
                    newStem = new SimpleStem(sequence1, sequence2);
                    for (int k = 0; i + k < numRows && j >= k && mtx[i + k][j - k] >= thresh && visitedMtx[i + k][j - k] <= 0; ++k) {
                        visitedMtx[i + k][j - k] = 1;
                        Residue residue1 = strand1.getResidue(i + k);
                        Residue residue2 = strand2.getResidue(j - k);
                        SimpleInteraction interaction = new SimpleInteraction(residue1, residue2, watsonCrick);
                        newStem.add(interaction);
                    }
                    if (newStem.size() < minStemLength) continue;
                    RnaStem3D naturalStem = StemTools.generateNaturalStem(strand1, strand2, newStem, stemBaseName + stemCounter++);
                    assert (naturalStem != null);
                    log.fine("Generated new stem: " + naturalStem);
                    result.add(naturalStem);
                    continue;
                }
                visitedMtx[i][j] = 1;
            }
        }
        log.fine("generateStemsFromUnsymmetricMatrix before removeConflictingStems: " + result.size());
        StemTools.removeConflictingStems(result);
        log.fine("Ending generateStemsFromUnsymmetricMatrix: " + result.size());
        return result;
    }

    private static double[][] generateContactMatrix(BioPolymer strand1, BioPolymer strand2, boolean atomMode) {
        double[][] mtx = new double[strand1.getResidueCount()][strand2.getResidueCount()];
        boolean symmetric = false;
        int idx = -1;
        int idy = -1;
        for (int i = 0; i < strand1.getResidueCount(); ++i) {
            for (int j = 0; j < strand2.getResidueCount(); ++j) {
                if (StemTools.isContacting2(strand1, i, strand2, j, atomMode)) {
                    mtx[i][j] = 1.0;
                    idx = i;
                    idy = j;
                    continue;
                }
                mtx[i][j] = 0.0;
            }
        }
        return mtx;
    }

    static boolean isResiduesContacting(Residue3D residue1, Residue3D residue2, double cutoff) {
        double dist = residue1.distance(residue2);
        return dist <= cutoff;
    }

    static boolean isAtomsContacting(Residue3D residue1, Residue3D residue2, double cutoff) {
        for (int i = 0; i < residue1.getAtomCount(); ++i) {
            for (int j = 0; j < residue2.getAtomCount(); ++j) {
                double dist = residue1.getAtom(i).distance(residue2.getAtom(j));
                if (!(dist <= cutoff)) continue;
                return true;
            }
        }
        return false;
    }

    static double atomMinimumDistance(Residue3D residue1, Residue3D residue2) {
        double minDist = residue1.distance(residue2);
        for (int i = 0; i < residue1.getAtomCount(); ++i) {
            for (int j = 0; j < residue2.getAtomCount(); ++j) {
                double dist = residue1.getAtom(i).distance(residue2.getAtom(j));
                if (!(dist <= minDist)) continue;
                minDist = dist;
            }
        }
        return minDist;
    }

    static Vector3D getBackboneVector(BioPolymer strand, int pos) {
        int pnext = pos + 1;
        int pbefore = pos - 1;
        if (pbefore < 0) {
            pbefore = 0;
        }
        if (pnext >= strand.getResidueCount()) {
            pnext = strand.getResidueCount() - 1;
        }
        if (pnext <= pbefore) {
            throw new ApplicationBugException("Internal error in line 338!");
        }
        int pos1Id = strand.getResidue3D(pbefore).getIndexOfChild("P");
        int pos2Id = strand.getResidue3D(pnext).getIndexOfChild("P");
        if (pos1Id >= 0 && pos2Id >= 0) {
            Vector3D pos1 = strand.getResidue3D(pbefore).getChild(pos1Id).getPosition();
            Vector3D pos2 = strand.getResidue3D(pnext).getChild(pos2Id).getPosition();
            return pos2.minus(pos1);
        }
        return new Vector3D();
    }

    static Vector3D getBaseVector(Residue3D residue) {
        int atom1Id = residue.getIndexOfChild("P");
        int atom2Id = residue.getIndexOfChild("C1*");
        if (atom1Id >= 0 && atom2Id >= 0) {
            return residue.getChild(atom1Id).getPosition().minus(residue.getChild(atom2Id).getPosition());
        }
        return new Vector3D();
    }

    static boolean isContactingBackbone(BioPolymer strand1, int pos1, BioPolymer strand2, int pos2) {
        double angle;
        Vector3D v1 = StemTools.getBackboneVector(strand1, pos1);
        Vector3D v2 = StemTools.getBackboneVector(strand2, pos2);
        return v1.lengthSquare() > 0.0 && v2.lengthSquare() > 0.0 && (angle = v1.angle(v2)) >= backboneAngleMin && angle <= backboneAngleMax;
    }

    static boolean isContactingBase(BioPolymer strand1, int pos1, BioPolymer strand2, int pos2) {
        double angle;
        Vector3D v1 = StemTools.getBaseVector(strand1.getResidue3D(pos1));
        Vector3D v2 = StemTools.getBaseVector(strand2.getResidue3D(pos2));
        return v1.lengthSquare() > 0.0 && v2.lengthSquare() > 0.0 && (angle = v1.angle(v2)) >= baseAngleMin && angle < baseAngleMax;
    }

    static boolean isContacting(BioPolymer strand1, int pos1, BioPolymer strand2, int pos2, boolean atomMode) {
        boolean backboneContact;
        Residue3D residue1 = strand1.getResidue3D(pos1);
        Residue3D residue2 = strand2.getResidue3D(pos2);
        double residueDist = residue1.distance(residue2);
        if (!DnaTools.isComplementary(residue1.getSymbol().getCharacter(), residue2.getSymbol().getCharacter())) {
            return false;
        }
        if (residueDist > WATSON_CRICK_RESIDUE_CUTOFF) {
            return false;
        }
        if (strand1.getResidueCount() > 2 && strand2.getResidueCount() > 2 && !(backboneContact = StemTools.isContactingBackbone(strand1, pos1, strand2, pos2))) {
            return false;
        }
        if (atomMode) {
            backboneContact = StemTools.isContactingBackbone(strand1, pos1, strand2, pos2);
            double atomDist = StemTools.atomMinimumDistance(residue1, residue2);
            if (atomDist < WATSON_CRICK_ATOM_CUTOFF) {
                if (strand1 instanceof NucleotideStrand && strand2 instanceof NucleotideStrand && !StemTools.isContactingBase(strand1, pos1, strand2, pos2)) {
                    return false;
                }
                for (int i = pos1 - 1; i <= pos1 + 1; ++i) {
                    if (i == pos1 || i < 0 || i >= strand1.getResidueCount()) continue;
                    for (int j = pos2 - 1; j <= pos2 + 1; ++j) {
                        double newDist;
                        if (j == pos2 || j < 0 || j >= strand2.getResidueCount() || !((newDist = StemTools.atomMinimumDistance(strand1.getResidue3D(i), strand2.getResidue3D(j))) < atomDist)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return StemTools.isResiduesContacting(residue1, residue2, WATSON_CRICK_RESIDUE_CUTOFF);
    }

    static double residueDistance(Residue3D res1, Residue3D res2, String atomName) {
        int id1 = res1.getIndexOfChild(atomName);
        int id2 = res2.getIndexOfChild(atomName);
        if (id1 >= 0 && id2 >= 0) {
            return res1.getChild(id1).distance(res2.getChild(id2));
        }
        return res1.distance(res2);
    }

    static boolean isContacting2(BioPolymer strand1, int pos1, BioPolymer strand2, int pos2, boolean atomMode) {
        Residue3D residue2;
        if (pos1 == 0 || pos2 == 0 || pos1 + 1 == strand1.getResidueCount() || pos2 + 1 == strand2.getResidueCount() || strand1.getResidueCount() <= 2 || strand2.getResidueCount() <= 2) {
            return StemTools.isContacting(strand1, pos1, strand2, pos2, atomMode);
        }
        Residue3D residue1 = strand1.getResidue3D(pos1);
        double residueDist = StemTools.residueDistance(residue1, residue2 = strand2.getResidue3D(pos2), "C4*");
        if (residueDist > WATSON_CRICK_RESIDUE_CUTOFF) {
            return false;
        }
        if (!DnaTools.isComplementary(residue1.getSymbol().getCharacter(), residue2.getSymbol().getCharacter())) {
            return false;
        }
        for (int offset = -2; offset <= 0; ++offset) {
            int startPos = pos1 + offset;
            int endPos = pos2 - offset;
            if (startPos < 0 || startPos + 3 >= strand1.getResidueCount() || endPos >= strand2.getResidueCount() || endPos - 3 < 0) continue;
            Vector3D[] helix = StemTools.generateHelixPatch((NucleotideStrand)strand1, pos1, (NucleotideStrand)strand2, pos2, offset, atomMode);
            if (helix.length != idealHelix.length) {
                throw new ApplicationBugException("Internal error in line 530!");
            }
            double drms = Vector3DTools.computeDrms(helix, idealHelix);
            if (!(drms < drmsCutoff)) continue;
            return true;
        }
        return false;
    }

    private static double[][] generateContactMatrix(BioPolymer strand1, boolean atomMode) {
        double[][] mtx = new double[strand1.getResidueCount()][strand1.getResidueCount()];
        for (int i = 0; i < strand1.getResidueCount(); ++i) {
            for (int j = i + 4; j < strand1.getResidueCount(); ++j) {
                mtx[i][j] = StemTools.isContacting2(strand1, i, strand1, j, atomMode) ? 1.0 : 0.0;
                mtx[j][i] = mtx[i][j];
            }
        }
        return mtx;
    }

    private static void writeSparseMatrix(double[][] mtx) {
        for (int i = 0; i < mtx.length; ++i) {
            for (int j = 0; j < mtx[i].length; ++j) {
                if (!(mtx[i][j] > 0.0)) continue;
                System.out.println("" + (i + 1) + " " + (j + 1) + " " + mtx[i][j]);
            }
        }
    }

    public static Object3DSet generateStems(NucleotideStrand strand1, NucleotideStrand strand2, String stemBaseName) {
        SimpleObject3DSet stemSet = new SimpleObject3DSet();
        double[][] mtx = StemTools.generateContactMatrix(strand1, strand2, atomMode);
        return StemTools.generateStemsFromUnsymmetricMatrix(mtx, STEM_LENGTH_MINIMUM, 0.5, strand1, strand2, stemBaseName);
    }

    public static Object3DSet generateStems(NucleotideStrand strand1, String stemBaseName) {
        SimpleObject3DSet stemSet = new SimpleObject3DSet();
        double[][] mtx = StemTools.generateContactMatrix(strand1, atomMode);
        StemTools.writeSparseMatrix(mtx);
        return StemTools.generateStemsFromSymmetricMatrix(mtx, STEM_LENGTH_MINIMUM, 0.5, strand1, stemBaseName);
    }

    public static void removeConflictingStems(Object3DSet stemSet) {
    }

    public static Object3DLinkSetBundle generateStems(Object3D root) {
        int i;
        SimpleObject3D resultRoot = new SimpleObject3D();
        SimpleObject3DSet resultSet = new SimpleObject3DSet();
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        resultRoot.setName("stems");
        Object3DSet strandSet = Object3DTools.collectByClassName(root, "RnaStrand");
        strandSet.merge(Object3DTools.collectByClassName(root, "DnaStrand"));
        for (i = 0; i < strandSet.size(); ++i) {
            NucleotideStrand strand1 = (NucleotideStrand)strandSet.get(i);
            for (int j = i; j < strandSet.size(); ++j) {
                NucleotideStrand strand2 = (NucleotideStrand)strandSet.get(j);
                String stemBaseName = "H" + (i + 1) + "_" + (j + 1);
                Object3DSet stemSet = i == j ? StemTools.generateStems(strand1, stemBaseName) : StemTools.generateStems(strand1, strand2, stemBaseName);
                resultSet.merge(stemSet);
            }
        }
        for (i = 0; i < resultSet.size(); ++i) {
            resultRoot.insertChild(resultSet.get(i));
        }
        SimpleObject3DLinkSetBundle result = new SimpleObject3DLinkSetBundle(resultRoot, resultLinks);
        return result;
    }

    private static double[][] generateMatrixFromLinks(NucleotideStrand strand, LinkSet links) {
        if (debugMode) assert (links.size() > 0);
        int numResidues = strand.getResidueCount();
        assert (numResidues > 0);
        double[][] matrix = new double[numResidues][numResidues];
        assert (matrix.length == numResidues);
        assert (matrix[0].length == numResidues);
        for (int i = 0; i < links.size(); ++i) {
            Interaction interaction;
            InteractionType interactionType;
            Link link = links.get(i);
            if (!(link instanceof InteractionLink) || !((interactionType = (interaction = ((InteractionLink)link).getInteraction()).getInteractionType()) instanceof RnaInteractionType) || interactionType.getSubTypeId() == 6) continue;
            Object3D obj1 = link.getObj1();
            Object3D obj2 = link.getObj2();
            if (!(obj1 instanceof Residue3D) || obj1.getParent() != strand || !(obj2 instanceof Residue3D) || obj2.getParent() != strand) continue;
            int p1 = ((Residue3D)obj1).getPos();
            int p2 = ((Residue3D)obj2).getPos();
            matrix[p1][p2] = 1.0;
            matrix[p2][p1] = 1.0;
        }
        return matrix;
    }

    private static double[][] generateMatrixFromLinks(NucleotideStrand strand1, NucleotideStrand strand2, LinkSet links) {
        int numResidues1 = strand1.getResidueCount();
        int numResidues2 = strand2.getResidueCount();
        double[][] matrix = new double[numResidues1][numResidues2];
        int count = 0;
        for (int i = 0; i < links.size(); ++i) {
            Interaction interaction;
            InteractionType interactionType;
            Link link = links.get(i);
            if (!(link instanceof InteractionLink) || !((interactionType = (interaction = ((InteractionLink)link).getInteraction()).getInteractionType()) instanceof RnaInteractionType) || interactionType.getSubTypeId() == 6) continue;
            Object3D obj1 = link.getObj1();
            Object3D obj2 = link.getObj2();
            if (!(obj1 instanceof Residue3D) || !(obj2 instanceof Residue3D)) continue;
            int p1 = ((Residue3D)obj1).getPos();
            int p2 = ((Residue3D)obj2).getPos();
            if (obj1.getParent() == strand1 && obj2.getParent() == strand2) {
                matrix[p1][p2] = 1.0;
                ++count;
                continue;
            }
            if (obj1.getParent() != strand2 || obj2.getParent() != strand1) continue;
            matrix[p2][p1] = 1.0;
            ++count;
        }
        log.fine("Generating " + count + " contacts in matrix between strands " + strand1.getFullName() + " and " + strand2.getFullName());
        return matrix;
    }

    public static Object3DLinkSetBundle generateStemsFromLinks(Object3D root, LinkSet links, int minStemLength) {
        int i;
        log.fine("Starting generateStemsFromLinks!");
        double thresh = 0.5;
        SimpleObject3D resultRoot = new SimpleObject3D();
        SimpleObject3DSet resultSet = new SimpleObject3DSet();
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        resultRoot.setName("stems");
        Object3DSet strandSet = Object3DTools.collectByClassName(root, "RnaStrand");
        strandSet.merge(Object3DTools.collectByClassName(root, "DnaStrand"));
        log.fine("Detected " + strandSet.size() + " strands.");
        for (i = 0; i < strandSet.size(); ++i) {
            NucleotideStrand strand1 = (NucleotideStrand)strandSet.get(i);
            assert (strand1.size() > 0);
            String stemBaseName = "stem" + strand1.getName() + "_";
            double[][] matrix = StemTools.generateMatrixFromLinks(strand1, links);
            Object3DSet newStemSet = StemTools.generateStemsFromSymmetricMatrix(matrix, minStemLength, 0.5, strand1, stemBaseName);
            resultSet.merge(newStemSet);
            newStemSet.clear();
            for (int j = i + 1; j < strandSet.size(); ++j) {
                NucleotideStrand strand2 = (NucleotideStrand)strandSet.get(j);
                stemBaseName = "stem" + strand1.getName() + "_" + strand2.getName() + "_";
                matrix = StemTools.generateMatrixFromLinks(strand1, strand2, links);
                assert (matrix.length == strand1.getResidueCount());
                assert (matrix[0].length == strand2.getResidueCount());
                newStemSet = StemTools.generateStemsFromUnsymmetricMatrix(matrix, minStemLength, 0.5, strand1, strand2, stemBaseName);
                if (newStemSet.size() > 0) {
                    log.fine("Found " + newStemSet.size() + " + stems between strands " + strand1.getFullName() + " and " + strand2.getFullName());
                }
                resultSet.merge(newStemSet);
                newStemSet.clear();
            }
        }
        for (i = 0; i < resultSet.size(); ++i) {
            resultRoot.insertChild(resultSet.get(i));
        }
        log.fine("Finished generateStemsFromLinks: " + resultRoot.size());
        return new SimpleObject3DLinkSetBundle(resultRoot, resultLinks);
    }

    public static boolean isPartOfStem(Nucleotide3D residue, Stem stem) {
        Sequence seq1 = stem.getSequence1();
        int pos = residue.getPos();
        if (residue.isSameSequence(seq1.getResidue(0)) && pos >= stem.getStartPos() && pos < stem.getStartPos() + stem.size()) {
            return true;
        }
        Sequence seq2 = stem.getSequence2();
        return residue.isSameSequence(seq2.getResidue(0)) && pos <= stem.getStopPos() && pos > stem.getStopPos() - stem.size();
    }

    public static boolean isPartOfStem(Nucleotide3D residue, RnaStem3D stem3D) {
        return StemTools.isPartOfStem(residue, stem3D.getStemInfo());
    }

    public static boolean isPartOfStem(Nucleotide3D residue, Object3DSet stemSet) {
        for (int i = 0; i < stemSet.size(); ++i) {
            boolean result;
            Object3D child = stemSet.get(i);
            if (!(child instanceof RnaStem3D) || !(result = StemTools.isPartOfStem(residue, (RnaStem3D)child))) continue;
            return true;
        }
        return false;
    }

    public static Object3DSet collectStems3D(Object3D root) {
        SimpleObject3DSet stemSet = new SimpleObject3DSet();
        for (int i = 0; i < root.size(); ++i) {
            Object3D child = root.getChild(i);
            if (!(child instanceof RnaStem3D)) continue;
            stemSet.add(child);
        }
        return stemSet;
    }

    public static boolean isPartOfStem(Nucleotide3D residue, Object3D root) {
        Object3DSet stemSet = StemTools.collectStems3D(root);
        return StemTools.isPartOfStem(residue, stemSet);
    }
}

