/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ScoreWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.AI3DTools;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SingleStrandBridgeFinder;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;

public class StrandFuser
implements Runnable {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    public static final int STRAND_FUSION_MAX = 20;
    private static final double STRAND_ANGLE_MAX = 2.356194490192345;
    private static final double ANGLE_PENALTY = 50.0;
    private static final double STRAND_CONNECTION_SCORE_CUTOFF = 50.0;
    private static final String TMP_TOKEN = "__RINGFUSE_STATUS";
    private static final String TMP_TOKEN_OCCUPIED = "occupied";
    private double scoreCutoff = 50.0;
    private static boolean debugMode = true;
    private List<RnaStrand> strands = new ArrayList<RnaStrand>();
    private List<RnaStrand> fusedStrands;
    private SingleStrandBridgeFinder singleStrandBridger;

    public StrandFuser(List<RnaStrand> strands, SingleStrandBridgeFinder singleStrandBridger) {
        this.singleStrandBridger = singleStrandBridger;
        this.strands.addAll(strands);
        this.strands = this.cleanStrands(this.strands);
        this.log.info("Initial strands: " + strands.size() + " cleaned version: " + this.strands.size());
    }

    public StrandFuser(Object3DSet strandSet, SingleStrandBridgeFinder singleStrandBridger) {
        this.singleStrandBridger = singleStrandBridger;
        for (int i = 0; i < strandSet.size(); ++i) {
            Object3D obj = strandSet.get(i);
            if (obj instanceof RnaStrand) {
                this.strands.add((RnaStrand)obj);
                continue;
            }
            this.log.severe("Internal error in RingFuse: 3D object is not RNA strand: " + obj.getFullName() + " " + obj.getClassName());
            assert (false);
        }
        this.strands = this.cleanStrands(this.strands);
        this.log.info("Initial strands: " + strandSet.size() + " cleaned version: " + this.strands.size());
    }

    private boolean isDuplicateStrand(RnaStrand strand, List<RnaStrand> strands) {
        for (RnaStrand strand2 : strands) {
            if (strand2 == strand || !AI3DTools.checkStrandDuplicate(strand, strand2, 2.0, "C4*")) continue;
            this.log.info("Strand duplicate found: " + strand.getFullName() + " " + strand.sequenceString() + strand2.getFullName() + " " + strand2.sequenceString());
            return true;
        }
        return false;
    }

    private List<RnaStrand> cleanStrands(List<RnaStrand> strands) {
        return strands;
    }

    @Override
    public void run() {
        this.log.info("Starting automatic strand fusing for " + this.strands.size() + " strands !");
        this.fusedStrands = new ArrayList<RnaStrand>();
        int[] strandUsed = new int[this.strands.size()];
        for (int j = 0; j < this.strands.size(); ++j) {
            NucleotideStrand strand = this.strands.get(j);
            if (!this.checkStrandAvailable(strand)) continue;
            int strandId = this.strands.indexOf(strand);
            assert (strandId >= 0);
            List<Integer> fusionIds = this.generateFusionStrandIds(this.strands, strandId, this.scoreCutoff);
            if (fusionIds.size() > 1) {
                this.fusedStrands.add(this.applyStrandFusion(fusionIds));
                continue;
            }
            this.log.info("No strand available for fusing with strand " + (j + 1) + " : " + strand.getFullName());
        }
        this.log.info("Finished automatic strand fusing! Number of strands in result: " + this.fusedStrands.size());
    }

    private RnaStrand applyStrandFusion(List<Integer> strandIds) {
        this.log.info("Starting applyStrandFusion with " + strandIds.size() + " strands!");
        assert (strandIds.size() < 20);
        assert (strandIds != null && strandIds.size() > 0);
        assert (strandIds.size() == 1 || !strandIds.get(0).equals(strandIds.get(1)));
        RnaStrand newStrand = this.strands.get(strandIds.get(0));
        String outs = "";
        StringBuffer buf = new StringBuffer();
        for (Integer ii : strandIds) {
            System.out.println("Id: " + (ii + 1) + " size: " + buf.length());
            buf.append("" + (ii + 1) + " ");
        }
        outs = buf.toString();
        this.log.info("Applying strand fusing to sequence path with " + this.strands.get(strandIds.get(0)).getFullName() + " strand ids: " + outs);
        this.setStrandOccupied(this.strands.get(strandIds.get(0)));
        assert (!this.checkStrandAvailable(this.strands.get(strandIds.get(0))));
        int count = this.strands.get(strandIds.get(0)).getResidueCount();
        for (int i = 1; i < strandIds.size(); ++i) {
            RnaStrand tmpStrand = this.strands.get(strandIds.get(i));
            assert (tmpStrand != this.strands.get(strandIds.get(i - 1)));
            this.setStrandOccupied(tmpStrand);
            assert (!this.checkStrandAvailable(tmpStrand));
            count += this.strands.get(strandIds.get(i)).getResidueCount();
            this.log.info("Fusing strand " + newStrand.getFullName() + " " + newStrand.sequenceString() + " with " + tmpStrand.getFullName() + " " + tmpStrand.sequenceString() + " strand id: " + (strandIds.get(i) + 1));
            List<Object3DLinkSetBundle> fragments = null;
            if (this.singleStrandBridger.getRms() > 0.0 && this.singleStrandBridger.getLenMax() > 0) {
                fragments = this.singleStrandBridger.findBridge(newStrand.getResidue3D(newStrand.getResidueCount() - 1), tmpStrand.getResidue3D(0));
                if (fragments != null && fragments.size() > 0) {
                    RnaStrand loop = (RnaStrand)fragments.get(0).getObject3D();
                    this.log.info("Found fragment between strands " + newStrand.getFullName() + " and " + tmpStrand.getFullName() + loop.getFullName() + " " + loop.getResidueCount());
                    newStrand.append(loop);
                    count += loop.getResidueCount();
                } else {
                    this.log.info("No fragment found between strands " + newStrand.getFullName() + " and " + tmpStrand.getFullName());
                }
            }
            newStrand.appendAndDelete(tmpStrand);
        }
        assert (newStrand.getResidueCount() == count);
        return newStrand;
    }

    private boolean checkStrandAvailable(NucleotideStrand strand) {
        return strand.getProperty(TMP_TOKEN) != TMP_TOKEN_OCCUPIED;
    }

    public void setScoreCutoff(double value) {
        this.scoreCutoff = value;
    }

    private void setStrandOccupied(NucleotideStrand strand) {
        strand.setProperty(TMP_TOKEN, TMP_TOKEN_OCCUPIED);
    }

    private double scoreStrandConnectivity(RnaStrand startStrand, RnaStrand endStrand) throws RnaModelException {
        Vector3D v2;
        Nucleotide3D startStrandResidue = (Nucleotide3D)startStrand.getResidue3D(startStrand.getResidueCount() - 1);
        Nucleotide3D endStrandResidue = (Nucleotide3D)endStrand.getResidue3D(0);
        Object3D ao21 = startStrandResidue.getChild("O2*");
        Object3D ap2 = endStrandResidue.getChild("P");
        if (ap2 == null) {
            NucleotideDBTools.addMissingPhosphor(endStrandResidue);
            ap2 = endStrandResidue.getChild("P");
            assert (ap2 != null);
        }
        if (ao21 == null) {
            throw new RnaModelException("Could not find atom O2* in residue: " + startStrandResidue.getFullName());
        }
        double distance = ao21.distance(ap2);
        Vector3D v1 = NucleotideDBTools.getBackwardDirectionVector(startStrandResidue, "C4*");
        double angle = Math.PI - v1.angle(v2 = NucleotideDBTools.getForwardDirectionVector(endStrandResidue, "C4*"));
        if (angle > 2.356194490192345) {
            distance += 50.0;
        }
        if (!this.singleStrandBridger.validate(startStrandResidue, endStrandResidue)) {
            distance += this.scoreCutoff + 1.0;
        }
        return distance;
    }

    int findNextStrandId(List<RnaStrand> strands, List<Integer> sofarStrandIds, double scoreCutoff) {
        assert (sofarStrandIds.size() > 0);
        int id = sofarStrandIds.get(sofarStrandIds.size() - 1);
        ArrayList<ScoreWrapper> rankedList = new ArrayList<ScoreWrapper>();
        for (int i = 0; i < strands.size(); ++i) {
            if (i == id || sofarStrandIds.contains(i) || !this.checkStrandAvailable(strands.get(i))) continue;
            try {
                double score = this.scoreStrandConnectivity(strands.get(id), strands.get(i));
                this.log.info("Working on connectivity for strand " + (i + 1) + " : " + score);
                if (!(score < scoreCutoff)) continue;
                ScoreWrapper wrap = new ScoreWrapper(new Integer(i), score);
                rankedList.add(wrap);
                continue;
            }
            catch (RnaModelException e) {
                this.log.warning("Bad nucleotide for strand fusing encountered: " + e.getMessage());
            }
        }
        if (rankedList.size() == 0) {
            return -1;
        }
        try {
            Collections.sort(rankedList);
        }
        catch (ClassCastException ce) {
            this.log.warning("Internal error: " + ce.getMessage());
            System.exit(-1);
        }
        catch (UnsupportedOperationException uoe) {
            this.log.warning("Internal error: " + uoe.getMessage());
            System.exit(-1);
        }
        Integer strandIndexInt = (Integer)((ScoreWrapper)rankedList.get(0)).getObject();
        int result = strandIndexInt;
        assert (this.checkStrandAvailable(strands.get(result)));
        assert (((ScoreWrapper)rankedList.get(0)).getScore() <= 50.0);
        assert (!sofarStrandIds.contains(strandIndexInt));
        return result;
    }

    private List<Integer> generateFusionStrandIds(List<RnaStrand> strands, int currentId, double scoreCutoff) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(currentId);
        while ((currentId = this.findNextStrandId(strands, result, scoreCutoff)) >= 0) {
            assert (!result.contains(currentId));
            assert (result.size() < 100);
            result.add(currentId);
        }
        return result;
    }

    public List<RnaStrand> getFusedStrands() {
        if (this.fusedStrands == null) {
            this.run();
        }
        return this.fusedStrands;
    }
}

