/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.awt.geom.NoninvertibleTransformException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.InteractionLinkImp;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.StrandJunction3D;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteraction;
import tools3d.CoordinateSystem;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.numerics3d.Geom3DTools;
import tools3d.numerics3d.Line;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class StrandJunctionTools {
    public static final int PDB_STRAND_OFFSET = 2;
    public static final double RAD2DEG = 57.29577951308232;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public Matrix4D computeTransformation(StrandJunction3D junction, int branchId1, int branchId2) {
        assert (false);
        return null;
    }

    public static Object3DSet generateStrandJunctions(Object3D root) {
        SimpleObject3DSet result = new SimpleObject3DSet();
        assert (false);
        return result;
    }

    static LinkSet generateJunctionBranchLinks(StrandJunction3D junction, int branchId) {
        SimpleLinkSet result = new SimpleLinkSet();
        BranchDescriptor3D bd = junction.getBranch(branchId);
        NucleotideStrand inStrand = bd.getIncomingStrand();
        NucleotideStrand outStrand = bd.getOutgoingStrand();
        RnaInteractionType interactionType = new RnaInteractionType(1);
        for (int i = 0; i <= bd.getOffset(); ++i) {
            int inId = bd.getIncomingIndex() + i;
            int outId = bd.getOutgoingIndex() - i;
            assert (inId < inStrand.getResidueCount());
            Residue3D inRes = inStrand.getResidue3D(inId);
            assert (outId < outStrand.getResidueCount());
            Residue3D outRes = outStrand.getResidue3D(outId);
            SimpleInteraction interaction = new SimpleInteraction(inRes, outRes, interactionType);
            InteractionLinkImp link = new InteractionLinkImp(inRes, outRes, interaction);
            result.add(link);
        }
        return result;
    }

    static LinkSet generateJunctionLinks(StrandJunction3D junction) {
        SimpleLinkSet result = new SimpleLinkSet();
        if (junction == null) {
            return result;
        }
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            result.merge(StrandJunctionTools.generateJunctionBranchLinks(junction, i));
        }
        return result;
    }

    public static void setHelixEndUsed(Object3D object, String helixendName) {
        assert (StrandJunctionTools.isHelixEndFree(object, helixendName));
        String usedHelixends = object.getProperty("used_helixends");
        if (usedHelixends == null || usedHelixends.length() == 0) {
            object.setProperty("used_helixends", helixendName);
        } else {
            object.setProperty("used_helixends", usedHelixends + ";" + helixendName);
        }
    }

    public static void setHelixendUsed(StrandJunction3D junction, int id) {
        StrandJunctionTools.setHelixEndUsed(junction, "(hxend)" + (id + 1));
    }

    public static boolean isHelixEndFree(Object3D object, String helixendName) {
        assert (helixendName != null);
        String usedHelixends = object.getProperty("used_helixends");
        if (usedHelixends == null || usedHelixends.length() == 0) {
            return true;
        }
        String[] words = usedHelixends.split(";");
        for (int i = 0; i < words.length; ++i) {
            if (!helixendName.equals(words[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isHelixEndFree(StrandJunction3D junction, int id) {
        return StrandJunctionTools.isHelixEndFree((Object3D)junction, "(hxend)" + (id + 1));
    }

    public static boolean hasFreeHelixEnds(Object3D obj) {
        if (!(obj instanceof StrandJunction3D)) {
            return false;
        }
        StrandJunction3D junction = (StrandJunction3D)obj;
        String usedHelixends = junction.getProperty("used_helixends");
        if (usedHelixends == null || usedHelixends.length() == 0) {
            return true;
        }
        String[] words = usedHelixends.split(";");
        return words.length < junction.getBranchCount();
    }

    private static Object3DSet generateFreeHelixGraphEnds(StrandJunction3D junction, double distance, Object3D cloneObject) {
        SimpleObject3DSet resultSet = new SimpleObject3DSet();
        Vector3D origPos = junction.getPosition();
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            if (!StrandJunctionTools.isHelixEndFree(junction, i)) continue;
            Vector3D direction = junction.getBranch(i).getDirection();
            Vector3D offset = direction.mul(distance);
            Object3D newObj = (Object3D)cloneObject.cloneDeep();
            newObj.setName(junction.getName() + "_hxextension" + (i + 1));
            newObj.setPosition(origPos.plus(offset));
            resultSet.add(newObj);
        }
        return resultSet;
    }

    public static Object3DLinkSetBundle extractJunctionGraph(Object3D root, LinkSet links, String nameBase, Object3DSet tabooSet) {
        int i;
        Object3DSet junctionSet = Object3DTools.collectByClassName(root, "StrandJunction3D");
        for (int i2 = junctionSet.size() - 1; i2 >= 0; --i2) {
            assert (junctionSet.get(i2) != null);
            if (!tabooSet.contains(junctionSet.get(i2))) continue;
            junctionSet.remove(junctionSet.get(i2));
        }
        Object3DSet kissingSet = Object3DTools.collectByClassName(root, "KissingLoop3D");
        for (int i3 = kissingSet.size() - 1; i3 >= 0; --i3) {
            if (!tabooSet.contains(kissingSet.get(i3))) continue;
            kissingSet.remove(kissingSet.get(i3));
        }
        junctionSet.merge(kissingSet);
        if (junctionSet.size() < 1) {
            return new SimpleObject3DLinkSetBundle();
        }
        SimpleObject3DSet allFreeEnds = new SimpleObject3DSet();
        SimpleObject3D resultObj = new SimpleObject3D(Object3DSetTools.centerOfMass(junctionSet));
        SimpleLinkSet resultLinks = new SimpleLinkSet();
        resultObj.setName(nameBase);
        String nameBase2 = "p";
        double freeEndDistance = 20.0;
        int pc = 0;
        for (i = 0; i < junctionSet.size(); ++i) {
            StrandJunction3D junction = (StrandJunction3D)junctionSet.get(i);
            SimpleObject3D obj = new SimpleObject3D(junction.getPosition());
            obj.setName(nameBase2 + ++pc);
            if (junctionSet.get(i).getClassName().equals("StrandJunction3D")) {
                obj.setProperty("graph_color", "j");
            } else if (junctionSet.get(i).getClassName().equals("KissingLoop3D")) {
                obj.setProperty("graph_color", "k");
                obj.setProperty("atom_element", "S");
            }
            resultObj.insertChild(obj);
            Object3DSet freeHelixGraphEnds = StrandJunctionTools.generateFreeHelixGraphEnds(junction, freeEndDistance, obj);
            for (int j = 0; j < freeHelixGraphEnds.size(); ++j) {
                resultLinks.add(new SimpleLink(obj, freeHelixGraphEnds.get(j)));
            }
            allFreeEnds.merge(freeHelixGraphEnds);
        }
        for (i = 0; i < allFreeEnds.size(); ++i) {
            Object3D newObj = allFreeEnds.get(i);
            newObj.setName(nameBase2 + ++pc);
            resultObj.insertChild(newObj);
        }
        for (i = 0; i < junctionSet.size(); ++i) {
            for (int j = i + 1; j < junctionSet.size(); ++j) {
                int linkNumber = links.getLinkNumber(junctionSet.get(i), junctionSet.get(j));
                if (linkNumber <= 0) continue;
                resultLinks.add(new SimpleLink(resultObj.getChild(i), resultObj.getChild(j)));
            }
        }
        return new SimpleObject3DLinkSetBundle(resultObj, resultLinks);
    }

    public static Object3DLinkSetBundle extractJunctionGraph(Object3D root, LinkSet links, String nameBase) {
        SimpleObject3DSet tabooSet = new SimpleObject3DSet();
        return StrandJunctionTools.extractJunctionGraph(root, links, nameBase, tabooSet);
    }

    public static void fuseStrands(StrandJunction3D junction, double residueCutoffDist) {
        boolean isOk = false;
        block0: while (!isOk) {
            isOk = true;
            NucleotideStrand[] strands = junction.getStrands();
            assert (strands.length == junction.getStrandCount());
            log.fine("Strand count: " + strands.length + " " + junction.getStrandCount());
            for (int i = 0; i < strands.length; ++i) {
                for (int j = i + 1; j < strands.length; ++j) {
                    double dist1 = strands[i].getResidue3D(strands[i].getResidueCount() - 1).distance(strands[j].getResidue3D(0));
                    if (dist1 <= residueCutoffDist) {
                        log.fine("Trying to fuse strands: " + (i + 1) + " " + (j + 1));
                        junction.fuseStrands(i, j);
                        isOk = false;
                        break;
                    }
                    double dist2 = strands[j].getResidue3D(strands[j].getResidueCount() - 1).distance(strands[i].getResidue3D(0));
                    if (!(dist2 <= residueCutoffDist)) continue;
                    log.fine("Trying to fuse strands: " + (j + 1) + " " + (i + 1));
                    junction.fuseStrands(j, i);
                    isOk = false;
                    break;
                }
                if (!isOk) continue block0;
            }
        }
    }

    public static void placeStrands(StrandJunction3D junction, Object3D obj) {
        HashSet<NucleotideStrand> strandSet = new HashSet<NucleotideStrand>();
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            BranchDescriptor3D branch = junction.getBranch(i);
            strandSet.add(branch.getIncomingStrand());
            strandSet.add(branch.getOutgoingStrand());
        }
        for (NucleotideStrand strand : strandSet) {
            obj.insertChild(strand);
        }
    }

    private static String toPdb(BranchDescriptor3D branchDescriptor, int n, GeneralPdbWriter writer) {
        StringBuffer result = new StringBuffer();
        writer.incStrandChar();
        Atom3D dummyAtom = new Atom3D();
        String atomName = "p" + (n + 1);
        String residueName = "b" + (n + 1);
        dummyAtom.setName(atomName);
        dummyAtom.setPosition(branchDescriptor.getPosition());
        result.append(writer.writeHeteroAtom(dummyAtom, residueName, writer.getStrandChar(), 1) + PackageConstants.NEWLINE);
        dummyAtom.setPosition(branchDescriptor.getPosition().plus(branchDescriptor.getDirection().mul(3.0)));
        dummyAtom.setName("dir");
        result.append(writer.writeHeteroAtom(dummyAtom, residueName, writer.getStrandChar(), 1) + PackageConstants.NEWLINE);
        for (int i = 0; i < 4; ++i) {
            dummyAtom = new Atom3D();
            atomName = "o" + (i + 1);
            dummyAtom.setName(atomName);
            dummyAtom.setPosition(branchDescriptor.computeHelixPosition(i, 1));
            result.append(writer.writeHeteroAtom(dummyAtom, residueName, writer.getStrandChar(), 1) + PackageConstants.NEWLINE);
            dummyAtom = new Atom3D();
            atomName = "i" + (i + 1);
            dummyAtom.setName(atomName);
            dummyAtom.setPosition(branchDescriptor.computeHelixPosition(i, 2));
            result.append(writer.writeHeteroAtom(dummyAtom, residueName, writer.getStrandChar(), 1) + PackageConstants.NEWLINE);
        }
        result.append("TER" + PackageConstants.NEWLINE);
        return result.toString();
    }

    public static char getOriginalStrandChar(NucleotideStrand strand, char defaultChar) {
        Properties properties = strand.getProperties();
        if (properties != null) {
            String chainString = properties.getProperty("pdb_chain_char");
            if (chainString == null) {
                log.warning("Strand with name " + strand.getName() + " has no property pdb_chain_char");
            }
            if (chainString != null && chainString.length() == 1) {
                return chainString.charAt(0);
            }
        }
        return defaultChar;
    }

    public static String toPdb(StrandJunction3D junction, boolean originalMode) {
        int i;
        int strandChar = 65;
        GeneralPdbWriter writer = new GeneralPdbWriter();
        writer.setOriginalMode(1);
        log.info("starting StandJunctionTools.toPdb with size junction: " + junction.getBranchCount());
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < junction.getBranchCount(); ++i) {
            buf.append(StrandJunctionTools.toPdb(junction.getBranch(i), i, writer));
        }
        for (i = 0; i < junction.getStrandCount(); ++i) {
            NucleotideStrand strand = junction.getStrand(i);
            if (originalMode) {
                strandChar = strand.getName().charAt(0);
            }
            buf.append(writer.writeStrand(strand, StrandJunctionTools.getOriginalStrandChar(strand, (char)strandChar)));
            log.info("Writing strand: " + (char)strandChar);
            int strandCharId = strandChar;
            strandChar = (char)(++strandCharId);
        }
        log.info("finishing StandJunctionTools.toPdb with size junction: " + junction.getBranchCount());
        return buf.toString();
    }

    private static Line computeLine(BranchDescriptor3D branch) {
        Vector3D pos = branch.getPosition();
        Vector3D dir = branch.getDirection();
        return new Line(pos, dir);
    }

    private static Line computeLine(BranchDescriptor3D branch, CoordinateSystem activeTransformation) {
        Vector3D pos = activeTransformation.activeTransform3(branch.getPosition());
        Vector3D dir = activeTransformation.activeTransform3(branch.getDirection());
        return new Line(pos, dir);
    }

    private static Line computeLine(CoordinateSystem branch) {
        Vector3D pos = branch.getPosition();
        Vector3D dir = branch.getZ();
        return new Line(pos, dir);
    }

    public static Vector3D computeJunctionCenter(StrandJunction3D junction) throws NoninvertibleTransformException {
        Line[] lines = new Line[junction.getBranchCount()];
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            lines[i] = StrandJunctionTools.computeLine(junction.getBranch(i));
        }
        return Geom3DTools.computeLinesMedium(lines);
    }

    public static Vector3D computeJunctionCenter(List<BranchDescriptor3D> helixDescriptors) throws NoninvertibleTransformException {
        Line[] lines = new Line[helixDescriptors.size()];
        for (int i = 0; i < helixDescriptors.size(); ++i) {
            lines[i] = StrandJunctionTools.computeLine(helixDescriptors.get(i));
        }
        return Geom3DTools.computeLinesMedium(lines);
    }

    public static Vector3D computeJunctionCenter(List<BranchDescriptor3D> helixDescriptors, List<CoordinateSystem> activeTransformations) throws NoninvertibleTransformException {
        Line[] lines = new Line[helixDescriptors.size()];
        for (int i = 0; i < helixDescriptors.size(); ++i) {
            lines[i] = StrandJunctionTools.computeLine(helixDescriptors.get(i), activeTransformations.get(i));
        }
        return Geom3DTools.computeLinesMedium(lines);
    }

    public static Vector3D computeCSJunctionCenter(List<CoordinateSystem> helixDescriptors) throws NoninvertibleTransformException {
        Line[] lines = new Line[helixDescriptors.size()];
        for (int i = 0; i < helixDescriptors.size(); ++i) {
            lines[i] = StrandJunctionTools.computeLine(helixDescriptors.get(i));
        }
        return Geom3DTools.computeLinesMedium(lines);
    }

    public static Vector3D computeCS3DJunctionCenter(List<CoordinateSystem3D> helixDescriptors) throws NoninvertibleTransformException {
        Line[] lines = new Line[helixDescriptors.size()];
        for (int i = 0; i < helixDescriptors.size(); ++i) {
            lines[i] = StrandJunctionTools.computeLine(helixDescriptors.get(i));
        }
        return Geom3DTools.computeLinesMedium(lines);
    }

    private static boolean stericalCheck(StrandJunction3D junction, int n) {
        BranchDescriptor3D branch = junction.getBranch(n);
        assert (branch.isValid());
        Vector3D base = branch.getPosition();
        Vector3D dir = branch.getDirection();
        dir.normalize();
        for (int i = 0; i < junction.getStrandCount(); ++i) {
            NucleotideStrand strand = junction.getStrand(i);
            for (int j = 0; j < strand.getResidueCount(); ++j) {
                Residue3D residue = strand.getResidue3D(j);
                for (int k = 0; k < residue.size(); ++k) {
                    double dist;
                    Atom3D atom = residue.getAtom(k);
                    Vector3D v = atom.getPosition();
                    Vector3D vRel = v.minus(base);
                    double projection = dir.dot(vRel);
                    if (!(projection > 15.0) || !((dist = Math.abs(Geom3DTools.computeDistanceToLine(v, base, dir))) < 10.0)) continue;
                    log.fine("Problem in junction detected! " + projection + " " + dist + " " + junction.getName() + " branch: " + (n + 1) + " " + branch.getName() + " " + branch.getPosition() + " " + branch.getDirection() + " strand: " + (i + 1) + " " + strand.getName() + " " + strand.getPosition() + " residue: " + (j + 1) + " " + residue.getName() + " " + residue.getPosition() + " atom: " + (k + 1) + " " + atom.getName() + " " + atom.getPosition());
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean stericalCheck(StrandJunction3D junction) {
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            if (StrandJunctionTools.stericalCheck(junction, i)) continue;
            return false;
        }
        return true;
    }

    public static String writeJunctionGeomInfo(StrandJunction3D junction) {
        StringBuffer buf = new StringBuffer();
        buf.append(junction.getName() + " " + junction.getBranchCount());
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            buf.append(junction.getBranch(i).getRelativePosition());
        }
        return buf.toString();
    }

    public static String generateJunctionAngleInfo(StrandJunction3D junction) {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("#############  Start of Description of junction: " + junction.getName() + PackageConstants.NEWLINE);
        int numBranches = junction.getBranchCount();
        int numStrands = junction.getStrandCount();
        buf.append("Number of strands: " + numStrands + PackageConstants.NEWLINE);
        for (i = 0; i < numStrands; ++i) {
            buf.append("Strand " + (i + 1) + " : ");
            NucleotideStrand strand = junction.getStrand(i);
            int b1Id = junction.getIncomingBranchId(i);
            int b2Id = junction.getOutgoingBranchId(i);
            int fiveId = junction.getBranch(b1Id).getIncomingIndex();
            int threeId = junction.getBranch(b2Id).getOutgoingIndex();
            String seqString = junction.getStrand(i).sequenceString();
            String nameIn = strand.getResidue3D(fiveId).getName();
            String nameOut = strand.getResidue3D(threeId).getName();
            log.fine("namein: " + nameIn + " " + fiveId + " " + "nameout: " + nameOut + " " + threeId + " " + "complete sequence: " + seqString);
            seqString = seqString.substring(fiveId, threeId + 1);
            buf.append(nameIn + "," + nameOut + " " + seqString + PackageConstants.NEWLINE);
        }
        buf.append("Number of stems: " + numBranches + PackageConstants.NEWLINE);
        for (i = 0; i < numBranches; ++i) {
            buf.append("BranchDescriptor for Stem " + (i + 1) + " : " + junction.getBranch(i).infoString() + PackageConstants.NEWLINE);
        }
        for (i = 0; i < numBranches; ++i) {
            BranchDescriptor3D branch1 = junction.getBranch(i);
            for (int j = i + 1; j < numBranches; ++j) {
                BranchDescriptor3D branch2 = junction.getBranch(j);
                buf.append("Angle between stems " + (i + 1) + " and " + (j + 1) + " : " + 57.29577951308232 * BranchDescriptorTools.computeBranchDescriptorAngle(branch1, branch2) + PackageConstants.NEWLINE);
            }
        }
        buf.append("#############  END of Description of junction: " + junction.getName() + PackageConstants.NEWLINE);
        return buf.toString();
    }
}

