/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.Properties;
import rnadesign.rnamodel.AbstractBranchDescriptorOptimizer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.RnaStem3D;

public class StretchedBranchDescriptorOptimizer
extends AbstractBranchDescriptorOptimizer {
    public static final String CLASS_NAME = "StretchedBranchDescriptorOptimizer";
    public static final double RMS_LIMIT_DEFAULT = 100.0;
    private double rmsLimit = 5.0;
    private double stretchMaxFactor = 1.0;
    private double stretchStep = 0.02;

    public StretchedBranchDescriptorOptimizer() {
        this.rmsLimit = 100.0;
    }

    public StretchedBranchDescriptorOptimizer(FitParameters limits) {
        this.rmsLimit = limits.getRmsLimit();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private BranchDescriptor3D optimize(RnaStem3D stem, BranchDescriptor3D branch1, BranchDescriptor3D branch2, double rmsLimit) throws FittingException {
        double hOrig;
        log.fine("Starting StretchedBranchDescriptorOptimizer.optimize with rmsLimit: " + rmsLimit + " !");
        assert (branch1.isValid());
        assert (branch2.isValid());
        boolean bestAngle = false;
        double bestError = rmsLimit + 1.0E-4;
        BranchDescriptor3D b = null;
        try {
            b = StretchedBranchDescriptorOptimizer.interpolateBranchDescriptor(stem, branch1, branch2, 0.0);
        }
        catch (FittingException fe) {
            log.fine("Could not generate result from interpolateBranchDescriptor: " + fe.getMessage());
            throw fe;
        }
        assert (b != null);
        HelixParameters prmOrig = branch1.getHelixParameters();
        HelixParameters prm = new HelixParameters(prmOrig);
        double bestH = hOrig = prmOrig.rise;
        double bestNt = prm.basePairsPerTurn;
        double bestStretch = 1.0;
        double A = 38.1356601;
        for (double stretch = 1.0; stretch <= this.stretchMaxFactor; stretch += this.stretchStep) {
            for (int flag = -1; flag <= 1; flag += 2) {
                assert (flag != 0);
                double stretchUse = stretch;
                if (flag > 0) {
                    stretchUse = 1.0 / stretch;
                }
                double hNew = hOrig * stretchUse;
                double newNt = Math.PI * 2 * prm.radius / Math.sqrt(A - hNew * hNew);
                prm.rise = hNew;
                prm.basePairsPerTurn = newNt;
                b.setHelixParameters(prm);
                double errorVal = StretchedBranchDescriptorOptimizer.computeBranchDescriptorError(stem.getLength(), branch1, branch2, b);
                if (errorVal < bestError) {
                    log.fine("New better solution for stem helix rise, bp per turn: " + hNew + " " + newNt + " error: " + errorVal + " stretch: " + stretchUse);
                    bestError = errorVal;
                    bestH = hNew;
                    bestNt = newNt;
                    bestStretch = stretchUse;
                    continue;
                }
                log.fine("Error value too large (stretch)" + errorVal);
            }
        }
        if (bestError > rmsLimit) {
            log.fine("Could not find stem solution: " + bestError + " " + rmsLimit);
            return null;
        }
        log.fine("Could find stem solution: " + bestError + " with stretch: " + bestStretch);
        prm.rise = bestH;
        prm.basePairsPerTurn = bestNt;
        b.setHelixParameters(prm);
        Properties prop = b.getProperties();
        if (prop == null) {
            prop = new Properties();
            b.setProperties(prop);
        }
        log.fine("Optimized stem helix rise: " + bestH + " " + bestError + " stretch: " + bestStretch);
        prop.setProperty("fit_score", "" + bestError);
        prop.setProperty("stretch_factor", "" + bestStretch);
        assert (b.getProperties() != null);
        return b;
    }

    public double getStretchMaxFactor() {
        return this.stretchMaxFactor;
    }

    public void setStretchMaxFactor(double x) {
        this.stretchMaxFactor = x;
    }

    @Override
    public BranchDescriptor3D optimize(RnaStem3D stem, BranchDescriptor3D branch1, BranchDescriptor3D branch2) throws FittingException {
        log.fine("starting StretchBranchDescriptorOptimizer.optimize(stem, branch1, branch2) with rms limit: " + this.rmsLimit);
        return this.optimize(stem, branch1, branch2, this.rmsLimit);
    }

    public void setRmsLimit(double rmsLimit) {
        this.rmsLimit = rmsLimit;
    }
}

