/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.ResultWorker;
import generaltools.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import rnasecondary.InteractionSet;
import rnasecondary.RnaInteractionType;
import rnasecondary.RnaSecondaryTools;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleInteractionSet;
import rnasecondary.SimpleSecondaryStructure;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Residue;
import sequence.Sequence;
import sequence.UnevenAlignment;

public class HXMatchStructurePredictor
extends ResultWorker {
    public static final int CLUSTAL_WIDTH = 60;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private String scriptName = "hxmatch.sh";
    private UnevenAlignment ali;
    private double gcEnergy = -1.0;
    private double auEnergy = -0.8;
    private Alphabet alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;
    private Sequence[] sequences;
    private int stemLengthMin = 3;
    private int stopOffset = 3;
    private Level debugLogLevel = Level.FINE;

    public HXMatchStructurePredictor(UnevenAlignment ali) {
        assert (ali != null);
        this.ali = ali;
        this.sequences = this.getSequences(ali);
    }

    private Sequence[] getSequences(UnevenAlignment ali) {
        Sequence[] sequences = new Sequence[ali.getSequenceCount()];
        for (int i = 0; i < ali.getSequenceCount(); ++i) {
            sequences[i] = ali.getSequence(i);
        }
        return sequences;
    }

    private InteractionSet readInteractions(InputStream is) {
        assert (false);
        return null;
    }

    private void writeCLUSTAL(OutputStream os, String[] sequences, String[] names) {
        assert (sequences.length > 0);
        if (names == null) {
            names = new String[sequences.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = "s" + (i + 1);
            }
        }
        int frontCount = 16;
        PrintStream ps = new PrintStream(os);
        ps.println("CLUSTAL");
        int length = sequences[0].length();
        for (int colCount = 0; colCount < length; colCount += 60) {
            int i;
            int diff = length - colCount;
            int sLen = diff;
            if (sLen > 60) {
                sLen = 60;
            }
            assert (colCount + sLen <= length);
            for (i = 0; i < sequences.length; ++i) {
                String s = sequences[i];
                assert (s.length() == length);
                s = s.substring(colCount, colCount + sLen);
                String name = names[i];
                if (name.length() > frontCount) {
                    name = name.substring(0, frontCount);
                }
                ps.print(name);
                int dChar = frontCount - name.length();
                for (int j = 0; j < dChar; ++j) {
                    ps.print(" ");
                }
                ps.println(s + " " + (colCount + sLen));
            }
            for (int j = 0; j < frontCount; ++j) {
                ps.print(" ");
            }
            for (i = 0; i < sLen; ++i) {
                ps.print(".");
            }
            ps.println();
            ps.println();
        }
    }

    static String paste(Sequence[] sequences) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < sequences.length; ++i) {
            buf.append(((Object)sequences[i]).toString());
        }
        return buf.toString();
    }

    String[] launchFolding(Sequence[] sequences) throws IOException {
        System.out.println("Launching folding for folling sequences:");
        for (Sequence seq : sequences) {
            System.out.println(((Object)seq).toString());
        }
        File tmpInputFile = File.createTempFile("nanotiler_hxmatch", ".clustal");
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        String sequence = HXMatchStructurePredictor.paste(sequences);
        this.log.log(this.debugLogLevel, "Writing to file: " + inputFileName);
        this.log.log(this.debugLogLevel, "Writing content: " + sequence);
        StringBuffer seqBuf = new StringBuffer();
        for (int i = 0; i < sequences.length; ++i) {
            seqBuf.append(((Object)sequences[i]).toString());
        }
        String[] seqs = new String[]{seqBuf.toString(), seqBuf.toString()};
        String[] names = null;
        this.writeCLUSTAL(fos, seqs, names);
        fos.close();
        File tmpOutputFile = File.createTempFile("nanotiler_hxmatch", ".sec");
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        File tempFile = new File(this.scriptName);
        String[] commandWords = new String[]{this.scriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        this.log.log(this.debugLogLevel, "Issuing command: " + this.scriptName + " " + inputFileName + " " + outputFileName);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        this.log.log(this.debugLogLevel, "queue manager finished job!");
        this.log.log(this.debugLogLevel, "Importing optimized sequences from " + outputFileName);
        String[] resultLines = null;
        FileInputStream resultFile = null;
        try {
            resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            this.log.warning("Error when scraping result file from: " + outputFileName);
            assert (false);
            throw ioe;
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
                File file = new File(outputFileName);
                file.delete();
            }
            if (tmpInputFile != null) {
                tmpInputFile.delete();
            }
        }
        if (resultLines != null) {
            this.log.log(this.debugLogLevel, "Results for RNAcofold:");
            for (int i = 0; i < resultLines.length; ++i) {
                this.log.fine(resultLines[i]);
            }
        } else {
            assert (false);
            this.log.warning("Rnacofold results were null!");
        }
        System.out.println("Using tmp files: " + tmpInputFile + " " + tmpOutputFile);
        System.out.println("Result from hxmatch:");
        for (int i = 0; i < resultLines.length; ++i) {
            System.out.println(resultLines[i]);
        }
        return resultLines;
    }

    int[] parseHXMatchLine(String line) throws NumberFormatException {
        String line2 = line.trim();
        String[] words = line2.split(" ");
        int pc = 0;
        int n = 0;
        int m = 0;
        for (int i = 0; i < words.length; ++i) {
            if (words[i].length() <= 0) continue;
            if (pc == 0) {
                n = Integer.parseInt(words[i]) - 1;
                ++pc;
                continue;
            }
            if (pc != true) break;
            m = Integer.parseInt(words[i]) - 1;
            ++pc;
        }
        int[] result = new int[]{n, m};
        return result;
    }

    int[] findSequenceIndex(int pastedIndex) {
        int sum = 0;
        for (int i = 0; i < this.sequences.length; ++i) {
            assert (pastedIndex >= sum);
            if (pastedIndex < sum + this.sequences[i].size()) {
                int[] result = new int[]{i, pastedIndex - sum};
                assert (result[1] < this.sequences[result[0]].size());
                return result;
            }
            sum += this.sequences[i].size();
        }
        assert (false);
        return null;
    }

    InteractionSet parseHXMatch(String[] resultLines) throws NumberFormatException {
        SimpleInteractionSet result = new SimpleInteractionSet();
        for (int i = 2; i < resultLines.length; ++i) {
            System.out.println(resultLines[i]);
            int[] lineResult = this.parseHXMatchLine(resultLines[i]);
            assert (lineResult.length == 2);
            int[] ids1 = this.findSequenceIndex(lineResult[0]);
            int[] ids2 = this.findSequenceIndex(lineResult[1]);
            System.out.println("Parsing result: " + lineResult[0] + " " + lineResult[1] + " " + ids1[0] + " " + ids1[1] + " " + ids2[0] + " " + ids2[1]);
            Residue res1 = this.sequences[ids1[0]].getResidue(ids1[1]);
            Residue res2 = this.sequences[ids2[0]].getResidue(ids2[1]);
            if (RnaSecondaryTools.isWatsonCrick(res1.getSymbol().getCharacter(), res2.getSymbol().getCharacter())) {
                RnaInteractionType interactionType = new RnaInteractionType(1);
                result.add(new SimpleInteraction(res1, res2, interactionType));
                continue;
            }
            System.out.println("Warning: ignoring predicted non-Watson-Crick pair: " + res1.getSymbol() + " " + ids1[1] + 1 + " " + res2.getSymbol() + " " + ids2[1]);
            StringTools.printStride(System.out, this.sequences[ids1[0]].sequenceString(), 10);
            System.out.println("");
            StringTools.printStride(System.out, this.sequences[ids2[0]].sequenceString(), 10);
            System.out.println("");
        }
        return result;
    }

    @Override
    protected void runInternal() {
        try {
            String[] resultLines = this.launchFolding(this.sequences);
            InteractionSet interactionSet = this.parseHXMatch(resultLines);
            this.setResult(new SimpleSecondaryStructure(this.ali, interactionSet));
        }
        catch (IOException ioe) {
            System.out.println("IO exception in HXMatchStructurePredictor: " + ioe.getMessage());
            this.setResult(null);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Number format exception in HXMatchStructurePredictor: " + nfe.getMessage());
            this.setResult(null);
        }
    }
}

