/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import java.util.logging.Logger;
import rnasecondary.PackageConstants;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureWriter;
import sequence.Sequence;

public class SecondaryStructureCTFormatWriter
implements SecondaryStructureWriter {
    public static final char NO_BASE_PAIR_CHAR = '.';
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean writeSequenceMode = true;
    private boolean purgeMultipleInteractions = true;
    private int stride = 0;
    private String strideString = "";

    public static String generateConcatenatedSequenceString(SecondaryStructure structure) {
        assert (structure != null);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < structure.getSequenceCount(); ++i) {
            Sequence seq = structure.getSequence(i);
            buf.append(seq.sequenceString());
        }
        return buf.toString();
    }

    private int[] convertSingleSeqInteractions(SecondaryStructure structure) {
        assert (structure != null);
        String concatSeq = SecondaryStructureCTFormatWriter.generateConcatenatedSequenceString(structure);
        int[] interactions = new int[concatSeq.length()];
        for (int i = 0; i < interactions.length; ++i) {
            interactions[i] = -1;
        }
        int[] starts = structure.getStarts();
        for (int i = 0; i < structure.getSequenceCount(); ++i) {
            for (int j = i; j < structure.getSequenceCount(); ++j) {
                int[][] mtx = structure.toInteractionMatrix(i, j);
                for (int m = 0; m < mtx.length; ++m) {
                    for (int n = 0; n < mtx[m].length; ++n) {
                        if (mtx[m][n] == -1) continue;
                        interactions[starts[i] + m] = starts[j] + n;
                        interactions[starts[j] + n] = starts[i] + m;
                        assert (starts[i] + m < interactions.length);
                        assert (starts[j] + n < interactions.length);
                    }
                }
            }
        }
        return interactions;
    }

    private void appendChars(StringBuffer buf, char c, int n) {
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            buf.append(c);
        }
    }

    public String writeString(String sequence, SecondaryStructure structure) {
        int i;
        assert (structure != null);
        StringBuffer buf = new StringBuffer();
        int numEntries = sequence.length();
        int[] connections = this.convertSingleSeqInteractions(structure);
        int[] starts = structure.getStarts();
        buf.append("" + sequence.length() + " ");
        buf.append("" + starts.length);
        for (i = 0; i < starts.length; ++i) {
            buf.append(" " + (starts[i] + 1));
        }
        buf.append(PackageConstants.NEWLINE);
        for (i = 0; i < numEntries; ++i) {
            String s1 = "" + (i + 1);
            int len1 = s1.length();
            int sp1l = 5 - len1;
            assert (sp1l >= 0);
            this.appendChars(buf, ' ', sp1l);
            char resChar = sequence.charAt(i);
            if (resChar == '.') {
                resChar = '-';
            }
            buf.append(s1 + " " + resChar);
            String s2 = "" + i;
            int len2 = s2.length();
            int sp2l = 6 - len2;
            assert (sp2l >= 0);
            this.appendChars(buf, ' ', sp2l);
            buf.append(s2);
            String s3 = "" + (i + 2);
            int len3 = s3.length();
            int sp3l = 6 - len3;
            assert (sp3l >= 0);
            this.appendChars(buf, ' ', sp3l);
            buf.append(s3);
            String s4 = "" + (connections[i] + 1);
            int len4 = s4.length();
            int sp4l = 6 - len4;
            assert (sp4l >= 0);
            this.appendChars(buf, ' ', sp4l);
            buf.append(s4);
            int sp1lb = 6 - len1;
            assert (sp1lb >= 0);
            this.appendChars(buf, ' ', sp1lb);
            buf.append(s1);
            buf.append(PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    @Override
    public String writeString(SecondaryStructure structure) {
        assert (structure != null);
        String sequence = SecondaryStructureCTFormatWriter.generateConcatenatedSequenceString(structure);
        return this.writeString(sequence, structure);
    }
}

