/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.PackageConstants;
import rnasecondary.Interaction;
import rnasecondary.RnaInteractionType;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureWriter;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleStem;
import sequence.Residue;
import sequence.Sequence;

public class SecondaryStructureServerFormatWriter
implements SecondaryStructureWriter {
    public static final char NO_BASE_PAIR_CHAR = '.';
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final int INDVIDUAL_CASE = 0;
    public static final int ALL_UPPER_CASE = 1;
    public static final int ALL_LOWER_CASE = -1;
    private int capitalizationMode = 1;
    private boolean writeSequenceMode = true;
    private boolean purgeMultipleInteractions = true;

    public SecondaryStructureServerFormatWriter() {
    }

    public SecondaryStructureServerFormatWriter(boolean writeSequenceMode) {
        this.writeSequenceMode = writeSequenceMode;
    }

    private static String setChar(String s, char c, int pos) {
        if (pos >= s.length()) {
            return s;
        }
        String result = s.substring(0, pos) + c + s.substring(pos + 1, s.length());
        assert (result.length() == s.length());
        return result;
    }

    public String writeSequence(SecondaryStructure structure, int seqId) {
        Sequence sequence = structure.getSequence(seqId);
        String result = sequence.sequenceString();
        log.fine("Writing sequence for optimizer: " + result);
        for (int i = 0; i < result.length(); ++i) {
            Residue residue = sequence.getResidue(i);
            Properties prop = residue.getProperties();
            if (prop != null) {
                String status = prop.getProperty("sequence_status");
                if (status != null && status.equals("adhoc")) {
                    result = SecondaryStructureServerFormatWriter.setChar(result, Character.toUpperCase(result.charAt(i)), i);
                    continue;
                }
                char c = Character.toLowerCase(result.charAt(i));
                assert (c != 'b');
                result = SecondaryStructureServerFormatWriter.setChar(result, c, i);
                continue;
            }
            result = SecondaryStructureServerFormatWriter.setChar(result, Character.toLowerCase(result.charAt(i)), i);
        }
        if (this.capitalizationMode == 1) {
            result = result.toUpperCase();
        } else if (this.capitalizationMode == -1) {
            result = result.toLowerCase();
        }
        return result;
    }

    private int findSequence(Residue res, SecondaryStructure structure) {
        assert (res != null);
        assert (structure != null);
        assert (res.getParentObject() != null);
        for (int i = 0; i < structure.getSequenceCount(); ++i) {
            Sequence seq = structure.getSequence(i);
            Residue other = seq.getResidue(0);
            if (!res.isSameSequence(other)) continue;
            return i;
        }
        return -1;
    }

    private void addInteraction(Interaction interaction, Interaction[][] interactionArray, SecondaryStructure structure) {
        log.fine("Starting addInteraction for " + interaction);
        Residue res1 = interaction.getResidue1();
        Residue res2 = interaction.getResidue2();
        assert (res1 != null);
        assert (res2 != null);
        int seqId1 = this.findSequence(res1, structure);
        int seqId2 = this.findSequence(res2, structure);
        if (seqId1 < 0) {
            log.fine("Could not find sequence for residue: " + res1.getAssignedName() + " " + res1.getPos() + " " + res1.getSymbol().getCharacter());
            return;
        }
        if (seqId2 < 0) {
            log.fine("Could not find sequence for residue: " + res2.getAssignedName() + " " + res2.getPos() + " " + res2.getSymbol().getCharacter());
            return;
        }
        assert (seqId1 >= 0);
        assert (seqId2 >= 0);
        assert (seqId1 < structure.getSequenceCount());
        assert (seqId2 < structure.getSequenceCount());
        Sequence seq1 = structure.getSequence(seqId1);
        Sequence seq2 = structure.getSequence(seqId2);
        assert (seq1.size() == interactionArray[seqId1].length);
        assert (seq2.size() == interactionArray[seqId2].length);
        if (seqId1 >= 0 && seqId2 >= 0) {
            log.fine("Adding interaction(1): " + (seqId1 + 1) + ":" + (res1.getPos() + 1) + " " + (seqId2 + 1) + ":" + (res2.getPos() + 1) + " " + (seq1.size() + 1) + " " + (seq2.size() + 1));
            assert (seqId1 < interactionArray.length);
            assert (res1.getPos() < interactionArray[seqId1].length);
            assert (seqId2 < interactionArray.length);
            assert (res2.getPos() < interactionArray[seqId2].length);
            interactionArray[seqId1][res1.getPos()] = interaction;
            interactionArray[seqId2][res2.getPos()] = interaction;
        } else {
            log.fine("could not find: " + res1.getSymbol() + res1.getPos() + " " + res2.getSymbol() + res2.getPos());
        }
    }

    private char incChar(char c) {
        int n = c;
        return (char)(++n);
    }

    private char decChar(char c) {
        int n = c;
        return (char)(--n);
    }

    private double[][] generateInteractionMatrix(Interaction[][] interactionArray, int seqId1, int seqId2, SecondaryStructure structure) {
        int i;
        Sequence sequence1 = structure.getSequence(seqId1);
        Sequence sequence2 = structure.getSequence(seqId2);
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        double[][] matrix = new double[size1][size2];
        for (i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = 0.0;
            }
        }
        for (i = 0; i < size1; ++i) {
            Interaction interaction = interactionArray[seqId1][i];
            if (interaction == null) continue;
            Residue res1 = interaction.getResidue1();
            Residue res2 = interaction.getResidue2();
            int sid1 = this.findSequence(res1, structure);
            int sid2 = this.findSequence(res2, structure);
            if (sid1 == seqId1 && sid2 == seqId2) {
                assert (res1.getPos() < matrix.length);
                assert (res2.getPos() < matrix[res1.getPos()].length);
                matrix[res1.getPos()][res2.getPos()] = 1.0;
                continue;
            }
            if (sid1 != seqId2 || sid2 != seqId1) continue;
            assert (res2.getPos() < matrix.length);
            assert (res1.getPos() < matrix[res2.getPos()].length);
            matrix[res2.getPos()][res1.getPos()] = 1.0;
        }
        return matrix;
    }

    private String generateCharArray(char[][] charArray, Interaction[][] interactionArray, SecondaryStructure structure, int seqId1) {
        Sequence sequence1;
        String wyfcurseq = "";
        int seqId2 = seqId1;
        Sequence sequence2 = sequence1 = structure.getSequence(seqId1);
        int numRows = sequence1.size();
        int numCols = sequence2.size();
        assert (numRows == numCols);
        double thresh = 0.5;
        int[][] visitedMtx = new int[numRows][numCols];
        double[][] mtx = this.generateInteractionMatrix(interactionArray, seqId1, seqId2, structure);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                visitedMtx[i][j] = 0;
            }
        }
        RnaInteractionType watsonCrick = new RnaInteractionType(1);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                if (visitedMtx[i][j] == 1) continue;
                if (mtx[i][j] >= thresh) {
                    SimpleStem newStem = new SimpleStem(sequence1, sequence2);
                    for (int k = 0; i + k < numRows && j >= k && mtx[i + k][j - k] >= thresh && visitedMtx[i + k][j - k] <= 0; ++k) {
                        visitedMtx[i + k][j - k] = 1;
                        Residue residue1 = sequence1.getResidue(i + k);
                        Residue residue2 = sequence2.getResidue(j - k);
                        SimpleInteraction interaction = new SimpleInteraction(residue1, residue2, watsonCrick);
                        newStem.add(interaction);
                    }
                    for (int k2 = 0; k2 < newStem.size(); ++k2) {
                        int p1 = newStem.getStartPos() + k2;
                        int p2 = newStem.getStopPos() - k2;
                        log.fine("Stem pos: " + p1 + " " + p2 + " " + charArray.length + " " + charArray[0].length);
                        assert (p1 < charArray[seqId1].length);
                        assert (p2 < charArray[seqId1].length);
                        if (p1 < p2) {
                            charArray[seqId1][p1] = 40;
                            charArray[seqId1][p2] = 41;
                        } else {
                            charArray[seqId1][p1] = 41;
                            charArray[seqId1][p2] = 40;
                        }
                        wyfcurseq = wyfcurseq + "[" + p1 + "," + p2 + "]";
                    }
                    continue;
                }
                visitedMtx[i][j] = 1;
            }
        }
        return wyfcurseq;
    }

    private char generateCharArray(char[][] charArray, Interaction[][] interactionArray, SecondaryStructure structure, int seqId1, int seqId2, char interactionChar) {
        Sequence sequence1 = structure.getSequence(seqId1);
        Sequence sequence2 = structure.getSequence(seqId2);
        int numRows = sequence1.size();
        int numCols = sequence2.size();
        double thresh = 0.5;
        int[][] visitedMtx = new int[numRows][numCols];
        double[][] mtx = this.generateInteractionMatrix(interactionArray, seqId1, seqId2, structure);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                visitedMtx[i][j] = 0;
            }
        }
        RnaInteractionType watsonCrick = new RnaInteractionType(1);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                if (visitedMtx[i][j] == 1) continue;
                if (mtx[i][j] >= thresh) {
                    SimpleStem newStem = new SimpleStem(sequence1, sequence2);
                    for (int k = 0; i + k < numRows && j >= k && mtx[i + k][j - k] >= thresh && visitedMtx[i + k][j - k] <= 0; ++k) {
                        visitedMtx[i + k][j - k] = 1;
                        Residue residue1 = sequence1.getResidue(i + k);
                        Residue residue2 = sequence2.getResidue(j - k);
                        SimpleInteraction interaction = new SimpleInteraction(residue1, residue2, watsonCrick);
                        newStem.add(interaction);
                    }
                    interactionChar = this.incChar(interactionChar);
                    for (int k2 = 0; k2 < newStem.size(); ++k2) {
                        int p1 = newStem.getStartPos() + k2;
                        int p2 = newStem.getStopPos() - k2;
                        assert (seqId1 < charArray.length);
                        assert (seqId2 < charArray.length);
                        assert (charArray[seqId1] != null);
                        assert (charArray[seqId2] != null);
                        assert (p1 >= 0);
                        assert (p1 < charArray[seqId1].length);
                        assert (p2 >= 0);
                        assert (p2 < charArray[seqId2].length);
                        charArray[seqId1][p1] = interactionChar;
                        charArray[seqId2][p2] = interactionChar;
                    }
                    continue;
                }
                visitedMtx[i][j] = 1;
            }
        }
        return interactionChar;
    }

    private String[] generateCharArray(char[][] charArray, Interaction[][] interactionArray, SecondaryStructure structure) {
        String[] wyfpair = new String[interactionArray.length];
        char interactionChar = 'A';
        interactionChar = this.decChar(interactionChar);
        for (int i = 0; i < interactionArray.length; ++i) {
            wyfpair[i] = "";
            wyfpair[i] = this.generateCharArray(charArray, interactionArray, structure, i);
            for (int j = i + 1; j < interactionArray.length; ++j) {
                interactionChar = this.generateCharArray(charArray, interactionArray, structure, i, j, interactionChar);
            }
        }
        return wyfpair;
    }

    void setCapitalizationMode(int mode) {
        this.capitalizationMode = mode;
    }

    public List<String[]> writeSecondaryStructure(SecondaryStructure structure) {
        int i;
        if (structure == null || structure.getSequenceCount() == 0) {
            return null;
        }
        Interaction[][] interactionArray = new Interaction[structure.getSequenceCount()][0];
        char[][] charArray = new char[structure.getSequenceCount()][0];
        for (i = 0; i < structure.getSequenceCount(); ++i) {
            interactionArray[i] = new Interaction[structure.getSequence(i).size()];
            charArray[i] = new char[structure.getSequence(i).size()];
            for (int j = 0; j < charArray[i].length; ++j) {
                charArray[i][j] = 46;
            }
        }
        log.fine("Generating secondary structure representation using " + structure.getInteractionCount() + " interactions.");
        for (i = 0; i < structure.getInteractionCount(); ++i) {
            Interaction interaction = structure.getInteraction(i);
            int subType = interaction.getInteractionType().getSubTypeId();
            if (subType != 6 && subType != -1) {
                this.addInteraction(interaction, interactionArray, structure);
                continue;
            }
            log.fine("Ignoring interaction " + ((Object)interaction).toString());
        }
        this.generateCharArray(charArray, interactionArray, structure);
        ArrayList<String[]> secondaryStructures = new ArrayList<String[]>();
        for (int i2 = 0; i2 < charArray.length; ++i2) {
            String[] temp = new String[charArray[i2].length];
            for (int k = 0; k < temp.length; ++k) {
                temp[k] = String.valueOf(charArray[i2][k]);
            }
            secondaryStructures.add(temp);
        }
        return secondaryStructures;
    }

    @Override
    public String writeString(SecondaryStructure structure) {
        int i;
        if (structure == null || structure.getSequenceCount() == 0) {
            return "";
        }
        Interaction[][] interactionArray = new Interaction[structure.getSequenceCount()][0];
        char[][] charArray = new char[structure.getSequenceCount()][0];
        for (i = 0; i < structure.getSequenceCount(); ++i) {
            interactionArray[i] = new Interaction[structure.getSequence(i).size()];
            charArray[i] = new char[structure.getSequence(i).size()];
            for (int j = 0; j < charArray[i].length; ++j) {
                charArray[i][j] = 46;
            }
        }
        for (i = 0; i < structure.getInteractionCount(); ++i) {
            Interaction interaction = structure.getInteraction(i);
            int subType = interaction.getInteractionType().getSubTypeId();
            if (subType == 6 || subType == -1) continue;
            this.addInteraction(interaction, interactionArray, structure);
        }
        String[] wyfinfo = new String[interactionArray.length];
        wyfinfo = this.generateCharArray(charArray, interactionArray, structure);
        String result = "";
        for (int i2 = 0; i2 < structure.getSequenceCount(); ++i2) {
            if (this.writeSequenceMode) {
                result = result + this.writeSequence(structure, i2) + PackageConstants.NEWLINE;
            }
            result = result + new String(charArray[i2]) + PackageConstants.NEWLINE + wyfinfo[i2];
        }
        return result;
    }
}

