/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.MalformedInputException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.PackageConstants;
import rnasecondary.PackageConventionTools;
import rnasecondary.SimpleInteraction;

public class SimpleInteractionSet
implements InteractionSet {
    private List<Interaction> list = new ArrayList<Interaction>();

    @Override
    public void add(Interaction interaction) {
        this.list.add(interaction);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Object clone() {
        SimpleInteractionSet newSet = new SimpleInteractionSet();
        newSet.list = new ArrayList<Interaction>();
        for (int i = 0; i < this.size(); ++i) {
            newSet.add((Interaction)this.list.get(i).clone());
        }
        return newSet;
    }

    @Override
    public Interaction get(int n) throws IndexOutOfBoundsException {
        return this.list.get(n);
    }

    @Override
    public String getClassName() {
        return "InteractionSet";
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void sort() {
        Collections.sort(this.list);
    }

    @Override
    public void read(InputStream is) throws MalformedInputException {
        PackageConventionTools.readHeader(is, this.getClassName());
        int numEntries = 0;
        for (int i = 0; i < numEntries; ++i) {
            SimpleInteraction interaction = new SimpleInteraction();
            interaction.read(is);
            this.add(interaction);
        }
        PackageConventionTools.readFooter(is, this.getClassName());
    }

    @Override
    public void remove(Interaction interaction) {
        this.list.remove(interaction);
    }

    @Override
    public String toString() {
        String result = "(InteractionSet " + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.get(i) + PackageConstants.ENDL;
        }
        result = result + ")";
        return result;
    }
}

