/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import generaltools.MalformedInputException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.PackageConventionTools;
import rnasecondary.SecondaryStructure;
import rnasecondary.SimpleInteractionSet;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.Residue;
import sequence.Sequence;
import sequence.UnevenAlignment;
import sequence.UnknownSequenceException;

public class SimpleSecondaryStructure
implements SecondaryStructure {
    public static final double DEFAULT_WEIGHT = 1.0;
    public static final String NEWLINE = System.getProperty("line.separator");
    private UnevenAlignment sequences;
    private InteractionSet interactions;
    private double energy = 0.0;
    private boolean ignoreNotConstantMode = false;
    private List<Alphabet> alphabets = null;
    private List<List<Double>> weights = new ArrayList<List<Double>>();
    private Set<Integer> inactiveMap = new HashSet<Integer>();

    public SimpleSecondaryStructure(UnevenAlignment alignment, InteractionSet interactions) {
        this.sequences = alignment;
        this.interactions = interactions;
        this.alphabets = this.generateDefaultAlphabets();
    }

    public SimpleSecondaryStructure(UnevenAlignment alignment, InteractionSet interactions, List<List<Double>> weights) {
        this.sequences = alignment;
        this.interactions = interactions;
        this.weights = weights;
        this.alphabets = this.generateDefaultAlphabets();
        assert (this.weightsSanityCheck());
    }

    @Override
    public void setAlphabets(List<Alphabet> alphabets) {
        assert (alphabets == null || alphabets.size() == this.sequences.getSequenceCount());
        this.alphabets = alphabets;
    }

    public void addInteraction(Interaction interaction) {
        this.interactions.add(interaction);
    }

    public void addSequence(Sequence sequence) throws DuplicateNameException {
        this.sequences.addSequence(sequence);
    }

    @Override
    public List<Alphabet> getAlphabets() {
        assert (this.alphabets == null || this.alphabets.size() == this.getSequenceCount());
        return this.alphabets;
    }

    @Override
    public List<Alphabet> generateDefaultAlphabets() {
        ArrayList<Alphabet> list = new ArrayList<Alphabet>();
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            list.add(DnaTools.RNA_ALPHABET);
        }
        return list;
    }

    @Override
    public void generateDefaultWeights() {
        this.weights = new ArrayList<List<Double>>();
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            int n = this.getSequence(i).size();
            ArrayList<Double> lst = new ArrayList<Double>();
            for (int j = 0; j < n; ++j) {
                lst.add(1.0);
            }
            assert (lst.size() == n);
            this.weights.add(lst);
        }
        assert (this.weights.size() == this.getSequenceCount());
        assert (this.weightsSanityCheck());
    }

    @Override
    public boolean weightsSanityCheck() {
        if (this.weights.size() != this.getSequenceCount()) {
            return false;
        }
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            if (this.weights.get(i) == null) {
                return false;
            }
            if (this.weights.get(i).size() == this.getSequence(i).size()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Double> getWeights(int n) {
        assert (this.weightsSanityCheck());
        assert (this.weights != null);
        assert (n < this.weights.size());
        return this.weights.get(n);
    }

    @Override
    public void setWeights(List<Double> _weights, int n) {
        assert (this.weightsSanityCheck());
        assert (this.weights != null);
        assert (n < this.weights.size());
        this.weights.set(n, _weights);
        assert (this.weightsSanityCheck());
    }

    @Override
    public int findSequence(Residue res) {
        assert (res != null);
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            Sequence seq = this.getSequence(i);
            Residue other = seq.getResidue(0);
            if (!res.isSameSequence(other)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[][][][] generateInteractionMatrices() {
        int[][][][] matrices = new int[this.getSequenceCount()][this.getSequenceCount()][0][0];
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            for (int j = i; j < this.getSequenceCount(); ++j) {
                matrices[i][j] = this.generateInteractionMatrix(i, j);
            }
        }
        return matrices;
    }

    public int[][][][] generateInteractionMatrices(int[] subset) {
        int len = subset.length;
        int[][][][] matrices = new int[len][len][0][0];
        for (int i = 0; i < len; ++i) {
            for (int j = i; j < len; ++j) {
                matrices[i][j] = this.generateInteractionMatrix(subset[i], subset[j]);
            }
        }
        return matrices;
    }

    int[][] generateInteractionMatrix(int id1, int id2) {
        int i;
        Sequence seq1 = this.getSequence(id1);
        Sequence seq2 = this.getSequence(id2);
        int[][] result = new int[seq1.size()][seq2.size()];
        for (i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        for (i = 0; i < this.getInteractionCount(); ++i) {
            Interaction interaction = this.getInteraction(i);
            int pos1 = interaction.getResidue1().getPos();
            int pos2 = interaction.getResidue2().getPos();
            if (interaction.getSequence1() == seq1 && interaction.getSequence2() == seq2) {
                result[pos1][pos2] = interaction.getInteractionType().getSubTypeId();
                if (id1 != id2) continue;
                result[pos2][pos1] = result[pos1][pos2];
                continue;
            }
            if (interaction.getSequence2() != seq1 || interaction.getSequence1() != seq2) continue;
            result[pos2][pos1] = interaction.getInteractionType().getSubTypeId();
            assert (id1 != id2);
        }
        for (i = 0; i < result.length; ++i) {
            if (!"ignore".equals(seq1.getResidue(i).getProperty("seqstatus")) && (!this.ignoreNotConstantMode || !"fragment".equals(seq1.getResidue(i).getProperty("sequence_status")))) continue;
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = 0;
            }
        }
        for (i = 0; i < result[0].length; ++i) {
            if (!"ignore".equals(seq2.getResidue(i).getProperty("seqstatus")) && (!this.ignoreNotConstantMode || !"fragment".equals(seq2.getResidue(i).getProperty("sequence_status")))) continue;
            for (int j = 0; j < result.length; ++j) {
                result[j][i] = 0;
            }
        }
        return result;
    }

    @Override
    public String getClassName() {
        return "SecondaryStructure";
    }

    @Override
    public InteractionSet getInteractions() {
        return this.interactions;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public int[] getStarts() {
        int[] result = new int[this.getSequenceCount()];
        result[0] = 0;
        for (int i = 1; i < result.length; ++i) {
            result[i] = result[i - 1] + this.getSequence(i - 1).size();
        }
        return result;
    }

    @Override
    public void setEnergy(double _energy) {
        this.energy = _energy;
    }

    @Override
    public boolean isActive(int seqId) {
        return !this.inactiveMap.contains(seqId);
    }

    @Override
    public void setInActive(int seqId) {
        this.inactiveMap.add(seqId);
    }

    @Override
    public void setActive(int seqId) {
        if (!this.isActive(seqId)) {
            this.inactiveMap.remove(seqId);
        }
    }

    @Override
    public int getSequenceCount() {
        return this.sequences.getSequenceCount();
    }

    @Override
    public Sequence getSequence(int n) {
        return this.sequences.getSequence(n);
    }

    @Override
    public Sequence getSequence(String name) throws UnknownSequenceException {
        return this.sequences.getSequence(name);
    }

    @Override
    public UnevenAlignment getSequences() {
        return this.sequences;
    }

    @Override
    public int getInteractionCount() {
        return this.interactions.size();
    }

    @Override
    public Interaction getInteraction(int n) {
        return this.interactions.get(n);
    }

    @Override
    public void setSequences(UnevenAlignment sequences) {
        this.sequences = sequences;
    }

    @Override
    public void setInteractions(InteractionSet interactions) {
        this.interactions = interactions;
    }

    @Override
    public void read(InputStream is) throws MalformedInputException {
        PackageConventionTools.readHeader(is, this.getClassName());
        this.sequences.read(is);
        this.interactions.read(is);
        PackageConventionTools.readFooter(is, this.getClassName());
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(SecondaryStructure ");
        for (int i = 0; i < this.sequences.getSequenceCount(); ++i) {
            String s = this.sequences.getSequence(i).sequenceString();
            buf.append(s + "\n");
        }
        buf.append(this.interactions.toString() + NEWLINE + ")");
        return buf.toString();
    }

    private void purgeOverlappingInteractions(InteractionSet overlappingInteractions, List<Integer> overlappingIndices, int purgeMode, boolean[] removeFlags) {
        switch (purgeMode) {
            case 0: {
                return;
            }
            case 1: {
                for (int i = 0; i < overlappingIndices.size(); ++i) {
                    removeFlags[overlappingIndices.get((int)i).intValue()] = true;
                }
                break;
            }
            case 2: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void purgeOverlappingInteractions(int purgeMode) {
        int i;
        boolean[] removeFlags = new boolean[this.interactions.size()];
        for (i = 0; i < this.interactions.size(); ++i) {
            if (removeFlags[i]) continue;
            SimpleInteractionSet overlappingInteractions = new SimpleInteractionSet();
            ArrayList<Integer> overlappingIndices = new ArrayList<Integer>();
            overlappingInteractions.add(this.interactions.get(i));
            overlappingIndices.add(new Integer(i));
            for (int j = i + 1; j < this.interactions.size(); ++j) {
                if (removeFlags[j] || !this.interactions.get(i).isOverlapping(this.interactions.get(j))) continue;
                overlappingInteractions.add(this.interactions.get(j));
                overlappingIndices.add(new Integer(j));
            }
            if (overlappingInteractions.size() <= 1) continue;
            this.purgeOverlappingInteractions(overlappingInteractions, overlappingIndices, purgeMode, removeFlags);
        }
        for (i = this.interactions.size() - 1; i >= 0; --i) {
            if (!removeFlags[i]) continue;
            this.interactions.remove(this.interactions.get(i));
        }
    }

    @Override
    public int[][] toInteractionMatrix(int m, int n) {
        assert (m < this.getSequenceCount());
        assert (n < this.getSequenceCount());
        int len1 = this.getSequence(m).size();
        int len2 = this.getSequence(n).size();
        int[][] result = new int[len1][len2];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        UnevenAlignment ali = this.getSequences();
        for (int i = 0; i < this.getInteractionCount(); ++i) {
            Interaction inter = this.getInteraction(i);
            Sequence s1 = inter.getSequence1();
            Sequence s2 = inter.getSequence2();
            int idx1 = ali.getIndex(s1.getName());
            int idx2 = ali.getIndex(s2.getName());
            assert (idx1 >= 0);
            assert (idx2 >= 0);
            Residue res1 = inter.getResidue1();
            Residue res2 = inter.getResidue2();
            if (idx1 == m && idx2 == n) {
                result[res1.getPos()][res2.getPos()] = inter.getInteractionType().getSubTypeId();
                if (m != n) continue;
                result[res2.getPos()][res1.getPos()] = result[res1.getPos()][res2.getPos()];
                continue;
            }
            if (idx1 != n || idx2 != m) continue;
            result[res2.getPos()][res1.getPos()] = inter.getInteractionType().getSubTypeId();
            if (m != n) continue;
            result[res1.getPos()][res2.getPos()] = result[res2.getPos()][res1.getPos()];
        }
        assert (result.length == len1);
        assert (result[0].length == len2);
        return result;
    }
}

