/*
 * Decompiled with CFR 0.152.
 */
package rnasecondary;

import java.io.InputStream;
import numerictools.IntervalInt;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.RnaInteractionType;
import rnasecondary.RnaSecondaryTools;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleInteractionSet;
import rnasecondary.Stem;
import sequence.Residue;
import sequence.Sequence;

public class SimpleStem
implements Stem {
    private Sequence sequence1;
    private Sequence sequence2;
    private InteractionSet interactions;
    private double energy = 0.0;
    public static final String CLASS_NAME = "STEM";

    private SimpleStem() {
    }

    public SimpleStem(int startPos, int stopPos, int length, Sequence sequence1, Sequence sequence2) {
        this.sequence1 = sequence1;
        this.sequence2 = sequence2;
        this.interactions = new SimpleInteractionSet();
        for (int i = 0; i < length; ++i) {
            this.interactions.add(new SimpleInteraction(sequence1.getResidue(startPos + i), sequence2.getResidue(stopPos - i), new RnaInteractionType(1)));
        }
    }

    public SimpleStem(Sequence sequence1, Sequence sequence2) {
        this.sequence1 = sequence1;
        this.sequence2 = sequence2;
        this.interactions = new SimpleInteractionSet();
    }

    @Override
    public void add(Interaction interaction) {
        this.interactions.add(interaction);
        this.interactions.sort();
    }

    @Override
    public void clear() {
        this.interactions.clear();
        this.sequence1 = null;
        this.sequence2 = null;
    }

    @Override
    public Object clone() {
        SimpleStem stem = new SimpleStem();
        stem.sequence1 = this.sequence1;
        stem.sequence2 = this.sequence2;
        stem.interactions = (InteractionSet)this.interactions.clone();
        stem.energy = this.energy;
        return stem;
    }

    @Override
    public int compareTo(Stem otherStem) {
        double diff = this.getEnergy() - otherStem.getEnergy();
        if (diff < 0.0) {
            return -1;
        }
        if (diff > 0.0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Stem generateReverseStem() {
        SimpleStem result = new SimpleStem(this.getStopPos() - this.size() + 1, this.getStartPos() + this.size() - 1, this.size(), this.sequence2, this.sequence1);
        result.setEnergy(this.energy);
        return result;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Sequence getSequence1() {
        return this.sequence1;
    }

    @Override
    public Sequence getSequence2() {
        return this.sequence2;
    }

    @Override
    public boolean isComplementary() {
        assert (this.isValid());
        String s1 = this.getSequence1().sequenceString();
        String s2 = this.getSequence2().sequenceString();
        int start = this.getStartPos();
        int stop = this.getStopPos();
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            int p1 = start + i;
            int p2 = stop - i;
            if (RnaSecondaryTools.isWatsonCrick(s1.charAt(p1), s2.charAt(p2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConflicting(Stem other) {
        IntervalInt startInterval = new IntervalInt(this.getStartPos(), this.getStartPos() + this.size() - 1);
        IntervalInt stopInterval = new IntervalInt(this.getStopPos() - this.size() + 1, this.getStopPos());
        IntervalInt otherStartInterval = new IntervalInt(other.getStartPos(), other.getStartPos() + other.size() - 1);
        IntervalInt otherStopInterval = new IntervalInt(other.getStopPos() - other.size() + 1, other.getStopPos());
        if (this.getSequence1() == other.getSequence1() && startInterval.isOverlapping(otherStartInterval)) {
            return true;
        }
        if (this.getSequence1() == other.getSequence2() && startInterval.isOverlapping(otherStopInterval)) {
            return true;
        }
        if (this.getSequence2() == other.getSequence1() && stopInterval.isOverlapping(otherStartInterval)) {
            return true;
        }
        return this.getSequence2() == other.getSequence2() && stopInterval.isOverlapping(otherStopInterval);
    }

    @Override
    public boolean isValid() {
        return this.getStartPos() < this.sequence1.size() && this.getStopPos() < this.sequence2.size() && this.getStartPos() + (this.size() - 1) < this.sequence1.size() && this.getStopPos() - (this.size() - 1) >= 0;
    }

    public static boolean isValid(int _start, int _stop, int _length, int _len1, int _len2) {
        return _start < _len1 && _stop < _len2 && _start + (_length - 1) < _len1 && _stop - (_length - 1) >= 0;
    }

    @Override
    public boolean isSingleSequence() {
        return this.sequence1 == this.sequence2;
    }

    @Override
    public int size() {
        return this.interactions.size();
    }

    @Override
    public Interaction get(int n) {
        return this.interactions.get(n);
    }

    @Override
    public Residue getResidue1(int n) {
        return this.get(n).getResidue1();
    }

    @Override
    public Residue getResidue2(int n) {
        return this.get(n).getResidue2();
    }

    @Override
    public Residue getStartPos(int n) {
        return this.get(n).getResidue1();
    }

    @Override
    public Residue getStopPos(int n) {
        return this.get(n).getResidue2();
    }

    @Override
    public int getStartPos() {
        return this.get(0).getResidue1().getPos();
    }

    @Override
    public int getStopPos() {
        return this.get(0).getResidue2().getPos();
    }

    @Override
    public void read(InputStream is) {
    }

    @Override
    public void remove(Interaction interaction) {
        this.interactions.remove(interaction);
    }

    @Override
    public void setEnergy(double energy) {
        this.energy = energy;
    }

    @Override
    public void sort() {
        this.interactions.sort();
    }

    @Override
    public String toString() {
        String result = "(Stem " + this.sequence1.getName() + " " + this.sequence2.getName() + " ";
        result = result + (this.getStartPos() + 1) + " " + (this.getStopPos() + 1) + " " + this.interactions.size() + " )";
        return result;
    }
}

