/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.Randomizer;
import generaltools.SimplePropertyCarrier;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import rnasecondary.Interaction;
import rnasecondary.SecondaryStructure;
import secondarystructuredesign.CritonScorer;
import secondarystructuredesign.PackageConstants;
import secondarystructuredesign.RnacofoldSecondaryStructureScorer;
import secondarystructuredesign.SecondaryStructureScorer;
import secondarystructuredesign.SequenceOptimizer;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Residue;
import sequence.Sequence;

public class MonteCarloSequenceOptimizer3Step
extends SimplePropertyCarrier
implements SequenceOptimizer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private Alphabet alphabet = DnaTools.RNA_ALPHABET;
    private double errorScoreLimit = 0.0;
    private int iterMax = 500;
    private int iter2Max = 200;
    private int iter3Max = 500;
    private int rerun = 1;
    private double kt = 0.5;
    private double kt2 = 0.2;
    private double gcContent = 0.6;
    private boolean ignoreNotConstantMode = false;
    private double mismatchPenalty = 1.0;
    private double matchPenalty = 1.0;
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private double sameResiduePenalty = 0.2;
    private double midScoreWeight = 0.1;
    private double finalScoreWeight = 0.1;
    private Random rand = Randomizer.getInstance();
    private boolean randomizeFlag = true;
    private int[] nucleotideProbabilities;
    private static final int CHAR_HELP_SIZE = 100;
    private char[] nucleotideHelperChars;
    private SecondaryStructureScorer defaultScorer = new CritonScorer();
    private SecondaryStructureScorer midScorer = new RnacofoldSecondaryStructureScorer();
    private SecondaryStructureScorer finalScorer = new CritonScorer();

    public MonteCarloSequenceOptimizer3Step() {
        this.nucleotideProbabilities = new int[this.alphabet.size()];
        this.initProbabilities();
    }

    @Override
    public Properties eval(SecondaryStructure structure) {
        assert (false);
        return null;
    }

    private void initProbabilities() {
        this.nucleotideProbabilities[0] = (int)(100.0 * (1.0 - this.gcContent) / 2.0);
        this.nucleotideProbabilities[1] = (int)(100.0 * this.gcContent / 2.0);
        this.nucleotideProbabilities[2] = (int)(100.0 * this.gcContent / 2.0);
        this.nucleotideProbabilities[3] = (int)(100.0 * (1.0 - this.gcContent) / 2.0);
        int sum = 0;
        for (int i = 0; i < this.nucleotideProbabilities.length; ++i) {
            sum += this.nucleotideProbabilities[i];
        }
        this.nucleotideHelperChars = new char[sum];
        int pc = 0;
        for (int i = 0; i < this.nucleotideProbabilities.length; ++i) {
            int numChar = this.nucleotideProbabilities[i];
            for (int j = 0; j < numChar; ++j) {
                if (pc >= this.nucleotideHelperChars.length) assert (false);
                this.nucleotideHelperChars[pc++] = this.alphabet.getSymbol(i).getCharacter();
            }
        }
        if (pc != 100) {
            this.log.severe("Bad helper index: " + pc + " " + 100);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nucleotideHelperChars.length; ++i) {
            buf.append("" + this.nucleotideHelperChars[i]);
        }
        this.log.finest("Helper character array: " + buf.toString());
    }

    public SecondaryStructureScorer getDefaultScorer() {
        return this.defaultScorer;
    }

    @Override
    public double getErrorScoreLimit() {
        return this.errorScoreLimit;
    }

    public SecondaryStructureScorer getFinalScorer() {
        return this.finalScorer;
    }

    public boolean getIgnoreNotConstantMode() {
        return this.ignoreNotConstantMode;
    }

    public double getGcContent() {
        return this.gcContent;
    }

    public double getKt() {
        return this.kt;
    }

    @Override
    public int getIterMax() {
        return this.iterMax;
    }

    @Override
    public int getIter2Max() {
        return this.iter2Max;
    }

    public void setDefaultScorer(SecondaryStructureScorer scorer) {
        this.defaultScorer = scorer;
    }

    public void setMidScorer(SecondaryStructureScorer scorer) {
        this.midScorer = scorer;
    }

    public void setFinalScorer(SecondaryStructureScorer scorer) {
        this.finalScorer = scorer;
    }

    public void setMidScoreWeight(double w) {
        this.midScoreWeight = w;
    }

    public void setFinalScoreWeight(double w) {
        this.finalScoreWeight = w;
    }

    public void setGcContent(double x) {
        this.gcContent = x;
        this.initProbabilities();
    }

    @Override
    public void setErrorScoreLimit(double x) {
        this.errorScoreLimit = x;
    }

    public void setIgnoreNotConstantMode(boolean mode) {
        this.ignoreNotConstantMode = mode;
    }

    @Override
    public void setIterMax(int n) {
        this.iterMax = n;
    }

    @Override
    public void setIter2Max(int n) {
        this.iter2Max = n;
    }

    public void setIter3Max(int n) {
        this.iter3Max = n;
    }

    @Override
    public void setRerun(int n) {
        this.rerun = n;
    }

    public void setKt(double kt) {
        assert (kt > 0.0);
        this.kt = kt;
    }

    private char mutateCharacter(char c) {
        if (Character.isLowerCase(c)) {
            return c;
        }
        char result = c;
        while ((result = this.nucleotideHelperChars[this.rand.nextInt(this.nucleotideHelperChars.length)]) == c) {
        }
        return result;
    }

    private void randomizeSequence(StringBuffer buf) {
        int origLen = buf.length();
        for (int i = 0; i < buf.length(); ++i) {
            if (!Character.isUpperCase(buf.charAt(i))) continue;
            buf.setCharAt(i, this.mutateCharacter(buf.charAt(i)));
        }
        assert (buf.length() == origLen);
    }

    private String generateRandomWatsonCrick() {
        String result = "";
        result = this.rand.nextDouble() > this.gcContent ? "AU" : "CG";
        if (this.rand.nextDouble() > 0.5) {
            return "" + result.charAt(1) + result.charAt(0);
        }
        assert (result.length() == 2);
        return result;
    }

    private void randomizeSequences2(StringBuffer[] buf, int[][][][] interactionMatrices) {
        int i;
        for (i = 0; i < buf.length; ++i) {
            this.randomizeSequence(buf[i]);
        }
        for (i = 0; i < interactionMatrices.length; ++i) {
            for (int j = i; j < interactionMatrices[i].length; ++j) {
                if (interactionMatrices[i][j].length != buf[i].length()) {
                    this.log.warning("" + i + " " + j + " " + interactionMatrices[i][j].length + " " + buf[i].length());
                }
                assert (interactionMatrices[i][j].length == buf[i].length());
                for (int k = 0; k < interactionMatrices[i][j].length; ++k) {
                    assert (interactionMatrices[i][j][k].length == buf[j].length());
                    for (int m = 0; m < interactionMatrices[i][j][k].length; ++m) {
                        if (!Character.isUpperCase(buf[i].charAt(k)) || !Character.isUpperCase(buf[j].charAt(m)) || interactionMatrices[i][j][k][m] != 1) continue;
                        String randWC = this.generateRandomWatsonCrick();
                        buf[i].setCharAt(k, randWC.charAt(0));
                        buf[j].setCharAt(m, randWC.charAt(1));
                    }
                }
            }
        }
    }

    private String generateSequencesOutputString(StringBuffer[] bufs) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bufs.length; ++i) {
            result.append(bufs[i]);
            result.append(PackageConstants.NEWLINE);
        }
        return result.toString();
    }

    private Mutation generateMutation(StringBuffer[] bseqs) {
        int seqId = 0;
        int pos = 0;
        char newChar = 'N';
        char oldChar = 'N';
        while (Character.isLowerCase(oldChar = (char)bseqs[seqId = this.rand.nextInt(bseqs.length)].charAt(pos = this.rand.nextInt(bseqs[seqId].length())))) {
        }
        while ((newChar = (char)this.alphabet.getSymbol(this.rand.nextInt(this.alphabet.size())).getCharacter()) == oldChar) {
        }
        assert (Character.isUpperCase(bseqs[seqId].charAt(pos)));
        return new Mutation(seqId, pos, newChar);
    }

    private char generateWatsonCrickPartner(char c) {
        switch (c) {
            case 'A': {
                return 'U';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'U': {
                return 'A';
            }
        }
        assert (false);
        return 'N';
    }

    Mutation findMatchingMutation(Mutation mutation, int[][][][] interactionMatrices) {
        int j;
        int i;
        int seqId = mutation.getSeqId();
        int pos = mutation.getPos();
        char c = mutation.getCharacter();
        for (i = 0; i < seqId; ++i) {
            for (j = 0; j < interactionMatrices[i][seqId].length; ++j) {
                if (interactionMatrices[i][seqId][j][pos] != 1) continue;
                return new Mutation(i, j, this.generateWatsonCrickPartner(c));
            }
        }
        for (i = seqId + 1; i < interactionMatrices[seqId].length; ++i) {
            for (j = 0; j < interactionMatrices[seqId][i][pos].length; ++j) {
                if (interactionMatrices[seqId][i][pos][j] != 1) continue;
                return new Mutation(i, j, this.generateWatsonCrickPartner(c));
            }
        }
        return null;
    }

    private Mutation generateMatchingMutation(StringBuffer[] bseqs, Mutation prevMutation, int[][][][] interactionMatrices) {
        Mutation mut = this.findMatchingMutation(prevMutation, interactionMatrices);
        if (mut != null) {
            return mut;
        }
        int seqId = 0;
        int pos = 0;
        char newChar = 'N';
        char oldChar = 'N';
        while (Character.isLowerCase(oldChar = (char)bseqs[seqId = this.rand.nextInt(bseqs.length)].charAt(pos = this.rand.nextInt(bseqs[seqId].length())))) {
        }
        while ((newChar = (char)this.alphabet.getSymbol(this.rand.nextInt(this.alphabet.size())).getCharacter()) == oldChar) {
        }
        return new Mutation(seqId, pos, newChar);
    }

    private StringBuffer[] initStringBuffers2(SecondaryStructure structure, boolean randomizeFlag, int[][][][] interactionMatrices) {
        StringBuffer[] bseqs = new StringBuffer[structure.getSequenceCount()];
        for (int i = 0; i < bseqs.length; ++i) {
            Sequence sequence = structure.getSequence(i);
            bseqs[i] = new StringBuffer(sequence.sequenceString());
            for (int j = 0; j < bseqs[i].length(); ++j) {
                Residue res = sequence.getResidue(j);
                if ("fragment".equals(res.getProperty("sequence_status"))) {
                    bseqs[i].setCharAt(j, Character.toLowerCase(bseqs[i].charAt(j)));
                    continue;
                }
                if ("adhoc".equals(res.getProperty("sequence_status"))) {
                    bseqs[i].setCharAt(j, Character.toUpperCase(bseqs[i].charAt(j)));
                    continue;
                }
                this.log.warning("Residue status unknown: " + bseqs[i] + " " + res.getSymbol() + " " + (i + 1) + " " + (j + 1) + " : setting for optimizable (adhoc)");
                bseqs[i].setCharAt(j, Character.toUpperCase(bseqs[i].charAt(j)));
            }
        }
        if (randomizeFlag) {
            this.log.info("Randomizing sequences (2)!");
            this.randomizeSequences2(bseqs, interactionMatrices);
        }
        return bseqs;
    }

    private void applyMutation(Mutation mutation, StringBuffer[] bseqs) {
        if (Character.isUpperCase(bseqs[mutation.getSeqId()].charAt(mutation.getPos()))) {
            bseqs[mutation.getSeqId()].setCharAt(mutation.getPos(), mutation.getCharacter());
        }
    }

    int[][] generateInteractionMatrix(SecondaryStructure structure, int id1, int id2) {
        int i;
        Sequence seq1 = structure.getSequence(id1);
        Sequence seq2 = structure.getSequence(id2);
        int[][] result = new int[seq1.size()][seq2.size()];
        for (i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        for (i = 0; i < structure.getInteractionCount(); ++i) {
            Interaction interaction = structure.getInteraction(i);
            int pos1 = interaction.getResidue1().getPos();
            int pos2 = interaction.getResidue2().getPos();
            if (interaction.getSequence1() == seq1 && interaction.getSequence2() == seq2) {
                result[pos1][pos2] = interaction.getInteractionType().getSubTypeId();
                if (id1 != id2) continue;
                result[pos2][pos1] = result[pos1][pos2];
                continue;
            }
            if (interaction.getSequence2() != seq1 || interaction.getSequence1() != seq2) continue;
            result[pos2][pos1] = interaction.getInteractionType().getSubTypeId();
            assert (id1 != id2);
        }
        for (i = 0; i < result.length; ++i) {
            if (!"ignore".equals(seq1.getResidue(i).getProperty("seqstatus")) && (!this.ignoreNotConstantMode || !"fragment".equals(seq1.getResidue(i).getProperty("sequence_status")))) continue;
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = 0;
            }
        }
        for (i = 0; i < result[0].length; ++i) {
            if (!"ignore".equals(seq2.getResidue(i).getProperty("seqstatus")) && (!this.ignoreNotConstantMode || !"fragment".equals(seq2.getResidue(i).getProperty("sequence_status")))) continue;
            for (int j = 0; j < result.length; ++j) {
                result[j][i] = 0;
            }
        }
        return result;
    }

    int[][][][] generateInteractionMatrices(SecondaryStructure structure) {
        int[][][][] matrices = new int[structure.getSequenceCount()][structure.getSequenceCount()][0][0];
        for (int i = 0; i < structure.getSequenceCount(); ++i) {
            for (int j = i; j < structure.getSequenceCount(); ++j) {
                matrices[i][j] = this.generateInteractionMatrix(structure, i, j);
            }
        }
        return matrices;
    }

    private double optimizationTrial(StringBuffer[] bseqs, SecondaryStructure structure, double oldScore, int[][][][] interactionMatrices) {
        this.log.finest("Starting optimizationTrial: " + oldScore);
        Mutation mutation = this.generateMutation(bseqs);
        Mutation mutation2 = this.generateMatchingMutation(bseqs, mutation, interactionMatrices);
        boolean count = false;
        char oldCharacter = bseqs[mutation.getSeqId()].charAt(mutation.getPos());
        char oldCharacter2 = bseqs[mutation2.getSeqId()].charAt(mutation2.getPos());
        this.applyMutation(mutation, bseqs);
        this.applyMutation(mutation2, bseqs);
        double newScore = this.defaultScorer.scoreStructure(bseqs, structure, interactionMatrices);
        this.log.fine("new score: " + newScore);
        if (Math.exp(-(newScore - oldScore) / this.kt) < this.rand.nextDouble()) {
            mutation.setCharacter(oldCharacter);
            mutation2.setCharacter(oldCharacter2);
            this.applyMutation(mutation, bseqs);
            this.applyMutation(mutation2, bseqs);
            newScore = oldScore;
        } else if (newScore < oldScore) {
            this.log.finest("New score accepted: " + newScore + " " + oldScore);
        }
        this.log.finest("Finished optimizationTrial!");
        return newScore;
    }

    private double optimizationTrial2(StringBuffer[] bseqs, SecondaryStructure structure, double oldScore, int[][][][] interactionMatrices) {
        this.log.finest("Starting optimizationTrial: " + oldScore);
        Mutation mutation = this.generateMutation(bseqs);
        Mutation mutation2 = this.generateMatchingMutation(bseqs, mutation, interactionMatrices);
        char oldCharacter = bseqs[mutation.getSeqId()].charAt(mutation.getPos());
        char oldCharacter2 = bseqs[mutation2.getSeqId()].charAt(mutation2.getPos());
        this.applyMutation(mutation, bseqs);
        this.applyMutation(mutation2, bseqs);
        double newScore1 = this.defaultScorer.scoreStructure(bseqs, structure, interactionMatrices);
        double newScore2 = this.midScorer.scoreStructure(bseqs, structure, interactionMatrices);
        double newScore = newScore1 + this.finalScoreWeight * newScore2;
        this.log.info("new score: " + newScore + " " + newScore1 + " " + newScore2);
        if (Math.exp(-(newScore - oldScore) / this.kt2) < this.rand.nextDouble()) {
            mutation.setCharacter(oldCharacter);
            mutation2.setCharacter(oldCharacter2);
            this.applyMutation(mutation, bseqs);
            this.applyMutation(mutation2, bseqs);
            newScore = oldScore;
        } else if (newScore < oldScore) {
            this.log.finest("New score accepted: " + newScore + " " + oldScore);
        }
        this.log.finest("Finished optimizationTrial!");
        return newScore;
    }

    private double optimizationTrial3(StringBuffer[] bseqs, SecondaryStructure structure, double oldScore, int[][][][] interactionMatrices) {
        this.log.finest("Starting optimizationTrial: " + oldScore);
        Mutation mutation = this.generateMutation(bseqs);
        Mutation mutation2 = this.generateMatchingMutation(bseqs, mutation, interactionMatrices);
        boolean count = false;
        char oldCharacter = bseqs[mutation.getSeqId()].charAt(mutation.getPos());
        char oldCharacter2 = bseqs[mutation2.getSeqId()].charAt(mutation2.getPos());
        this.applyMutation(mutation, bseqs);
        this.applyMutation(mutation2, bseqs);
        double newScore = this.finalScorer.scoreStructure(bseqs, structure, interactionMatrices);
        this.log.fine("new score: " + newScore);
        if (Math.exp(-(newScore - oldScore) / this.kt) < this.rand.nextDouble()) {
            mutation.setCharacter(oldCharacter);
            mutation2.setCharacter(oldCharacter2);
            this.applyMutation(mutation, bseqs);
            this.applyMutation(mutation2, bseqs);
            newScore = oldScore;
        } else if (newScore < oldScore) {
            this.log.finest("New score accepted: " + newScore + " " + oldScore);
        }
        this.log.finest("Finished optimizationTrial!");
        return newScore;
    }

    boolean hasUpperCaseCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    boolean hasUpperCaseCharacters(StringBuffer[] bseqs) {
        for (int i = 0; i < bseqs.length; ++i) {
            if (!this.hasUpperCaseCharacters(bseqs[i].toString())) continue;
            return true;
        }
        return false;
    }

    private StringBuffer[] cloneBuffers(StringBuffer[] bufs) {
        assert (bufs != null);
        StringBuffer[] result = new StringBuffer[bufs.length];
        for (int i = 0; i < bufs.length; ++i) {
            result[i] = new StringBuffer(bufs[i].toString());
        }
        return result;
    }

    @Override
    public String[] optimize(SecondaryStructure structure) {
        int i;
        assert (this.finalScorer != null);
        this.log.info("Starting MonteCarloSequenceOptimizer3Step.optimize !");
        int rerunCount = 0;
        int[][][][] interactionMatrices = this.generateInteractionMatrices(structure);
        double errorScoreTotBest = 99999.0;
        double errorScoreBest = 1.0E10;
        double stage3Best = 99999.0;
        StringBuffer[] bseqsFinal = null;
        do {
            StringBuffer[] bseqs;
            double errorScore;
            if ((errorScore = this.defaultScorer.scoreStructure(bseqs = this.initStringBuffers2(structure, this.randomizeFlag, interactionMatrices), structure, interactionMatrices)) < errorScoreBest) {
                errorScoreBest = errorScore;
            }
            this.log.info("Starting optimization run " + (rerunCount + 1) + " with score : " + errorScore + " and sequences: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
            if (!this.hasUpperCaseCharacters(bseqs)) {
                this.log.warning("No residue can be optimized because they are all in lower case characters!");
                break;
            }
            int stage1Steps = 0;
            int stage2Steps = 0;
            int stage3Steps = 0;
            int i2 = 0;
            while (i2 < this.iterMax && errorScore > 0.0) {
                if ((errorScore = this.optimizationTrial(bseqs, structure, errorScore, interactionMatrices)) < errorScoreBest) {
                    errorScoreBest = errorScore;
                    this.log.info("New best sequence optimization (stage 1) score found at run " + (rerunCount + 1) + " and iteration " + (i2 + 1) + " " + errorScoreBest);
                }
                if (i2 % 100 == 0) {
                    System.out.println("Round " + (rerunCount + 1) + " : Sequences at stage 1 iteration " + (i2 + 1) + " and score: " + errorScore);
                    System.out.println(this.generateSequencesOutputString(bseqs));
                }
                if (errorScore <= this.errorScoreLimit) {
                    System.out.println("Scoring structure with stage 2 scorer");
                    double errorScore2 = this.midScorer.scoreStructure(bseqs, structure, interactionMatrices);
                    System.out.println("Done initial scoring!");
                    double errorScoreTot = errorScore + this.midScoreWeight * errorScore2;
                    this.log.info("Starting stage 2 of sequence optimization with error score:" + errorScore + " " + errorScore2 + " " + errorScoreTot);
                    int i22 = 0;
                    while (i22 < this.iter2Max) {
                        errorScoreTot = this.optimizationTrial2(bseqs, structure, errorScoreTot, interactionMatrices);
                        this.log.fine("Score of inner loop: " + errorScore + " " + errorScoreTot + " at round " + (rerunCount + 1) + " and iteration " + (i22 + 1));
                        if (errorScoreTot < errorScoreTotBest) {
                            this.log.info("Found new best sequences (stage2) with score: " + errorScoreTot + " at outer iteration " + (i2 + 1) + " and inner iteration: " + (i22 + 1));
                            errorScoreTotBest = errorScoreTot;
                            bseqsFinal = this.cloneBuffers(bseqs);
                        }
                        if (i22 % 10 == 0) {
                            System.out.println("Round " + (rerunCount + 1) + " : Sequences at stage 2 iteration " + (i22 + 1) + " and score: " + errorScoreTot);
                            System.out.println(this.generateSequencesOutputString(bseqs));
                        }
                        ++i22;
                        ++stage2Steps;
                    }
                    break;
                }
                ++i2;
                ++stage1Steps;
            }
            bseqs = this.cloneBuffers(bseqsFinal);
            int i3 = 0;
            while (i3 < this.iter3Max) {
                System.out.println("Entering final scoring stage");
                errorScore = this.optimizationTrial3(bseqs, structure, errorScore, interactionMatrices);
                if (errorScore < stage3Best) {
                    stage3Best = errorScore;
                    bseqsFinal = this.cloneBuffers(bseqs);
                    this.log.info("New best sequence optimization (stage 1) score found at run " + (rerunCount + 1) + " and iteration " + (i3 + 1) + " " + errorScore);
                }
                if (i3 % 100 == 0) {
                    System.out.println("Round " + (rerunCount + 1) + " : Sequences at stage 3 iteration " + (i3 + 1) + " and score: " + errorScore);
                    System.out.println(this.generateSequencesOutputString(bseqs));
                }
                ++i3;
                ++stage3Steps;
            }
            this.log.info("Ended optimization run after steps " + stage1Steps + " " + stage2Steps + " " + stage3Steps + " with strings: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqs));
        } while (++rerunCount < this.rerun);
        if (bseqsFinal == null) {
            this.log.warning("Sorry, no sequences that fullfill all optimization criteria found!");
            return null;
        }
        String[] result = new String[bseqsFinal.length];
        this.log.info("Best error score of all runs: " + errorScoreBest);
        this.log.info("Best error score 2 of all runs: " + errorScoreTotBest);
        this.log.info("Best error score of stage 3: " + stage3Best);
        this.log.info("Final strings: " + PackageConstants.NEWLINE + this.generateSequencesOutputString(bseqsFinal));
        for (i = 0; i < bseqsFinal.length; ++i) {
            result[i] = bseqsFinal[i].toString();
        }
        this.log.info("Finished MonteCarloSequenceOptimizer.optimize !");
        System.out.println("");
        System.out.println("Final optimized strands from MonteCarloSequenceOptimizer:");
        for (i = 0; i < result.length; ++i) {
            System.out.println(result);
        }
        System.out.println("");
        return result;
    }

    @Override
    public void setRandomizeFlag(boolean flag) {
        this.randomizeFlag = flag;
    }

    private class Mutation {
        private int seqId;
        private int pos;
        private char character;

        Mutation(int seqId, int pos, char character) {
            this.seqId = seqId;
            this.pos = pos;
            this.character = character;
        }

        int getPos() {
            return this.pos;
        }

        char getCharacter() {
            return this.character;
        }

        int getSeqId() {
            return this.seqId;
        }

        void setCharacter(char c) {
            this.character = c;
        }
    }
}

