/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import java.util.ResourceBundle;
import java.util.logging.Logger;

public class NupackTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesign");

    public static String[] findRelevantData(String[] lines) {
        int index = -1;
        for (int i = 0; i < lines.length; ++i) {
            String currLine = lines[i];
            if (currLine.charAt(0) == '%') continue;
            index = i;
            break;
        }
        assert (index >= 0 && index < lines.length);
        if (index == 0) {
            return lines;
        }
        String[] data = new String[lines.length - index];
        for (int i = index; i < lines.length; ++i) {
            data[i - index] = lines[i];
        }
        return data;
    }

    public static int findIndex(int[] complex, String[] data) {
        for (int i = 0; i < data.length; ++i) {
            String[] line = NupackTools.parseLine(data[i]);
            boolean matches = true;
            for (int n = 0; n < complex.length; ++n) {
                try {
                    if (Integer.parseInt(line[n + 1]) == complex[n]) continue;
                    matches = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Number format exception in line: " + data[i]);
                    System.out.println(nfe.getMessage());
                    System.out.println("Complex:");
                    for (int j = 0; j < complex.length; ++j) {
                        System.out.print(" " + complex[j]);
                    }
                    System.out.println();
                    assert (false);
                    continue;
                }
            }
            if (!matches) continue;
            return Integer.parseInt(line[0]);
        }
        return -1;
    }

    public static int[] findComplex(String[] data, int index) {
        String[] line = NupackTools.parseLine(data[index - 1]);
        int[] complex = new int[line.length - 2];
        for (int i = 1; i < line.length - 1; ++i) {
            complex[i - 1] = Integer.parseInt(line[i]);
        }
        return complex;
    }

    public static double findEnergy(int[] complex, String[] orderedData, String[] unorderedData) {
        int index = NupackTools.findIndex(complex, orderedData);
        return NupackTools.findEnergy(index, unorderedData);
    }

    private static double findEnergy(int index, String[] data) {
        assert (index > 0 && index <= data.length);
        String[] line = NupackTools.parseLine(data[index - 1]);
        String conc = line[line.length - 1];
        return NupackTools.parseSciNot(conc);
    }

    public static double findConcentration(int[] complex, String[] orderedData, String[] unorderedData) {
        int index = NupackTools.findIndex(complex, orderedData);
        return NupackTools.findConcentration(index, orderedData);
    }

    private static double findConcentration(int index, String[] data) {
        assert (index > 0 && index <= data.length);
        for (int i = 0; i < data.length; ++i) {
            String[] line = NupackTools.parseLine(data[i]);
            if (Integer.parseInt(line[0]) != index) continue;
            String concentration = line[line.length - 1];
            return NupackTools.parseSciNot(concentration);
        }
        return 0.0;
    }

    private static String[] parseLine(String line) {
        return line.split("\t");
    }

    private static double parseSciNot(String s) {
        String[] line = s.split("e");
        if (line.length == 1) {
            return Double.parseDouble(s);
        }
        double prefix = Double.parseDouble(line[0]);
        if (line[1].startsWith("+")) {
            line[1] = line[1].substring(1, line[1].length());
        }
        int exp = Integer.parseInt(line[1]);
        return prefix * Math.pow(10.0, exp);
    }

    public static String parseNupackMFEStructure(String[] nupackOutput, int index) {
        return NupackTools.parseNupackMFEStructure(nupackOutput, index, 1);
    }

    public static String parseNupackMFEStructure(String[] nupackOutput, int index, int order) {
        String line = "% complex" + index + "-order" + order;
        String structure = null;
        for (int i = 0; i < nupackOutput.length; ++i) {
            nupackOutput[i].trim();
            if (!nupackOutput[i].equals(line)) continue;
            structure = nupackOutput[i + 3];
            structure = structure.replace('+', '&');
            break;
        }
        if (structure == null) {
            System.out.println("Correct line not found");
        }
        return structure;
    }
}

