/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnasecondary.SecondaryStructure;
import rnasecondary.SimpleSecondaryStructurePredictor;
import secondarystructuredesign.AbstractSecondaryStructureScorer;
import sequence.DuplicateNameException;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;

public class SimpleSecondaryStructurePredictorScorer
extends AbstractSecondaryStructureScorer {
    private double scale = 1.0;
    private Level debugLevel = Level.FINE;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        UnevenAlignment ali;
        Properties resultProperties;
        block5: {
            resultProperties = new Properties();
            ali = null;
            try {
                ali = this.generateAlignment(bseqs);
            }
            catch (UnknownSymbolException use) {
                System.out.println(use.getMessage());
                assert (false);
            }
            catch (DuplicateNameException dne) {
                System.out.println(dne.getMessage());
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        log.log(this.debugLevel, "Starting SimpleSecondaryStructurePredictor...");
        SimpleSecondaryStructurePredictor predictor = new SimpleSecondaryStructurePredictor(ali);
        predictor.run();
        SecondaryStructure prediction = (SecondaryStructure)predictor.getResult();
        log.log(this.debugLevel, "Finished SimpleSecondaryStructurePredictor. Starting accuracy estimation...");
        double result = this.scorePrediction(prediction, structure, interactionMatrices);
        log.log(this.debugLevel, "Finished accuracy estimation with result: " + result);
        assert (result >= 0.0);
        resultProperties.setProperty("score", "" + result);
        return resultProperties;
    }
}

