/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import java.util.ArrayList;
import java.util.List;
import sequence.Alphabet;
import sequence.LetterSymbol;
import sequence.SimpleLetterSymbol;
import sequence.UnknownSymbolException;

public class SimpleAlphabet
implements Alphabet {
    int type = 2;
    private List<LetterSymbol> symbols = new ArrayList<LetterSymbol>();

    public SimpleAlphabet() {
    }

    public SimpleAlphabet(int type) {
        this.type = type;
    }

    public SimpleAlphabet(String letters) {
        for (int i = 0; i < letters.length(); ++i) {
            try {
                this.add(new SimpleLetterSymbol(letters.charAt(i), this));
                continue;
            }
            catch (UnknownSymbolException unknownSymbolException) {
                // empty catch block
            }
        }
    }

    public SimpleAlphabet(String letters, int type) {
        for (int i = 0; i < letters.length(); ++i) {
            try {
                this.add(new SimpleLetterSymbol(letters.charAt(i), this, true));
                continue;
            }
            catch (UnknownSymbolException e) {
                System.out.println("Unknown symbol: " + e.getMessage() + " : " + letters.charAt(i));
            }
        }
        this.type = type;
    }

    @Override
    public void add(LetterSymbol symbol) {
        this.symbols.add(symbol);
    }

    @Override
    public boolean contains(LetterSymbol symbol) {
        return this.symbols.contains(symbol);
    }

    @Override
    public boolean contains(char c) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getSymbol(i).getCharacter() != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public LetterSymbol getSymbol(int n) throws IndexOutOfBoundsException {
        return this.symbols.get(n);
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            result.append("" + this.getSymbol(i) + " ");
        }
        return result.toString();
    }
}

