/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import generaltools.StringTools;
import java.util.logging.Logger;
import sequence.Alphabet;
import sequence.LetterSymbol;
import sequence.UnknownSymbolException;

public class SimpleLetterSymbol
implements LetterSymbol {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private Alphabet alphabet;
    private char character;

    public SimpleLetterSymbol(char c, Alphabet alphabet) throws UnknownSymbolException {
        this.alphabet = alphabet;
        this.character = c;
        if (!alphabet.contains(c)) {
            throw new UnknownSymbolException("Unknown symbol: " + c);
        }
    }

    public SimpleLetterSymbol(char c, Alphabet alphabet, boolean allow) throws UnknownSymbolException {
        this.alphabet = alphabet;
        this.character = c;
        if (!allow && !alphabet.contains(c)) {
            throw new UnknownSymbolException("Unknown symbol: " + c);
        }
    }

    @Override
    public Object clone() {
        SimpleLetterSymbol newSymbol = null;
        try {
            newSymbol = new SimpleLetterSymbol(this.character, this.alphabet);
        }
        catch (UnknownSymbolException e) {
            log.warning("Warning: internal error in SimpleLetterSymbol.clone()!");
        }
        return newSymbol;
    }

    @Override
    public char getCharacter() {
        return this.character;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LetterSymbol) {
            LetterSymbol s = (LetterSymbol)other;
            return this.getCharacter() == s.getCharacter();
        }
        return false;
    }

    @Override
    public void setAlphabet(Alphabet alpbabet) {
        this.alphabet = this.alphabet;
    }

    @Override
    public void setCharacter(char c) {
        this.character = c;
    }

    @Override
    public String toString() {
        int type;
        String s = StringTools.stringFromChar(this.character);
        s = this.alphabet != null ? ((type = this.alphabet.getType()) == 2 ? s + " DNA" : (type == 1 ? s + " DNA_A" : (type == 4 ? s + " RNA" : (type == 3 ? s + " RNA_A" : (type == 5 ? s + " PROTEIN" : (type == 6 ? s + " DNA_RNA" : s + " UNKNOWN")))))) : s + " null";
        return s;
    }
}

