/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import generaltools.Namable;
import java.util.ArrayList;
import java.util.List;
import sequence.Alphabet;
import sequence.Residue;
import sequence.Sequence;
import sequence.SimpleLetterSymbol;
import sequence.SimpleResidue;
import sequence.UnknownSymbolException;

public class SimpleSequence
implements Sequence {
    private Alphabet alphabet;
    private Object parent = null;
    private String name;
    private double weight = 1.0;
    private List<Residue> sequence = new ArrayList<Residue>();

    private SimpleSequence() {
    }

    public SimpleSequence(String s, String name, Alphabet alphabet) throws UnknownSymbolException {
        this.alphabet = alphabet;
        this.name = name;
        for (int i = 0; i < s.length(); ++i) {
            SimpleResidue residue = new SimpleResidue(new SimpleLetterSymbol(s.charAt(i), alphabet), this, i);
            this.addResidue(residue);
        }
    }

    public SimpleSequence(String name, Alphabet alphabet) {
        this.alphabet = alphabet;
        this.name = name;
    }

    public List<Residue> getSequence() {
        return this.sequence;
    }

    @Override
    public void clear() {
        this.sequence.clear();
    }

    @Override
    public Object cloneDeep() {
        SimpleSequence seq = new SimpleSequence();
        seq.alphabet = this.alphabet;
        seq.parent = this.parent;
        seq.name = new String(this.name);
        seq.weight = this.weight;
        for (int i = 0; i < this.size(); ++i) {
            seq.addResidue((Residue)this.getResidue(i).cloneDeep());
        }
        return seq;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void addResidue(Residue residue) {
        Residue newResidue = residue;
        newResidue.setPos(this.size());
        newResidue.setParentObject(this);
        this.sequence.add(newResidue);
    }

    @Override
    public Residue getResidue(int n) throws IndexOutOfBoundsException {
        Residue r = this.sequence.get(n);
        return this.sequence.get(n);
    }

    @Override
    public Object getParentObject() {
        return this.parent;
    }

    public boolean isProbablyIdentical(Sequence other) {
        if (this.size() != other.size() || !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getParentObject() != null) {
            if (other.getParentObject() == null) {
                return false;
            }
            Object o1 = this.getParentObject();
            Object o2 = other.getParentObject();
            if (o1 instanceof Namable) {
                String otherParentName;
                if (!(o2 instanceof Namable)) {
                    return false;
                }
                String parentName = ((Namable)o1).getName();
                if (!parentName.equals(otherParentName = ((Namable)o2).getName())) {
                    return false;
                }
            }
        } else if (other.getParentObject() != null) {
            return false;
        }
        return this.sequenceString().equals(other.sequenceString());
    }

    public void removeChild(int n) {
        this.sequence.remove(n);
    }

    @Override
    public String sequenceString() {
        String s = new String();
        for (int i = 0; i < this.size(); ++i) {
            char c = this.getResidue(i).getSymbol().getCharacter();
            assert (c != 'B');
            s = s + c;
        }
        return s;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public void setParent(Object obj) {
        this.parent = obj;
    }

    @Override
    public int size() {
        return this.sequence.size();
    }

    public int getResidueCount() {
        return this.sequence.size();
    }

    public String getTypeString() {
        int type = this.alphabet.getType();
        if (type == 2) {
            return "DNA";
        }
        if (type == 1) {
            return "DNA_A";
        }
        if (type == 4) {
            return "RNA";
        }
        if (type == 3) {
            return "RNA_A";
        }
        return "UNKNOWN";
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public String toString() {
        String s = "(Sequence ";
        s = s + this.getName() + " ";
        s = s + this.getTypeString() + " ";
        s = s + this.sequenceString();
        s = s + " )";
        return s;
    }
}

