/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sequence.Alphabet;
import sequence.DuplicateNameException;
import sequence.Sequence;
import sequence.SimpleSequence;
import sequence.UnevenAlignment;
import sequence.UnknownSequenceException;
import sequence.UnknownSymbolException;

public class SimpleUnevenAlignment
implements UnevenAlignment {
    private List<Sequence> list = new ArrayList<Sequence>();
    private Map<String, Integer> map = new HashMap<String, Integer>();

    public SimpleUnevenAlignment() {
    }

    public SimpleUnevenAlignment(Collection<Sequence> sequences) throws DuplicateNameException {
        Iterator<Sequence> it = sequences.iterator();
        while (it.hasNext()) {
            this.addSequence(it.next());
        }
    }

    public SimpleUnevenAlignment(String[] lines, Alphabet alphabet) throws DuplicateNameException, UnknownSymbolException {
        boolean fastaMode = false;
        int startLine = 0;
        int stride = 1;
        if (lines[0].charAt(0) == '>') {
            fastaMode = true;
            startLine = 1;
            stride = 2;
        }
        int sCount = 0;
        for (int i = startLine; i < lines.length; i += stride) {
            String name = null;
            name = fastaMode ? lines[i - 1].substring(1, lines[i - 1].length()).trim() : "s" + (sCount + 1);
            this.addSequence(new SimpleSequence(lines[i].trim(), name, alphabet));
            ++sCount;
        }
    }

    @Override
    public void addSequence(Sequence sequence) throws DuplicateNameException {
        if (this.getIndex(sequence.getName()) >= 0) {
            throw new DuplicateNameException("Sequence name already exists: " + sequence.getName());
        }
        this.list.add(sequence);
        this.update();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Sequence getSequence(int n) throws IndexOutOfBoundsException {
        return this.list.get(n);
    }

    @Override
    public int getIndex(String name) {
        Integer in = this.map.get(name);
        if (in == null) {
            return -1;
        }
        return in;
    }

    @Override
    public Sequence getSequence(String name) throws UnknownSequenceException {
        return this.getSequence(this.getIndex(name));
    }

    @Override
    public void read(InputStream is) {
    }

    @Override
    public int getSequenceCount() {
        return this.list.size();
    }

    @Override
    public int getTotalResidueCount() {
        int result = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            result += this.getSequence(i).size();
        }
        return result;
    }

    @Override
    public void setWeights(double[] weights) {
        assert (weights.length == this.getSequenceCount());
        for (int i = 0; i < weights.length; ++i) {
            this.getSequence(i).setWeight(weights[i]);
        }
    }

    @Override
    public String toString() {
        String result = "(UnevenAlignment " + this.getSequenceCount() + " ";
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            result = result + this.getSequence(i) + " ";
        }
        result = result + ")";
        return result;
    }

    public void update() {
        this.map.clear();
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            this.map.put(this.getSequence(i).getName(), new Integer(i));
        }
    }
}

