/*
 * Decompiled with CFR 0.152.
 */
package statisticstools;

import generaltools.StringTools;
import java.util.List;
import statisticstools.AbstractScraper;

public class RSpearmanScraper
extends AbstractScraper {
    public RSpearmanScraper(List<String> lines) {
        super(lines);
        this.parse();
        this.setName("spearman");
    }

    public RSpearmanScraper(String[] linesOrig) {
        this(StringTools.convertArrayToList(linesOrig));
    }

    @Override
    protected void parse() {
        String[] words;
        int i;
        assert (this.lines != null);
        int lastLine = 0;
        for (i = 0; i < this.lines.size(); ++i) {
            lastLine = i;
            words = ((String)this.lines.get(i)).split(" ");
            if (words.length != 6 || !words[3].equals("p-value")) continue;
            try {
                this.setPValue(Double.parseDouble(words[5]));
                this.errorMessage = "";
                break;
            }
            catch (NumberFormatException nfe) {
                this.errorMessage = nfe.getMessage();
                assert (this.errorMessage != null && this.errorMessage.length() > 0);
                break;
            }
        }
        if (this.errorMessage == null || this.errorMessage.length() == 0) {
            for (i = lastLine + 1; i < this.lines.size(); ++i) {
                words = ((String)this.lines.get(i)).trim().split(" ");
                if (words.length != 2 || !words[0].equals("sample") || !words[1].equals("estimates:") || i + 2 >= this.lines.size()) continue;
                this.setProperty("estimate_method", ((String)this.lines.get(i + 1)).trim());
                try {
                    this.setProperty("estimate", "" + Double.parseDouble(((String)this.lines.get(i + 2)).trim()));
                    break;
                }
                catch (NumberFormatException nfe) {
                    this.errorMessage = "Error parsing correlation coefficient value: " + nfe.getMessage();
                    assert (this.errorMessage != null && this.errorMessage.length() > 0);
                    break;
                }
            }
        }
        assert (!this.validate() || this.getProperty("estimate") != null);
    }
}

