/*
 * Decompiled with CFR 0.152.
 */
package symmetry;

import generaltools.ParsingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import symmetry.Ccp4SpaceGroupParser;
import symmetry.SpaceGroup;
import symmetry.SpaceGroupConvention;
import symmetry.SpaceGroupFactory;
import symmetry.SymmetryException;

public class Ccp4SpaceGroupFactory
implements SpaceGroupFactory {
    private SpaceGroup[] spaceGroups;
    private Logger log = Logger.getLogger("NanoTiler_debug");

    public Ccp4SpaceGroupFactory() {
    }

    public Ccp4SpaceGroupFactory(InputStream is) throws IOException, ParsingException {
        this.init(is);
    }

    @Override
    public void init(InputStream is) throws IOException, ParsingException {
        Ccp4SpaceGroupParser parser = new Ccp4SpaceGroupParser();
        this.spaceGroups = parser.parse(is);
        assert (this.isValid());
    }

    @Override
    public SpaceGroup generate(int number) throws SymmetryException {
        if (!this.isValid()) {
            throw new SymmetryException("No space group definitions read yet!");
        }
        boolean found = false;
        for (int i = 0; i < this.spaceGroups.length; ++i) {
            System.out.println("Trying number " + this.spaceGroups[i].getNumber() + " " + number);
            if (this.spaceGroups[i].getNumber() != number) continue;
            found = true;
            return (SpaceGroup)this.spaceGroups[i].clone();
        }
        if (!found) {
            throw new SymmetryException("Invalid symmetry group number!");
        }
        return null;
    }

    @Override
    public SpaceGroup generate(String name) throws SymmetryException {
        return this.generate(name, 0);
    }

    @Override
    public SpaceGroup generate(String name, int conventionId) throws SymmetryException {
        if (!this.isValid()) {
            throw new SymmetryException("No space group definitions read yet!");
        }
        if (conventionId < 0 || conventionId >= SpaceGroupConvention.COUNT) {
            throw new SymmetryException("Illegal symmetry group convention id!");
        }
        boolean found = false;
        for (int i = 0; i < this.spaceGroups.length; ++i) {
            if (!this.spaceGroups[i].getName(conventionId).equals(name)) continue;
            return (SpaceGroup)this.spaceGroups[i].clone();
        }
        if (!found) {
            throw new SymmetryException("Invalid symmetry group name!");
        }
        return null;
    }

    @Override
    public SpaceGroup generate(String name, String conventionName) throws SymmetryException {
        int conventionId = SpaceGroupConvention.findConventionId(conventionName);
        return this.generate(name, conventionId);
    }

    @Override
    public boolean isValid() {
        if (this.spaceGroups == null) {
            this.log.warning("Space group array is null!");
            return false;
        }
        if (this.spaceGroups.length == 0) {
            this.log.warning("No space groups defined!");
            return false;
        }
        boolean found = false;
        for (int i = 0; i < this.spaceGroups.length; ++i) {
            if (this.spaceGroups[i] == null) continue;
            found = true;
            if (this.spaceGroups[i].isValid()) continue;
            this.log.info("Invalid space group found: " + this.spaceGroups[i].toString());
            return false;
        }
        if (!found) {
            this.log.warning("All space groups were zero!");
        }
        return found;
    }
}

