/*
 * Decompiled with CFR 0.152.
 */
package symmetry;

import symmetry.Cell;
import tools3d.Vector3D;

public class DefaultCell
implements Cell {
    public static final double DEFAULT_LENGTH = 100.0;
    public static final double DEFAULT_ANGLE = 1.5707963267948966;
    private double a;
    private double b;
    private double c;
    private double alpha;
    private double beta;
    private double gamma;
    private Vector3D x;
    private Vector3D y;
    private Vector3D z;

    public DefaultCell() {
        this.a = 100.0;
        this.b = 100.0;
        this.c = 100.0;
        this.alpha = 1.5707963267948966;
        this.beta = 1.5707963267948966;
        this.gamma = 1.5707963267948966;
        this.updateXyz();
    }

    public DefaultCell(double a, double b, double c, double alpba, double beta, double gamma) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.alpha = this.alpha;
        this.beta = beta;
        this.gamma = gamma;
        this.updateXyz();
    }

    @Override
    public double getA() {
        return this.a;
    }

    @Override
    public double getB() {
        return this.b;
    }

    @Override
    public double getC() {
        return this.c;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public double getBeta() {
        return this.beta;
    }

    @Override
    public double getGamma() {
        return this.gamma;
    }

    @Override
    public void setA(double a) {
        this.a = a;
        this.updateXyz();
    }

    @Override
    public void setB(double b) {
        this.b = b;
        this.updateXyz();
    }

    @Override
    public void setC(double c) {
        this.c = c;
        this.updateXyz();
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.updateXyz();
    }

    @Override
    public void setBeta(double beta) {
        this.beta = beta;
        this.updateXyz();
    }

    @Override
    public void setGamma(double gamma) {
        this.gamma = gamma;
        this.updateXyz();
    }

    @Override
    public String toString() {
        return "CELL " + this.a + " " + this.b + " " + this.c + " " + 57.29577951308232 * this.alpha + " " + 57.29577951308232 * this.beta + " " + 57.29577951308232 * this.gamma;
    }

    private void updateXyz() {
        Vector3D zero = new Vector3D(0.0, 0.0, 0.0);
        this.x = new Vector3D(this.getA(), 0.0, 0.0);
        this.y = new Vector3D(this.getB() * Math.cos(this.getGamma()), this.getB() * Math.sin(this.getGamma()), 0.0);
        double zxh = Math.cos(this.getBeta());
        double zyh = Math.cos(this.getAlpha()) * Math.sin(this.getGamma());
        double zzh = Math.sqrt(1.0 - zxh * zxh - zyh * zyh);
        this.z = new Vector3D(zxh, zyh, zzh);
        this.z.scale(this.getC());
    }

    @Override
    public Vector3D getX() {
        return this.x;
    }

    @Override
    public Vector3D getY() {
        return this.y;
    }

    @Override
    public Vector3D getZ() {
        return this.z;
    }
}

