/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.AbstractGeometryElement;
import tools3d.CoordinateSystem;
import tools3d.Point3D;
import tools3d.Vector3D;

public class Edge3D
extends AbstractGeometryElement {
    private Vector3D first;
    private Vector3D second;

    public Edge3D(Vector3D first, Vector3D second) {
        this.first = new Vector3D(first);
        this.second = new Vector3D(second);
        Vector3D pos = first.plus(second);
        pos.scale(0.5);
        this.setPosition(pos);
    }

    public Edge3D(Point3D first, Point3D second) {
        this.first = new Vector3D(first.getPosition());
        this.second = new Vector3D(second.getPosition());
        Vector3D pos = first.getPosition().plus(second.getPosition());
        pos.scale(0.5);
        this.setPosition(pos);
    }

    private Edge3D(Edge3D other) {
        this(other.getFirst(), other.getSecond());
    }

    @Override
    public void activeTransform(CoordinateSystem cs) {
        super.activeTransform(cs);
        this.first = cs.activeTransform(this.first);
        this.second = cs.activeTransform(this.second);
    }

    @Override
    public Object cloneDeep() {
        Edge3D edge = new Edge3D(this);
        edge.superCopy(this);
        return edge;
    }

    private void superCopy(Edge3D other) {
        super.copy(other);
    }

    public Vector3D getFirst() {
        return this.first;
    }

    public Vector3D getSecond() {
        return this.second;
    }

    public boolean isAdjacent(Edge3D other) {
        return this.first.equals(other.getFirst()) || this.first.equals(other.getSecond()) || this.second.equals(other.getFirst()) || this.second.equals(other.getSecond());
    }

    public Vector3D findAdjacent(Edge3D other) {
        if (this.first.equals(other.getFirst())) {
            return this.first;
        }
        if (this.first.equals(other.getSecond())) {
            return this.first;
        }
        if (this.second.equals(other.getFirst())) {
            return this.first;
        }
        if (this.second.equals(other.getSecond())) {
            return this.first;
        }
        return null;
    }

    @Override
    public void translate(Vector3D shift) {
        this.position.add(shift);
        this.first.add(shift);
        this.second.add(shift);
    }
}

