/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.Vector;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import tools3d.PackageConstants;
import tools3d.Point;
import tools3d.Vector2;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.SimpleLink;

public class Junction {
    private Point centerPoint = new Point("overwrite", 0.0, 0.0, 0.0);
    private String name = "";
    private Vector<Link> links = new Vector();
    private Vector<Point> points = new Vector();
    private Vector<Vector2> vectors = new Vector();
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public Junction() {
    }

    public Junction(String name) {
        this.setName(name);
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addLink(Point point1, Point point2) {
        SimpleLink link = new SimpleLink("name", point1, point2);
        this.addLink(link);
    }

    @Test
    public void testAddLink() {
        Junction testJunction = new Junction();
        SimpleLink testLink = new SimpleLink("link", new Point(0.0, 0.0, 0.0), new Point(100.0, 100.0, 100.0));
        int index = 0;
        assert (testJunction.getNumLinks() == 0);
        testJunction.addLink(testLink);
        assert (testJunction.getLink(index).equals(testLink));
        testJunction = new Junction();
        assert (testJunction.getNumLinks() == 0);
        testJunction.addLink(new Point(0.0, 0.0, 0.0), new Point(100.0, 100.0, 100.0));
        assert (testJunction.getLink(index).getObj1().getName().equals(testLink.getObj1().getName()));
        assert (testJunction.getLink(index).getObj1().getPosition().equals(testLink.getObj1().getPosition()));
        assert (testJunction.getLink(index).getObj2().getName().trim().equals(testLink.getObj2().getName().trim()));
        assert (testJunction.getLink(index).getObj2().getPosition().equals(testLink.getObj2().getPosition()));
    }

    public void addPoint(Point point) {
        this.points.add(point);
        if (point.getCenterPoint()) {
            this.centerPoint = point;
        }
    }

    @Test
    public void testAddPoint() {
        Junction testJunction = new Junction();
        Point testPoint = new Point("testPoint", 10.0, 10.0, 10.0, true);
        int index = 0;
        assert (testJunction.getNumPoints() == 0);
        testJunction.addPoint(testPoint);
        assert (testJunction.getPoint(index).equals(testPoint));
        assert (testJunction.getPoint(index).getCenterPoint());
    }

    public void addVector(Vector2 vector) {
        this.vectors.add(vector);
    }

    public void addVector(Point point, Point vectorPoint) {
        this.vectors.add(new Vector2(point, vectorPoint));
    }

    @Test
    public void testAddVector() {
        Junction testJunction = new Junction();
        Vector2 testVector = new Vector2(new Point("origPoint", 10.0, 10.0, 10.0), new Point("vectorPoint", 100.0, 100.0, 100.0));
        int index = 0;
        testJunction.addVector(testVector);
        assert (testJunction.getVector(index).equals(testVector));
        testJunction = new Junction();
        assert (testJunction.getNumVectors() == 0);
        testJunction.addVector(new Point("origPoint", 10.0, 10.0, 10.0), new Point("vectorPoint", 100.0, 100.0, 100.0));
        assert (testJunction.getVector(index).equals(testVector));
    }

    public Object cloneDeep() {
        Junction newJunction = new Junction();
        newJunction.copyDeepThisCore(this);
        assert (newJunction.getNumPoints() == this.getNumPoints());
        return newJunction;
    }

    @Test
    public void testCloneDeep() {
        Junction testJunction = new Junction("junction");
        Point testPoint1 = new Point("testPoint1", 0.0, 0.0, 0.0);
        testJunction.addPoint(testPoint1);
        Point testPoint2 = new Point("testPoint2", 100.0, 100.0, 100.0);
        testJunction.addPoint(testPoint2);
        testJunction.addLink(testPoint1, testPoint2);
        testJunction.addVector(testPoint1, testPoint2);
        Junction newJunction = new Junction();
        newJunction = (Junction)testJunction.cloneDeep();
        assert (testJunction.getName().equals(newJunction.getName()));
        assert (testJunction.getPoint(0).equals(newJunction.getPoint(0)));
        assert (testJunction.getPoint(1).equals(newJunction.getPoint(1)));
        assert (testJunction.getLink(0).equals(newJunction.getLink(0)));
        assert (testJunction.getVector(0).equals(newJunction.getVector(0)));
    }

    public boolean containsPoint(Vector3D v) {
        Point point = new Point(v.getX(), v.getY(), v.getZ());
        boolean found = false;
        int i = -1;
        log.info("" + found + "" + this.getNumPoints());
        while (!found && i++ < this.getNumPoints()) {
            log.fine("testing: " + this.points.get(i));
            if (!this.points.get(i).isSimilarTo(point)) continue;
            found = true;
        }
        return found;
    }

    @Test
    public void testContainsPoint() {
        Junction testJunction = new Junction();
        testJunction.addPoint(new Point("testPoint", 0.0, 0.0, 0.0));
        assert (testJunction.containsPoint(new Vector3D(0.0, 0.0, 0.0)));
    }

    protected void copyDeepThisCore(Junction jToCopy) {
        this.setName(jToCopy.getName());
        this.setCenterPoint(jToCopy.getCenterPoint());
        Vector<Point> newPoints = new Vector<Point>();
        for (int i = 0; i < jToCopy.getNumPoints(); ++i) {
            newPoints.add((Point)jToCopy.getPoint(i).cloneDeep());
            assert (((Point)newPoints.get(i)).equals(jToCopy.getPoint(i)));
        }
        this.points = newPoints;
        Vector<Link> newLinks = new Vector<Link>();
        for (int i = 0; i < jToCopy.getNumLinks(); ++i) {
            newLinks.add((Link)jToCopy.getLink(i).clone());
            assert (((Link)newLinks.get(i)).equals(jToCopy.getLink(i)));
        }
        this.links = newLinks;
        Vector<Vector2> newVectors = new Vector<Vector2>();
        for (int i = 0; i < jToCopy.getNumVectors(); ++i) {
            newVectors.add((Vector2)jToCopy.getVector(i).cloneDeep());
            assert (((Vector2)newVectors.get(i)).equals(jToCopy.getVector(i)));
        }
        this.vectors = newVectors;
    }

    public Point getCenterPoint() {
        if (this.centerPoint.getName().equals("overwrite")) {
            Point bestGuess = new Point();
            for (int i = 0; i < this.getNumPoints(); ++i) {
                Point point = this.getPoint(i);
                if (point.getNumNeighbors() <= bestGuess.getNumNeighbors()) continue;
                bestGuess = (Point)point.cloneDeep();
            }
            return bestGuess;
        }
        return this.centerPoint;
    }

    @Test
    public void testGetCenterPoint() {
        Junction testJunction = new Junction("testJunction");
        Point testPoint = new Point("centerPoint", 0.0, 0.0, 0.0, true);
        testJunction.addPoint(testPoint);
        assert (testJunction.getCenterPoint().equals(testPoint));
        assert (testJunction.getCenterPoint().getCenterPoint());
    }

    public Link getLink(int index) {
        return this.links.get(index);
    }

    public Link getLink(String linkName) {
        try {
            return this.getLink(this.getLinkIndex(linkName));
        }
        catch (Object3DIOException e) {
            return new SimpleLink();
        }
    }

    @Test
    public void testGetLink() {
        Junction testJunction = new Junction("testJunction");
        SimpleLink testLink = new SimpleLink("testLink", new Point(0.0, 0.0, 0.0), new Point(100.0, 100.0, 100.0));
        int index = 0;
        testJunction.addLink(testLink);
        assert (testJunction.getLink(index).equals(testLink));
        assert (testJunction.getLink("testLink").equals(testLink));
    }

    public int getLinkIndex(String linkName) throws Object3DIOException {
        int index = -1;
        boolean indexFound = false;
        for (int i = 0; i < this.getNumLinks(); ++i) {
            if (!this.links.get(i).getName().equals(linkName)) continue;
            indexFound = true;
            index = i;
        }
        if (!indexFound) {
            throw new Object3DIOException("Link: " + linkName + " could not be found.");
        }
        return index;
    }

    @Test
    public void testGetLinkIndex() {
        Junction testJunction = new Junction("testJunction");
        SimpleLink testLink = new SimpleLink("testLink", new Point(0.0, 0.0, 0.0), new Point(100.0, 100.0, 100.0));
        int index = 0;
        testJunction.addLink(testLink);
        try {
            assert (this.getLinkIndex("testLink") == index);
        }
        catch (Object3DIOException e) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    @Test
    public void testGetName() {
        Junction testJunction = new Junction("testJunction");
        assert (testJunction.getName().equals("testJunction"));
    }

    public int getNumLinks() {
        return this.links.size();
    }

    @Test
    public void testGetNumLinks() {
        Junction testJunction = new Junction("testJunction");
        SimpleLink testLink1 = new SimpleLink("testLink1", new Point("point1", 0.0, 0.0, 0.0), new Point("point2", 10.0, 10.0, 10.0));
        SimpleLink testLink2 = new SimpleLink("testLink2", new Point("point2", 10.0, 10.0, 10.0), new Point("point3", 20.0, 20.0, 20.0));
        int numLinks = 2;
        testJunction.addLink(testLink1);
        testJunction.addLink(testLink2);
        assert (testJunction.getNumLinks() == numLinks);
    }

    public int getNumPoints() {
        return this.points.size();
    }

    @Test
    public void testGetNumPoints() {
        Junction testJunction = new Junction();
        int numPoints = 3;
        testJunction.addPoint(new Point("point1", 0.0, 0.0, 0.0));
        testJunction.addPoint(new Point("point2", 10.0, 10.0, 10.0));
        testJunction.addPoint(new Point("point3", 20.0, 20.0, 20.0));
        assert (testJunction.getNumPoints() == numPoints);
    }

    public int getNumVectors() {
        return this.vectors.size();
    }

    @Test
    public void testGetNumVectors() {
        Junction testJunction = new Junction();
        int numVectors = 2;
        testJunction.addVector(new Point(0.0, 0.0, 0.0), new Point(10.0, 10.0, 10.0));
        testJunction.addVector(new Point(10.0, 10.0, 10.0), new Point(20.0, 20.0, 20.0));
        assert (testJunction.getNumVectors() == numVectors);
    }

    public Point getPoint(int index) {
        return this.points.get(index);
    }

    public Point getPoint(String pointName) {
        try {
            return this.getPoint(this.getPointIndex(pointName));
        }
        catch (Object3DIOException e) {
            log.severe("Point with name: " + pointName + " was not found!");
            return new Point();
        }
    }

    @Test
    public void testGetPoint() {
        Junction testJunction = new Junction();
        Point testPoint = new Point("testPoint", 0.0, 0.0, 0.0);
        int index = 0;
        testJunction.addPoint(testPoint);
        assert (testJunction.getPoint(index).equals(testPoint));
        assert (testJunction.getPoint("testPoint").equals(testPoint));
    }

    public int getPointIndex(String pointName) throws Object3DIOException {
        int i = -1;
        boolean indexFound = false;
        while (!indexFound && i < this.points.size() - 1) {
            if (!this.points.get(++i).getName().equals(pointName)) continue;
            indexFound = true;
        }
        if (!indexFound) {
            log.severe("Point with name: " + pointName + " could not be found!");
            throw new Object3DIOException("Point: " + pointName + " could not be found.");
        }
        return i;
    }

    @Test
    public void testGetPointIndex() {
        Junction testJunction = new Junction();
        int index = 0;
        testJunction.addPoint(new Point("testPoint", 0.0, 0.0, 0.0));
        try {
            assert (testJunction.getPointIndex("testPoint") == index);
        }
        catch (Object3DIOException e) {
            assert (false);
            log.severe("Point index was not found.");
        }
    }

    public Vector2 getVector(int index) {
        return this.vectors.get(index);
    }

    public Vector2 getVector(Point point) throws Object3DIOException {
        for (int i = 0; i < this.getNumVectors(); ++i) {
            Vector2 vector = this.getVector(i);
            if (!vector.containsPoint(point)) continue;
            return vector;
        }
        throw new Object3DIOException("The Vector2 with " + point + " was not found.");
    }

    @Test
    public void testGetVector() {
        int index = 0;
        Junction testJunction = new Junction();
        Vector2 testVector = new Vector2(new Point(0.0, 0.0, 0.0), new Point(100.0, 100.0, 100.0));
        testJunction.addVector(testVector);
        assert (testJunction.getVector(index).equals(testVector));
    }

    public void rotate(Vector3D start, Vector3D axis, double angle) {
        Point point;
        int i;
        this.centerPoint.getVector3D().rotate(start, axis, angle);
        for (i = 0; i < this.getNumPoints(); ++i) {
            Vector3D vector3d = ((Point)this.getPoint(i).cloneDeep()).getVector3D();
            vector3d.rotate(start, axis, angle);
            point = new Point(this.getPoint(i).getName(), vector3d.getX(), vector3d.getY(), vector3d.getZ(), this.getPoint(i).getCenterPoint());
            this.points.setElementAt(point, i);
        }
        for (i = 0; i < this.getNumLinks(); ++i) {
            Link link = (Link)this.getLink(i).clone();
            link.getObj1().rotate(start, axis, angle);
            link.getObj2().rotate(start, axis, angle);
            this.links.setElementAt(link, i);
        }
        for (i = 0; i < this.getNumVectors(); ++i) {
            Vector2 vector = (Vector2)this.getVector(i).cloneDeep();
            point = (Point)vector.getPoint().cloneDeep();
            Point vectorPoint = (Point)vector.getVectorPoint().cloneDeep();
            point.rotate(start, axis, angle);
            vectorPoint.rotate(start, axis, angle);
            Vector2 newVector = new Vector2(point, vectorPoint);
            this.vectors.setElementAt(newVector, i);
        }
    }

    @Test
    public void testRotate() {
        Junction testJunction = new Junction("testJunction");
        Point point1 = new Point("point1", 0.0, 0.0, 0.0, true);
        Point point2 = new Point("point2", 1.0, 1.0, 1.0);
        Point vectorPoint = new Point("vectorPoint", 2.0, 2.0, 2.0);
        SimpleLink link = new SimpleLink(point1.toObject3D(), point2.toObject3D());
        Vector2 vector = new Vector2(point1, vectorPoint);
        testJunction.addPoint(point1);
        testJunction.addPoint(point2);
        testJunction.addLink(link);
        testJunction.addVector(vector);
        testJunction.rotate(new Vector3D(0.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), Math.PI);
        assert (testJunction.getCenterPoint().equals(point1));
        assert (testJunction.getPoint(0).similar(point1));
        assert (testJunction.getPoint(1).similar(new Point(-1.0, 1.0, -1.0)));
        assert (testJunction.getLink(0).getObj1().getPosition().similar(point1.getVector3D()));
        assert (testJunction.getLink(0).getObj2().getPosition().similar(new Point(-1.0, 1.0, -1.0).getVector3D()));
        assert (testJunction.getVector(0).equals(new Vector2(point1, new Point("vectorPoint", -2.0, 2.0, -2.0))));
    }

    public void setCenterPoint(Point centerPoint) {
        if (this.centerPoint.getName().equals("overwrite")) {
            this.centerPoint = centerPoint;
        } else {
            if (this.centerPoint.equals(centerPoint)) {
                return;
            }
            assert (false);
        }
    }

    @Test
    public void testSetCenterPoint() {
        Junction testJunction = new Junction();
        Point centerPoint = new Point("centPoint", 0.0, 0.0, 0.0, true);
        testJunction.setCenterPoint(centerPoint);
        assert (testJunction.getCenterPoint().equals(centerPoint));
    }

    public void setName(String name) {
        this.name = name;
    }

    @Test
    public void testSetName() {
        Junction testJunction = new Junction();
        testJunction.setName("testJunction");
        assert (testJunction.getName().equals("testJunction"));
    }

    public String toString() {
        int i;
        String s = new String("Junction " + this.getName() + PackageConstants.NEWLINE + "Points:" + PackageConstants.NEWLINE);
        for (i = 0; i < this.getNumPoints(); ++i) {
            s = s + "   " + this.getPoint(i) + PackageConstants.NEWLINE;
        }
        s = s + "Links:" + PackageConstants.NEWLINE;
        for (i = 0; i < this.getNumLinks(); ++i) {
            s = s + "   " + this.getLink(i) + PackageConstants.NEWLINE;
        }
        s = s + "Vectors:" + PackageConstants.NEWLINE;
        for (i = 0; i < this.getNumVectors(); ++i) {
            s = s + "   " + this.getVector(i) + PackageConstants.NEWLINE;
        }
        return s;
    }

    public void testToString() {
        Junction testJunction = new Junction();
        testJunction.setName("testJunction");
        Point point1 = new Point("point1", 0.0, 0.0, 0.0, true);
        Point point2 = new Point("point2", 100.0, 100.0, 100.0);
        testJunction.addPoint(point1);
        testJunction.addPoint(point2);
        testJunction.addLink(point1, point2);
        Point vectorPoint = new Point("vectorPoint", 50.0, 50.0, 50.0);
        testJunction.addVector(point1, vectorPoint);
        String s = new String("Junction testJunction" + PackageConstants.NEWLINE + "Points:" + PackageConstants.NEWLINE + "   point1: 0.0, 0.0, 0.0 (center point)" + PackageConstants.NEWLINE + "   point2: 100.0, 100.0, 100.0" + PackageConstants.NEWLINE + "Links:" + PackageConstants.NEWLINE + "   (Link name point1 point2)" + PackageConstants.NEWLINE + "Vectors:" + PackageConstants.NEWLINE + "   Vector from point1: 0.0, 0.0, 0.0 (center point) to vectorPoint: 50.0, 50.0, 50.0" + PackageConstants.NEWLINE);
        assert (testJunction.toString().equals(s));
    }
}

