/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.Point3D;
import tools3d.Shape3D;
import tools3d.SimpleShape3D;
import tools3d.StandardGeometry;
import tools3d.Vector3D;

public class LineShape
extends SimpleShape3D
implements Shape3D {
    private Vector3D position1;
    private Vector3D position2;

    public LineShape(Vector3D pos1, Vector3D pos2) {
        Vector3D pos = pos1.plus(pos2);
        pos = pos.mul(0.5);
        this.setPosition(pos);
        this.position1 = pos1;
        this.position2 = pos2;
        Vector3D diff = pos2.minus(pos1);
        double radius = diff.length();
        this.setBoundingRadius(radius);
        this.setDimensions(new Vector3D(radius, radius, radius));
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        if (!this.isGeometryUpToDate()) {
            this.updateGeometry(angleDelta);
        }
        return this.geometry;
    }

    public Vector3D getPosition1() {
        return this.position1;
    }

    public Vector3D getPosition2() {
        return this.position2;
    }

    @Override
    public String getShapeName() {
        return "LineShape";
    }

    protected void updateGeometry(double angleDelta) {
        Vector3D pos = this.getPosition();
        double radius = this.getBoundingRadius();
        Point3D[] points = new Point3D[]{};
        Edge3D[] edges = new Edge3D[]{new Edge3D(this.position1, this.position2)};
        Face3D[] faces = new Face3D[]{};
        this.geometry = new StandardGeometry(points, edges, faces);
        this.geometry.setProperties(this.getProperties());
        this.geometry.setSelected(this.isSelected());
        this.setGeometryUpToDate(true);
    }

    @Override
    public String toString() {
        return "(Line " + this.getPosition1() + " " + this.getPosition2() + " )";
    }
}

