/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.Randomizer;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import tools3d.AxisAngle;
import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.Vector4D;

public class Matrix4DTools {
    private static Random rnd = Randomizer.getInstance();
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public static String computeEpsilonHash(Matrix4D m4, double epsilonRot, double epsilonTrans) {
        Matrix3D m3 = m4.submatrix();
        Vector3D v3 = m4.subvector();
        Vector4D quat = Matrix3DTools.extractQuaternion(m3);
        return Vector3DTools.computeEpsilonHash(quat, epsilonRot) + "_" + Vector3DTools.computeEpsilonHash(v3, epsilonTrans);
    }

    public static Matrix4D computeRoot(Matrix4D matrix, double error) {
        return Matrix4DTools.computeRoot(matrix, 2, error);
    }

    private static double computeRootScore(Matrix3D rotMatrix, Vector3D translation, Matrix4D matrix, int power) {
        Matrix4D m = new Matrix4D(rotMatrix, translation);
        Matrix4D finalM = m.pow(power);
        double error = finalM.minus(matrix).norm();
        return error;
    }

    public static double mutate(double x, double step) {
        return x + step * rnd.nextGaussian();
    }

    private static void mutateHomogeneousVector(double[] v, double translationStep, double angleStep) {
        v[0] = Matrix4DTools.mutate(v[0], translationStep);
        v[1] = Matrix4DTools.mutate(v[1], translationStep);
        v[2] = Matrix4DTools.mutate(v[2], translationStep);
        v[3] = Matrix4DTools.mutate(v[3], angleStep);
        v[4] = Matrix4DTools.mutate(v[4], angleStep);
        v[5] = Matrix4DTools.mutate(v[5], angleStep);
    }

    private static double computeRootScore(double[] v, Matrix4D matrix, int power) {
        Vector3D translation = new Vector3D(v[0], v[1], v[2]);
        Matrix3D rotMatrix = Matrix3DTools.computeEulerRotationMatrix(v[3], v[4], v[5]);
        return Matrix4DTools.computeRootScore(rotMatrix, translation, matrix, power);
    }

    private static Matrix4D generateMatrixFromVector(double[] v) {
        assert (v.length == 6);
        Vector3D translation = new Vector3D(v[0], v[1], v[2]);
        Matrix3D rotMatrix = Matrix3DTools.computeEulerRotationMatrix(v[3], v[4], v[5]);
        return new Matrix4D(rotMatrix, translation);
    }

    private static void arrayCopy(double[] src, double[] dest) {
        assert (src.length == dest.length);
        for (int i = 0; i < src.length; ++i) {
            dest[i] = src[i];
        }
    }

    public static Matrix4D computeRoot(Matrix4D matrix, int power, double errorLimit) {
        assert (power >= 0);
        int len = 6;
        double[] v = new double[len];
        double[] vBest = new double[len];
        double[] vSave = new double[len];
        if (power == 0) {
            return new Matrix4D(1.0);
        }
        if (power == 1) {
            return new Matrix4D(matrix);
        }
        double error = Matrix4DTools.computeRootScore(v, matrix, power);
        double translationStep = 1.0;
        double angleStep = 0.1;
        double bestError = error;
        int mulStep = 1000;
        double annealingMul = 0.98;
        int stepCount = 1;
        int stepMax = 1000000;
        while (error > errorLimit) {
            if (++stepCount % mulStep == 0) {
                angleStep *= annealingMul;
                translationStep *= annealingMul;
            }
            if (stepCount > stepMax) {
                log.warning("Could not find matrix root for matrix " + matrix + " and error limit: " + errorLimit);
                return null;
            }
            Matrix4DTools.arrayCopy(v, vSave);
            Matrix4DTools.mutateHomogeneousVector(v, translationStep, angleStep);
            error = Matrix4DTools.computeRootScore(v, matrix, power);
            if (error < bestError) {
                bestError = error;
                Matrix4DTools.arrayCopy(v, vBest);
                log.fine("New best transformation matrix found at step " + stepCount + " with error: " + bestError + "  ");
                continue;
            }
            Matrix4DTools.arrayCopy(vSave, v);
        }
        return Matrix4DTools.generateMatrixFromVector(v);
    }

    public static Matrix4D generateRandomHomogeneousMatrix(double translationStep, double angleStep) {
        double[] v = new double[6];
        Matrix4DTools.mutateHomogeneousVector(v, translationStep, angleStep);
        return Matrix4DTools.generateMatrixFromVector(v);
    }

    public void testComputeRoot() {
        int numTest = 3;
        double errorLimit = 0.02;
        for (int power = 2; power <= 5; ++power) {
            for (int i = 0; i < numTest; ++i) {
                Matrix4D m = Matrix4DTools.generateRandomHomogeneousMatrix(5.0, Math.PI);
                Matrix4D result = Matrix4DTools.computeRoot(m, power, errorLimit);
                assert (result != null);
                log.info("Found root " + power + " solution: " + result.toString() + " test result for " + m + " is: " + result.pow(power));
                assert (result.pow(power).minus(m).norm() <= errorLimit);
            }
        }
    }

    private static Matrix4D computeTransformation(Matrix4D startOrient, Matrix4D endOrient) {
        return startOrient.inverse().multiply(endOrient);
    }

    public static double scoreFit(Matrix4D target, Matrix4D query) {
        double transDiff = query.subvector().minus(target.subvector()).length();
        double rotationNorm = query.submatrix().minus(target.submatrix()).norm();
        return transDiff + rotationNorm;
    }

    public static double scoreFit(Matrix4D target, Matrix4D query, double rotationWeight) {
        double transDiff = query.subvector().minus(target.subvector()).length();
        double rotationNorm = query.submatrix().minus(target.submatrix()).norm();
        return transDiff + rotationWeight * rotationNorm;
    }

    public static Properties generateMatrix4DFitResult(double score, int nAlt1, int nAlt2) {
        Properties result = new Properties();
        result.setProperty("score", "" + score);
        result.setProperty("num_alt1", "" + nAlt1);
        result.setProperty("num_alt2", "" + nAlt2);
        assert (result != null);
        return result;
    }

    public static Properties scoreFit(Matrix4D target, Matrix4D query, Matrix4D altMatrix1, Matrix4D altMatrix2, int alt1Min, int alt1Max, int alt2Min, int alt2Max) {
        assert (alt1Min < alt1Max);
        assert (alt2Min < alt2Max);
        Properties result = null;
        double bestScore = 1.0E30;
        for (int i = alt1Min; i < alt1Max; ++i) {
            Matrix4D m1 = altMatrix1.pow(i);
            for (int j = alt2Min; j < alt2Max; ++j) {
                Matrix4D m2 = altMatrix2.pow(j);
                Matrix4D m = m1.multiply(query).multiply(m2);
                double score = Matrix4DTools.scoreFit(target, m);
                if (!(score < bestScore)) continue;
                result = Matrix4DTools.generateMatrix4DFitResult(score, i, j);
                bestScore = score;
            }
        }
        assert (result != null);
        return result;
    }

    public static Matrix4D computeAverageTransformation(Matrix4D m1, Matrix4D m2) {
        Vector3D v1 = m1.subvector();
        Vector3D v2 = m2.subvector();
        Vector3D avgTrans = Vector3D.average(v1, v2);
        AxisAngle axisAngle1 = new AxisAngle(m1.submatrix());
        AxisAngle axisAngle2 = new AxisAngle(m2.submatrix());
        double avgAngle = 0.5 * (axisAngle1.getAngle() + axisAngle2.getAngle());
        Vector3D avgAxis = Vector3D.average(axisAngle1.getAxis(), axisAngle2.getAxis());
        Matrix3D avgRot = new AxisAngle(avgAngle, avgAxis).generateMatrix();
        return new Matrix4D(avgRot, avgTrans);
    }

    public static Matrix4D computeAverageTransformationQuat(Matrix4D m1, Matrix4D m2) {
        AxisAngle aa1 = new AxisAngle(m1.submatrix());
        AxisAngle aa2 = new AxisAngle(m2.submatrix());
        Vector4D q1 = aa1.toQuaternion();
        Vector4D q2 = aa2.toQuaternion();
        Vector4D qavg = q1.plus(q2);
        qavg.normalize();
        AxisAngle aaResult = AxisAngle.fromQuaternion(qavg);
        Matrix3D newRot = aaResult.generateMatrix();
        Vector3D t1 = m1.subvector();
        Vector3D t2 = m2.subvector();
        Vector3D tAvg = Vector3D.average(t1, t2);
        return new Matrix4D(newRot, tAvg);
    }

    private double ReciprocalSqrt(double x) {
        return 1.0 / Math.sqrt(x);
    }
}

