/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.Vector;
import java.util.logging.Logger;
import tools3d.CoordinateSet;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleObject3D;

public class Point {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final double SIMILAR_CUTOFF = 1.0E-5;
    public static final double SIMILAR_CUTOFF_OLD = 10.0;
    private boolean centerPoint = false;
    private boolean finalPoint;
    private String name = "POINT";
    private CoordinateSet xyz = new CoordinateSet(0.0, 0.0, 0.0);
    private Vector<Point> neighbors = new Vector();

    public Point() {
    }

    public Point(String name, CoordinateSet xyz) {
        this.setName(name);
        this.setXYZ(xyz);
    }

    public Point(String name, CoordinateSet xyz, boolean centerPoint) {
        this.setName(name);
        this.setXYZ(xyz);
        this.centerPoint(centerPoint);
    }

    public Point(CoordinateSet xyz) {
        this.setXYZ(xyz);
    }

    public Point(double x, double y, double z) {
        this.setName("aPoint");
        this.setXYZ(x, y, z);
    }

    public Point(boolean keep, String name, double x, double y, double z) {
        this.setFinal(keep);
        this.setName(name);
        this.setXYZ(x, y, z);
    }

    public Point(String name, double x, double y, double z) {
        this.setName(name);
        this.setXYZ(x, y, z);
    }

    public Point(String name, double x, double y, double z, boolean centerPoint) {
        this.setName(name);
        this.setXYZ(x, y, z);
        this.centerPoint(centerPoint);
    }

    public void centerPoint(boolean b) {
        this.centerPoint = b;
    }

    public boolean getCenterPoint() {
        return this.centerPoint;
    }

    public boolean getFinalPoint() {
        return this.finalPoint;
    }

    public void addNeighbor(Point p) {
        boolean neighborAlreadyAdded = false;
        for (int i = 0; i < this.getNumNeighbors(); ++i) {
            if (!p.getName().equals(this.getNeighbor(i).getName())) continue;
            neighborAlreadyAdded = true;
        }
        if (!neighborAlreadyAdded) {
            this.neighbors.add(p);
        }
        p.addNeighborBack(this);
    }

    public void addNeighbor(int index, Point p) {
        boolean neighborAlreadyAdded = false;
        for (int i = 0; i < this.getNumNeighbors(); ++i) {
            if (!p.getName().equals(this.getNeighbor(i).getName())) continue;
            neighborAlreadyAdded = true;
        }
        if (!neighborAlreadyAdded) {
            this.neighbors.add(index, p);
        }
    }

    public void addNeighbor(String vector, Point p) {
        log.warning("TODO: Method not yet implemented");
    }

    public void addNeighborBack(Point p) {
        boolean neighborAlreadyAdded = false;
        for (int i = 0; i < this.getNumNeighbors(); ++i) {
            if (!p.getName().equals(this.getNeighbor(i).getName())) continue;
            neighborAlreadyAdded = true;
        }
        if (!neighborAlreadyAdded) {
            this.neighbors.add(p);
        }
    }

    public Point getNeighbor(int i) {
        return this.neighbors.get(i);
    }

    public Vector<Point> getNeighbors() {
        return this.neighbors;
    }

    public int getNumNeighbors() {
        return this.neighbors.size();
    }

    public Object cloneDeep() {
        Point p = new Point();
        p.copyDeepThisCore(this);
        return p;
    }

    protected void copyDeepThisCore(Point p) {
        this.setName(p.getName());
        this.setXYZ(p.getXYZ());
        this.centerPoint(p.getCenterPoint());
    }

    public boolean equals(Point p) {
        int result = 0;
        if (this.getName().trim().length() == p.getName().trim().length()) {
            ++result;
        } else {
            return false;
        }
        int sameName = 0;
        for (int i = 0; i < this.getName().trim().length(); ++i) {
            if (this.getName().trim().charAt(i) != p.getName().trim().charAt(i)) continue;
            ++sameName;
        }
        if (sameName == this.getName().trim().length()) {
            ++result;
        } else {
            return false;
        }
        if (Math.abs(this.getX() - p.getX()) == 0.0) {
            ++result;
        } else {
            return false;
        }
        if (Math.abs(this.getY() - p.getY()) == 0.0) {
            ++result;
        } else {
            return false;
        }
        if (Math.abs(this.getZ() - p.getZ()) != 0.0) {
            return false;
        }
        return ++result == 5;
    }

    public boolean similar(Object other) {
        if (this.equals(other)) {
            return true;
        }
        if (!(other instanceof Point)) {
            return false;
        }
        Point point = (Point)other;
        return Point.similar(this.getX(), point.getX()) && Point.similar(this.getY(), point.getY()) && Point.similar(this.getZ(), point.getZ());
    }

    public static boolean similar(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }

    public boolean isSimilarTo(Point p) {
        log.info("Similarity beteen " + this + " and " + p + Math.sqrt(Math.pow(p.getX() - this.getX(), 2.0) + Math.pow(p.getY() - this.getY(), 2.0) + Math.pow(p.getZ() - this.getZ(), 2.0)));
        return Math.sqrt(Math.pow(p.getX() - this.getX(), 2.0) + Math.pow(p.getY() - this.getY(), 2.0) + Math.pow(p.getZ() - this.getZ(), 2.0)) < 10.0;
    }

    public String getName() {
        return this.name;
    }

    public Vector3D getVector3D() {
        return this.xyz.toVector3D();
    }

    public CoordinateSet getXYZ() {
        return this.xyz;
    }

    public double getX() {
        return this.xyz.getX();
    }

    public double getY() {
        return this.xyz.getY();
    }

    public double getZ() {
        return this.xyz.getZ();
    }

    public void rotate(Vector3D start, Vector3D axis, double angle) {
        Vector3D vector3d = this.getVector3D();
        vector3d.rotate(start, axis, angle);
        this.setX(vector3d.getX());
        this.setY(vector3d.getY());
        this.setZ(vector3d.getZ());
    }

    public void setFinal(boolean keep) {
        this.finalPoint = keep;
    }

    public String toString() {
        String s = "";
        s = this.getCenterPoint() ? s + this.name + ": " + this.xyz + " (center point)" : s + this.name + ": " + this.xyz;
        return s;
    }

    public Object3D toObject3D() {
        SimpleObject3D o = new SimpleObject3D();
        o.setPosition(this.getVector3D());
        o.setName(this.getName());
        return o;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setXYZ(double x, double y, double z) {
        this.xyz = new CoordinateSet(x, y, z);
    }

    public void setXYZ(CoordinateSet xyz) {
        this.xyz = xyz;
    }

    public void setX(double x) {
        this.xyz.setX(x);
    }

    public void setY(double y) {
        this.xyz.setY(y);
    }

    public void setZ(double z) {
        this.xyz.setZ(z);
    }
}

