/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.RotationDescriptor;
import tools3d.Vector3D;

public class SimpleRotationDescriptor
implements RotationDescriptor {
    private Vector3D axis;
    private Vector3D center;
    private double angle;

    public SimpleRotationDescriptor() {
        this.axis = new Vector3D(0.0, 0.0, 1.0);
        this.center = new Vector3D(0.0, 0.0, 0.0);
        this.angle = 0.0;
    }

    public SimpleRotationDescriptor(Vector3D axis, Vector3D center, double angle) {
        this.axis = axis;
        this.center = center;
        this.angle = angle;
    }

    public SimpleRotationDescriptor(RotationDescriptor other) {
        this.axis = new Vector3D(other.getAxis());
        this.center = new Vector3D(other.getCenter());
        this.angle = other.getAngle();
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof RotationDescriptor)) {
            return false;
        }
        RotationDescriptor other = (RotationDescriptor)otherObject;
        if (this.getAngle() != other.getAngle()) {
            return false;
        }
        if (this.getAngle() == 0.0) {
            return true;
        }
        return this.getAxis().equals(other.getAxis()) && this.getCenter().equals(other.getCenter());
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public Vector3D getAxis() {
        return this.axis;
    }

    @Override
    public Vector3D getCenter() {
        return this.center;
    }

    @Override
    public boolean isValid() {
        return this.axis != null && this.center != null && this.axis.length() > 0.0;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public void setAxis(Vector3D axis) {
        this.axis = axis;
    }

    @Override
    public void setCenter(Vector3D center) {
        this.center = center;
    }
}

